/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry;

import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector2d;
import pyrosim.legacy_2012_1.thunderheadeng.delaunay.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.delaunay.MeshBuilder;
import pyrosim.legacy_2012_1.thunderheadeng.delaunay.TriangulatorInfo;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.IParametric2D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.LineSeg2D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ShapeUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util2D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.PolyUtil;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class AreaUtil {
    private static final int ROUND_DECIMALS = 6;

    public static double area(Area a, AffineTransform xform, double curveError, double eqtol) {
        if (a.isEmpty()) {
            return 0.0;
        }
        double totalArea = 0.0;
        TriangulatorInfo ti = AreaUtil.triangulate(a, xform, curveError, eqtol);
        for (int m = 0; m < ti.triangles.length; m += 3) {
            Point2d p1 = ti.points[ti.triangles[m + 0]];
            Point2d p2 = ti.points[ti.triangles[m + 1]];
            Point2d p3 = ti.points[ti.triangles[m + 2]];
            totalArea += Util2D.triArea(p1, p2, p3);
        }
        return totalArea;
    }

    private static Point2d findPointInPoly(List<? extends IParametric2D> poly, double tol) {
        if (poly.isEmpty()) {
            return null;
        }
        Point2d startPoint = poly.get(0).get(0.5);
        Random rand = new Random(0L);
        for (int m = 0; m < 10; ++m) {
            Vector2d rvec = AreaUtil.randomVec(rand);
            List<double[]> trimmed = AreaUtil.trimLineToPoly(poly, startPoint, rvec, tol);
            for (double[] seg : trimmed) {
                if (theUtil.eq(seg[0], seg[1], tol)) continue;
                double midt = (seg[0] + seg[1]) * 0.5;
                return Util2D.linePoint(startPoint, rvec, midt);
            }
        }
        return startPoint;
    }

    private static Vector2d randomVec(Random rand) {
        double x = 0.0;
        double y = 0.0;
        while (x == 0.0 && y == 0.0) {
            x = rand.nextDouble() - 0.5;
            y = rand.nextDouble() - 0.5;
        }
        return new Vector2d(x, y);
    }

    public static List<double[]> trimLineToPoly(List<? extends IParametric2D> poly, Point2d l1, Vector2d ldir, final double tol) {
        TreeSet<Double> sortedIsects = new TreeSet<Double>(new Comparator<Double>(){

            @Override
            public int compare(Double o1, Double o2) {
                int compare = theUtil.compare(o1, o2, tol);
                if (compare != 0) {
                    return compare;
                }
                return Integer.compare(System.identityHashCode(o1), System.identityHashCode(o2));
            }
        });
        for (IParametric2D iParametric2D : poly) {
            List<double[]> isects = iParametric2D.getLineIsects(l1, ldir, tol);
            for (double[] isect : isects) {
                boolean comp0 = theUtil.eq0(isect[0], tol);
                boolean comp1 = theUtil.eq(isect[0], 1.0, tol);
                if (comp0 || comp1) {
                    double cross;
                    Vector2d tan = iParametric2D.getTangent(isect[0]);
                    if (comp1) {
                        tan.negate();
                    }
                    if (!theUtil.gt0(cross = Util2D.cross(ldir, tan), tol)) continue;
                    sortedIsects.add(isect[1]);
                    continue;
                }
                sortedIsects.add(isect[1]);
            }
        }
        if (sortedIsects.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (sortedIsects.size() == 1) {
            System.err.println("Encountered 1 intersection during line to poly trim.");
            return Collections.EMPTY_LIST;
        }
        if (sortedIsects.size() % 2 != 0) {
            System.err.println("Encounterd odd number of intersections during line to poly trim");
            return Arrays.asList(new double[][]{{sortedIsects.first(), sortedIsects.last()}});
        }
        ArrayList<double[]> validIsects = new ArrayList<double[]>();
        double[] dArray = theUtil.toDoubleArray(sortedIsects);
        for (int m = 0; m < dArray.length - 1; m += 2) {
            validIsects.add(new double[]{dArray[m], dArray[m + 1]});
        }
        validIsects.trimToSize();
        return validIsects;
    }

    public static IPolygon toPoly(Area area, Matrix4d lwXform, double error) {
        ArrayList<Point3d> verts = new ArrayList<Point3d>();
        ArrayList<Integer> loopOffsets = new ArrayList<Integer>();
        loopOffsets.add(0);
        PathIterator path = ShapeUtil.getPathIterator(area, null, error);
        double[] coords = new double[2];
        int lastLoopOffset = 0;
        Point3d firstPoint = null;
        while (!path.isDone()) {
            int type = path.currentSegment(coords);
            switch (type) {
                case 0: {
                    if (verts.size() > lastLoopOffset) {
                        loopOffsets.add(lastLoopOffset);
                    }
                    lastLoopOffset = verts.size();
                    firstPoint = new Point3d(coords[0], coords[1], 0.0);
                    if (lwXform != null) {
                        lwXform.transform(firstPoint);
                    }
                    verts.add(firstPoint);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    Point3d currPoint = new Point3d(coords[0], coords[1], 0.0);
                    if (lwXform != null) {
                        lwXform.transform(currPoint);
                    }
                    if (currPoint.equals(firstPoint)) break;
                    verts.add(currPoint);
                }
            }
            path.next();
        }
        if (verts.size() > lastLoopOffset) {
            loopOffsets.add(lastLoopOffset);
        }
        return PolyUtil.newPoly(verts.toArray(new Point3d[verts.size()]), theUtil.toIntArray(loopOffsets));
    }

    public static TriangulatorInfo triangulate(Area area, AffineTransform xform, double error, double eqtol) {
        MeshBuilder meshBuilder = new MeshBuilder(eqtol);
        PathIterator path = ShapeUtil.getPathIterator(area, xform, error);
        double[] coords = new double[2];
        Point2d firstPoint = null;
        Point2d lastPoint = null;
        while (!path.isDone()) {
            int type = path.currentSegment(coords);
            switch (type) {
                case 0: {
                    lastPoint = firstPoint = new Point2d(coords[0], coords[1]);
                    break;
                }
                case 4: {
                    meshBuilder.addEdge(lastPoint, firstPoint);
                    break;
                }
                default: {
                    Point2d currPoint = new Point2d(coords[0], coords[1]);
                    meshBuilder.addEdge(lastPoint, currPoint);
                    lastPoint = currPoint;
                }
            }
            path.next();
        }
        Mesh dmesh = meshBuilder.build();
        dmesh.triangulateEvenOdd(0);
        return dmesh.getOutput();
    }

    public static void cleanupArea(Area a) {
        Path2D.Double gp = new Path2D.Double(a);
        a.reset();
        a.add(new Area(gp));
    }

    public static List<List<IParametric2D>> toParametrics(Area area, AffineTransform xform, double curveTol) {
        return AreaUtil.toParametrics(AreaUtil.getBoundaryLoops(area), xform, curveTol);
    }

    public static List<List<IParametric2D>> toParametrics(List<Loop> loops, AffineTransform xform, double curveTol) {
        ArrayList<List<IParametric2D>> parms = new ArrayList<List<IParametric2D>>();
        Stack<Loop> loopStack = new Stack<Loop>();
        loopStack.addAll(loops);
        while (!loopStack.isEmpty()) {
            Loop loop = (Loop)loopStack.pop();
            Path2D.Double path = new Path2D.Double();
            loop.addToPath(path);
            parms.add(ShapeUtil.getBoundary2D(path, xform, curveTol));
            loopStack.addAll(loop.children);
        }
        return parms;
    }

    public static List<ComponentArea> toSimpleAreas(Area area) {
        ArrayList<ComponentArea> simpleAreas = new ArrayList<ComponentArea>();
        AreaUtil.toSimpleAreas(simpleAreas, AreaUtil.getBoundaryLoops(area));
        return simpleAreas;
    }

    private static void toSimpleAreas(List<ComponentArea> sis, Collection<Loop> posLoops) {
        for (Loop posLoop : posLoops) {
            Path2D.Double posArea = posLoop.toPath();
            ArrayList<Path2D.Double> negAreas = new ArrayList<Path2D.Double>();
            for (Loop negLoop : posLoop.children) {
                negAreas.add(negLoop.toPath());
            }
            sis.add(new ComponentArea(posArea, negAreas));
            for (Loop negLoop : posLoop.children) {
                AreaUtil.toSimpleAreas(sis, negLoop.children);
            }
        }
    }

    private static Point2d getCoords(double[] arr, int begin) {
        return new Point2d(arr[begin], arr[begin + 1]);
    }

    private static Set<Point2d> getPathPoints(Collection<PathCommand> commands) {
        HashSet<Point2d> points = new HashSet<Point2d>();
        for (PathCommand command : commands) {
            switch (command.type) {
                case 0: {
                    points.add(AreaUtil.getCoords(command.coords, 0));
                    break;
                }
                case 1: {
                    points.add(AreaUtil.getCoords(command.coords, 0));
                    break;
                }
                case 2: {
                    points.add(AreaUtil.getCoords(command.coords, 2));
                    break;
                }
                case 3: {
                    points.add(AreaUtil.getCoords(command.coords, 4));
                }
            }
        }
        return points;
    }

    public static List<Loop> getBoundaryLoops(Area area) {
        PathIterator it = area.getPathIterator(null);
        if (it.getWindingRule() == 0) {
            return null;
        }
        LinkedList<Loop> loops = new LinkedList<Loop>();
        Loop currentLoop = null;
        while (!it.isDone()) {
            PathCommand command = new PathCommand();
            command.type = it.currentSegment(command.coords);
            switch (command.type) {
                case 0: {
                    currentLoop = new Loop(it.getWindingRule());
                    loops.add(currentLoop);
                    currentLoop.path.moveTo(command.coords[0], command.coords[1]);
                    currentLoop.commands.add(command);
                    break;
                }
                case 1: {
                    currentLoop.path.lineTo(command.coords[0], command.coords[1]);
                    currentLoop.commands.add(command);
                    break;
                }
                case 2: {
                    currentLoop.path.quadTo(command.coords[0], command.coords[1], command.coords[2], command.coords[3]);
                    currentLoop.commands.add(command);
                    break;
                }
                case 3: {
                    currentLoop.path.curveTo(command.coords[0], command.coords[1], command.coords[2], command.coords[3], command.coords[4], command.coords[5]);
                    currentLoop.commands.add(command);
                    break;
                }
                case 4: {
                    currentLoop.path.closePath();
                    currentLoop.commands.add(command);
                    currentLoop.points = AreaUtil.getPathPoints(currentLoop.commands);
                }
            }
            it.next();
        }
        Iterator loopIt1 = loops.iterator();
        block8: while (loopIt1.hasNext()) {
            Loop l1 = (Loop)loopIt1.next();
            for (Loop l2 : loops) {
                if (l1 == l2 || !l2.contains(l1)) continue;
                l2.children.add(l1);
                loopIt1.remove();
                continue block8;
            }
        }
        return loops;
    }

    public static Collection<Area> separateUnconnectedAreas(Area area) {
        List<Loop> loops = AreaUtil.getBoundaryLoops(area);
        ArrayList<Area> areas = new ArrayList<Area>(loops.size());
        for (Loop parentLoop : loops) {
            parentLoop.createAreas(areas, null, 0);
        }
        return areas;
    }

    public static boolean overlap(Area a1, Area a2) {
        a1 = (Area)a1.clone();
        a1.intersect(a2);
        return !a1.isEmpty();
    }

    public static boolean overlap(Area a1, Area a2, double curveError, double tol) {
        if (tol == 0.0) {
            return AreaUtil.overlap(a1, a2);
        }
        a1 = (Area)a1.clone();
        a1.intersect(a2);
        double area = AreaUtil.area(a1, null, curveError, tol);
        return area > tol;
    }

    public static Area union(Area a1, Area a2) {
        if (a1.equals(a2)) {
            return (Area)a1.clone();
        }
        List<Loop> loops1 = AreaUtil.getBoundaryLoops(a1);
        List<Loop> loops2 = AreaUtil.getBoundaryLoops(a2);
        List<List<IParametric2D>> a1Loops = AreaUtil.toParametrics(loops1, null, 0.0);
        List<List<IParametric2D>> a2Loops = AreaUtil.toParametrics(loops2, null, 0.0);
        ArrayList<List<IParametric2D>> nonIntersect1 = new ArrayList<List<IParametric2D>>();
        ArrayList<List<IParametric2D>> nonIntersect2 = new ArrayList<List<IParametric2D>>();
        Collection<LoopVert> verts = AreaUtil.getIsects(a1Loops, a2Loops, nonIntersect1, nonIntersect2);
        Collection<LoopEdge> exitingEdges = AreaUtil.getExitingEdges(verts);
        Path2D.Double path = new Path2D.Double();
        while (!exitingEdges.isEmpty()) {
            LoopEdge exitEdge = exitingEdges.iterator().next();
            LoopVert loopVert = exitEdge.v1;
            path.moveTo(loopVert.p.x, loopVert.p.y);
            LoopEdge edge = exitEdge;
            while (true) {
                edge.parm.append(path);
                exitingEdges.remove(edge);
                if (edge.v2 == loopVert) break;
                LoopEdge nedge = edge.v2.nextEdge(edge);
                edge.disconnect();
                assert (nedge != null);
                assert (nedge != edge);
                edge = nedge;
            }
            edge.disconnect();
            path.closePath();
        }
        for (List list : nonIntersect1) {
            int parentLevel = AreaUtil.findImmediateParentLevel(loops2, list);
            if (parentLevel != -1 && parentLevel % 2 == 0) continue;
            ShapeUtil.appendAsSubPath(path, list);
        }
        for (List list : nonIntersect2) {
            int parentLevel = AreaUtil.findImmediateParentLevel(loops1, list);
            if (parentLevel != -1 && parentLevel % 2 == 0) continue;
            ShapeUtil.appendAsSubPath(path, list);
        }
        return new Area(path);
    }

    private static int findImmediateParentLevel(List<Loop> topLoops, List<IParametric2D> parmLoop) {
        Point2d testPoint = AreaUtil.findPointInPoly(parmLoop, 1.0E-6);
        if (testPoint == null) {
            return -1;
        }
        int level = -1;
        List<Loop> nextLoops = topLoops;
        block0: while (nextLoops != null) {
            List<Loop> currLoops = nextLoops;
            nextLoops = null;
            for (Loop l : currLoops) {
                if (!l.path.contains(testPoint.x, testPoint.y)) continue;
                ++level;
                nextLoops = l.children;
                continue block0;
            }
        }
        return level;
    }

    private static Collection<LoopVert> getIsects(List<List<IParametric2D>> a1Loops, List<List<IParametric2D>> a2Loops, List<List<IParametric2D>> nonIntersecting1, List<List<IParametric2D>> nonIntersecting2) {
        a1Loops = AreaUtil.removeInvalidSegs(a1Loops);
        a2Loops = AreaUtil.removeInvalidSegs(a2Loops);
        HashMap<Point2d, LoopVert> vertMap = new HashMap<Point2d, LoopVert>();
        List<List<ParmDiv>> area1Isects = AreaUtil.initVerts(vertMap, a1Loops);
        List<List<ParmDiv>> area2Isects = AreaUtil.initVerts(vertMap, a2Loops);
        AreaUtil.getIsects(area1Isects, area2Isects, vertMap);
        AreaUtil.constructEdges(0, area1Isects);
        AreaUtil.constructEdges(1, area2Isects);
        Collection<LoopVert> isectVerts = AreaUtil.getIsectVerts(vertMap.values());
        AreaUtil.getNonIsectLoops(area1Isects, isectVerts, nonIntersecting1);
        AreaUtil.getNonIsectLoops(area2Isects, isectVerts, nonIntersecting2);
        return isectVerts;
    }

    private static Point2d get(IParametric2D parm, double t) {
        return Util2D.round(parm.get(t), 6);
    }

    private static List<List<ParmDiv>> initVerts(Map<Point2d, LoopVert> vertMap, List<List<IParametric2D>> loops) {
        ArrayList<List<ParmDiv>> loopDivs = new ArrayList<List<ParmDiv>>(loops.size());
        for (List<IParametric2D> loop : loops) {
            ArrayList<LoopVert> verts = new ArrayList<LoopVert>(loop.size());
            for (IParametric2D parm : loop) {
                Point2d p = parm.get(0.0);
                Point2d rp = Util2D.round(p, 6);
                LoopVert vert = vertMap.get(rp);
                if (vert == null) {
                    vert = new LoopVert(p);
                    vertMap.put(rp, vert);
                }
                verts.add(vert);
            }
            ArrayList<ParmDiv> divs = new ArrayList<ParmDiv>(loop.size());
            loopDivs.add(divs);
            for (int m = 0; m < loop.size(); ++m) {
                IParametric2D parm = loop.get(m);
                LoopVert v1 = (LoopVert)verts.get(m);
                LoopVert v2 = (LoopVert)verts.get((m + 1) % verts.size());
                divs.add(new ParmDiv(parm, v1, v2));
            }
        }
        return loopDivs;
    }

    private static List<List<IParametric2D>> removeInvalidSegs(List<List<IParametric2D>> loops) {
        ArrayList<List<IParametric2D>> result = new ArrayList<List<IParametric2D>>(loops.size());
        for (List<IParametric2D> loop : loops) {
            ArrayList<IParametric2D> resultLoop = new ArrayList<IParametric2D>(loop.size());
            for (IParametric2D parm : loop) {
                if (!parm.isValid(1.0E-6)) continue;
                resultLoop.add(parm);
            }
            if (resultLoop.size() <= 0) continue;
            result.add(resultLoop);
        }
        return result;
    }

    private static void getIsects(List<List<ParmDiv>> area1, List<List<ParmDiv>> area2, Map<Point2d, LoopVert> vertMap) {
        for (List<ParmDiv> loop1 : area1) {
            for (ParmDiv pd1 : loop1) {
                IParametric2D parm1 = pd1.parm;
                TreeMap<Double, LoopVert> parm1Isects = pd1.divs;
                for (List<ParmDiv> loop2 : area2) {
                    for (ParmDiv pd2 : loop2) {
                        IParametric2D parm2 = pd2.parm;
                        TreeMap<Double, LoopVert> parm2Isects = pd2.divs;
                        List<double[]> isects = AreaUtil.isect(parm1, parm2);
                        for (double[] isect : isects) {
                            Point2d p2;
                            Point2d p1 = AreaUtil.get(parm1, isect[0]);
                            if (!p1.equals(p2 = AreaUtil.get(parm2, isect[1]))) continue;
                            LoopVert v = vertMap.get(p1);
                            if (v == null) {
                                v = new LoopVert(p1);
                                vertMap.put(p1, v);
                            }
                            if (!parm1Isects.containsValue(v)) {
                                isect[0] = parm1.getClosestT(v.p);
                                parm1Isects.put(isect[0], v);
                            }
                            if (parm2Isects.containsValue(v)) continue;
                            isect[1] = parm2.getClosestT(v.p);
                            parm2Isects.put(isect[1], v);
                        }
                    }
                }
            }
        }
    }

    private static void constructEdges(int whichArea, List<List<ParmDiv>> area) {
        for (List<ParmDiv> loop : area) {
            for (ParmDiv pd : loop) {
                TreeMap<Double, LoopVert> parmVerts = pd.divs;
                double lastt = -1.0;
                LoopVert lastVert = null;
                for (Map.Entry<Double, LoopVert> entry : parmVerts.entrySet()) {
                    double t = entry.getKey();
                    LoopVert vert = entry.getValue();
                    if (t > 0.0) {
                        IParametric2D subseg = pd.parm.subsegment(lastt, t);
                        subseg.setBegin(lastVert.p);
                        subseg.setEnd(vert.p);
                        LoopEdge edge = new LoopEdge(whichArea, lastVert, vert, subseg);
                        edge.connect();
                    }
                    lastt = t;
                    lastVert = vert;
                }
            }
        }
    }

    private static Collection<LoopVert> getIsectVerts(Collection<LoopVert> allVerts) {
        LinkedIdentityHashSet<LoopVert> closed = new LinkedIdentityHashSet<LoopVert>();
        LinkedIdentityHashSet open = new LinkedIdentityHashSet();
        for (LoopVert vert : allVerts) {
            if (!vert.isIntersectVert()) continue;
            open.add(vert);
        }
        closed.addAll(open);
        while (!open.isEmpty()) {
            LoopVert vert = (LoopVert)open.iterator().next();
            open.remove(vert);
            for (List<LoopEdge> edges : vert.edges.values()) {
                for (LoopEdge edge : edges) {
                    LoopVert otherVert = edge.v1 == vert ? edge.v2 : edge.v1;
                    if (!closed.add(otherVert)) continue;
                    open.add(otherVert);
                }
            }
        }
        return closed;
    }

    private static void getNonIsectLoops(List<List<ParmDiv>> loops, Collection<LoopVert> isectVerts, List<List<IParametric2D>> nonIsectLoops) {
        for (List<ParmDiv> loop : loops) {
            boolean doesIsect = false;
            for (ParmDiv pd : loop) {
                TreeMap<Double, LoopVert> parmIsects = pd.divs;
                for (LoopVert vert : parmIsects.values()) {
                    if (!isectVerts.contains(vert)) continue;
                    doesIsect = true;
                    break;
                }
                if (!doesIsect) continue;
                break;
            }
            if (doesIsect) continue;
            ArrayList<IParametric2D> parms = new ArrayList<IParametric2D>(loop.size());
            for (ParmDiv pd : loop) {
                parms.add(pd.parm);
            }
            nonIsectLoops.add(parms);
        }
    }

    private static Collection<LoopEdge> getExitingEdges(Collection<LoopVert> verts) {
        LinkedIdentityHashSet<LoopEdge> exitEdges = new LinkedIdentityHashSet<LoopEdge>();
        for (LoopVert vert : verts) {
            for (List<LoopEdge> edges : vert.edges.values()) {
                for (LoopEdge edge : edges) {
                    if (!AreaUtil.isEdgeExiting(edge, vert)) continue;
                    exitEdges.add(edge);
                }
            }
        }
        return exitEdges;
    }

    private static boolean isEdgeExiting(LoopEdge edge, LoopVert vert) {
        if (edge.v2 == vert) {
            return false;
        }
        LoopEdge prevEdge = vert.prevEdge(edge);
        return prevEdge != null;
    }

    private static List<double[]> isect(IParametric2D parm1, IParametric2D parm2) {
        if (!(parm1 instanceof LineSeg2D) || !(parm2 instanceof LineSeg2D)) {
            return null;
        }
        List<double[]> isects = parm1.getIsects(parm2, 1.0E-6);
        if (isects.isEmpty()) {
            List<double[][]> align = parm1.getAlignedSegs(parm2, 1.0E-6);
            isects = new ArrayList<double[]>(align.size() * 2);
            for (double[][] alignedSeg : align) {
                isects.add(new double[]{alignedSeg[0][0], alignedSeg[1][0]});
                isects.add(new double[]{alignedSeg[0][1], alignedSeg[1][1]});
            }
        }
        return isects;
    }

    private static class TolComp
    implements Comparator<Double> {
        private final double tol;

        public TolComp(double tol) {
            this.tol = tol;
        }

        @Override
        public int compare(Double o1, Double o2) {
            return theUtil.compare(o1, o2, this.tol);
        }
    }

    private static class ParmDiv {
        public final IParametric2D parm;
        public final TreeMap<Double, LoopVert> divs;

        public ParmDiv(IParametric2D parm, LoopVert v1, LoopVert v2) {
            this.parm = parm;
            this.divs = new TreeMap();
            this.divs.put(0.0, v1);
            this.divs.put(1.0, v2);
        }
    }

    private static class LoopEdgeUse {
        public final LoopEdge edge;
        public final boolean positive;

        public LoopEdgeUse(LoopEdge edge, boolean positive) {
            this.edge = edge;
            this.positive = positive;
        }

        public LoopVert v1() {
            return this.positive ? this.edge.v1 : this.edge.v2;
        }

        public LoopVert v2() {
            return this.positive ? this.edge.v2 : this.edge.v1;
        }
    }

    private static class LoopEdge {
        public final int whichArea;
        public final LoopVert v1;
        public final LoopVert v2;
        public final IParametric2D parm;

        public LoopEdge(int whichArea, LoopVert v1, LoopVert v2, IParametric2D parm) {
            this.whichArea = whichArea;
            this.v1 = v1;
            this.v2 = v2;
            this.parm = parm;
        }

        public void connect() {
            this.v1.add(this);
            this.v2.add(this);
        }

        public void disconnect() {
            this.v1.remove(this);
            this.v2.remove(this);
        }

        public String toString() {
            return "[LoopEdge: " + this.v1.p + " -> " + this.v2.p + "]";
        }
    }

    private static class LoopVert {
        private static final Vector2d s_baseDir = new Vector2d(1.0, 0.0);
        private final TreeMap<Double, List<LoopEdge>> edges = new TreeMap();
        public final Point2d p;

        public LoopVert(Point2d p) {
            this.p = p;
        }

        public void add(LoopEdge edge) {
            Vector2d dir = this.getRelativeDir(edge);
            double angle = Util2D.angle(s_baseDir, dir);
            List<LoopEdge> angleEdges = this.edges.get(angle);
            if (angleEdges == null) {
                angleEdges = new ArrayList<LoopEdge>(2);
                this.edges.put(angle, angleEdges);
            }
            angleEdges.add(edge);
        }

        public void remove(LoopEdge edge) {
            Vector2d dir = this.getRelativeDir(edge);
            double angle = Util2D.angle(s_baseDir, dir);
            List<LoopEdge> angleEdges = this.edges.get(angle);
            assert (angleEdges != null);
            angleEdges.remove(edge);
            if (angleEdges.isEmpty()) {
                this.edges.remove(angle);
            }
        }

        public boolean isIntersectVert() {
            int baseArea = -1;
            for (List<LoopEdge> angleEdges : this.edges.values()) {
                for (LoopEdge edge : angleEdges) {
                    if (baseArea == -1) {
                        baseArea = edge.whichArea;
                        continue;
                    }
                    if (edge.whichArea == baseArea) continue;
                    return true;
                }
            }
            return false;
        }

        private Vector2d getRelativeDir(LoopEdge edge) {
            if (edge.v1 == this) {
                return edge.parm.getTangent(0.0);
            }
            Vector2d dir = edge.parm.getTangent(1.0);
            dir.negate();
            return dir;
        }

        private List<LoopEdge> nextEdges(double currAngle) {
            Map.Entry<Double, List<LoopEdge>> next = this.edges.lowerEntry(currAngle);
            return next == null ? this.edges.lastEntry().getValue() : next.getValue();
        }

        private List<LoopEdge> prevEdges(double currAngle) {
            Map.Entry<Double, List<LoopEdge>> prev = this.edges.higherEntry(currAngle);
            return prev == null ? this.edges.firstEntry().getValue() : prev.getValue();
        }

        public LoopEdge nextEdge(LoopEdge prev) {
            if (prev.v1 == this) {
                return null;
            }
            Vector2d dir = this.getRelativeDir(prev);
            double angle = Util2D.angle(s_baseDir, dir);
            List<LoopEdge> currEdges = this.edges.get(angle);
            assert (currEdges != null);
            for (LoopEdge edge : currEdges) {
                if (edge.v1 != this) continue;
                return null;
            }
            List<LoopEdge> nextEdges = this.nextEdges(angle);
            for (LoopEdge next : nextEdges) {
                if (next.v2 != this) continue;
                return null;
            }
            return nextEdges.get(0);
        }

        public LoopEdge prevEdge(LoopEdge next) {
            if (next.v2 == this) {
                return null;
            }
            Vector2d dir = this.getRelativeDir(next);
            double angle = Util2D.angle(s_baseDir, dir);
            List<LoopEdge> currEdges = this.edges.get(angle);
            assert (currEdges != null);
            for (LoopEdge edge : currEdges) {
                if (edge.v1 == this) continue;
                return null;
            }
            List<LoopEdge> prevEdges = this.prevEdges(angle);
            for (LoopEdge prev : prevEdges) {
                if (prev.v1 != this) continue;
                return null;
            }
            return prevEdges.get(0);
        }

        public String toString() {
            return this.p.toString();
        }
    }

    private static class Loop {
        public final Path2D.Double path;
        public final List<PathCommand> commands = new ArrayList<PathCommand>();
        public final List<Loop> children = new ArrayList<Loop>();
        public Set<Point2d> points;

        public Loop(int windingRule) {
            this.path = new Path2D.Double(windingRule);
        }

        public boolean contains(Loop loop) {
            List<IParametric2D> parms = ShapeUtil.getBoundary2D(loop.path, null, 0.0);
            Point2d testPoint = AreaUtil.findPointInPoly(parms, 1.0E-6);
            return this.path.contains(testPoint.x, testPoint.y);
        }

        public Path2D.Double toPath() {
            Path2D.Double path = new Path2D.Double();
            this.addToPath(path);
            return path;
        }

        public void addToPath(Path2D.Double path) {
            for (PathCommand command : this.commands) {
                switch (command.type) {
                    case 0: {
                        path.moveTo(command.coords[0], command.coords[1]);
                        break;
                    }
                    case 1: {
                        path.lineTo(command.coords[0], command.coords[1]);
                        break;
                    }
                    case 2: {
                        path.quadTo(command.coords[0], command.coords[1], command.coords[2], command.coords[3]);
                        break;
                    }
                    case 3: {
                        path.curveTo(command.coords[0], command.coords[1], command.coords[2], command.coords[3], command.coords[4], command.coords[5]);
                        break;
                    }
                    case 4: {
                        path.closePath();
                    }
                }
            }
        }

        public void createAreas(Collection<Area> areas, Path2D.Double path, int level) {
            boolean isEvenPath;
            boolean bl = isEvenPath = level % 2 == 0;
            if (isEvenPath) {
                path = new Path2D.Double();
            }
            this.addToPath(path);
            int nextLevel = level + 1;
            for (Loop child : this.children) {
                child.createAreas(areas, path, nextLevel);
            }
            if (isEvenPath) {
                areas.add(new Area(path));
            }
        }
    }

    private static class PathCommand {
        public int type;
        public double[] coords = new double[6];

        private PathCommand() {
        }
    }

    public static class ComponentArea {
        public final Path2D.Double posComp;
        public final Collection<Path2D.Double> negComps;

        public ComponentArea(Path2D.Double posComp, Collection<Path2D.Double> negComps) {
            this.posComp = posComp;
            this.negComps = negComps;
        }
    }
}

