/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.output.PlanarSlice;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class SliceParser
extends AFDS5Parser {
    public SliceParser(FDS5ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("SLCF");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
        unsupportedFields.add("MESH_NUMBER");
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        boolean includeFlowVectors = rec.getBoolean("VECTOR", true);
        IQuantity measurement = this.parseQuantity(rec, "QUANTITY", "PART_ID", "SPEC_ID", null, null, null, 128, Intl.intl("SLCF ignored"), true, false);
        if (measurement == null) {
            return false;
        }
        PlanarSlice s = null;
        UnitDouble xPlane = rec.getUnitDouble("PBX");
        if (xPlane != null) {
            s = new PlanarSlice(0, xPlane, measurement, includeFlowVectors);
        } else {
            UnitDouble yPlane = rec.getUnitDouble("PBY");
            if (yPlane != null) {
                s = new PlanarSlice(1, yPlane, measurement, includeFlowVectors);
            } else {
                UnitDouble zPlane = rec.getUnitDouble("PBZ");
                if (zPlane != null) {
                    s = new PlanarSlice(2, zPlane, measurement, includeFlowVectors);
                }
            }
        }
        if (s != null) {
            this.getContainer().getSlcfList().add(s);
            this.flagObjectAdded(s);
            return true;
        }
        this.addWarning(rec, Intl.intl("Unsupported Slice type encountered."), Intl.intl("Ignoring Slice record."));
        return false;
    }
}

