/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.controls.AControl;
import pyrosim.legacy_2012_1.domain.controls.AIntCompareOp;
import pyrosim.legacy_2012_1.domain.controls.AndOp;
import pyrosim.legacy_2012_1.domain.controls.CustomCtrl;
import pyrosim.legacy_2012_1.domain.controls.DblGreaterThanOp;
import pyrosim.legacy_2012_1.domain.controls.DblLessThanOp;
import pyrosim.legacy_2012_1.domain.controls.DeadbandCtrl;
import pyrosim.legacy_2012_1.domain.controls.IControl;
import pyrosim.legacy_2012_1.domain.controls.IntEqualOp;
import pyrosim.legacy_2012_1.domain.controls.IntGreaterThanOp;
import pyrosim.legacy_2012_1.domain.controls.IntLessThanOp;
import pyrosim.legacy_2012_1.domain.controls.IntNotEqualOp;
import pyrosim.legacy_2012_1.domain.controls.LatchCtrl;
import pyrosim.legacy_2012_1.domain.controls.NotOp;
import pyrosim.legacy_2012_1.domain.controls.OrOp;
import pyrosim.legacy_2012_1.domain.controls.SumOp;
import pyrosim.legacy_2012_1.domain.controls.TimeDelayCtrl;
import pyrosim.legacy_2012_1.domain.devices.IDevice;
import pyrosim.legacy_2012_1.domain.devices.simctrl.ASimCtrlDevice;
import pyrosim.legacy_2012_1.domain.devices.simctrl.KillDevice;
import pyrosim.legacy_2012_1.domain.devices.simctrl.RestartFileDevc;
import pyrosim.legacy_2012_1.domain.ramp.IRampInput;
import pyrosim.legacy_2012_1.domain.ramp.Ramp;
import pyrosim.legacy_2012_1.domain.signals.IDoubleInPin;
import pyrosim.legacy_2012_1.domain.signals.ISignalSink;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.PinConnParser;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class ControlParser
extends AFDS5Parser {
    private final PinConnParser d_pinConns;
    private final List<IControl> d_doubleInCtrls;

    public ControlParser(FDS5ParsingInfo parsingInfo, PinConnParser pinConns) {
        super(parsingInfo);
        this.d_pinConns = pinConns;
        this.d_doubleInCtrls = new ArrayList<IControl>();
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("CTRL");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        IControl control;
        String id = (String)rec.get("ID");
        if (id == null || id.trim().equals("")) {
            this.addWarning(rec, Intl.intl("Control has no ID."), Intl.intl("Adding control to additional records section."));
            return false;
        }
        if (this.d_pinConns.outputNameExists(id)) {
            this.addWarning(rec, Intl.intl("CTRL ID is not unique across all controls and devices."), Intl.intl("Ignoring control."));
            return true;
        }
        String function = (String)rec.get("FUNCTION_TYPE");
        if (function == null) {
            this.addWarning(rec, Intl.intl("Control has no function type specified."), Intl.intl("Adding control to additional records section."));
            return false;
        }
        if (function.equals("KILL") || function.equals("RESTART")) {
            ASimCtrlDevice devc = function.equals("KILL") ? this.parseKill(rec, id) : this.parseRestart(rec, id);
            this.markInputRetrieval(rec, devc);
            this.getContainer().getDevices().add(devc);
            this.flagObjectAdded(devc);
            int exists = this.existsStatus(rec, devc, IDevice.class);
            if (exists != 0) {
                return this.convertToReturn(exists);
            }
            this.getContainer().getDevices().add(devc);
            this.flagObjectAdded(devc);
            return true;
        }
        if (function.equals("ANY")) {
            control = this.parseAny(rec);
        } else if (function.equals("ALL")) {
            control = this.parseAll(rec);
        } else if (function.equals("ONLY")) {
            control = this.parseOnly(rec);
        } else if (function.equals("AT_LEAST")) {
            control = this.parseAtLeast(rec);
        } else if (function.equals("TIME_DELAY")) {
            control = this.parseTimeDelay(rec);
        } else if (function.equals("CUSTOM")) {
            control = this.parseCustom(rec);
        } else if (function.equals("DEADBAND")) {
            control = this.parseDeadBand(rec);
        } else {
            this.addWarning(rec, String.format(Intl.intl("Unknown control function type, %s."), function), Intl.intl("Adding control to additional records section."));
            return false;
        }
        if (control != null) {
            control.setName(id);
            this.d_pinConns.addOutputName(control.getOutputPins().get(0), id);
        }
        return true;
    }

    public void finish() throws FDSRecordFormatException {
        for (IControl ctrl : this.d_doubleInCtrls) {
            IDoubleInPin inPin = (IDoubleInPin)ctrl.getInputPin();
            inPin.changeInputUnits(SIUS.getInstance());
        }
    }

    private RestartFileDevc parseRestart(FDSParseRecord rec, String id) {
        return new RestartFileDevc(id);
    }

    private KillDevice parseKill(FDSParseRecord rec, String id) {
        return new KillDevice(id);
    }

    private IControl parseDeadBand(FDSParseRecord rec) {
        int tripDir;
        String onBound = (String)rec.get("ON_BOUND", true);
        if (onBound.equals("LOWER")) {
            tripDir = 0;
        } else if (onBound.equals("UPPER")) {
            tripDir = 1;
        } else {
            this.addWarning(rec, String.format(Intl.intl("Unknown on-bound, %s."), onBound), Intl.intl("Adding control to additional records."));
            return null;
        }
        if (!rec.contains("SETPOINT")) {
            this.addWarning(rec, Intl.intl("Deadband control has no setpoint."), Intl.intl("Adding control to additional records."));
            return null;
        }
        FDSArray bounds = rec.getArray("SETPOINT", true);
        DeadbandCtrl ctrl = new DeadbandCtrl(tripDir, new UnitDouble((Double)bounds.get(0), Unit.ONE), new UnitDouble((Double)bounds.get(1), Unit.ONE));
        this.markInputRetrieval(rec, ctrl);
        this.d_doubleInCtrls.add(ctrl);
        return this.parseInvertAndLatch(rec, ctrl);
    }

    private IControl parseCustom(FDSParseRecord rec) throws FDSRecordFormatException {
        AControl result;
        String rampID = (String)rec.get("RAMP_ID");
        if (rampID == null) {
            throw new FDSRecordFormatException(rec, Intl.intl("Custom control has no ramp function."));
        }
        IRampInput unitlessInput = new IRampInput(){
            private static final long serialVersionUID = -4063231887493305957L;

            @Override
            public String getName() {
                return "";
            }

            @Override
            public int getUnitType() {
                return 28;
            }

            @Override
            public String getTVar() {
                return "T";
            }
        };
        Ramp ramp = this.getParsingInfo().getRamp(rampID, unitlessInput, 28, false);
        if (ramp == null) {
            throw new FDSRecordFormatException(rec, String.format(Intl.intl("Could not find ramp with id, %s."), rampID));
        }
        Pair<List<UnitDouble>, Boolean> rampRes = this.parseCustomRamp(ramp);
        if (((List)rampRes.v1).isEmpty()) {
            throw new FDSRecordFormatException(rec, Intl.intl("Custom ramp contains no zero-crossings."));
        }
        if (((List)rampRes.v1).size() == 1) {
            UnitDouble val = (UnitDouble)((List)rampRes.v1).iterator().next();
            result = (Boolean)rampRes.v2 != false ? new DblLessThanOp(val) : new DblGreaterThanOp(val);
        } else {
            result = new CustomCtrl((boolean)((Boolean)rampRes.v2), (Collection)rampRes.v1);
        }
        this.markInputRetrieval(rec, result);
        this.d_doubleInCtrls.add(result);
        return result;
    }

    private Pair<List<UnitDouble>, Boolean> parseCustomRamp(Ramp ramp) {
        List<Ramp.Entry> entries = ramp.getRecords();
        if (entries.isEmpty()) {
            return new Pair<List<UnitDouble>, Boolean>(new ArrayList(), false);
        }
        TreeMap<Double, Double> vals = new TreeMap<Double, Double>();
        for (Ramp.Entry entry : entries) {
            UnitDouble val = entry.t;
            vals.put(val.getValueNoUnit(), entry.f.getValueNoUnit());
        }
        ArrayList<UnitDouble> crossings = new ArrayList<UnitDouble>();
        boolean initValue = (Double)vals.values().iterator().next() >= 0.0;
        Iterator entryit = vals.entrySet().iterator();
        Map.Entry last = entryit.next();
        while (entryit.hasNext()) {
            Map.Entry curr = entryit.next();
            if ((Double)curr.getValue() < 0.0 && (Double)last.getValue() >= 0.0 || (Double)curr.getValue() >= 0.0 && (Double)last.getValue() < 0.0) {
                double m = ((Double)curr.getValue() - (Double)last.getValue()) / ((Double)curr.getKey() - (Double)last.getKey());
                double b = (Double)curr.getValue() - m * (Double)curr.getKey();
                double crossing = -b / m;
                crossings.add(new UnitDouble(crossing, Unit.ONE));
            }
            last = curr;
        }
        return new Pair<List<UnitDouble>, Boolean>(crossings, initValue);
    }

    private IControl parseTimeDelay(FDSParseRecord rec) {
        UnitDouble delay = (UnitDouble)rec.get("DELAY", true);
        TimeDelayCtrl ctrl = new TimeDelayCtrl(delay);
        this.markInputRetrieval(rec, ctrl);
        return this.parseInvertAndLatch(rec, ctrl);
    }

    private IControl parseAll(FDSParseRecord rec) {
        AndOp op = new AndOp();
        this.markInputRetrieval(rec, op);
        return this.parseInvertAndLatch(rec, op);
    }

    private IControl parseAny(FDSParseRecord rec) {
        OrOp op = new OrOp();
        this.markInputRetrieval(rec, op);
        return this.parseInvertAndLatch(rec, op);
    }

    private IControl parseAtLeast(FDSParseRecord rec) {
        SumOp summer = new SumOp();
        this.markInputRetrieval(rec, summer);
        boolean initState = (Boolean)rec.get("INITIAL_STATE", true);
        int num = rec.getInteger("N", true);
        AIntCompareOp ctrl = initState ? new IntLessThanOp(num) : new IntGreaterThanOp(num - 1);
        ctrl.getInputPin().connect(summer.getOutputPins().get(0));
        return this.parseLatch(rec, ctrl);
    }

    private IControl parseOnly(FDSParseRecord rec) {
        SumOp summer = new SumOp();
        this.markInputRetrieval(rec, summer);
        boolean initState = (Boolean)rec.get("INITIAL_STATE", true);
        int num = (Integer)rec.get("N", true);
        AIntCompareOp ctrl = initState ? new IntNotEqualOp(num) : new IntEqualOp(num);
        ctrl.getInputPin().connect(summer.getOutputPins().get(0));
        return this.parseLatch(rec, ctrl);
    }

    private IControl parseInvertAndLatch(FDSParseRecord rec, IControl existing) {
        return this.parseInvert(rec, this.parseLatch(rec, existing));
    }

    private IControl parseLatch(FDSParseRecord rec, IControl existing) {
        boolean latch = rec.getBoolean("LATCH", true);
        if (latch) {
            LatchCtrl ctrl = new LatchCtrl();
            ctrl.getInputPin().connect(existing.getOutputPins().get(0));
            return ctrl;
        }
        return existing;
    }

    private IControl parseInvert(FDSParseRecord rec, IControl existing) {
        boolean initState = rec.getBoolean("INITIAL_STATE", true);
        if (initState) {
            NotOp op = new NotOp();
            op.getInputPin().connect(existing.getOutputPins().get(0));
            return op;
        }
        return existing;
    }

    private void markInputRetrieval(FDSParseRecord rec, ISignalSink ctrl) {
        List<String> inputIDs = rec.getList("INPUT_ID", false);
        this.d_pinConns.markInputForRetrieval(rec, ctrl.getInputPin(), inputIDs);
    }
}

