/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds;

import java.io.PrintWriter;
import java.util.Map;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordSpec;
import pyrosim.legacy_2012_1.io.fds.FDSRenderProps;
import pyrosim.legacy_2012_1.io.fds.IFDSFieldRenderer;
import pyrosim.legacy_2012_1.thunderheadeng.io.StringPrintWriter;

public class FDSRenderRecord
extends FDSRecord {
    static final long serialVersionUID = 1L;
    private String d_customText = null;

    public FDSRenderRecord(FDSRecordSpec spec, boolean init) {
        super(spec, init);
    }

    public static FDSRenderRecord fromParseRecord(FDSParseRecord rec) {
        FDSRenderRecord renrec = new FDSRenderRecord(rec.getSpec(), false);
        renrec.setComment(rec.getComment());
        for (FDSRecord.UnknownProp unknownProp : rec.getUnknownProps()) {
            renrec.addUnknownProp(unknownProp.key, unknownProp.values);
        }
        for (Map.Entry entry : rec.getProperties().entrySet()) {
            renrec.setValue((String)entry.getKey(), entry.getValue());
        }
        return renrec;
    }

    @Override
    public boolean empty() {
        return super.empty() && this.d_customText == null;
    }

    public void setCustomText(String custom) {
        this.d_customText = custom;
    }

    public String getCustomText() {
        return this.d_customText;
    }

    public String renderRecord(FDSRenderProps props, IFDSFieldRenderer renderer) {
        StringPrintWriter writer = new StringPrintWriter();
        this.renderRecord(writer, props, renderer);
        return writer.toString();
    }

    public void renderRecord(PrintWriter writer, FDSRenderProps props, IFDSFieldRenderer renderer) {
        if (this.d_customText != null) {
            writer.println(this.d_customText);
            return;
        }
        writer.append("&");
        writer.append(this.getType());
        writer.append(" ");
        String fieldSep = props.getFieldSep();
        int ix = 0;
        for (Map.Entry<String, Object> entry : this.getProperties().entrySet()) {
            String hashString = this.renderToString(props, entry.getKey(), entry.getValue());
            if (hashString.length() <= 0) continue;
            if (ix++ > 0) {
                writer.append(fieldSep);
            }
            renderer.render(writer, entry.getKey(), hashString);
        }
        for (FDSRecord.UnknownProp up : this.getUnknownProps()) {
            if (ix++ > 0) {
                writer.append(fieldSep);
            }
            writer.append(up.render());
        }
        writer.append("/");
        String comment = this.getComment();
        if (comment != null) {
            writer.append(" " + comment);
        }
        writer.append(props.getNewline());
    }

    protected String renderToString(FDSRenderProps props, String key, Object value) {
        FDSRecordSpec.Field field = this.getSpec().fields.get(key);
        assert (field != null);
        try {
            return field.render(props, value);
        }
        catch (Throwable t) {
            String msg = String.format("Error rendering %s:%s", this.getType(), key);
            throw new RuntimeException(msg, t);
        }
    }
}

