/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import javax.vecmath.Point3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.APyroObject;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.ExSpecList;
import pyrosim.legacy_2012_1.domain.FDSRun;
import pyrosim.legacy_2012_1.domain.Grid;
import pyrosim.legacy_2012_1.domain.Hierarchy;
import pyrosim.legacy_2012_1.domain.INamed;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.ResultsArchive;
import pyrosim.legacy_2012_1.domain.Serialized;
import pyrosim.legacy_2012_1.domain.boundcond.mat.LiquidPyrolysis;
import pyrosim.legacy_2012_1.domain.boundcond.mat.LiquidReaction;
import pyrosim.legacy_2012_1.domain.boundcond.mat.Material;
import pyrosim.legacy_2012_1.domain.boundcond.mat.ReacByproducts;
import pyrosim.legacy_2012_1.domain.boundcond.mat.SolidPyrolysis;
import pyrosim.legacy_2012_1.domain.boundcond.mat.SolidReaction;
import pyrosim.legacy_2012_1.domain.boundcond.surf.AOutFlowSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ISurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ParticleInjection;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.controls.AControl;
import pyrosim.legacy_2012_1.domain.controls.ADblCompareOp;
import pyrosim.legacy_2012_1.domain.controls.ALogicOp;
import pyrosim.legacy_2012_1.domain.controls.AndOp;
import pyrosim.legacy_2012_1.domain.controls.ControlBridge;
import pyrosim.legacy_2012_1.domain.controls.CustomCtrl;
import pyrosim.legacy_2012_1.domain.controls.DblLessThanOp;
import pyrosim.legacy_2012_1.domain.controls.IControl;
import pyrosim.legacy_2012_1.domain.controls.LatchCtrl;
import pyrosim.legacy_2012_1.domain.controls.NotOp;
import pyrosim.legacy_2012_1.domain.controls.OrOp;
import pyrosim.legacy_2012_1.domain.controls.TimeDelayCtrl;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepSnapshot;
import pyrosim.legacy_2012_1.domain.dependencies.Dependency;
import pyrosim.legacy_2012_1.domain.devices.AlarmInfo;
import pyrosim.legacy_2012_1.domain.devices.IDevice;
import pyrosim.legacy_2012_1.domain.devices.TripFlags;
import pyrosim.legacy_2012_1.domain.devices.detectors.SmokeLinkModel;
import pyrosim.legacy_2012_1.domain.devices.detectors.Timer;
import pyrosim.legacy_2012_1.domain.devices.measurers.Clock;
import pyrosim.legacy_2012_1.domain.devices.measurers.GasPointMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.IMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.LayerMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.MeasureOutInfo;
import pyrosim.legacy_2012_1.domain.devices.measurers.SolidPointMeasurer;
import pyrosim.legacy_2012_1.domain.devices.sprayers.Nozzle;
import pyrosim.legacy_2012_1.domain.devices.sprayers.SprayModel;
import pyrosim.legacy_2012_1.domain.devices.sprayers.Sprinkler;
import pyrosim.legacy_2012_1.domain.evac.CorrList;
import pyrosim.legacy_2012_1.domain.evac.DoorList;
import pyrosim.legacy_2012_1.domain.evac.PersList;
import pyrosim.legacy_2012_1.domain.geom.FDSObject;
import pyrosim.legacy_2012_1.domain.geom.IObstruction;
import pyrosim.legacy_2012_1.domain.managers.Util;
import pyrosim.legacy_2012_1.domain.output.IMeasurementStat;
import pyrosim.legacy_2012_1.domain.output.IsosurfaceMgr;
import pyrosim.legacy_2012_1.domain.output.Slice;
import pyrosim.legacy_2012_1.domain.particle.GenericPartDesc;
import pyrosim.legacy_2012_1.domain.particle.IParticleDesc;
import pyrosim.legacy_2012_1.domain.particle.Output;
import pyrosim.legacy_2012_1.domain.particle.Particle;
import pyrosim.legacy_2012_1.domain.particle.SizeDistribution;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.domain.quantity.QuantityType;
import pyrosim.legacy_2012_1.domain.quantity.StaticQuantity;
import pyrosim.legacy_2012_1.domain.ramp.Ramp;
import pyrosim.legacy_2012_1.domain.rasterization.RasterizationOptions;
import pyrosim.legacy_2012_1.domain.reaction.Reaction;
import pyrosim.legacy_2012_1.domain.signals.IDoubleInPin;
import pyrosim.legacy_2012_1.domain.signals.IInPin;
import pyrosim.legacy_2012_1.domain.signals.IOutPin;
import pyrosim.legacy_2012_1.domain.signals.ISignalSink;
import pyrosim.legacy_2012_1.domain.signals.ISignalSource;
import pyrosim.legacy_2012_1.domain.signals.LogicOutPin;
import pyrosim.legacy_2012_1.domain.texture.TextureInfo;
import pyrosim.legacy_2012_1.domain.zones.Leak;
import pyrosim.legacy_2012_1.domain.zones.Zone;
import pyrosim.legacy_2012_1.domain.zones.ZoneMgr;
import pyrosim.legacy_2012_1.legacy.v22.domain.measure.Measurement;
import pyrosim.legacy_2012_1.legacy.v22.domain.measure.ObjectMeasurement;
import pyrosim.legacy_2012_1.legacy.v26.domain.output.AMeasurementStat;
import pyrosim.legacy_2012_1.legacy.v26.domain.output.GasMeasurementStat;
import pyrosim.legacy_2012_1.legacy.v26.domain.output.SolidMeasurementStat;
import pyrosim.legacy_2012_1.legacy.v28.domain.output.Isosurface;
import pyrosim.legacy_2012_1.legacy.v29.domain.devices.measurers.LayerMeasurer;
import pyrosim.legacy_2012_1.legacy.v30.domain.output.AMsrStat;
import pyrosim.legacy_2012_1.legacy.v30.domain.output.GasMsrStat;
import pyrosim.legacy_2012_1.legacy.v30.domain.output.SolidMsrStat;
import pyrosim.legacy_2012_1.legacy.v31.boundcond.surf.LayeredSurfDesc;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.AAlignedFDSObject;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.AUnalignedFDSObject;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.AbstractFDSObject;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.AbstractFace;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.AlignedBlock;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.AlignedHole;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.FDSConvexPoly;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.Hole;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.IFace;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.PartCloud;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.Slab;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.Vent;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.Wall;
import pyrosim.legacy_2012_1.legacy.v31.domain.texture.BufferModelImage;
import pyrosim.legacy_2012_1.legacy.v31.domain.texture.FileModelImage;
import pyrosim.legacy_2012_1.legacy.v31.geom.Polygon;
import pyrosim.legacy_2012_1.legacy.v31.geom.Quad;
import pyrosim.legacy_2012_1.legacy.v36.domain.Ramp;
import pyrosim.legacy_2012_1.legacy.v39.domain.texture.ModelImage;
import pyrosim.legacy_2012_1.legacy.v42.domain.ExSpecList;
import pyrosim.legacy_2012_1.legacy.v42.domain.FloorManager;
import pyrosim.legacy_2012_1.legacy.v42.domain.GridList;
import pyrosim.legacy_2012_1.legacy.v42.domain.boundcond.mat.MaterialManager;
import pyrosim.legacy_2012_1.legacy.v42.domain.boundcond.surf.SurfaceManager;
import pyrosim.legacy_2012_1.legacy.v42.domain.controls.ControlMgr;
import pyrosim.legacy_2012_1.legacy.v42.domain.devices.DeviceManager;
import pyrosim.legacy_2012_1.legacy.v42.domain.devices.detectors.HeatLinkModelMgr;
import pyrosim.legacy_2012_1.legacy.v42.domain.devices.detectors.SmokeLinkModelMgr;
import pyrosim.legacy_2012_1.legacy.v42.domain.devices.detectors.SprinklerLinkModelMgr;
import pyrosim.legacy_2012_1.legacy.v42.domain.devices.sprayers.SprayModelMgr;
import pyrosim.legacy_2012_1.legacy.v42.domain.evac.EntrList;
import pyrosim.legacy_2012_1.legacy.v42.domain.evac.EvacList;
import pyrosim.legacy_2012_1.legacy.v42.domain.evac.EvhoList;
import pyrosim.legacy_2012_1.legacy.v42.domain.evac.EvssList;
import pyrosim.legacy_2012_1.legacy.v42.domain.evac.ExitList;
import pyrosim.legacy_2012_1.legacy.v42.domain.geom.FDSComposite;
import pyrosim.legacy_2012_1.legacy.v42.domain.geom.FDSObjectManager;
import pyrosim.legacy_2012_1.legacy.v42.domain.hvac.HvacList;
import pyrosim.legacy_2012_1.legacy.v42.domain.managers.ADepPyroList;
import pyrosim.legacy_2012_1.legacy.v42.domain.managers.ADepPyroSet;
import pyrosim.legacy_2012_1.legacy.v42.domain.managers.ADepPyroUniqueMap;
import pyrosim.legacy_2012_1.legacy.v42.domain.managers.APyroList;
import pyrosim.legacy_2012_1.legacy.v42.domain.managers.APyroManager;
import pyrosim.legacy_2012_1.legacy.v42.domain.managers.APyroMap;
import pyrosim.legacy_2012_1.legacy.v42.domain.managers.APyroSet;
import pyrosim.legacy_2012_1.legacy.v42.domain.managers.APyroUniqueMap;
import pyrosim.legacy_2012_1.legacy.v42.domain.managers.IPyroManager;
import pyrosim.legacy_2012_1.legacy.v42.domain.output.ProfList;
import pyrosim.legacy_2012_1.legacy.v42.domain.output.SliceList;
import pyrosim.legacy_2012_1.legacy.v42.domain.output.StatisticMgr;
import pyrosim.legacy_2012_1.legacy.v42.domain.particle.ParticleList;
import pyrosim.legacy_2012_1.legacy.v42.domain.reaction.ReactionList;
import pyrosim.legacy_2012_1.legacy.v42.domain.zones.LeakMgr;
import pyrosim.legacy_2012_1.legacy.v43.domain.Floor;
import pyrosim.legacy_2012_1.legacy.v45.domain.measure.AMeasurement;
import pyrosim.legacy_2012_1.legacy.v45.domain.measure.Measurements;
import pyrosim.legacy_2012_1.legacy.v45.domain.measure.ObjectMsr;
import pyrosim.legacy_2012_1.legacy.v45.domain.measure.StaticMsr;
import pyrosim.legacy_2012_1.thunderheadeng.TeciIO;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AARectangle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.BlockGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.EmptyGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ExtrudedPoly;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomGroup;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.LineSeg;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.NGon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.PolyLine;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.TransformedGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Triangle;
import pyrosim.legacy_2012_1.thunderheadeng.legacy.v5.geometry.objs.WallGeom;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;
import pyrosim.legacy_2012_1.thunderheadeng.util.Global;
import pyrosim.legacy_2012_1.thunderheadeng.util.IdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.thunderheadeng.util.Warning;
import pyrosim.legacy_2012_1.thunderheadeng.util.WarningReport;
import pyrosim.legacy_2012_1.unitsystem.EnglishUS;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class PyroSimObjectInputStream
extends ObjectInputStream {
    public static final int CURR_VERSION = 48;
    public static final int TECI_VERSION = 7;
    public static final byte[] FORMAT_CODE;
    private final int d_version;
    private final int d_teciVersion;
    private String d_revision;
    private final TeciIO d_teciio;
    private final Set<String> d_fileSystemTextures;
    private final WarningReport<Warning> d_warnings = new WarningReport<Warning>(Warning.class, Warning.getWarningInfoTypes(), Warning.getWarningInfoDescriptions(), 0);
    private final Map<UnitPoint3D, UnitPoint3D> d_pointMap = new HashMap<UnitPoint3D, UnitPoint3D>();
    private final Map<Point3d, Point3d> d_point3dMap = new HashMap<Point3d, Point3d>();
    private final Map<Color, Color> d_colorMap = new HashMap<Color, Color>();
    private final Map<String, String> d_strMap = new HashMap<String, String>();
    private final NavigableMap<Integer, Map<String, Class>> d_classLookup;
    private Map<String, IQuantity> d_pre23MsrMap = null;
    private List<ISignalSource> d_pre42SignalSources = null;
    private List<ISignalSink> d_pre42SignalSinks = null;
    private Unit d_pre29ObscurationUnitSIUS = Unit.ONE.divide(SI.METER).alternate("%/m");
    private Unit d_pre29ObscurationUnitEnglish = Unit.ONE.divide(NonSI.FOOT).label("%/ft");
    private Unit d_pre29AspirationUnit = Unit.ONE.alternate("%");
    private Set<SolidReaction.Rate.RefSpec> d_pre32RefSpecs = null;
    private Set<LiquidReaction> d_pre32InvalidReacs = null;
    private Set<Unit> d_obscurationUnits;

    public PyroSimObjectInputStream(InputStream arg0, Set<String> fileSystemTextures) throws IOException {
        super(arg0);
        this.d_fileSystemTextures = fileSystemTextures;
        byte[] formatCode = new byte[FORMAT_CODE.length];
        this.read(formatCode);
        String versionString = new String(formatCode);
        this.d_version = Integer.parseInt(versionString.substring(3));
        if (this.d_version < 30) {
            this.d_teciVersion = 1;
            this.d_revision = "";
        } else {
            this.d_teciVersion = this.readInt();
            try {
                this.d_revision = (String)this.readObject();
            }
            catch (ClassNotFoundException e) {
                assert (false);
                this.d_revision = "";
            }
        }
        this.d_teciio = new TeciIO(this.d_teciVersion);
        this.enableResolveObject(true);
        this.d_classLookup = new TreeMap<Integer, Map<String, Class>>();
        this.initLegClasses();
    }

    public static int getVersion(ObjectInputStream is) {
        return is instanceof PyroSimObjectInputStream ? ((PyroSimObjectInputStream)is).getVersion() : Integer.MAX_VALUE;
    }

    public boolean canOpenVersion() {
        return this.d_version >= 21;
    }

    public boolean isNewer() {
        return this.d_version > 48;
    }

    public String getRevision() {
        return this.d_revision;
    }

    public int getVersion() {
        return this.d_version;
    }

    public Serialized readModel() throws IOException, ClassNotFoundException {
        System.out.printf("loading model (PyroSim Version: %d; Teci Version: %d)%n", this.d_version, this.d_teciVersion);
        if (this.d_version < 21) {
            throw new IOException("[" + this.getClass().getName() + "] Unsupported model version.");
        }
        if (this.d_version < 23) {
            this.constructPre23MsrMap();
        }
        if (this.d_version < 32) {
            this.d_pre32RefSpecs = new IdentityHashSet<SolidReaction.Rate.RefSpec>();
            this.d_pre32InvalidReacs = new IdentityHashSet<LiquidReaction>();
        }
        if (this.d_version < 42) {
            this.d_pre42SignalSources = new ArrayList<ISignalSource>();
            this.d_pre42SignalSinks = new ArrayList<ISignalSink>();
        }
        Serialized ser = (Serialized)this.readObject();
        this.initSerFields(ser);
        this.updateData(ser);
        this.fixSurfRefs(ser);
        return ser;
    }

    private void removeObjsFromInvalidGroups(Serialized ser) {
        HashMap<IPyroObject, List<Composite>> objGroups = new HashMap<IPyroObject, List<Composite>>();
        PyroSimObjectInputStream.mapParents(ser.obstructions, objGroups);
        HashSet<Composite> affectedParents = new HashSet<Composite>();
        for (Map.Entry entry : objGroups.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            for (int m = 1; m < ((List)entry.getValue()).size(); ++m) {
                Composite parent = (Composite)((List)entry.getValue()).get(m);
                parent.remove((IPyroObject)entry.getKey());
                affectedParents.add(parent);
            }
        }
        System.out.printf("Removed duplicate objects from %d groups.%n", affectedParents.size());
    }

    private static void mapParents(Composite parent, Map<IPyroObject, List<Composite>> parents) {
        for (IPyroObject obj : parent.getMembers(IPyroObject.class)) {
            List<Composite> objParents = parents.get(obj);
            if (objParents == null) {
                objParents = new ArrayList<Composite>(2);
                parents.put(obj, objParents);
            }
            if (!objParents.contains(parent)) {
                objParents.add(parent);
            }
            if (!(obj instanceof Composite)) continue;
            PyroSimObjectInputStream.mapParents((Composite)obj, parents);
        }
    }

    private void initSerFields(Serialized ser) {
        if (ser.controls == null) {
            ser.controls = new pyrosim.legacy_2012_1.domain.controls.ControlMgr();
        }
        if (this.d_version < 29) {
            ser.controls = new pyrosim.legacy_2012_1.domain.controls.ControlMgr();
        }
        if (this.d_version < 31) {
            ser.zones = new ZoneMgr();
            ser.zones.addDefaults();
            ser.zoneLeaks = new pyrosim.legacy_2012_1.domain.zones.LeakMgr();
            ser.perss = new PersList();
            ser.exits = new pyrosim.legacy_2012_1.domain.evac.ExitList();
            ser.evacs = new pyrosim.legacy_2012_1.domain.evac.EvacList();
            ser.entrs = new pyrosim.legacy_2012_1.domain.evac.EntrList();
            ser.evhos = new pyrosim.legacy_2012_1.domain.evac.EvhoList();
            ser.corrs = new CorrList();
            ser.evsss = new pyrosim.legacy_2012_1.domain.evac.EvssList();
            ser.doors = new DoorList();
            ser.simParams.getMisc().initEvacProps(ser.surfmgr);
        }
        if (ser.msrStats == null) {
            ser.msrStats = new pyrosim.legacy_2012_1.domain.output.StatisticMgr();
        }
        if (this.d_version < 36) {
            ser.rastProps = new RasterizationOptions();
        }
        if (this.d_version < 37) {
            ser.d_protect = false;
            ser.d_protectPassHash = new byte[0];
        }
        if (this.d_version < 41) {
            ser.hvacSystem = new pyrosim.legacy_2012_1.domain.hvac.HvacList();
        }
        if (this.d_version < 42) {
            ser.resultsArchive = new ResultsArchive();
        }
        if (ser.lastFDSRun == null) {
            ser.lastFDSRun = new FDSRun();
        }
        this.initMissingSurfs(ser);
    }

    private void updateData(Serialized ser) {
        boolean warn;
        if (this.d_version < 25 && (warn = this.updatePre25ISOF(ser.isosurfaces))) {
            this.d_warnings.addWarning(new Warning(Intl.intl("Mass flux isosurface for extra species detected.\nThis value was stored with an incorrect unit type."), Intl.intl("Value has been converted to the correct unit type.  Please verify.")));
        }
        if (this.d_version < 42) {
            this.fixPre42SourceSinkRefs();
        }
        if (this.d_version < 27) {
            this.updatePre27Stats(ser);
        }
        if (this.d_version < 28) {
            this.removeV28DeprecatedQuantities(ser);
            ser.simParams.getFileOutput().convertPre28SpecToQuantity();
        }
        if (this.d_version < 29) {
            this.fixPre29LowerTemp(ser);
            ser.controls = this.createPre29Controls(ser);
        }
        if (this.d_version < 32) {
            this.warnPre32Mats(ser);
        }
        if (this.d_version < 37) {
            this.moveDropsPerSecData(ser);
            this.fixPre37ZoneLeaks(ser);
        }
        if (this.d_version < 39) {
            this.fixPre39DtInsert(ser);
        }
        if (this.d_version < 40) {
            this.fixPre40Defaults(ser);
        }
        if (this.d_version < 43) {
            this.sortManagers(ser);
        }
        if (this.d_version < 47) {
            this.fixPre47DisabledReactions(ser);
        }
        if (this.d_version < 48) {
            this.fixPre48TextureInfos(ser);
        }
    }

    public WarningReport<Warning> getWarnings() {
        return this.d_warnings;
    }

    private void initMissingSurfs(Serialized ser) {
        pyrosim.legacy_2012_1.domain.boundcond.surf.SurfaceManager defMgr = new pyrosim.legacy_2012_1.domain.boundcond.surf.SurfaceManager();
        defMgr.addPredefined();
        for (Surface surf : defMgr.flatten()) {
            if (!surf.isPredefined() || ser.surfmgr.get(surf.getName()) != null) continue;
            ser.surfmgr.add(surf);
        }
    }

    private void fixPre47DisabledReactions(Serialized ser) {
        boolean disabledReacs = false;
        for (Reaction reac : ser.reactions.flatten()) {
            if (reac.isEnabled()) continue;
            disabledReacs = true;
            reac.setEnabled(true);
        }
        if (disabledReacs) {
            String warning = Intl.intl("Reactions can no longer be disabled - they can only be made \"active\" and \"inactive.\"");
            String action = Intl.intl("Re-enabled all reactions.");
            this.getWarnings().addWarning(new Warning(warning, action));
        }
    }

    private void fixPre48TextureInfos(Serialized ser) {
        for (Surface surf : ser.surfmgr.flatten()) {
            TextureInfo ti = surf.getTextureInfo();
            if (ti == null || ser.textures.getTexture(ti.getTexID()) != null || this.d_fileSystemTextures.contains(ti.getTexID())) continue;
            surf.setTexture(null);
            String msg = String.format(Intl.intl("Could not find texture for surface, %1$s: %2$s"), surf.getName(), ti.getTexID());
            String action = Intl.intl("Removed texture from surface.");
            this.getWarnings().addWarning(new Warning(msg, action));
        }
    }

    private void moveDropsPerSecData(Serialized ser) {
        for (SprayModel spry : ser.sprayModels.flatten()) {
            Particle p = spry.getParticle();
            IParticleDesc desc = p.getDescription();
            if (!(desc instanceof GenericPartDesc)) continue;
            GenericPartDesc gDesc = (GenericPartDesc)desc;
            spry.setDropsPerSecond(gDesc.d_dropsPerSec);
        }
        for (Particle p : ser.particles.flatten()) {
            IParticleDesc desc = p.getDescription();
            if (!(desc instanceof GenericPartDesc)) continue;
            GenericPartDesc gDesc = (GenericPartDesc)desc;
            try {
                pyrosim.legacy_2012_1.util.Util.assignFinalField(gDesc, "d_dropsPerSec", -1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void fixPre37ZoneLeaks(Serialized ser) {
        ArrayList<Leak> invalidLeaks = new ArrayList<Leak>();
        for (Leak leak : ser.zoneLeaks.flatten()) {
            Zone zone1 = (Zone)ser.zones.get(leak.zone1.getName());
            Zone zone2 = (Zone)ser.zones.get(leak.zone2.getName());
            if (zone1 == leak.zone1 && zone2 == leak.zone2) continue;
            invalidLeaks.add(leak);
        }
        ser.zoneLeaks.removeAll(invalidLeaks);
    }

    private void fixPre39DtInsert(Serialized ser) {
        for (Surface surf : ser.surfmgr.flatten()) {
            ParticleInjection inj;
            ISurfDesc desc = surf.getSurfDesc();
            if (!(desc instanceof AOutFlowSurfDesc) || (inj = ((AOutFlowSurfDesc)desc).d_partInj) == null) continue;
            Particle p = inj.getParticle();
            try {
                pyrosim.legacy_2012_1.util.Util.assignFinalField(inj, "d_dtInsert", p.getDescription().getOutput().d_dtInsert);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (SprayModel sprayMod : ser.sprayModels.flatten()) {
            Particle p = sprayMod.getParticle();
            if (p == null) continue;
            sprayMod.setDtInsert(p.getDescription().getOutput().d_dtInsert);
        }
    }

    private void fixPre40Defaults(Serialized ser) {
        for (Particle part : ser.particles.flatten()) {
            IParticleDesc desc = part.getDescription();
            Output output = desc.getOutput();
            if (output.d_samplingFactor != -1) continue;
            int newSampleFreq = part.isMassless() ? 1 : 10;
            output = new Output(output.d_age, newSampleFreq);
            IParticleDesc newDesc = desc.setOutput(output);
            part.setDescription(newDesc);
        }
    }

    private void sortManagers(Serialized ser) {
        ArrayList<Composite> allGroups = new ArrayList<Composite>(Hierarchy.flatten(PyroMod.getMembers(ser, true), Composite.class));
        for (Composite group : allGroups) {
            Class type = group.getType();
            if (type.isAssignableFrom(FDSObject.class) || type.isAssignableFrom(Grid.class) || !INamed.class.isAssignableFrom(type)) continue;
            List<IPyroObject> members = pyrosim.legacy_2012_1.util.Util.sort(group.getMembers());
            group.reorder(members);
        }
    }

    private void fixPre29LowerTemp(Serialized ser) {
        for (FDSObject obj : ((APyroObject)ser.obstructions).flatten(FDSObject.class)) {
            this.fixPre29LowerTemp(obj.getInputPin());
        }
        for (Nozzle nozzle : ((APyroObject)ser.devices).flatten(Nozzle.class)) {
            this.fixPre29LowerTemp(nozzle.getInputPin());
        }
    }

    private void fixPre29LowerTemp(IInPin inPin) {
        Unit siLen = SIUS.getInstance().getLengthUnit();
        Unit engLen = EnglishUS.getInstance().getLengthUnit();
        for (IOutPin iOutPin : inPin.getConnections()) {
            CustomCtrl custom;
            IDoubleInPin dblInPin;
            ISignalSource src;
            ISignalSink op;
            boolean inputIsLowerTemp = false;
            if (iOutPin.getAttachedSource() instanceof ISignalSink && (op = (ISignalSink)((Object)iOutPin.getAttachedSource())).getInputPin().getConnections().size() == 1 && (src = op.getInputPin().getConnectedSources().iterator().next()) instanceof pyrosim.legacy_2012_1.domain.devices.measurers.LayerMeasurer && ((pyrosim.legacy_2012_1.domain.devices.measurers.LayerMeasurer)src).getLowerTempInfo().getPin() == op.getInputPin().getConnections().iterator().next()) {
                inputIsLowerTemp = true;
            }
            if (iOutPin.getAttachedSource() instanceof ADblCompareOp && inputIsLowerTemp) {
                op = (ADblCompareOp)iOutPin.getAttachedSource();
                dblInPin = (IDoubleInPin)((ADblCompareOp)op).getInputPin();
                if (((ADblCompareOp)op).getN().getUnit().equals(siLen)) {
                    dblInPin.changeInputUnits(SIUS.getInstance());
                } else if (((ADblCompareOp)op).getN().getUnit().equals(engLen)) {
                    dblInPin.changeInputUnits(EnglishUS.getInstance());
                }
            } else if (iOutPin.getAttachedSource() instanceof CustomCtrl && inputIsLowerTemp && (custom = (CustomCtrl)iOutPin.getAttachedSource()).getTripValues().size() >= 1) {
                dblInPin = (IDoubleInPin)custom.getInputPin();
                Unit testUnit = custom.getTripValues().first().getUnit();
                if (testUnit.equals(siLen)) {
                    dblInPin.changeInputUnits(SIUS.getInstance());
                } else if (testUnit.equals(engLen)) {
                    dblInPin.changeInputUnits(EnglishUS.getInstance());
                }
            }
            if (!(iOutPin.getAttachedSource() instanceof ISignalSink)) continue;
            this.fixPre29LowerTemp(((ISignalSink)((Object)iOutPin.getAttachedSource())).getInputPin());
        }
    }

    /*
     * WARNING - void declaration
     */
    private pyrosim.legacy_2012_1.domain.controls.ControlMgr createPre29Controls(Serialized ser) {
        void var5_11;
        ArrayList<INamed> sinks = new ArrayList<INamed>();
        sinks.addAll(((APyroObject)ser.obstructions).flatten(FDSObject.class));
        sinks.addAll(((APyroObject)ser.devices).flatten(Nozzle.class));
        IdentityHashMap<IDevice, Pre29DevcWrapper> devcWrappers = new IdentityHashMap<IDevice, Pre29DevcWrapper>();
        for (ISignalSink iSignalSink : sinks) {
            PyroSimObjectInputStream.wrapPre29Devices(devcWrappers, iSignalSink.getInputPin(), null);
        }
        boolean convert = false;
        if (!devcWrappers.isEmpty()) {
            System.out.println("Converted control logic to the new control system.");
            convert = true;
        }
        if (convert) {
            for (Pre29DevcWrapper wrapper : devcWrappers.values()) {
                PyroSimObjectInputStream.unwrapPre29Device(ser, wrapper);
            }
        }
        LinkedHashMap<IOutPin, List<IInPin>> linkedHashMap = new LinkedHashMap<IOutPin, List<IInPin>>();
        PyroSimObjectInputStream.disconnectControls(sinks, linkedHashMap);
        if (convert) {
            Map<IOutPin, List<IInPin>> map = this.convertPre29Controls(linkedHashMap);
        }
        pyrosim.legacy_2012_1.domain.controls.ControlMgr mgr = new pyrosim.legacy_2012_1.domain.controls.ControlMgr();
        for (Map.Entry entry : var5_11.entrySet()) {
            ControlBridge bridge = new ControlBridge(Intl.intl("CTRL"));
            Util.autoRename(mgr, bridge);
            bridge.getInputPin().connect((IOutPin)entry.getKey());
            IOutPin bridgeOut = bridge.getOutputPins().get(0);
            for (IInPin inPin : (List)entry.getValue()) {
                inPin.connect(bridgeOut);
            }
            mgr.add(bridge);
        }
        return mgr;
    }

    private static void wrapPre29Devices(Map<IDevice, Pre29DevcWrapper> map, IInPin inPin, IInPin prevLatchOutput) {
        boolean latch = false;
        for (IOutPin iOutPin : inPin.getConnections()) {
            ISignalSource src;
            AControl ctrl = null;
            AlarmInfo ai = null;
            if (iOutPin.getAttachedSource() instanceof CustomCtrl) {
                CustomCtrl customCtrl = (CustomCtrl)iOutPin.getAttachedSource();
                if (customCtrl.getTripValues().size() == 1) {
                    ctrl = customCtrl;
                    ai = new AlarmInfo((UnitDouble)customCtrl.getTripValues().iterator().next(), TripFlags.toFlags(latch, customCtrl.getInitialState()));
                }
            } else if (iOutPin.getAttachedSource() instanceof ADblCompareOp) {
                ADblCompareOp op = (ADblCompareOp)iOutPin.getAttachedSource();
                boolean initOn = op instanceof DblLessThanOp;
                ctrl = op;
                ai = new AlarmInfo(op.getN(), TripFlags.toFlags(latch, initOn));
            }
            IMeasurer devc = null;
            IOutPin devcPin = null;
            if (ctrl != null && ai != null && ctrl.getInputPin().getConnections().size() == 1 && (src = (devcPin = ctrl.getInputPin().getConnections().iterator().next()).getAttachedSource()) instanceof IMeasurer) {
                devc = (IMeasurer)src;
            }
            if (devc != null && devcPin != null) {
                Pre29DevcWrapper wrapper = map.get(devc);
                if (wrapper == null) {
                    wrapper = new Pre29DevcWrapper(devc);
                    map.put(devc, wrapper);
                }
                int quantix = -1;
                for (int m = 0; m < devc.getNumMeasurements(); ++m) {
                    if (devc.getMsrInfo(m).getPin() != devcPin) continue;
                    quantix = m;
                    break;
                }
                assert (quantix != -1);
                List<PinReplacement> pins = wrapper.alarmMaps[quantix].get(ai);
                if (pins == null) {
                    pins = new ArrayList<PinReplacement>();
                    wrapper.alarmMaps[quantix].put(ai, pins);
                }
                IInPin inPinToReplace = latch ? prevLatchOutput : inPin;
                IOutPin outPinToReplace = latch ? ((LatchCtrl)inPin.getAttachedSink()).getOutputPins().get(0) : ctrl.getOutputPins().get(0);
                pins.add(new PinReplacement(outPinToReplace, inPinToReplace));
                continue;
            }
            if (!(iOutPin.getAttachedSource() instanceof ISignalSink)) continue;
            IInPin latchOutput = iOutPin.getAttachedSource() instanceof LatchCtrl ? inPin : null;
            PyroSimObjectInputStream.wrapPre29Devices(map, ((ISignalSink)((Object)iOutPin.getAttachedSource())).getInputPin(), latchOutput);
        }
    }

    private static void unwrapPre29Device(Serialized ser, Pre29DevcWrapper wrapper) {
        if (wrapper.devc instanceof Clock) {
            assert (wrapper.alarmMaps.length == 1);
            for (Map.Entry<AlarmInfo, List<PinReplacement>> entry : wrapper.alarmMaps[0].entrySet()) {
                AlarmInfo ai = entry.getKey();
                List<PinReplacement> repl = entry.getValue();
                Timer timer = new Timer(ai.setpoint, TripFlags.initiallyOn(ai.tripFlags));
                IOutPin timerout = timer.getOutputPins().get(0);
                for (PinReplacement pr : repl) {
                    ((IInPin)pr.v2).disconnect((IOutPin)pr.v1);
                    ((IInPin)pr.v2).connect(timerout);
                }
            }
            return;
        }
        ArrayList<IMeasurer> clones = new ArrayList<IMeasurer>();
        clones.add(wrapper.devc);
        for (int n = 0; n < wrapper.alarmMaps.length; ++n) {
            int cloneix = 0;
            for (Map.Entry<AlarmInfo, List<PinReplacement>> entry : wrapper.alarmMaps[n].entrySet()) {
                IMeasurer devc;
                if (cloneix >= clones.size()) {
                    devc = (IMeasurer)wrapper.devc.clone();
                    for (int m = 0; m < devc.getNumMeasurements(); ++m) {
                        devc.getMsrInfo(m).setAlarmInfo(null);
                    }
                    Util.autoRename(ser.devices, devc);
                    ser.devices.add(devc);
                    clones.add(devc);
                }
                devc = (IMeasurer)clones.get(cloneix++);
                AlarmInfo ai = entry.getKey();
                List<PinReplacement> repl = entry.getValue();
                MeasureOutInfo minfo = devc.getMsrInfo(n);
                minfo.setAlarmInfo(ai);
                LogicOutPin alarmPin = minfo.getAlarmPin();
                for (PinReplacement pr : repl) {
                    ((IInPin)pr.v2).disconnect((IOutPin)pr.v1);
                    ((IInPin)pr.v2).connect(alarmPin);
                }
            }
        }
    }

    private static void disconnectControls(Collection<? extends ISignalSink> objs, Map<IOutPin, List<IInPin>> map) {
        for (ISignalSink iSignalSink : objs) {
            for (IOutPin iOutPin : iSignalSink.getInputPin().getConnections()) {
                List<IInPin> inPins = map.get(iOutPin);
                if (inPins == null) {
                    inPins = new ArrayList<IInPin>(1);
                    map.put(iOutPin, inPins);
                }
                inPins.add(iSignalSink.getInputPin());
            }
            iSignalSink.getInputPin().disconnectAll();
        }
    }

    private Map<IOutPin, List<IInPin>> convertPre29Controls(Map<IOutPin, List<IInPin>> controls) {
        LinkedHashMap<IOutPin, List<IInPin>> result = new LinkedHashMap<IOutPin, List<IInPin>>(controls.size());
        for (Map.Entry<IOutPin, List<IInPin>> entry : controls.entrySet()) {
            IOutPin newPin = this.convertPre29Control(entry.getKey());
            List list = (List)result.get(newPin);
            if (list != null) {
                list.addAll((Collection)entry.getValue());
                continue;
            }
            result.put(newPin, entry.getValue());
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private IOutPin convertPre29Control(IOutPin pin) {
        if (!(pin.getAttachedSource() instanceof AndOp) && !(pin.getAttachedSource() instanceof OrOp)) {
            return pin;
        }
        boolean and = pin.getAttachedSource() instanceof AndOp;
        Set<? extends IOutPin> srcs = ((IControl)pin.getAttachedSource()).getInputPin().getConnections();
        if (srcs.size() > 1) {
            ArrayList<void> deviceOutputs = new ArrayList<void>(srcs.size());
            int invertCount = 0;
            int latchCount = 0;
            int delayCount = 0;
            UnitDouble delay = null;
            for (IOutPin iOutPin : srcs) {
                void var10_10;
                void var10_15;
                void var10_13;
                if (iOutPin.getAttachedSource() instanceof NotOp && ((NotOp)iOutPin.getAttachedSource()).getInputPin().getConnections().size() == 1) {
                    ++invertCount;
                    IOutPin iOutPin2 = ((NotOp)iOutPin.getAttachedSource()).getInputPin().getConnections().iterator().next();
                }
                if (var10_13.getAttachedSource() instanceof TimeDelayCtrl && (delay == null || delay.equals(((TimeDelayCtrl)var10_13.getAttachedSource()).getTimeDelay())) && ((TimeDelayCtrl)var10_13.getAttachedSource()).getInputPin().getConnections().size() == 1) {
                    ++delayCount;
                    TimeDelayCtrl timeDelayCtrl = (TimeDelayCtrl)var10_13.getAttachedSource();
                    delay = timeDelayCtrl.getTimeDelay();
                    IOutPin iOutPin3 = timeDelayCtrl.getInputPin().getConnections().iterator().next();
                }
                if (var10_15.getAttachedSource() instanceof LatchCtrl && ((LatchCtrl)var10_15.getAttachedSource()).getInputPin().getConnections().size() == 1) {
                    ++latchCount;
                    IOutPin iOutPin4 = ((LatchCtrl)var10_15.getAttachedSource()).getInputPin().getConnections().iterator().next();
                }
                if (!(var10_10.getAttachedSource() instanceof IDevice) || var10_10.getAttachedSource() instanceof Timer) continue;
                deviceOutputs.add(var10_10);
            }
            if (!(latchCount != srcs.size() || deviceOutputs.size() != srcs.size() || invertCount != 0 && invertCount != srcs.size() || delayCount != 0 && delayCount != srcs.size())) {
                void var10_23;
                if (invertCount > 0) {
                    and = !and;
                }
                ALogicOp compareOp = and ? new AndOp() : new OrOp();
                for (IOutPin iOutPin : deviceOutputs) {
                    compareOp.getInputPin().connect(iOutPin);
                }
                IOutPin iOutPin = compareOp.getOutputPins().get(0);
                LatchCtrl latchCtrl = new LatchCtrl();
                latchCtrl.getInputPin().connect(iOutPin);
                IOutPin iOutPin5 = latchCtrl.getOutputPins().get(0);
                if (delayCount > 0 && delay.getValueNoUnit() != 0.0) {
                    TimeDelayCtrl delayCtrl = new TimeDelayCtrl(delay);
                    delayCtrl.getInputPin().connect(iOutPin5);
                    IOutPin iOutPin6 = delayCtrl.getOutputPins().get(0);
                }
                if (invertCount > 0) {
                    void var10_21;
                    NotOp invert = new NotOp();
                    invert.getInputPin().connect((IOutPin)var10_21);
                    IOutPin iOutPin7 = invert.getOutputPins().get(0);
                }
                return var10_23;
            }
        }
        return pin;
    }

    private void warnPre32Mats(Serialized ser) {
        String msg;
        Object action;
        ArrayList<Object> affectedMats = new ArrayList<Object>();
        for (Object mat : ser.matmgr.flatten()) {
            if (!this.usesOldSpec((Material)mat)) continue;
            affectedMats.add(mat);
        }
        if (!affectedMats.isEmpty()) {
            action = Intl.intl("No action taken.  Please review the material.");
            for (Material material : affectedMats) {
                msg = String.format(Intl.intl("Material %s: reaction reference rates are no longer supported starting in FDS 5.4.0."), material.getName());
                this.d_warnings.addWarning(new Warning(msg, (String)action));
            }
        }
        affectedMats.clear();
        for (Object mat : ser.matmgr.flatten()) {
            if (!(((Material)mat).getPyrolysis() instanceof LiquidPyrolysis)) continue;
            LiquidPyrolysis liquidPyrolysis = (LiquidPyrolysis)((Material)mat).getPyrolysis();
            if (!this.d_pre32InvalidReacs.contains(liquidPyrolysis.d_reaction)) continue;
            affectedMats.add(mat);
        }
        if (!affectedMats.isEmpty()) {
            action = String.format(Intl.intl("Assigned a heat of vaporization of %s."), Global.format(SIUS.newud(0.0, 46)));
            for (Material material : affectedMats) {
                msg = String.format(Intl.intl("Material %s: liquid materials must specify a heat of vaporization starting with FDS 5.4.0."), material.getName());
                this.d_warnings.addWarning(new Warning(msg, (String)action));
            }
        }
    }

    private boolean usesOldSpec(Material mat) {
        if (mat.getPyrolysis() instanceof SolidPyrolysis) {
            for (SolidReaction reac : ((SolidPyrolysis)mat.getPyrolysis()).getReactions()) {
                if (!this.d_pre32RefSpecs.contains(reac.d_rate.d_spec)) continue;
                return true;
            }
        }
        return false;
    }

    private void fixSurfRefs(Serialized ser) {
        ArrayList<Surface> addedSurfs = new ArrayList<Surface>();
        int numBad = 0;
        for (FDSObject obj : ((APyroObject)ser.obstructions).flatten(FDSObject.class)) {
            if (obj instanceof IObstruction) {
                int bad = 0;
                IObstruction obst = (IObstruction)obj;
                Surface[] surfs = obst.getSurfaces();
                for (int m = 0; m < surfs.length; ++m) {
                    Surface surf = surfs[m];
                    Surface inModel = (Surface)ser.surfmgr.get(surf.getName());
                    if (inModel == null) {
                        ser.surfmgr.add(surf);
                        addedSurfs.add(surf);
                        continue;
                    }
                    if (surf == inModel) continue;
                    surfs[m] = inModel;
                    ++bad;
                }
                if (bad > 0) {
                    obst.setSurfaces(surfs);
                }
                numBad += bad;
                continue;
            }
            if (!(obj instanceof pyrosim.legacy_2012_1.domain.geom.Vent)) continue;
            pyrosim.legacy_2012_1.domain.geom.Vent vent = (pyrosim.legacy_2012_1.domain.geom.Vent)obj;
            Surface surf = vent.getSurface();
            Surface inModel = (Surface)ser.surfmgr.get(surf.getName());
            if (inModel == null) {
                ser.surfmgr.add(surf);
                addedSurfs.add(surf);
                continue;
            }
            if (surf == inModel) continue;
            vent.setSurface(inModel);
            ++numBad;
        }
        if (numBad > 0) {
            System.err.println("Fixed " + numBad + " invalid surface references.");
        }
        if (!addedSurfs.isEmpty()) {
            Object surfsStr = "";
            for (int m = 0; m < addedSurfs.size(); ++m) {
                if (m > 0) {
                    surfsStr = (String)surfsStr + ", ";
                }
                surfsStr = (String)surfsStr + ((Surface)addedSurfs.get(m)).getName();
            }
            String msg = String.format(Intl.intl("Found %d surface(s) missing from the model: %s"), addedSurfs.size(), surfsStr);
            String action = Intl.intl("Added extra surfaces to the model.");
            this.d_warnings.addWarning(new Warning(msg, action));
        }
    }

    private void constructPre23MsrMap() {
        this.d_pre23MsrMap = new HashMap<String, IQuantity>();
        this.addPre23Msr(Intl.intl("Absorption Coefficient"), Quantity.ABSORPTION_COEFFICIENT);
        this.addPre23Msr(Intl.intl("Carbon Dioxide Concentration"), ExSpecList.MixFrac.CARBON_DIOXIDE.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("Carbon Dioxide"), ExSpecList.MixFrac.CARBON_DIOXIDE.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("Carbon Monoxide Concentration"), ExSpecList.MixFrac.CARBON_MONOXIDE.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("Carbon Monoxide"), ExSpecList.MixFrac.CARBON_MONOXIDE.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("Density"), Quantity.DENSITY);
        this.addPre23Msr(Intl.intl("Divergence"), Quantity.DIVERGENCE);
        this.addPre23Msr(Intl.intl("Extinction Coefficient"), Quantity.EXTINCTION_COEFFICIENT);
        this.addPre23Msr(Intl.intl("Fuel Concentration"), ExSpecList.MixFrac.FUEL.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("Fuel"), ExSpecList.MixFrac.FUEL.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("H"), Quantity.H);
        this.addPre23Msr(Intl.intl("Heat Release Rate per Unit Volume"), Quantity.HRRPUV);
        this.addPre23Msr(Intl.intl("Hydrogen Concentration"), ExSpecList.MixFrac.HYDROGEN.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("Hydrogen"), ExSpecList.MixFrac.HYDROGEN.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("Mixture Fraction"), Quantity.MIXTURE_FRACTION);
        this.addPre23Msr(Intl.intl("Nitrogen Concentration"), ExSpecList.MixFrac.NITROGEN.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("Nitrogen"), ExSpecList.MixFrac.NITROGEN.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("Other Concentration"), ExSpecList.MixFrac.OTHER.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("Oxygen Concentration"), ExSpecList.MixFrac.OXYGEN.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("Oxygen"), ExSpecList.MixFrac.OXYGEN.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("Oxygen Mass Fraction"), ExSpecList.MixFrac.OXYGEN.spec, Quantity.SPEC_MASS_FRACTION);
        this.addPre23Msr(Intl.intl("Pressure"), Quantity.PRESSURE);
        this.addPre23Msr(Intl.intl("Radiant Intensity"), Quantity.RADIANT_INTENSITY);
        this.addPre23Msr(Intl.intl("Soot Concentration"), ExSpecList.MixFrac.SOOT.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("Soot"), ExSpecList.MixFrac.SOOT.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("Soot Volume Fraction"), ExSpecList.MixFrac.SOOT.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("Soot Density"), ExSpecList.MixFrac.SOOT.spec, Quantity.SPEC_DENSITY);
        this.addPre23Msr(Intl.intl("Temperature"), Quantity.TEMPERATURE);
        this.addPre23Msr(Intl.intl("Thermocouple"), Quantity.THERMOCOUPLE);
        this.addPre23Msr(Intl.intl("U-Velocity"), Quantity.U_VELOCITY);
        this.addPre23Msr(Intl.intl("V-Velocity"), Quantity.V_VELOCITY);
        this.addPre23Msr(Intl.intl("W-Velocity"), Quantity.W_VELOCITY);
        this.addPre23Msr(Intl.intl("Velocity"), Quantity.VELOCITY);
        this.addPre23Msr(Intl.intl("Viscosity"), Quantity.VISCOSITY);
        this.addPre23Msr(Intl.intl("Visibility"), Quantity.VISIBILITY);
        this.addPre23Msr(Intl.intl("Water Vapor"), ExSpecList.MixFrac.WATER_VAPOR.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("Adiabatic Surface Temperature"), Quantity.ADIABATIC_SURFACE_TEMPERATURE);
        this.addPre23Msr(Intl.intl("Back Wall Temperature"), Quantity.BACK_WALL_TEMPERATURE);
        this.addPre23Msr(Intl.intl("Burning Rate"), Quantity.BURNING_RATE);
        this.addPre23Msr(Intl.intl("Convective Flux"), Quantity.CONVECTIVE_FLUX);
        this.addPre23Msr(Intl.intl("Gas Temperature"), Quantity.GAS_TEMPERATURE);
        this.addPre23Msr(Intl.intl("Gauge Heat Flux"), Quantity.GAUGE_HEAT_FLUX);
        this.addPre23Msr(Intl.intl("Heat Flux"), Quantity.HEAT_FLUX);
        this.addPre23Msr(Intl.intl("Heat Transfer Coefficient"), Quantity.HEAT_TRANSFER_COEFFICIENT);
        this.addPre23Msr(Intl.intl("Incident Heat Flux"), Quantity.INCIDENT_HEAT_FLUX);
        this.addPre23Msr(Intl.intl("Inside Wall Temperature"), Quantity.INSIDE_WALL_TEMPERATURE);
        this.addPre23Msr(Intl.intl("Mass Loss"), Quantity.MASS_LOSS);
        this.addPre23Msr(Intl.intl("Normal Velocity"), Quantity.NORMAL_VELOCITY);
        this.addPre23Msr(Intl.intl("Pressure Coefficient"), Quantity.PRESSURE_COEFFICIENT);
        this.addPre23Msr(Intl.intl("Radiative Flux"), Quantity.RADIATIVE_FLUX);
        this.addPre23Msr(Intl.intl("Radiometer"), Quantity.RADIOMETER);
        this.addPre23Msr(Intl.intl("Wall Temperature"), Quantity.WALL_TEMPERATURE);
        this.addPre23Msr(Intl.intl("Wall Thickness"), Quantity.WALL_THICKNESS);
        this.addPre23Msr(Intl.intl("Heat Flow"), Quantity.HEAT_FLOW);
        this.addPre23Msr(Intl.intl("Heat Release Rate"), Quantity.HRR);
        this.addPre23Msr(Intl.intl("Mass Flow"), Quantity.MASS_FLOW);
        this.addPre23Msr(Intl.intl("Volume Flow"), Quantity.VOLUME_FLOW);
        this.addPre23Msr(Intl.intl("Layer Height"), Quantity.LAYER_HEIGHT);
        this.addPre23Msr(Intl.intl("Lower Temperature"), Quantity.LOWER_TEMPERATURE);
        this.addPre23Msr(Intl.intl("Path Obscuration"), Quantity.PATH_OBSCURATION);
        this.addPre23Msr(Intl.intl("Upper Temperature"), Quantity.UPPER_TEMPERATURE);
        this.addPre23Msr(Intl.intl("Time"), Quantity.TIME);
        this.addPre23Msr(Intl.intl("Aspiration"), Quantity.ASPIRATION);
    }

    private void addPre23Msr(String oldMsr, IPyroObject obj, Quantity newQuantity) {
        this.d_pre23MsrMap.put(oldMsr, newQuantity.create(obj));
    }

    private void addPre23Msr(String oldMsr, Quantity newMsr) {
        this.d_pre23MsrMap.put(oldMsr, newMsr.create());
    }

    private boolean updatePre25ISOF(IsosurfaceMgr isofs) {
        boolean warn = false;
        for (pyrosim.legacy_2012_1.domain.output.Isosurface isof : isofs.flatten()) {
            IQuantity msr = isof.getQuantity();
            Quantity quantity = msr.get();
            if (quantity.requiredTypes.length <= 0 || !ExSpec.class.isAssignableFrom(quantity.requiredTypes[0])) continue;
            int unitType = quantity.unitType;
            if (isof.getContours().size() <= 0) continue;
            warn |= quantity == Quantity.SPEC_MASS_FLUX_X || quantity == Quantity.SPEC_MASS_FLUX_Y || quantity == Quantity.SPEC_MASS_FLUX_Z;
            List<UnitDouble> oldContours = isof.getContours();
            ArrayList<UnitDouble> newContours = new ArrayList<UnitDouble>();
            for (UnitDouble udOld : oldContours) {
                newContours.add(SIUS.newud(udOld.getValueNoUnit(), unitType));
            }
            isof.setContours(newContours);
        }
        return warn;
    }

    /*
     * WARNING - void declaration
     */
    private void fixPre42SourceSinkRefs() {
        assert (this.d_pre42SignalSinks != null && this.d_pre42SignalSources != null);
        for (ISignalSink sink : this.d_pre42SignalSinks) {
            IInPin pin = sink.getInputPin();
            if (pin == null) continue;
            pin.setSink(sink);
        }
        for (ISignalSource source : this.d_pre42SignalSources) {
            void var4_6;
            for (IOutPin iOutPin : source.getOutputPins()) {
                iOutPin.setSource(source);
            }
            if (!(source instanceof IMeasurer)) continue;
            IMeasurer measurer = (IMeasurer)source;
            boolean bl = false;
            while (var4_6 < measurer.getNumMeasurements()) {
                measurer.getMsrInfo((int)var4_6).legacySetSource(measurer);
                ++var4_6;
            }
        }
    }

    private void updatePre27Stats(Serialized ser) {
        ser.msrStats.prune();
        ArrayList stats = new ArrayList(ser.msrStats.flatten());
        for (int m = stats.size() - 1; m >= 0; --m) {
            IMeasurementStat stat = (IMeasurementStat)stats.get(m);
            String name = stat.getName();
            List<IMeasurementStat> matches = ser.msrStats.findAll(name, IMeasurementStat.class, true);
            if (matches.size() <= 1) continue;
            Util.autoRename(ser.msrStats, stat);
        }
    }

    private void removeObjs(PyroMod domain, DepSnapshot ss, Collection<? extends IPyroObject> objs) {
        LinkedIdentityHashSet allToRemove = new LinkedIdentityHashSet();
        LinkedIdentityHashSet<IPyroObject> toRemove = new LinkedIdentityHashSet<IPyroObject>(objs);
        while (!toRemove.isEmpty()) {
            allToRemove.addAll(toRemove);
            LinkedIdentityHashSet incidentalDeletes = new LinkedIdentityHashSet();
            for (IPyroObject iPyroObject : toRemove) {
                Set<Dependency> deps = ss.getDependents(iPyroObject);
                for (Dependency dep : deps) {
                    assert (dep.link != DLink.REQUIRED);
                    if (dep.link == DLink.STRONG && dep.source instanceof IPyroObject && !allToRemove.contains((IPyroObject)((Object)dep.source)) && pyrosim.legacy_2012_1.util.Util.canDelete(domain, dep.source)) {
                        incidentalDeletes.add((IPyroObject)((Object)dep.source));
                        continue;
                    }
                    dep.source.taskReplaceDep(iPyroObject, null).run();
                }
            }
            toRemove = incidentalDeletes;
        }
        for (IPyroObject obj : allToRemove) {
            IPyroObject iPyroObject = obj.getParent();
            if (!(iPyroObject instanceof Composite)) continue;
            String catName = pyrosim.legacy_2012_1.util.Util.getCatName(obj);
            String msg = String.format(Intl.intl("The %s, %s, is no longer valid."), catName, pyrosim.legacy_2012_1.util.Util.getName(obj));
            String action = String.format(Intl.intl("Removed %s from the model."), catName);
            this.d_warnings.addWarning(new Warning(msg, action));
            ((Composite)iPyroObject).remove(obj);
        }
    }

    private void removeV28DeprecatedQuantities(Serialized ser) {
        PyroMod tempMod = new PyroMod(ser, false, false);
        LinkedHashSet<StaticQuantity> depMsrs = new LinkedHashSet<StaticQuantity>();
        depMsrs.add(Quantity.RADIANT_INTENSITY.create());
        ArrayList<IPyroObject> toRemove = new ArrayList<IPyroObject>();
        block0: for (IMeasurer devc : ((APyroObject)ser.devices).flatten(IMeasurer.class)) {
            for (int m = 0; m < devc.getNumMeasurements(); ++m) {
                if (!depMsrs.contains(devc.getQuantity(m))) continue;
                toRemove.add(devc);
                continue block0;
            }
        }
        for (Sprinkler sprk : ((APyroObject)ser.devices).flatten(Sprinkler.class)) {
            if (!(sprk.getLinkModel() instanceof Sprinkler.QuantityModel) || !depMsrs.contains(((Sprinkler.QuantityModel)sprk.getLinkModel()).d_quantity)) continue;
            toRemove.add(sprk);
        }
        for (Slice slice : ser.slices.flatten()) {
            if (!depMsrs.contains(slice.getQuantity())) continue;
            toRemove.add(slice);
        }
        for (pyrosim.legacy_2012_1.domain.output.Isosurface isof : ser.isosurfaces.flatten()) {
            if (!depMsrs.contains(isof.getQuantity())) continue;
            toRemove.add(isof);
        }
        for (IMeasurementStat stat : ser.msrStats.flatten()) {
            if (!depMsrs.contains(stat.getQuantity())) continue;
            toRemove.add(stat);
        }
        boolean quantityReferenced = !toRemove.isEmpty();
        HashSet<IQuantity> pl3dQuants = new HashSet<IQuantity>(ser.plot3d.getQuantities());
        if (pl3dQuants.removeAll(depMsrs)) {
            quantityReferenced = true;
            ser.plot3d.setQuantities(pl3dQuants);
        }
        if (quantityReferenced) {
            this.d_warnings.addWarning(new Warning(String.format(Intl.intl("RADIANT_INTENSITY is no longer supported since FDS 5.2."), new Object[0]), Intl.intl("All references to RADIANT_INTENSITY have been removed.")));
        }
        this.removeObjs(tempMod, tempMod.getDependencies(new IPyroObject[0]), toRemove);
        ser.setDomain(null);
        IdentityHashSet invalidIsofMsrs = new IdentityHashSet();
        for (Particle part : ser.particles.flatten()) {
            if (part.isMassless()) continue;
            invalidIsofMsrs.add(Quantity.PART_MPUV.create(part));
        }
        ArrayList<pyrosim.legacy_2012_1.domain.output.Isosurface> invalidIsof = new ArrayList<pyrosim.legacy_2012_1.domain.output.Isosurface>();
        for (pyrosim.legacy_2012_1.domain.output.Isosurface iso : ser.isosurfaces.flatten()) {
            IQuantity msr = iso.getQuantity();
            if (!invalidIsofMsrs.contains(msr)) continue;
            invalidIsof.add(iso);
        }
        if (!invalidIsof.isEmpty()) {
            ser.isosurfaces.removeAll(invalidIsof);
            this.d_warnings.addWarning(new Warning(Intl.intl("Starting with FDS version 5.2, Isosurfaces can no longer output particle quantities."), Intl.intl("Relevant Isosurfaces have been removed.")));
        }
    }

    private void initLegClasses() {
        this.addLegClass(23, "pyrosim.domain.measure.Measurement", Measurement.class);
        this.addLegClass(23, "pyrosim.domain.measure.ObjectMeasurement", ObjectMeasurement.class);
        this.addLegClass(27, "pyrosim.domain.output.AMeasurementStat", AMeasurementStat.class);
        this.addLegClass(27, "pyrosim.domain.output.GasMeasurementStat", GasMeasurementStat.class);
        this.addLegClass(27, "pyrosim.domain.output.SolidMeasurementStat", SolidMeasurementStat.class);
        this.addLegClass(28, "pyrosim.domain.output.Isosurface", Isosurface.class);
        this.addLegClass(28, "pyrosim.domain.output.IsosurfaceMgr", pyrosim.legacy_2012_1.legacy.v28.domain.output.IsosurfaceMgr.class);
        this.addLegClass(29, "pyrosim.domain.devices.measurers.LayerMeasurer", LayerMeasurer.class);
        this.addLegClass(31, "pyrosim.domain.output.GasMsrStat$AreaGeom", GasMsrStat.AreaGeom.class);
        this.addLegClass(31, "pyrosim.domain.output.GasMsrStat$VolumeGeom", GasMsrStat.VolumeGeom.class);
        this.addLegClass(31, "pyrosim.domain.output.GasMsrStat$GridGeom", GasMsrStat.GridGeom.class);
        this.addLegClass(31, "pyrosim.domain.output.AMsrStat", AMsrStat.class);
        this.addLegClass(31, "pyrosim.domain.output.SolidMsrStat", SolidMsrStat.class);
        this.addLegClass(31, "pyrosim.domain.output.GasMsrStat", GasMsrStat.class);
        this.addLegClass(31, "pyrosim.geom.Polygon", Polygon.class);
        this.addLegClass(31, "pyrosim.geom.Quad", Quad.class);
        this.addLegClass(31, "pyrosim.domain.geom.AAlignedFDSObject", AAlignedFDSObject.class);
        this.addLegClass(31, "pyrosim.domain.geom.AAlignedFDSObject$AAlignedFDSObjectFace", AAlignedFDSObject.AAlignedFDSObjectFace.class);
        this.addLegClass(31, "pyrosim.domain.geom.AARectangle", pyrosim.legacy_2012_1.legacy.v31.domain.geom.AARectangle.class);
        this.addLegClass(31, "pyrosim.domain.geom.AbstractFace", AbstractFace.class);
        this.addLegClass(31, "pyrosim.domain.geom.AbstractFDSObject", AbstractFDSObject.class);
        this.addLegClass(31, "pyrosim.domain.geom.AlignedBlock", AlignedBlock.class);
        this.addLegClass(31, "pyrosim.domain.geom.AlignedHole", AlignedHole.class);
        this.addLegClass(31, "pyrosim.domain.geom.AUnalignedFDSObject", AUnalignedFDSObject.class);
        this.addLegClass(31, "pyrosim.domain.geom.AUnalignedFDSObject$BlockFace", AUnalignedFDSObject.BlockFace.class);
        this.addLegClass(31, "pyrosim.domain.geom.FDSConvexPoly", FDSConvexPoly.class);
        this.addLegClass(31, "pyrosim.domain.geom.FDSConvexPoly$ConvexPolyFace", FDSConvexPoly.ConvexPolyFace.class);
        this.addLegClass(31, "pyrosim.domain.geom.Hole", Hole.class);
        this.addLegClass(31, "pyrosim.domain.geom.Hole$BlockFace", Hole.BlockFace.class);
        this.addLegClass(31, "pyrosim.domain.geom.IFace", IFace.class);
        this.addLegClass(31, "pyrosim.domain.geom.PartCloud", PartCloud.class);
        this.addLegClass(31, "pyrosim.domain.geom.Slab", Slab.class);
        this.addLegClass(31, "pyrosim.domain.geom.Slab$SlabFace", Slab.SlabFace.class);
        this.addLegClass(31, "pyrosim.domain.geom.Vent", Vent.class);
        this.addLegClass(31, "pyrosim.domain.geom.Vent$VentFace", Vent.VentFace.class);
        this.addLegClass(31, "pyrosim.domain.geom.Wall", Wall.class);
        this.addLegClass(31, "pyrosim.domain.geom.FDSComposite", pyrosim.legacy_2012_1.legacy.v31.domain.geom.FDSComposite.class);
        this.addLegClass(31, "pyrosim.domain.texture.ModelImage", pyrosim.legacy_2012_1.legacy.v31.domain.texture.ModelImage.class);
        this.addLegClass(31, "pyrosim.domain.texture.BufferModelImage", BufferModelImage.class);
        this.addLegClass(31, "pyrosim.domain.texture.FileModelImage", FileModelImage.class);
        this.addLegClass(31, "pyrosim.domain.boundcond.surf.LayeredSurfDesc", LayeredSurfDesc.class);
        this.addLegClass(33, "pyrosim.geom.AABoxGeom", AABoxGeom.class);
        this.addLegClass(33, "pyrosim.geom.AARectangle", AARectangle.class);
        this.addLegClass(33, "pyrosim.geom.BlockGeom", BlockGeom.class);
        this.addLegClass(33, "pyrosim.geom.EmptyGeom", EmptyGeom.class);
        this.addLegClass(33, "pyrosim.geom.ExtrudedPoly", ExtrudedPoly.class);
        this.addLegClass(33, "pyrosim.geom.GeomGroup", GeomGroup.class);
        this.addLegClass(33, "pyrosim.geom.IGeom", IGeom.class);
        this.addLegClass(33, "pyrosim.geom.IPolygon", IPolygon.class);
        this.addLegClass(33, "pyrosim.geom.LineSeg", LineSeg.class);
        this.addLegClass(33, "pyrosim.geom.Mesh", Mesh.class);
        this.addLegClass(33, "pyrosim.geom.NGon", NGon.class);
        this.addLegClass(33, "pyrosim.geom.Point", Point.class);
        this.addLegClass(33, "pyrosim.geom.PolyLine", PolyLine.class);
        this.addLegClass(33, "pyrosim.geom.Quad", pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Quad.class);
        this.addLegClass(33, "pyrosim.geom.TransformedGeom", TransformedGeom.class);
        this.addLegClass(33, "pyrosim.geom.Triangle", Triangle.class);
        this.addLegClass(33, "pyrosim.geom.WallGeom", WallGeom.class);
        this.addLegClass(37, "pyrosim.domain.Ramp", Ramp.class);
        this.addLegClass(37, "pyrosim.domain.Ramp$Entry", Ramp.Entry.class);
        this.addLegClass(40, "pyrosim.domain.texture.ModelImage", ModelImage.class);
        this.addLegClass(43, "pyrosim.domain.ExSpecList", ExSpecList.class);
        this.addLegClass(43, "pyrosim.domain.geom.FDSObjectManager", FDSObjectManager.class);
        this.addLegClass(43, "pyrosim.domain.FloorManager", FloorManager.class);
        this.addLegClass(43, "pyrosim.domain.GridList", GridList.class);
        this.addLegClass(43, "pyrosim.domain.boundcond.mat.MaterialManager", MaterialManager.class);
        this.addLegClass(43, "pyrosim.domain.boundcond.surf.SurfaceManager", SurfaceManager.class);
        this.addLegClass(43, "pyrosim.domain.controls.ControlMgr", ControlMgr.class);
        this.addLegClass(43, "pyrosim.domain.devices.DeviceManager", DeviceManager.class);
        this.addLegClass(43, "pyrosim.domain.devices.detectors.HeatLinkModelMgr", HeatLinkModelMgr.class);
        this.addLegClass(43, "pyrosim.domain.devices.detectors.SmokeLinkModelMgr", SmokeLinkModelMgr.class);
        this.addLegClass(43, "pyrosim.domain.devices.detectors.SprinklerLinkModelMgr", SprinklerLinkModelMgr.class);
        this.addLegClass(43, "pyrosim.domain.devices.sprayers.SprayModelMgr", SprayModelMgr.class);
        this.addLegClass(43, "pyrosim.domain.evac.CorrList", pyrosim.legacy_2012_1.legacy.v42.domain.evac.CorrList.class);
        this.addLegClass(43, "pyrosim.domain.evac.DoorList", pyrosim.legacy_2012_1.legacy.v42.domain.evac.DoorList.class);
        this.addLegClass(43, "pyrosim.domain.evac.EntrList", EntrList.class);
        this.addLegClass(43, "pyrosim.domain.evac.EvacList", EvacList.class);
        this.addLegClass(43, "pyrosim.domain.evac.EvhoList", EvhoList.class);
        this.addLegClass(43, "pyrosim.domain.evac.EvssList", EvssList.class);
        this.addLegClass(43, "pyrosim.domain.evac.ExitList", ExitList.class);
        this.addLegClass(43, "pyrosim.domain.evac.PersList", pyrosim.legacy_2012_1.legacy.v42.domain.evac.PersList.class);
        this.addLegClass(43, "pyrosim.domain.geom.FDSComposite", FDSComposite.class);
        this.addLegClass(43, "pyrosim.domain.hvac.HvacList", HvacList.class);
        this.addLegClass(43, "pyrosim.domain.managers.ADepPyroList", ADepPyroList.class);
        this.addLegClass(43, "pyrosim.domain.managers.ADepPyroSet", ADepPyroSet.class);
        this.addLegClass(43, "pyrosim.domain.managers.ADepPyroUniqueMap", ADepPyroUniqueMap.class);
        this.addLegClass(43, "pyrosim.domain.managers.APyroList", APyroList.class);
        this.addLegClass(43, "pyrosim.domain.managers.APyroManager", APyroManager.class);
        this.addLegClass(43, "pyrosim.domain.managers.APyroMap", APyroMap.class);
        this.addLegClass(43, "pyrosim.domain.managers.APyroSet", APyroSet.class);
        this.addLegClass(43, "pyrosim.domain.managers.APyroUniqueMap", APyroUniqueMap.class);
        this.addLegClass(43, "pyrosim.domain.output.IsosurfaceMgr", pyrosim.legacy_2012_1.legacy.v42.domain.output.IsosurfaceMgr.class);
        this.addLegClass(43, "pyrosim.domain.output.ProfList", ProfList.class);
        this.addLegClass(43, "pyrosim.domain.output.SliceList", SliceList.class);
        this.addLegClass(43, "pyrosim.domain.output.StatisticMgr", StatisticMgr.class);
        this.addLegClass(43, "pyrosim.domain.particle.ParticleList", ParticleList.class);
        this.addLegClass(43, "pyrosim.domain.reaction.ReactionList", ReactionList.class);
        this.addLegClass(43, "pyrosim.domain.zones.LeakMgr", LeakMgr.class);
        this.addLegClass(43, "pyrosim.domain.zones.ZoneMgr", pyrosim.legacy_2012_1.legacy.v42.domain.zones.ZoneMgr.class);
        this.addLegClass(44, "pyrosim.domain.Floor", Floor.class);
        this.addLegClass(45, "pyrosim.domain.geom.FDSComposite", pyrosim.legacy_2012_1.legacy.v44.domain.geom.FDSComposite.class);
        this.addLegClass(46, "pyrosim.domain.measure.AMeasurement", AMeasurement.class);
        this.addLegClass(46, "pyrosim.domain.measure.ObjectMsr", ObjectMsr.class);
        this.addLegClass(46, "pyrosim.domain.measure.StaticMsr", StaticMsr.class);
        this.addLegClass(46, "pyrosim.domain.measure.Measurements$VelocitySign", Measurements.VelocitySign.class);
    }

    private void addLegClass(int version, String legName, Class newClass) {
        HashMap<String, Class> versionMap = (HashMap<String, Class>)this.d_classLookup.get(version);
        if (versionMap == null) {
            versionMap = new HashMap<String, Class>();
            this.d_classLookup.put(version, versionMap);
        }
        versionMap.put(legName, newClass);
    }

    protected Class resolveClass(ObjectStreamClass osc) throws IOException, ClassNotFoundException {
        String name = osc.getName();
        Collection lookups = this.d_classLookup.tailMap(this.d_version, false).values();
        for (Map lookup : lookups) {
            Class clazz = (Class)lookup.get(name);
            if (clazz == null) continue;
            return clazz;
        }
        Class clazz = this.d_teciio.resolveClass(osc);
        if (clazz != null) {
            return clazz;
        }
        if (name.startsWith("pyrosim.") || name.startsWith("[Lpyrosim.")) {
            String legName = name;
            legName = legName.replaceFirst("pyrosim.", "pyrosim.legacy_2012_1.");
            return Class.forName(legName);
        }
        return super.resolveClass(osc);
    }

    @Override
    protected Object resolveObject(Object obj) {
        if (this.d_version < 22 && Clock.isClock(obj)) {
            return Clock.INSTANCE;
        }
        if (this.d_version == 22 && obj instanceof SolidPointMeasurer && ((SolidPointMeasurer)obj).getQuantity().get().quantityType == QuantityType.GAS) {
            SolidPointMeasurer devc = (SolidPointMeasurer)obj;
            return new GasPointMeasurer(devc.getName(), devc.getQuantity(), devc.getLocation());
        }
        if (this.d_version < 23) {
            if (obj instanceof ObjectMeasurement) {
                ObjectMeasurement om = (ObjectMeasurement)obj;
                obj = om.fromLegacy();
            } else if (obj instanceof Measurement) {
                Measurement msr = (Measurement)obj;
                obj = this.d_pre23MsrMap.get(msr.getDescription());
                assert (obj != null);
            }
        }
        if (this.d_version < 27 && obj instanceof AMeasurementStat) {
            obj = ((AMeasurementStat)obj).convert();
        }
        if (this.d_version < 28) {
            if (obj instanceof Isosurface) {
                obj = ((Isosurface)obj).convert();
            } else if (obj instanceof pyrosim.legacy_2012_1.legacy.v28.domain.output.IsosurfaceMgr) {
                obj = ((pyrosim.legacy_2012_1.legacy.v28.domain.output.IsosurfaceMgr)obj).convert();
            }
        }
        if (this.d_version < 29) {
            LayerMeasurer.LayerPin pin;
            if (obj instanceof UnitDouble) {
                UnitDouble d = (UnitDouble)obj;
                if (d.getUnit().equals(this.d_pre29AspirationUnit)) {
                    obj = new UnitDouble(d.getValueNoUnit(), SIUS.unit(57));
                } else if (d.getUnit().equals(this.d_pre29ObscurationUnitSIUS)) {
                    obj = new UnitDouble(d.getValueNoUnit(), SIUS.unit(31));
                } else if (d.getUnit().equals(this.d_pre29ObscurationUnitEnglish)) {
                    obj = new UnitDouble(d.getValueNoUnit(), EnglishUS.unit(31));
                }
            } else if (obj instanceof LayerMeasurer) {
                obj = ((LayerMeasurer)obj).convert();
            } else if (obj instanceof LayerMeasurer.LayerPin && (pin = (LayerMeasurer.LayerPin)obj).getName().equals(Intl.intl("LTEMP"))) {
                obj = new LayerMeasurer.LayerPin(pin.getAttachedSource(), pin.getName(), Quantity.LOWER_TEMPERATURE.create());
            }
        }
        if (this.d_version < 30) {
            if (obj instanceof GasMsrStat) {
                obj = ((GasMsrStat)obj).convert();
            } else if (obj instanceof SolidMsrStat) {
                obj = ((SolidMsrStat)obj).convert();
            }
        }
        if (this.d_version < 31) {
            if (obj instanceof pyrosim.legacy_2012_1.legacy.v31.domain.geom.AARectangle) {
                obj = ((pyrosim.legacy_2012_1.legacy.v31.domain.geom.AARectangle)obj).convert();
            } else if (obj instanceof pyrosim.legacy_2012_1.legacy.v31.domain.texture.ModelImage) {
                obj = ((pyrosim.legacy_2012_1.legacy.v31.domain.texture.ModelImage)obj).convert();
            } else if (obj instanceof LayeredSurfDesc) {
                obj = ((LayeredSurfDesc)obj).convert();
            }
        }
        if (this.d_version < 32) {
            if (obj instanceof SolidReaction.Rate.RefSpec) {
                this.d_pre32RefSpecs.add((SolidReaction.Rate.RefSpec)obj);
            } else if (obj instanceof LiquidReaction) {
                LiquidReaction lr = (LiquidReaction)obj;
                if (lr.d_byproducts.d_heat == null) {
                    lr = new LiquidReaction(lr.d_rate, new ReacByproducts(lr.d_byproducts.d_nuFuel, lr.d_byproducts.d_nuWater, lr.d_byproducts.d_nuResidue, lr.d_byproducts.getResidue(), SIUS.newud(0.0, 46)));
                    this.d_pre32InvalidReacs.add(lr);
                    obj = lr;
                }
            }
        }
        if (this.d_version < 33 && obj instanceof SizeDistribution) {
            SizeDistribution sd = (SizeDistribution)obj;
            if (sd.d_medianDiameter.equals(new UnitDouble(100.0, SI.MICRO(SI.METER)))) {
                obj = new SizeDistribution(new UnitDouble(500.0, SI.MICRO(SI.METER)), sd.d_type);
            }
        }
        if (this.d_version < 37 && obj instanceof Ramp) {
            obj = ((Ramp)obj).fromLegacy();
        }
        if (this.d_version < 40 && obj instanceof ModelImage) {
            obj = ((ModelImage)obj).fromLegacy();
        }
        if (this.d_version < 42) {
            if (obj instanceof ISignalSource) {
                this.d_pre42SignalSources.add((ISignalSource)obj);
            }
            if (obj instanceof ISignalSink) {
                this.d_pre42SignalSinks.add((ISignalSink)obj);
            }
        }
        if (this.d_version < 43 && obj instanceof IPyroManager) {
            obj = ((IPyroManager)obj).convert();
        }
        if (this.d_version < 44 && obj instanceof Floor) {
            obj = ((Floor)obj).fromLegacy();
        }
        if (this.d_version < 45 && obj instanceof pyrosim.legacy_2012_1.legacy.v44.domain.geom.FDSComposite) {
            obj = ((pyrosim.legacy_2012_1.legacy.v44.domain.geom.FDSComposite)obj).fromLegacy();
        }
        if (this.d_version < 46) {
            Map map;
            ArrayList<Object> msrs;
            if (obj instanceof Measurements.VelocitySign) {
                obj = ((Measurements.VelocitySign)((Object)obj)).fromLegacy();
            } else if (obj instanceof pyrosim.legacy_2012_1.legacy.v45.domain.measure.Measurement) {
                obj = ((pyrosim.legacy_2012_1.legacy.v45.domain.measure.Measurement)obj).fromLegacy();
            } else if (obj instanceof Set) {
                Set set = (Set)obj;
                if (!set.isEmpty() && set.iterator().next() instanceof IQuantity) {
                    msrs = new ArrayList(set);
                    set.clear();
                    set.addAll(msrs);
                }
            } else if (obj instanceof Map && !(map = (Map)obj).isEmpty() && map.keySet().iterator().next() instanceof IQuantity) {
                msrs = new ArrayList(map.entrySet());
                map.clear();
                for (Map.Entry entry : msrs) {
                    map.put(entry.getKey(), entry.getValue());
                }
            }
        }
        if (this.d_version < 47) {
            if (obj instanceof UnitDouble) {
                UnitDouble ud = (UnitDouble)obj;
                if (this.isObscurationUnit(ud.getUnit())) {
                    obj = ud.reinterpret(SIUS.unit(80));
                }
            } else if (obj instanceof SmokeLinkModel) {
                SmokeLinkModel slm = (SmokeLinkModel)obj;
                UnitDouble newVal = slm.getActivationObscuration().reinterpret(SIUS.unit(31));
                slm.setActivationObscuration(newVal);
            }
        }
        if (obj instanceof Color) {
            obj = this.getExisting((Color)obj, this.d_colorMap);
        } else if (obj instanceof UnitPoint3D) {
            obj = this.getExisting((UnitPoint3D)obj, this.d_pointMap);
        } else if (obj instanceof String) {
            obj = this.getExisting((String)obj, this.d_strMap);
        } else if (obj instanceof Point3d) {
            obj = this.getExisting((Point3d)obj, this.d_point3dMap);
        }
        obj = this.d_teciio.resolveObject(obj);
        return obj;
    }

    private boolean isObscurationUnit(Unit u) {
        if (this.d_obscurationUnits == null) {
            this.d_obscurationUnits = new HashSet<Unit>();
            for (Object ounit : Unit.getInstances()) {
                Unit unit = (Unit)ounit;
                if (!unit.isCompatible(SI.METER)) continue;
                this.d_obscurationUnits.add(NonSI.PERCENT.divide(unit));
            }
        }
        return this.d_obscurationUnits.contains(u);
    }

    private <T> T getExisting(T obj, Map<T, T> map) {
        if (!map.containsKey(obj)) {
            map.put(obj, obj);
            return obj;
        }
        return map.get(obj);
    }

    static {
        String code = String.format("PSM%04d", 48);
        assert (code.length() <= 7);
        FORMAT_CODE = code.getBytes();
    }

    private static class Pre29DevcWrapper {
        private final IMeasurer devc;
        private final Map<AlarmInfo, List<PinReplacement>>[] alarmMaps;

        public Pre29DevcWrapper(IMeasurer devc) {
            this.devc = devc;
            this.alarmMaps = new Map[devc.getNumMeasurements()];
            for (int m = 0; m < devc.getNumMeasurements(); ++m) {
                this.alarmMaps[m] = new HashMap<AlarmInfo, List<PinReplacement>>();
            }
        }
    }

    private static class PinReplacement
    extends Pair<IOutPin, IInPin> {
        private static final long serialVersionUID = 6895485069285052817L;

        public PinReplacement(IOutPin outPin, IInPin inPin) {
            super(outPin, inPin);
        }
    }
}

