/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.tasks;

import java.util.Collection;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.tasks.TransformTask;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;

public class RotateTask
extends TransformTask {
    private final Point3d d_base;
    private final Vector3d d_rotateAxis;
    private final double d_angle;

    public RotateTask(PyroMod mediator, Collection<? extends IPyroObject> objects, int n, UnitPoint3D base, Vector3d rotateAxis, UnitDouble angle) {
        super(mediator, objects, n);
        this.d_base = base.getPoint3dValue(Geometry.LU);
        this.d_rotateAxis = new Vector3d(rotateAxis);
        this.d_angle = angle.getValue(SI.RADIAN);
    }

    @Override
    public Matrix4d getXFormForIteration(int i) {
        double angle = this.d_angle * (double)i;
        Matrix4d matrix = Util.translateMat(this.d_base.x, this.d_base.y, this.d_base.z);
        matrix.mul(Util.rotMat(this.d_rotateAxis.x, this.d_rotateAxis.y, this.d_rotateAxis.z, angle));
        matrix.mul(Util.translateMat(-this.d_base.x, -this.d_base.y, -this.d_base.z));
        return matrix;
    }
}

