/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices.measurers;

import java.awt.Color;
import pyrosim.legacy_2012_1.domain.devices.IAABoxDevice;
import pyrosim.legacy_2012_1.domain.devices.measurers.AMeasuringDevc;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.domain.quantity.QuantityUtil;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.BlockGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitAABox;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;

public class AABoxMeasurer
extends AMeasuringDevc
implements IAABoxDevice {
    static final long serialVersionUID = 1L;
    private UnitAABox d_box;
    private static final IPrimProps s_primProps = new IPrimProps.Face(new Color(1.0f, 1.0f, 0.0f, 0.5f), null, true);

    public AABoxMeasurer(String name, IQuantity measurment, UnitAABox box) {
        super(name, measurment);
        this.d_box = box;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof AABoxMeasurer && super.equals(obj) && this.d_box.equals(((AABoxMeasurer)obj).d_box);
    }

    @Override
    public UnitAABox getBox() {
        return this.d_box;
    }

    public void setBox(UnitAABox box) {
        this.d_box = box;
        this.changedEvt(new Object[0]);
    }

    public static int getOutputType() {
        return 4;
    }

    public static IObjectFilter<Quantity> getQuantityFilter() {
        return new IObjectFilter<Quantity>(){

            @Override
            public boolean shouldFilter(Quantity o) {
                return !QuantityUtil.canOutputAll(o, AABoxMeasurer.getOutputType());
            }
        };
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        return new DisplayGeom((IGeom)this.getGeom(), s_primProps);
    }

    @Override
    public AABoxGeom getGeom() {
        return new BlockGeom(this.d_box.getMin(Geometry.LU), this.d_box.getMax(Geometry.LU), 0);
    }

    @Override
    public void setGeom(IGeom geom, boolean optimizeGeom) {
        if ((geom = Geometry.finalize(geom, optimizeGeom)) instanceof AABoxGeom) {
            AABoxGeom bg = (AABoxGeom)geom;
            this.setBox(new UnitAABox(bg.min, bg.max, Geometry.LU));
        }
    }
}

