/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices.detectors;

import java.awt.Color;
import java.io.Serializable;
import java.util.Set;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.devices.detectors.APointDetector;
import pyrosim.legacy_2012_1.domain.devices.detectors.HeatLinkModel;
import pyrosim.legacy_2012_1.domain.geom.FreePointLoc;
import pyrosim.legacy_2012_1.domain.tasks.AReplaceRefTask;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.util.Util;

public class HeatDetector
extends APointDetector
implements IDirectDependent,
Serializable {
    static final long serialVersionUID = 1L;
    private HeatLinkModel d_link;
    private static final IPrimProps s_primProps = new IPrimProps.Vertex(Color.RED, 10.0);

    public HeatDetector(String name, HeatLinkModel link, FreePointLoc loc) {
        super(name, loc);
        this.d_link = link;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof HeatDetector && super.equals(obj) && this.d_link.equals(((HeatDetector)obj).d_link);
    }

    public HeatLinkModel getModel() {
        return this.d_link;
    }

    public void setModel(HeatLinkModel link) {
        assert (link != null);
        this.d_link = link;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        assert (this.d_link != null) : "A Heat Detector must have a link";
        deps.add(DLink.STRONG, (IPyroObject)this.d_link);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        Util.removeAllNotOfType(objs, HeatLinkModel.class);
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        if (old == this.getModel()) {
            assert (replacement != null);
            return new AReplaceRefTask<HeatLinkModel>((Object)old, (Object)replacement){

                @Override
                public void set(HeatLinkModel obj) {
                    HeatDetector.this.setModel(obj);
                }
            };
        }
        return null;
    }

    @Override
    protected IPrimProps getPrimProps() {
        return s_primProps;
    }
}

