/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.APyroObject;
import pyrosim.legacy_2012_1.domain.Hierarchy;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.util.Util;

public class Composite<DataT extends IPyroObject>
extends NamedPyroObject {
    static final long serialVersionUID = 1L;
    public static final Object NON_UNIFORM = new Object();
    public static final Object NOT_SUPPORTED = new Object();
    private Class<DataT> d_type;
    private Set<IPyroObject> d_members;

    public Composite(String name, Class<DataT> type) {
        super(name);
        this.d_type = type;
        this.d_members = new LinkedIdentityHashSet<IPyroObject>();
    }

    public Class<DataT> getType() {
        return this.d_type;
    }

    protected boolean addDefault(DataT obj) {
        if (this.get(Util.getName(obj)) == null) {
            this.add((IPyroObject)obj);
            return true;
        }
        return false;
    }

    public Composite newGroup(String name) {
        Composite result = (Composite)super.clone();
        result.d_members = new LinkedIdentityHashSet<IPyroObject>();
        result.setName(name);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this;
    }

    @Override
    public Composite<DataT> clone() {
        return this.clone(true);
    }

    public Composite<DataT> clone(boolean deep) {
        Composite clone = (Composite)super.clone();
        if (deep) {
            clone.d_members = new LinkedIdentityHashSet<IPyroObject>(this.d_members.size());
            for (IPyroObject member : this.d_members) {
                IPyroObject objClone = (IPyroObject)member.clone();
                objClone.setDomain(null, clone);
                clone.d_members.add(objClone);
            }
        } else {
            clone.d_members = new LinkedIdentityHashSet<IPyroObject>();
        }
        return clone;
    }

    public DataT get(String name) {
        return this.find(name, this.d_type, true);
    }

    public List<DataT> getAll(String name) {
        return this.findAll(name, this.d_type, true);
    }

    public <T extends IPyroObject> T find(String name, Class<T> type, boolean deep) {
        Collection<T> objs = deep ? ((APyroObject)this).flatten(type) : this.getMembers(type);
        for (IPyroObject obj : objs) {
            if (!Util.getName(obj).equals(name)) continue;
            return (T)obj;
        }
        return null;
    }

    public <T extends IPyroObject> List<T> findAll(String name, Class<T> type, boolean deep) {
        ArrayList<IPyroObject> result = new ArrayList<IPyroObject>();
        Collection<T> objs = deep ? ((APyroObject)this).flatten(type) : this.getMembers(type);
        for (IPyroObject obj : objs) {
            if (!Util.getName(obj).equals(name)) continue;
            result.add(obj);
        }
        return result;
    }

    public boolean accept(IPyroObject obj) {
        return obj instanceof Composite ? this.d_type.isAssignableFrom(((Composite)obj).getType()) : this.d_type.isInstance(obj);
    }

    public void reorder(Collection<? extends IPyroObject> newOrder) {
        assert (this.d_members.containsAll(newOrder) && this.d_members.size() == newOrder.size());
        this.d_members.clear();
        this.d_members.addAll(newOrder);
        this.changedEvt(PyroMod.EVT_CHILDREN_CHANGED);
    }

    public boolean containsAny(Collection<? extends IPyroObject> objs) {
        for (IPyroObject iPyroObject : objs) {
            if (!this.d_members.contains(iPyroObject)) continue;
            return true;
        }
        return false;
    }

    public void insert(Collection<? extends IPyroObject> objs, int insertPos) {
        if (objs.isEmpty()) {
            return;
        }
        assert (!this.containsAny(objs));
        if (insertPos == this.d_members.size()) {
            this.addAll(objs);
            return;
        }
        ArrayList<IPyroObject> newList = new ArrayList<IPyroObject>(this.d_members);
        newList.addAll(insertPos, objs);
        this.d_members.clear();
        this.d_members.addAll(newList);
        this.addChildren(objs);
    }

    public void insert(IPyroObject[] objs, int[] insertPositions) {
        if (objs.length == 0) {
            return;
        }
        assert (!this.containsAny(Arrays.asList(objs)));
        assert (objs.length <= insertPositions.length);
        ArrayList<IPyroObject> newList = new ArrayList<IPyroObject>(this.d_members);
        for (int m = 0; m < objs.length; ++m) {
            newList.add(insertPositions[m], objs[m]);
        }
        this.d_members.clear();
        this.d_members.addAll(newList);
        this.addChildren(objs);
    }

    public int indexOf(IPyroObject obj) {
        int ix = 0;
        for (IPyroObject child : this.d_members) {
            if (child == obj) {
                return ix;
            }
            ++ix;
        }
        return -1;
    }

    public <ObjT, PropT> Object getProperty(IObjectProp<ObjT, PropT> prop) {
        return Composite.getProperty(prop, this.d_members);
    }

    public static <ObjT, PropT> Object getProperty(IObjectProp<ObjT, PropT> prop, Collection<? extends IPyroObject> objs) {
        if (objs.isEmpty()) {
            return NOT_SUPPORTED;
        }
        Object val = NOT_SUPPORTED;
        for (IPyroObject iPyroObject : objs) {
            Object val2;
            if (prop.getType().isInstance(iPyroObject)) {
                IPyroObject sobj = iPyroObject;
                val2 = prop.get(sobj);
            } else {
                if (!(iPyroObject instanceof Composite)) continue;
                val2 = ((Composite)iPyroObject).getProperty(prop);
            }
            if (val2 == NON_UNIFORM) {
                return NON_UNIFORM;
            }
            if (val2 == NOT_SUPPORTED) continue;
            if (val == NOT_SUPPORTED) {
                val = val2;
                continue;
            }
            if (prop.equal(val, val2)) continue;
            return NON_UNIFORM;
        }
        return val;
    }

    public <ObjT, PropT> void setProperty(IObjectProp<ObjT, PropT> prop, PropT value) {
        this.pauseUpdates();
        Composite.setProperty(prop, value, this.d_members);
        this.resumeUpdates();
    }

    public static <ObjT, PropT> void setProperty(IObjectProp<ObjT, PropT> prop, PropT value, Collection<? extends IPyroObject> objs) {
        for (IPyroObject iPyroObject : objs) {
            if (prop.getType().isInstance(iPyroObject)) {
                prop.set(iPyroObject, value);
                continue;
            }
            if (!(iPyroObject instanceof Composite)) continue;
            ((Composite)iPyroObject).setProperty(prop, value);
        }
    }

    public boolean contains(IPyroObject obj) {
        return this.d_members.contains(obj);
    }

    public boolean containsDeep(IPyroObject obj) {
        if (this.d_members.contains(obj)) {
            return true;
        }
        for (Composite comp : this.getNodes()) {
            if (!comp.containsDeep(obj)) continue;
            return true;
        }
        return false;
    }

    public Collection<IPyroObject> getMembers() {
        return this.d_members;
    }

    public Collection<Composite> getNodes() {
        return this.getMembers(Composite.class);
    }

    public Collection<DataT> flatten() {
        return ((APyroObject)this).flatten(this.d_type);
    }

    public Collection<DataT> flatten(IObjectFilter<DataT> filter) {
        return Hierarchy.flatten(this.d_members, this.d_type, filter);
    }

    public Collection<Composite> flattenNodes() {
        return ((APyroObject)this).flatten(Composite.class);
    }

    public void clear() {
        this.pauseUpdates();
        ArrayList<IPyroObject> members = new ArrayList<IPyroObject>(this.d_members);
        this.d_members.clear();
        this.removeChildren((Collection)members);
        this.resumeUpdates();
    }

    public boolean isEmpty() {
        return this.d_members.isEmpty();
    }

    public void prune() {
        this.pauseUpdates();
        for (Composite member : new ArrayList<Composite>(this.getNodes())) {
            member.prune();
            if (!member.isEmpty()) continue;
            this.remove(member);
        }
        this.resumeUpdates();
    }

    public Collection<? extends IPyroObject> getChildren() {
        return this.d_members;
    }

    public boolean add(IPyroObject obj) {
        if (!this.accept(obj)) {
            System.err.println("Adding non-accepted object to group: [group=" + this.getName() + "], [object=" + Util.getName(obj) + "]");
        }
        boolean result = this.d_members.add(obj);
        this.addChild(obj);
        return result;
    }

    public boolean addAll(Collection<? extends IPyroObject> objs) {
        boolean result = true;
        this.pauseUpdates();
        for (IPyroObject iPyroObject : objs) {
            result &= this.add(iPyroObject);
        }
        this.resumeUpdates();
        return result;
    }

    public boolean remove(IPyroObject obj) {
        boolean result = this.d_members.remove(obj);
        if (result) {
            this.removeChild(obj);
        }
        return result;
    }

    public boolean removeAll(Collection<? extends IPyroObject> objs) {
        boolean removed = false;
        this.pauseUpdates();
        for (IPyroObject iPyroObject : objs) {
            removed |= this.remove(iPyroObject);
        }
        this.resumeUpdates();
        return removed;
    }

    protected <T extends IPyroObject> void addChild(T child) {
        child.setDomain((PyroMod)this.getDomain(), this);
        this.changedEvt(PyroMod.EVT_CHILDREN_ADDED);
    }

    protected <T extends IPyroObject> void addChildren(T ... children) {
        this.addChildren((Collection<T>)Arrays.asList(children));
    }

    protected <T extends IPyroObject> void addChildren(Collection<T> children) {
        this.pauseUpdates();
        for (IPyroObject child : children) {
            child.setDomain((PyroMod)this.getDomain(), this);
        }
        this.changedEvt(PyroMod.EVT_CHILDREN_ADDED);
        this.resumeUpdates();
    }

    protected <T extends IPyroObject> void removeChild(T child) {
        child.setDomain(null, null);
        this.changedEvt(PyroMod.EVT_CHILDREN_REMOVED);
    }

    protected <T extends IPyroObject> void removeChildren(T ... children) {
        this.removeChildren((Collection<T>)Arrays.asList(children));
    }

    protected <T extends IPyroObject> void removeChildren(Collection<T> children) {
        this.pauseUpdates();
        for (IPyroObject child : children) {
            child.setDomain(null, null);
        }
        this.changedEvt(PyroMod.EVT_CHILDREN_REMOVED);
        this.resumeUpdates();
    }

    public static abstract class AObjectProp<ObjT, PropT>
    implements IObjectProp<ObjT, PropT> {
        private final Class<ObjT> d_type;

        public AObjectProp(Class<ObjT> type) {
            this.d_type = type;
        }

        @Override
        public Class<ObjT> getType() {
            return this.d_type;
        }

        @Override
        public boolean equal(PropT obj1, PropT obj2) {
            return theUtil.equal(obj1, obj2);
        }
    }

    public static interface IObjectProp<ObjT, PropT> {
        public Class<ObjT> getType();

        public void set(ObjT var1, PropT var2);

        public Object get(ObjT var1);

        public boolean equal(PropT var1, PropT var2);
    }
}

