/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.legacy.v17;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import pyrosim.io.IOUtil;
import pyrosim.legacy_2006_2.legacy.v17.TextureInfo;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.nativebuffered.Image;

public class TextureDB
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String TEX_DIR_NAME = "textures";
    private Map<String, TextureInfo> d_texmap = new HashMap<String, TextureInfo>();
    private Map<String, Image> d_nativeImageMap = new HashMap<String, Image>();

    public TextureDB(File dbDir) {
        File texDir = new File(dbDir, TEX_DIR_NAME);
        if (!texDir.isDirectory()) {
            if (texDir.exists()) {
                texDir.delete();
            }
            texDir.mkdir();
        }
        this.refresh(dbDir);
    }

    @Deprecated
    private void writeObject(ObjectOutputStream out) throws IOException {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.d_texmap = new HashMap<String, TextureInfo>();
        int sz = in.readInt();
        for (int i = 0; i < sz; ++i) {
            TextureInfo texinfo = (TextureInfo)in.readObject();
            this.put(texinfo.getFileName(), texinfo);
        }
    }

    public Set<String> keys() {
        return this.d_texmap.keySet();
    }

    public TextureInfo get(String texname) {
        return this.d_texmap.get(texname);
    }

    public boolean put(String texname, TextureInfo texinfo) {
        TextureInfo old = this.d_texmap.get(texname);
        if (old != null && old.getOrigin() > texinfo.getOrigin()) {
            return false;
        }
        if (texinfo.getImage() != null) {
            this.d_texmap.put(texname, texinfo);
        }
        return true;
    }

    public boolean containsKey(String texname) {
        return this.d_texmap.containsKey(texname);
    }

    public void refresh(File dbDir) {
        this.loadDefaults(dbDir);
    }

    public Runnable loader(final File dbDir) {
        return new Runnable(){

            @Override
            public void run() {
                TextureDB.this.loadDefaults(dbDir);
            }
        };
    }

    public void copyIn(File dbDir, File src) throws IOException {
        File texdir = new File(dbDir, TEX_DIR_NAME);
        File dest = new File(texdir, src.getName());
        BufferedImage orig = ImageIO.read(src);
        BufferedImage compat = TextureDB.makeSafe(orig);
        ImageIO.write((RenderedImage)compat, "jpg", dest);
        TextureInfo tex = new TextureInfo(dest.getName(), compat, 0);
        this.put(tex.getFileName(), tex);
    }

    public void loadDefaults(File dbDir) {
        File texdir = new File(dbDir, TEX_DIR_NAME);
        FilenameFilter jpgFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith("jpg");
            }
        };
        List<File> texFn = IOUtil.listFiles(texdir, jpgFilter);
        for (int i = 0; i < texFn.size(); ++i) {
            try {
                TextureInfo tex = this.createFromFile(texFn.get(i), 0);
                this.put(tex.getFileName(), tex);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static BufferedImage makeSafe(BufferedImage img) {
        BufferedImage compat = new BufferedImage(img.getWidth(), img.getHeight(), img.getType());
        Graphics2D g2d = compat.createGraphics();
        g2d.drawImage(img, null, 0, 0);
        g2d.dispose();
        return compat;
    }

    private TextureInfo createFromFile(File f, int origin) throws IOException {
        BufferedImage img = ImageIO.read(f);
        BufferedImage compat = TextureDB.makeSafe(img);
        return new TextureInfo(f.getName(), compat, origin);
    }
}

