/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.Reaction;
import pyrosim.legacy_2006_2.domain.ReactionList;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class ReacProcessor
extends AFDSRecordProcessor {
    public static Reaction last = null;

    public ReacProcessor(FDSParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public String getFDSTypeParsed() {
        return "REAC";
    }

    @Override
    public boolean process(FDSInputRecord rec) throws FDSRecordFormatException {
        PyroMod pyMod = this.getContainer();
        boolean err = false;
        FDSRecordFormatException caughtExc = null;
        if (!"REAC".equals(rec.getType())) {
            return false;
        }
        try {
            String name = (String)rec.getValue("ID");
            Reaction newReac = new Reaction(name);
            String[] optRecs = Reaction.getOptionalKeys();
            FdsSISystem fdsUS = FdsSISystem.getInstance();
            for (int i = 0; i < optRecs.length; ++i) {
                Object value = rec.getValue(optRecs[i]);
                if (value == null) continue;
                Reaction.ValueInfo vi = Reaction.getValueInfo(optRecs[i]);
                if (!vi.d_fdsParsingDataType.isInstance(value)) {
                    throw new FDSRecordFormatException(rec, optRecs[i] + " is of the wrong data type.");
                }
                if (value instanceof Double) {
                    Unit unit = fdsUS.getUnit(vi.d_unitType);
                    if (!vi.d_valueRange.checkValue((UnitDouble)(value = new UnitDouble((Double)value, unit)))) {
                        throw new FDSRecordFormatException(rec, optRecs[i] + " must be " + vi.d_valueRange.describeRange() + ".");
                    }
                }
                newReac.setValue(optRecs[i], value);
            }
            ReactionList rList = pyMod.getReactions();
            Reaction existing = rList.get(name);
            if (existing != null) {
                rList.taskRemove(existing, newReac);
            } else {
                rList.taskAdd(newReac).run();
            }
            this.flagPyroTypeAffected(Reaction.class);
            last = newReac;
        }
        catch (FDSRecordFormatException e) {
            caughtExc = e;
            err = true;
        }
        catch (ClassCastException e2) {
            err = true;
        }
        if (err) {
            if (caughtExc != null) {
                throw caughtExc;
            }
            throw new FDSRecordFormatException(rec);
        }
        return true;
    }

    @Override
    public void done() {
    }
}

