/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.io.FDSParseWarning;
import pyrosim.legacy_2006_2.thunderheadeng.util.WarningReport;

public class FDSParsingInfo {
    public static final int DBL_FAIL_ON_ERROR = 0;
    public static final int DBL_CONTINUE_ON_ERROR = 1;
    public static final int DEFAULT_DEBUG_LEVEL = 0;
    private final PyroMod d_rwContainer;
    private final Collection<PyroMod> d_rContainers;
    private Material d_defaultMaterial;
    private Set<String> d_parsedFiles = new TreeSet<String>();
    private Stack<String> d_filenameStack = new Stack();
    private int d_debugLevel;
    private Set<Class> d_pyroObjectTypesAffected = new HashSet<Class>(PyroMod.getAllPyroObjectTypes().size());
    private boolean d_markAsUnprocessedOnlyIfTrulyUnprocessable = false;
    private final Set<String> d_parsingTypes;
    private final WarningReport<FDSParseWarning> d_warningReport;

    public FDSParsingInfo(Set<String> parsingTypes, PyroMod writeMod, Collection<PyroMod> referenceContainers) {
        this(parsingTypes, writeMod, referenceContainers, 0, false);
    }

    public FDSParsingInfo(Set<String> parsingTypes, PyroMod writeMod, Collection<PyroMod> referenceContainers, int debugLevel, boolean markAsUnprocessedOnlyIfTrulyUnprocessable) {
        this(parsingTypes, writeMod, referenceContainers, new WarningReport<FDSParseWarning>(FDSParseWarning.class, FDSParseWarning.getWarningInfoTypes(), FDSParseWarning.getWarningInfoDescriptions(), 2), debugLevel, markAsUnprocessedOnlyIfTrulyUnprocessable);
    }

    public FDSParsingInfo(Set<String> parsingTypes, PyroMod writeMod, Collection<PyroMod> referenceContainers, WarningReport<FDSParseWarning> warningReport, int debugLevel, boolean markAsUnprocessedOnlyIfTrulyUnprocessable) {
        this.d_parsingTypes = parsingTypes;
        this.d_rwContainer = writeMod;
        this.d_rContainers = new Vector<PyroMod>(referenceContainers.size() + 1);
        this.d_rContainers.add(writeMod);
        for (PyroMod mod : referenceContainers) {
            this.d_rContainers.add(mod);
        }
        this.d_warningReport = warningReport;
        for (PyroMod mod : this.d_rContainers) {
            Material def = mod.getDefaultMaterial();
            if (def == null) continue;
            this.d_defaultMaterial = def;
            break;
        }
        assert (this.d_defaultMaterial != null);
        this.d_debugLevel = debugLevel;
        this.d_markAsUnprocessedOnlyIfTrulyUnprocessable = markAsUnprocessedOnlyIfTrulyUnprocessable;
    }

    public Set<String> getParsingTypes() {
        return this.d_parsingTypes;
    }

    public int getDebugLevel() {
        return this.d_debugLevel;
    }

    public boolean markRecsAsUnprocessedOnlyIfTrulyUnprocessable() {
        return this.d_markAsUnprocessedOnlyIfTrulyUnprocessable;
    }

    public void setDefaultMaterial(Material mat) {
        this.d_defaultMaterial = mat;
    }

    public Material getDefaultMaterial() {
        return this.d_defaultMaterial;
    }

    public boolean fileParsingStarted(String absoluteFilename) {
        if (this.d_parsedFiles.contains(absoluteFilename)) {
            return false;
        }
        this.d_parsedFiles.add(absoluteFilename);
        this.d_filenameStack.push(absoluteFilename);
        return true;
    }

    public String fileParsingFinished() {
        if (this.d_filenameStack.size() == 0) {
            return null;
        }
        return this.d_filenameStack.pop();
    }

    public String getCurrentParsingFile() {
        if (this.d_filenameStack.size() == 0) {
            return null;
        }
        return this.d_filenameStack.peek();
    }

    public boolean fileParsingHasStarted(String filename) {
        if (this.d_filenameStack.size() == 0) {
            return false;
        }
        return this.d_parsedFiles.contains(filename);
    }

    public Set<Class> getPyroObjectTypesAffected() {
        return this.d_pyroObjectTypesAffected;
    }

    public PyroMod getContainer() {
        return this.d_rwContainer;
    }

    public <K, V extends IPyroObject> boolean resourceExists(K key, Class<V> pyroObjectType) {
        return this.getResource(key, pyroObjectType) != null;
    }

    public <K, V extends IPyroObject> V getResource(K key, Class<V> pyroObjectType) {
        for (PyroMod mod : this.d_rContainers) {
            IPyroManager<?, K> man = mod.getPyroSimManager(pyroObjectType);
            V resource = man.get(key);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    public Collection<PyroMod> getSourceContainers() {
        return this.d_rContainers;
    }

    public <K, V extends IPyroObject> void makeUnique(V object, Class<V> pyroObjectType) {
        for (PyroMod mod : this.d_rContainers) {
            IPyroManager<?, V> man = mod.getPyroSimManager(pyroObjectType);
            man.taskMakeUnique(object).run();
        }
    }

    public void addWarning(FDSParseWarning warning) {
        this.d_warningReport.addWarning(warning);
    }

    public WarningReport<FDSParseWarning> getWarningReport() {
        return this.d_warningReport;
    }
}

