/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageOutputStream;
import pyrosim.io.IOUtil;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.TextureDB;
import pyrosim.legacy_2006_2.domain.AlignedBlock;
import pyrosim.legacy_2006_2.domain.AlignedHole;
import pyrosim.legacy_2006_2.domain.BNDFRecord;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSConvexPoly;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.Floor;
import pyrosim.legacy_2006_2.domain.Grid;
import pyrosim.legacy_2006_2.domain.HeadRecord;
import pyrosim.legacy_2006_2.domain.HeatDetector;
import pyrosim.legacy_2006_2.domain.Hole;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.IsofRecord;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.MaterialList;
import pyrosim.legacy_2006_2.domain.PL3DRecord;
import pyrosim.legacy_2006_2.domain.PipeRecord;
import pyrosim.legacy_2006_2.domain.RadiRecord;
import pyrosim.legacy_2006_2.domain.Slab;
import pyrosim.legacy_2006_2.domain.SlcfRecord;
import pyrosim.legacy_2006_2.domain.SmodRecord;
import pyrosim.legacy_2006_2.domain.SprkList;
import pyrosim.legacy_2006_2.domain.SprkRecord;
import pyrosim.legacy_2006_2.domain.Texture;
import pyrosim.legacy_2006_2.domain.TextureInfo;
import pyrosim.legacy_2006_2.domain.ThcpRecord;
import pyrosim.legacy_2006_2.domain.Vent;
import pyrosim.legacy_2006_2.domain.Wall;
import pyrosim.legacy_2006_2.events.PyroModDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSInputRecordDebugInfo;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.io.FDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSRecordProcessorFactory;
import pyrosim.legacy_2006_2.io.GE1File;
import pyrosim.legacy_2006_2.thunderheadeng.util.FilteredCollection;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;
import thunderheadeng.io.CopyFile;

public class FDSInputFile {
    private static final String REC_END_CHAR = "/";
    private static final String REC_START_CHAR = "&";
    private static final String DECODER_NAME = "ISO-8859-15";
    private static Charset CHARSET = Charset.forName("ISO-8859-15");
    private static CharsetDecoder DECODER = CHARSET.newDecoder();
    private static DecimalFormat d_doubleFormat;
    private static boolean d_easyReadFormat;
    public static final Set<Class> WRITE_RECS;

    public void setEasyReadFormat(boolean yesNo) {
        if (d_easyReadFormat != yesNo) {
            d_easyReadFormat = yesNo;
        }
    }

    public boolean getEasyReadFormat() {
        return d_easyReadFormat;
    }

    public static Set<String> collectAllKnownFDSRecordTypes() {
        String[] types = new String[]{"BNDF", "GRID", "HEAD", "HEAT", "HOLE", "ISOF", "MISC", "RADI", "OBST", "PART", "PDIM", "PIPE", "PL3D", "RAMP", "REAC", "SLCF", "SPRK", "SURF", "THCP", "TIME", "TRNX", "TRNY", "TRNZ", "VENT", "SMOD"};
        return new HashSet<String>(new VectorFromArray<String>(types));
    }

    public Set<Class> parseFile(String filename, PyroMod container) throws IOException, FDSRecordFormatException {
        return this.parseFile(filename, FDSInputFile.collectAllKnownFDSRecordTypes(), container);
    }

    private Set<Class> parseFile(String filename, Set<String> fdsRecTypesToParse, PyroMod container) throws IOException, FDSRecordFormatException {
        FDSParsingInfo parseInfo = new FDSParsingInfo(fdsRecTypesToParse, container, new LinkedList<PyroMod>());
        Set<Class> affectedTypes = this.parseFile(filename, parseInfo);
        String report = parseInfo.getWarningReport().prepareReport();
        System.err.println(report);
        return affectedTypes;
    }

    public Set<Class> parseFile(String filename, FDSParsingInfo parsingInfo) throws IOException, FDSRecordFormatException {
        CharSequence cb = this.getBufferFromFile(filename);
        return this.parseRecords(cb, filename, parsingInfo);
    }

    private CharSequence getBufferFromFile(String filename) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append(System.getProperty("line.separator"));
            }
            StringBuilder stringBuilder = sb;
            return stringBuilder;
        }
    }

    public Set<Class> parseRecords(CharSequence recordText, String filename, PyroMod container, Collection<PyroMod> referenceMods) throws IOException, FDSRecordFormatException {
        FDSParsingInfo pi = new FDSParsingInfo(FDSInputFile.collectAllKnownFDSRecordTypes(), container, referenceMods);
        Set<Class> affectedTypes = this.parseRecords(recordText, filename, pi);
        return affectedTypes;
    }

    public Set<Class> parseRecords(CharSequence recordText, String filename, FDSParsingInfo parsingInfo) throws IOException, FDSRecordFormatException {
        parsingInfo.getContainer().pauseUpdates(false);
        FDSInputRecord[] records = FDSInputFile.parse(recordText, filename);
        HashSet<FDSInputRecord> unprocessedRecs = new HashSet<FDSInputRecord>(records.length);
        for (int i = 0; i < records.length; ++i) {
            unprocessedRecs.add(records[i]);
        }
        parsingInfo.fileParsingStarted(filename);
        Queue<FDSRecordProcessor> processorQueue = this.queueNecessaryProcessors(parsingInfo);
        for (FDSRecordProcessor processor : processorQueue) {
            this.process(records, processor, unprocessedRecs);
        }
        if (unprocessedRecs.size() > 0) {
            AbstractCollection unprocessableRecs;
            if (!parsingInfo.markRecsAsUnprocessedOnlyIfTrulyUnprocessable()) {
                unprocessableRecs = unprocessedRecs;
            } else {
                unprocessableRecs = new LinkedList();
                Set<String> knownFDSTypes = FDSInputFile.collectAllKnownFDSRecordTypes();
                for (FDSInputRecord nextUnproc : unprocessedRecs) {
                    if (knownFDSTypes.contains(nextUnproc.getType()) && !parsingInfo.getParsingTypes().contains(nextUnproc.getType())) continue;
                    unprocessableRecs.add((FDSInputRecord)nextUnproc);
                }
            }
            if (!unprocessableRecs.isEmpty()) {
                Object unprocessedRecordsStr = parsingInfo.getContainer().getUnprocessedRecords();
                String nl = System.getProperty("line.separator");
                unprocessedRecordsStr = (String)unprocessedRecordsStr + FDSInputFile.renderRecords(unprocessableRecs) + nl;
                parsingInfo.getContainer().setUnprocessedRecords((String)unprocessedRecordsStr);
            }
        }
        parsingInfo.fileParsingFinished();
        parsingInfo.getContainer().resumeUpdates(PyroModDomainEvent.newOpenInstance());
        return parsingInfo.getPyroObjectTypesAffected();
    }

    private Queue<FDSRecordProcessor> queueNecessaryProcessors(FDSParsingInfo parsingInfo) {
        TreeSet<String> typesNeeded = new TreeSet<String>();
        this.collectNeededFDSTypesForProcessingRecursive(parsingInfo.getParsingTypes(), typesNeeded, parsingInfo);
        String[] types = typesNeeded.toArray(new String[typesNeeded.size()]);
        Arrays.sort(types, new Comparator<String>(){

            @Override
            public int compare(String type1, String type2) {
                if (type1.equals(type2)) {
                    return 0;
                }
                if (FDSRecordProcessorFactory.type1ProcessorDependsOnType2Processor(type1, type2)) {
                    return 1;
                }
                if (FDSRecordProcessorFactory.type1ProcessorDependsOnType2Processor(type2, type1)) {
                    return -1;
                }
                return Integer.compare(FDSRecordProcessorFactory.getFDSTypesDependendedOn(type1).size(), FDSRecordProcessorFactory.getFDSTypesDependendedOn(type2).size());
            }
        });
        LinkedList<FDSRecordProcessor> processorQueue = new LinkedList<FDSRecordProcessor>();
        for (int m = 0; m < types.length; ++m) {
            FDSRecordProcessor processor = FDSRecordProcessorFactory.getProcessor(types[m], parsingInfo);
            if (processor == null) continue;
            processorQueue.add(processor);
        }
        return processorQueue;
    }

    private void collectNeededFDSTypesForProcessingRecursive(Set<String> desiredTypes, Set<String> typesNeeded, FDSParsingInfo parsingInfo) {
        for (String type : desiredTypes) {
            typesNeeded.add(type);
            Set<String> dependedOnTypes = FDSRecordProcessorFactory.getFDSTypesDependendedOn(type);
            this.collectNeededFDSTypesForProcessingRecursive(dependedOnTypes, typesNeeded, parsingInfo);
        }
    }

    private static FDSInputRecord[] parse(CharSequence data, String sourceFile) throws FDSRecordFormatException {
        StringBuffer newData = new StringBuffer();
        Vector<FDSInputRecord> records = new Vector<FDSInputRecord>();
        String regex = new String("(?://|!)[^\\r\\n]*");
        Pattern commentPat = Pattern.compile(regex);
        Matcher matcher = commentPat.matcher(data);
        int start = 0;
        int end = 0;
        while (matcher.find()) {
            start = matcher.start();
            newData.append(data.subSequence(end, start).toString());
            end = matcher.end();
        }
        newData.append(data.subSequence(end, data.length()).toString());
        regex = new String("&([^/]*)/([^&\\n]*)");
        Pattern recordPattern = Pattern.compile(regex);
        matcher = recordPattern.matcher(newData.toString());
        int lastIndex = 0;
        String dataString = data.toString();
        int totalNL = 0;
        String nl = System.getProperty("line.separator");
        while (matcher.find()) {
            FDSInputRecord r;
            String text = matcher.group(1);
            String comment = matcher.group(2).trim();
            int nlSearchBegin = lastIndex;
            int beginLineNum = -1;
            int endLineNum = -1;
            int index = dataString.indexOf(text, lastIndex);
            if (index >= 0) {
                int nlIndex;
                lastIndex = index + text.length();
                String trimmedDataString = dataString.substring(nlSearchBegin, index);
                int numNL = 0;
                int lastNLIndex = 0;
                while ((nlIndex = trimmedDataString.indexOf(nl, lastNLIndex)) >= 0) {
                    ++numNL;
                    lastNLIndex = nlIndex + 1;
                }
                beginLineNum = (totalNL += numNL) + 1;
                lastNLIndex = 0;
                numNL = 0;
                while ((nlIndex = text.indexOf(nl, lastNLIndex)) >= 0) {
                    ++numNL;
                    lastNLIndex = nlIndex + 1;
                }
                endLineNum = (totalNL += numNL) + 1;
            }
            if ((r = new FDSInputRecord(text, comment, new FDSInputRecordDebugInfo(sourceFile, text, beginLineNum, endLineNum))).getType() == null) continue;
            records.add(r);
        }
        return records.toArray(new FDSInputRecord[records.size()]);
    }

    private void process(FDSInputRecord[] records, FDSRecordProcessor recProcessor, HashSet<FDSInputRecord> unprocessedRecs) throws FDSRecordFormatException {
        for (int i = 0; i < records.length; ++i) {
            if (!recProcessor.process(records[i])) continue;
            unprocessedRecs.remove(records[i]);
        }
        recProcessor.done();
    }

    private static Collection<Collection<IFDSRenderable>> collectAllFDSRenderableObjectsByType(PyroMod model, String filename, Set<Class> types) {
        model.getRasterizations().rasterizeObjects();
        Collection<FDSObject> frags = model.getRasterizations().getFrags(true);
        Vector<Collection<IFDSRenderable>> pyroObjectsByType = new Vector<Collection<IFDSRenderable>>(types.size());
        for (Class c : types) {
            IPyroManager man = model.getPyroSimManager(c);
            if (FDSObject.class.isAssignableFrom(man.getVClass())) {
                FilteredCollection fdsTypefrags = new FilteredCollection(frags, c);
                ArrayList objs = new ArrayList(frags.size() + man.toCollection().size());
                objs.addAll(fdsTypefrags);
                objs.addAll(man.toCollection());
                pyroObjectsByType.add(objs);
                continue;
            }
            if (!IFDSRenderable.class.isAssignableFrom(c)) continue;
            pyroObjectsByType.add(man.toCollection());
        }
        return pyroObjectsByType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyTextures(TextureDB texDB, File outDir, MaterialList mats) {
        TreeSet<String> needed = new TreeSet<String>();
        for (Material mat : mats) {
            TextureInfo ti = mat.getTextureInfo();
            if (ti == null) continue;
            String texname = ti.getTexID();
            needed.add(texname);
        }
        for (String texname : needed) {
            assert (texDB.names().contains(texname));
            TextureInfo texinfo = texDB.getDefaultInfo(texname);
            if (texinfo == null) continue;
            String texID = texinfo.getTexID();
            Texture tex = texDB.getTexture(texID);
            File texFile = new File(outDir, texID);
            try {
                texFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            String extn = texID.substring(texID.lastIndexOf(46) + 1);
            FileImageOutputStream fios = null;
            try {
                fios = new FileImageOutputStream(texFile);
                ImageIO.write((RenderedImage)tex.getImage(), extn, fios);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (fios == null) continue;
                    fios.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void copySprinklers(File sprkDir, File outDir, SprkList inUse) {
        for (SprkRecord sprk : inUse) {
            String fn = sprk.getMake() + ".spk";
            FilenameFilter filt = FDSInputFile.createFilter(sprkDir, fn);
            List<File> srcArr = IOUtil.listFiles(sprkDir, filt);
            if (srcArr.size() != 1) {
                System.err.println("unable to find sprinkler db file: " + fn);
                continue;
            }
            File src = srcArr.get(0);
            File dest = new File(outDir, fn);
            try {
                if (!dest.exists() && !dest.createNewFile()) {
                    IOException e = new IOException("unable to create destination file" + fn);
                    throw e;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            try {
                FDSInputFile.copyFile(src, dest);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static FilenameFilter createFilter(final File dir, final String fn) {
        return new FilenameFilter(){

            @Override
            public boolean accept(File ckDir, String ckFn) {
                return ckDir.equals(dir) && ckFn.equalsIgnoreCase(fn);
            }
        };
    }

    private static void copyFile(File src, File dest) throws IOException {
        CopyFile.copy(src, dest);
    }

    public static void writeFile(String filename, PyroMod model) throws IOException {
        FDSInputFile.writeFile(filename, model, FDSInputFile.collectAllFDSRenderableObjectsByType(model, filename, WRITE_RECS));
    }

    public static void writeFile(String filename, PyroMod model, Collection<Collection<IFDSRenderable>> pyroObjectsByType) throws IOException {
        File file = new File(filename);
        String chid = HeadRecord.getProperCHID(filename);
        String ge1Name = chid + ".ge1";
        File ge1File = new File(file.getParentFile(), ge1Name);
        boolean ge1Written = GE1File.writeFile(ge1File.getAbsolutePath(), model);
        String oldGE1 = null;
        if (ge1Written) {
            model.pauseUpdates(false);
            oldGE1 = model.getMiscManager().getMiscRecord().getRenderFile();
            model.getMiscManager().getMiscRecord().setRenderFile(ge1Name);
            model.resumeUpdates();
        }
        String sviniName = chid + ".ini";
        File sviniFile = new File(file.getParentFile(), sviniName);
        FDSInputFile.writeSmokeViewIni(sviniFile, ge1Written);
        PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(filename)));
        writer.println(file.getName());
        writer.println("Generated by PyroSim (c) 2002-2006");
        writer.println(DateFormat.getDateTimeInstance().format(new Date()));
        writer.println();
        String userText = model.getUnprocessedRecords();
        if (userText != null && userText.length() > 0) {
            writer.println("-------------User Section (not generated by PyroSim)-------------");
            writer.println();
            writer.print(userText);
            writer.println();
            writer.println();
        }
        writer.println("--------------------PyroSim-generated Section--------------------");
        writer.println();
        writer.println(FDSInputFile.renderPyroRecords(model, filename, pyroObjectsByType));
        writer.println();
        writer.close();
        if (ge1Written) {
            model.pauseUpdates(false);
            model.getMiscManager().getMiscRecord().setRenderFile(oldGE1);
            model.resumeUpdates();
        }
    }

    private static void writeSmokeViewIni(File file, boolean writeGE1) throws IOException {
        PrintWriter iniWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        if (writeGE1) {
            FDSInputFile.writeSVINIPref(iniWriter, "BLOCKLOCATION", 5);
        }
        FDSInputFile.writeSVINIPref(iniWriter, "SHOWNORMALWHENSMOOTH", 1);
        iniWriter.close();
    }

    private static void writeSVINIPref(PrintWriter writer, String pref, Object value) {
        writer.println(pref);
        writer.println(value.toString());
    }

    private static void writeGE1File(String filename, PyroMod model) throws IOException {
    }

    public static String renderAllPyroRecords(PyroMod mod, String filename) {
        return FDSInputFile.renderPyroRecords(mod, filename, FDSInputFile.collectAllFDSRenderableObjectsByType(mod, filename, WRITE_RECS));
    }

    public static String renderPyroRecords(PyroMod mod, String filename, Collection<Collection<IFDSRenderable>> objectsByType) {
        mod.pauseUpdates(false);
        String oldCHID = mod.getHeadManager().getHeadRecord().getCHID();
        mod.getHeadManager().getHeadRecord().setCHID(filename);
        mod.resumeUpdates();
        Collection objectsToWrite = mod.getDependencyManager().collectObjects(objectsByType);
        TreeMap sortedObjectsToWrite = new TreeMap();
        for (Collection objects : objectsToWrite) {
            if (objects.size() == 0) continue;
            IFDSRenderable firstObject = (IFDSRenderable)objects.iterator().next();
            Vector existingOfType = (Vector)sortedObjectsToWrite.get(firstObject.getFDSType());
            if (existingOfType == null) {
                existingOfType = new Vector(objects.size());
                sortedObjectsToWrite.put(firstObject.getFDSType(), existingOfType);
            }
            existingOfType.addAll(objects);
        }
        StringBuffer text = new StringBuffer();
        Iterator fdsNameIt = sortedObjectsToWrite.keySet().iterator();
        for (Collection values : sortedObjectsToWrite.values()) {
            String fdsType = (String)fdsNameIt.next();
            Vector<FDSInputRecord> recordsToWrite = new Vector<FDSInputRecord>();
            FDSInputFile.collectInputRecords(values, recordsToWrite);
            FDSInputFile.renderPyroRecords(recordsToWrite, fdsType, text);
        }
        mod.pauseUpdates(false);
        mod.getHeadManager().getHeadRecord().setCHID(oldCHID);
        mod.resumeUpdates();
        return text.toString();
    }

    private static void collectInputRecords(Collection<IFDSRenderable> fdsRenderableObjects, Collection<FDSInputRecord> inputRecords) {
        for (IFDSRenderable o : fdsRenderableObjects) {
            o.getInputRecords(inputRecords);
        }
    }

    private static void renderPyroRecords(Collection<FDSInputRecord> inputRecords, String fdsType, StringBuffer text) {
        if (inputRecords.isEmpty()) {
            return;
        }
        String nl = System.getProperty("line.separator");
        for (FDSInputRecord rec : inputRecords) {
            text.append(FDSInputFile.renderRecord(rec));
        }
        text.append(nl);
    }

    public static String renderRecord(FDSInputRecord rec) {
        StringBuffer text = new StringBuffer();
        if (rec.getValue("DISABLED") != null) {
            text.append("//");
        }
        text.append(REC_START_CHAR);
        text.append(rec.getType());
        String[] keys = rec.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            text.append(" ");
            text.append(keys[i] + "=");
            text.append(FDSInputFile.renderValue(rec.getValue(keys[i])));
        }
        text.append(REC_END_CHAR);
        String comment = rec.getComment();
        if (comment != null) {
            text.append(" " + comment);
        }
        text.append(System.getProperty("line.separator"));
        return text.toString();
    }

    private static String renderUnprocessedRecords(Collection<FDSInputRecord> recs) {
        StringBuffer text = new StringBuffer();
        for (FDSInputRecord rec : recs) {
            text.append(FDSInputFile.renderUnprocRecord(rec));
        }
        return text.toString();
    }

    private static String renderUnprocRecord(FDSInputRecord rec) {
        if (rec.getDebugInfo() == null) {
            return FDSInputFile.renderRecord(rec);
        }
        return REC_START_CHAR + rec.getDebugInfo().getOriginalText() + REC_END_CHAR + System.getProperty("line.separator");
    }

    public static String renderRecords(FDSInputRecord[] recs) {
        return FDSInputFile.renderRecords(Arrays.asList(recs));
    }

    public static String renderRecords(Collection<FDSInputRecord> recs) {
        StringBuffer text = new StringBuffer();
        for (FDSInputRecord rec : recs) {
            text.append(FDSInputFile.renderRecord(rec));
        }
        return text.toString();
    }

    private static String renderValue(Object obj) {
        StringBuffer text = new StringBuffer();
        if (obj instanceof Vector) {
            Vector v = (Vector)obj;
            for (int i = 0; i < v.size(); ++i) {
                if (i > 0) {
                    text.append(", ");
                }
                text.append(FDSInputFile.renderValue(v.get(i)));
            }
        } else if (obj instanceof Boolean) {
            if (((Boolean)obj).booleanValue()) {
                text.append(".TRUE.");
            } else {
                text.append(".FALSE.");
            }
        } else if (obj instanceof String) {
            text.append("'" + obj.toString() + "'");
        } else if (obj instanceof Double) {
            if (!d_easyReadFormat) {
                d_doubleFormat.applyPattern("0.000000E000");
            } else {
                double doubleNum = (Double)obj;
                if (Math.abs(doubleNum) >= 0.01 && Math.abs(doubleNum) <= 0.4999) {
                    d_doubleFormat.applyPattern("0.0000");
                } else if (Math.abs(doubleNum) >= 0.5 && Math.abs(doubleNum) <= 999.0 || doubleNum == 0.0) {
                    d_doubleFormat.applyPattern("0.00");
                } else {
                    d_doubleFormat.applyPattern("0.000000E000");
                }
            }
            String doubleTxt = d_doubleFormat.format((Double)obj);
            text.append(doubleTxt);
        } else if (obj instanceof Integer) {
            text.append(obj.toString());
        } else {
            throw new IllegalArgumentException("Unknown value type: " + obj.getClass().getName());
        }
        return text.toString();
    }

    static {
        d_easyReadFormat = false;
        d_doubleFormat = (DecimalFormat)DecimalFormat.getInstance(Locale.US);
        d_doubleFormat.applyPattern("0.000000E000");
        WRITE_RECS = new HashSet<Class>();
        WRITE_RECS.add(FDSComposite.class);
        WRITE_RECS.add(AlignedBlock.class);
        WRITE_RECS.add(FDSConvexPoly.class);
        WRITE_RECS.add(Wall.class);
        WRITE_RECS.add(AlignedHole.class);
        WRITE_RECS.add(Hole.class);
        WRITE_RECS.add(Vent.class);
        WRITE_RECS.add(Slab.class);
        WRITE_RECS.add(BNDFRecord.class);
        WRITE_RECS.add(Grid.class);
        WRITE_RECS.add(HeadRecord.class);
        WRITE_RECS.add(IsofRecord.class);
        WRITE_RECS.add(PyroMod.MiscRecord.class);
        WRITE_RECS.add(RadiRecord.class);
        WRITE_RECS.add(PipeRecord.class);
        WRITE_RECS.add(PL3DRecord.class);
        WRITE_RECS.add(SlcfRecord.class);
        WRITE_RECS.add(SprkRecord.class);
        WRITE_RECS.add(ThcpRecord.class);
        WRITE_RECS.add(PyroMod.TimeRecord.class);
        WRITE_RECS.add(Floor.class);
        WRITE_RECS.add(SmodRecord.class);
        WRITE_RECS.add(HeatDetector.class);
    }
}

