/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain.rasterization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.Grid;
import pyrosim.legacy_2006_2.domain.rasterization.FDSObjGridRasterization;
import pyrosim.legacy_2006_2.domain.rasterization.FDSRasterization;
import pyrosim.legacy_2006_2.thunderheadeng.rasterization.Raster3D;

public class FDSObjectRasterization {
    private final HashMap<Grid, FDSObjGridRasterization> d_gridRasts;
    private final FDSRasterization d_parentRast;
    private final FDSObject d_obj;

    public FDSObjectRasterization(FDSObject obj, Map<Grid, Raster3D<FDSObject>> rasts, FDSRasterization parentRast) {
        this.d_parentRast = parentRast;
        this.d_gridRasts = new HashMap();
        this.d_obj = obj;
        for (Map.Entry<Grid, Raster3D<FDSObject>> entry : rasts.entrySet()) {
            this.addGrid(entry.getKey(), entry.getValue());
        }
    }

    public FDSObject getObject() {
        return this.d_obj;
    }

    protected void addGrid(Grid g, Raster3D<FDSObject> raster) {
        FDSObjGridRasterization objGridRast = new FDSObjGridRasterization(this.d_obj, g, this, raster);
        this.d_gridRasts.put(g, objGridRast);
    }

    protected void removeGrid(Grid g) {
        this.d_gridRasts.remove(g);
        this.fireChanged();
    }

    protected void gridChanged(Grid g) {
        FDSObjGridRasterization rast = this.d_gridRasts.get(g);
        rast.gridChanged();
    }

    protected void objChanged() {
        for (FDSObjGridRasterization rast : this.d_gridRasts.values()) {
            rast.objChanged();
        }
    }

    protected void fireChanged() {
        this.d_parentRast.getEvents().objectChanged(this);
    }

    protected void rasterize() {
        for (FDSObjGridRasterization rast : this.d_gridRasts.values()) {
            rast.rasterize();
        }
    }

    protected void unrasterize() {
        for (FDSObjGridRasterization rast : this.d_gridRasts.values()) {
            rast.unrasterize();
        }
    }

    public Map<Grid, FDSObjGridRasterization> getObjGridRasterizations() {
        return this.d_gridRasts;
    }

    public Collection<FDSObject> getFrags(Grid g, boolean mergeCells) {
        FDSObjGridRasterization objGridRast = this.d_gridRasts.get(g);
        return objGridRast.getFrags(mergeCells);
    }

    public Collection<FDSObject> getFrags(boolean mergeCells) {
        ArrayList<FDSObject> frags = new ArrayList<FDSObject>();
        for (Grid g : this.d_gridRasts.keySet()) {
            frags.addAll(this.getFrags(g, mergeCells));
        }
        return frags;
    }
}

