/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain.rasterization;

import java.awt.Color;
import java.util.Collection;
import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.ActivationEventList;
import pyrosim.legacy_2006_2.domain.AlignedBlock;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.IFDSProperties;
import pyrosim.legacy_2006_2.domain.rasterization.IFDSFragGenerator;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.thunderheadeng.rasterization.IFragGenerator;

public class BlockFragGenerator
implements IFDSFragGenerator {
    private final IFDSProperties d_props;
    private final int d_cellPriority;

    public BlockFragGenerator(IFDSProperties props, int cellPriority) {
        this.d_props = props;
        this.d_cellPriority = cellPriority;
    }

    @Override
    public FDSObject generateFrag(double minx, double miny, double minz, double maxx, double maxy, double maxz) {
        Unit lu = Geometry.GEOM_LENGTH_UNIT;
        Color color = this.d_props.getColor();
        AlignedBlock ab = new AlignedBlock(new UnitPoint3D(minx, miny, minz, lu), new UnitPoint3D(maxx, maxy, maxz, lu), this.d_props.getName() + " [Segment]", color, this.d_props.getMaterial());
        ab.setSelected(this.d_props.isSelected());
        ab.setVisible(this.d_props.isVisible());
        ab.setPermitsHole(this.d_props.permitsHoles());
        ab.setIsThickened(this.d_props.isThickened());
        ab.setIsSawtoothed(this.d_props.isSawtoothed());
        Vector segmentEvents = ab.getEventsSeparatedByType();
        Collection<ActivationEventList> objEvents = this.d_props.getEventsSeparatedByType();
        for (ActivationEventList list : objEvents) {
            segmentEvents.add((ActivationEventList)list.clone());
        }
        return ab;
    }

    @Override
    public IFDSProperties getProps() {
        return this.d_props;
    }

    @Override
    public int getCellPriority() {
        return this.d_cellPriority;
    }

    @Override
    public <T2> boolean canMerge(IFragGenerator<T2> fragGen2) {
        if (!(fragGen2 instanceof BlockFragGenerator)) {
            return false;
        }
        BlockFragGenerator bfg2 = (BlockFragGenerator)fragGen2;
        return this.getProps().equals(bfg2.getProps());
    }
}

