/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.ArrayList;
import java.util.Collection;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.SelectTask;
import pyrosim.legacy_2006_2.thunderheadeng.util.CompositeTask;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public abstract class TransformTask
extends CompositeTask<PyroMod> {
    public static final int MODE_MOVE = 0;
    public static final int MODE_COPY = 1;
    private final PyroMod d_mediator;
    private final Collection<? extends FDSObject> d_objs;
    private final int d_n;
    private final int d_mode;

    protected abstract Object getXFormForIteration(int var1);

    protected abstract Task taskTransformObject(FDSObject var1, Object var2);

    public TransformTask(PyroMod pyMod, Collection<? extends FDSObject> objs, int mode, int n) {
        super(pyMod);
        this.d_mediator = pyMod;
        this.d_objs = objs;
        this.d_n = n;
        this.d_mode = mode;
    }

    @Override
    public int getEst() {
        return 1;
    }

    @Override
    public void queueBeginRuntimeTasks() {
        switch (this.d_mode) {
            case 0: {
                this.queueMoveTasks();
                break;
            }
            case 1: {
                this.queueCopyTasks();
            }
        }
    }

    private void queueCopyTasks() {
        CompositeTask<PyroMod> copies = new CompositeTask<PyroMod>(this.d_mediator);
        ArrayList<? extends FDSObject> selObjs = new ArrayList<FDSObject>();
        selObjs.addAll(this.d_objs);
        for (int i = 0; i < this.d_n; ++i) {
            Object xform = this.getXFormForIteration(i + 1);
            for (FDSObject fDSObject : this.d_objs) {
                FDSObject newObject = (FDSObject)fDSObject.clone();
                newObject.taskSetName(fDSObject.getName() + "[" + (i + 1) + "]").run();
                this.taskTransformObject(newObject, xform).run();
                FDSComposite parent = fDSObject.getParent();
                if (parent == null) {
                    parent = this.d_mediator.getObstructions();
                }
                copies.addTask(parent.taskAdd(newObject));
                selObjs.add(newObject);
            }
        }
        SelectTask wrapper = new SelectTask(this.d_mediator, selObjs);
        wrapper.addTask(copies);
        this.addTask(wrapper);
    }

    private void queueMoveTasks() {
        Object xform = this.getXFormForIteration(1);
        for (FDSObject fDSObject : this.d_objs) {
            this.addTask(this.taskTransformObject(fDSObject, xform));
        }
    }
}

