/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.PyroSimObjectInputStream;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.dependencies.AChangePyroDepOnIDTask;
import pyrosim.legacy_2006_2.domain.dependencies.AChangePyroDepOnTask;
import pyrosim.legacy_2006_2.domain.dependencies.IPyroDependedOn;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.gui.IDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.IntValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.ValueRange;

public class PartRecord
extends ADomainObject<PyroMod>
implements Serializable,
Cloneable,
IPyroDependedOn,
IFDSRenderable {
    static final long serialVersionUID = 1L;
    public static final String NO_QUANTITY = "none";
    private String d_ID;
    private double d_gamma;
    private int d_sample;
    private int d_initDrop;
    private int d_dropSec;
    private boolean d_massless;
    private boolean d_static;
    private boolean d_fuel;
    private boolean d_water;
    private boolean d_initTempFDS;
    private String d_quantity;
    private String d_quantityScalar;
    private String d_quantityColor;
    private UnitDouble d_udDensity;
    private UnitDouble d_udVapTemp;
    private UnitDouble d_udMeltTemp;
    private UnitDouble d_udSpecHeat;
    private UnitDouble d_udHeatVap;
    private UnitDouble d_udDiameter;
    private UnitDouble d_udHeatCombust;
    private UnitDouble d_udMassVol;
    private UnitDouble d_udAge;
    private UnitDouble d_udInitTemp;
    private static final Hashtable<String, ValueRange> d_ranges;

    public static ValueRange getValueRange(String field) {
        return d_ranges.get(field);
    }

    public PartRecord(String name) {
        this.d_ID = name;
        this.initUDs();
        this.setToDefaults();
    }

    @Override
    public Object clone() {
        PartRecord clone = (PartRecord)super.clone();
        clone.imprint(this);
        return clone;
    }

    public void imprint(Object obj) {
        if (!(obj instanceof PartRecord)) {
            return;
        }
        this.pauseUpdates(false);
        PartRecord p = (PartRecord)obj;
        this.taskSetID(p.d_ID).run();
        this.d_gamma = p.d_gamma;
        this.d_sample = p.d_sample;
        this.d_initDrop = p.d_initDrop;
        this.d_dropSec = p.d_dropSec;
        this.d_massless = p.d_massless;
        this.d_static = p.d_static;
        this.d_fuel = p.d_fuel;
        this.d_water = p.d_water;
        this.d_initTempFDS = p.d_initTempFDS;
        this.d_quantity = p.d_quantity;
        this.d_quantityScalar = p.d_quantityScalar;
        this.d_quantityColor = p.d_quantityColor;
        this.d_udDensity = (UnitDouble)p.d_udDensity.clone();
        this.d_udVapTemp = (UnitDouble)p.d_udVapTemp.clone();
        this.d_udMeltTemp = (UnitDouble)p.d_udMeltTemp.clone();
        this.d_udSpecHeat = (UnitDouble)p.d_udSpecHeat.clone();
        this.d_udHeatVap = (UnitDouble)p.d_udHeatVap.clone();
        this.d_udDiameter = (UnitDouble)p.d_udDiameter.clone();
        this.d_udHeatCombust = (UnitDouble)p.d_udHeatCombust.clone();
        this.d_udMassVol = (UnitDouble)p.d_udMassVol.clone();
        this.d_udAge = (UnitDouble)p.d_udAge.clone();
        this.d_udInitTemp = (UnitDouble)p.d_udInitTemp.clone();
        this.resumeWithEvent(true);
    }

    public void initUDs() {
        FdsSISystem fdsUS = FdsSISystem.getInstance();
        this.d_udDensity = new UnitDouble(0.0, fdsUS.getDensityUnit());
        this.d_udVapTemp = new UnitDouble(0.0, fdsUS.getTempUnit());
        this.d_udMeltTemp = new UnitDouble(0.0, fdsUS.getTempUnit());
        this.d_udSpecHeat = new UnitDouble(0.0, fdsUS.getSpecHeatUnit());
        this.d_udHeatVap = new UnitDouble(0.0, fdsUS.getSpecEnergyUnit());
        this.d_udDiameter = new UnitDouble(0.0, fdsUS.getDiameterUnit());
        this.d_udHeatCombust = new UnitDouble(0.0, fdsUS.getSpecEnergyUnit());
        this.d_udMassVol = new UnitDouble(0.0, fdsUS.getDensityUnit());
        this.d_udAge = new UnitDouble(0.0, fdsUS.getTimeUnit());
        this.d_udInitTemp = new UnitDouble(0.0, fdsUS.getTempUnit());
    }

    public void setToDefaults() {
        FdsSISystem fdsUS = FdsSISystem.getInstance();
        this.pauseUpdates(false);
        this.d_udDensity = new UnitDouble(1000.0, fdsUS.getDensityUnit());
        this.d_udVapTemp = new UnitDouble(100.0, fdsUS.getTempUnit());
        this.d_udMeltTemp = new UnitDouble(0.0, fdsUS.getTempUnit());
        this.d_udSpecHeat = new UnitDouble(4.184, fdsUS.getSpecHeatUnit());
        this.d_udHeatVap = new UnitDouble(2259.0, fdsUS.getSpecEnergyUnit());
        this.d_udDiameter = new UnitDouble(100.0, fdsUS.getDiameterUnit());
        this.d_udHeatCombust = new UnitDouble(0.0, fdsUS.getSpecEnergyUnit());
        this.d_udMassVol = new UnitDouble(1.0, fdsUS.getDensityUnit());
        this.d_udAge = new UnitDouble(100000.0, fdsUS.getTimeUnit());
        this.d_udInitTemp = new UnitDouble(20.0, fdsUS.getTempUnit());
        this.d_gamma = 2.4;
        this.d_massless = true;
        this.d_static = false;
        this.d_fuel = false;
        this.d_water = false;
        this.d_sample = 1;
        this.d_quantity = NO_QUANTITY;
        this.d_quantityScalar = "TEMPERATURE";
        this.d_quantityColor = "RED";
        this.d_initDrop = 0;
        this.d_dropSec = 1000;
        this.d_initTempFDS = true;
        this.resumeWithEvent(true);
    }

    public Task taskSetID(String newID) {
        return new AChangePyroDepOnIDTask(this, newID, this.getDomains()){

            @Override
            public void setID(String newID) {
                PartRecord.this.setID(newID);
            }
        };
    }

    private void setID(String name) {
        this.d_ID = name;
        this.fireChangeEvent(false);
    }

    public void setDensity(double density, Unit u) {
        this.d_udDensity = new UnitDouble(density, u);
        this.fireChangeEvent(true);
    }

    public void setVapTemp(double vapTemp, Unit u) {
        this.d_udVapTemp = new UnitDouble(vapTemp, u);
        this.fireChangeEvent(true);
    }

    public void setMeltTemp(double meltTemp, Unit u) {
        this.d_udMeltTemp = new UnitDouble(meltTemp, u);
        this.fireChangeEvent(true);
    }

    public void setSpecificHeat(double specHeat, Unit u) {
        this.d_udSpecHeat = new UnitDouble(specHeat, u);
        this.fireChangeEvent(true);
    }

    public void setHeatVap(double heatVap, Unit u) {
        this.d_udHeatVap = new UnitDouble(heatVap, u);
        this.fireChangeEvent(true);
    }

    public void setDiameter(double diameter, Unit u) {
        this.d_udDiameter = new UnitDouble(diameter, u);
        this.fireChangeEvent(true);
    }

    public void setGamma(double gamma) {
        this.d_gamma = gamma;
        this.fireChangeEvent(true);
    }

    public void setMassless(boolean massless) {
        this.d_massless = massless;
        this.fireChangeEvent(true);
    }

    public void setStatic(boolean static1) {
        this.d_static = static1;
        this.fireChangeEvent(true);
    }

    public void setFuel(boolean fuel) {
        this.d_fuel = fuel;
        this.fireChangeEvent(true);
    }

    public void setHeatCombust(double heatCombust, Unit u) {
        this.d_udHeatCombust = new UnitDouble(heatCombust, u);
        this.fireChangeEvent(true);
    }

    public void setWater(boolean water) {
        this.d_water = water;
        this.fireChangeEvent(true);
    }

    public void setSample(int sample) {
        this.d_sample = sample;
        this.fireChangeEvent(true);
    }

    public void setQuantity(String quantity) {
        this.d_quantity = quantity;
        this.fireChangeEvent(true);
    }

    public void setQuantityScalar(String quantity) {
        this.d_quantityScalar = quantity;
        this.fireChangeEvent(true);
    }

    public void setQuantityColor(String quantity) {
        this.d_quantityColor = quantity;
        this.fireChangeEvent(true);
    }

    public void setInitDrop(int initDrop) {
        this.d_initDrop = initDrop;
        this.fireChangeEvent(true);
    }

    public void setMassVol(double massVol, Unit u) {
        this.d_udMassVol = new UnitDouble(massVol, u);
        this.fireChangeEvent(true);
    }

    public void setDropSec(int dropSec) {
        this.d_dropSec = dropSec;
        this.fireChangeEvent(true);
    }

    public void setAge(double age, Unit u) {
        this.d_udAge = new UnitDouble(age, u);
        this.fireChangeEvent(true);
    }

    public void setInitTemp(double temp, Unit u) {
        this.d_udInitTemp = this.d_udInitTemp == null ? new UnitDouble(temp, u) : new UnitDouble(temp, u);
        this.fireChangeEvent(true);
    }

    public void setInitTemp(UnitDouble ud) {
        this.d_udInitTemp = ud;
        this.fireChangeEvent(true);
    }

    public void setInitTempFDS(boolean state) {
        this.d_initTempFDS = state;
        this.fireChangeEvent(true);
    }

    public String getID() {
        return this.d_ID;
    }

    public UnitDouble getDensity() {
        return this.d_udDensity;
    }

    public UnitDouble getVapTemp() {
        return this.d_udVapTemp;
    }

    public UnitDouble getMeltTemp() {
        return this.d_udMeltTemp;
    }

    public UnitDouble getSpecificHeat() {
        return this.d_udSpecHeat;
    }

    public UnitDouble getHeatVap() {
        return this.d_udHeatVap;
    }

    public UnitDouble getDiameter() {
        return this.d_udDiameter;
    }

    public double getGamma() {
        return this.d_gamma;
    }

    public boolean getMassless() {
        return this.d_massless;
    }

    public boolean getStatic() {
        return this.d_static;
    }

    public boolean getFuel() {
        return this.d_fuel;
    }

    public UnitDouble getHeatCombust() {
        return this.d_udHeatCombust;
    }

    public boolean getWater() {
        return this.d_water;
    }

    public int getSample() {
        return this.d_sample;
    }

    public String getQuantity() {
        return this.d_quantity;
    }

    public String getQuantityScalar() {
        return this.d_quantityScalar;
    }

    public String getQuantityColor() {
        return this.d_quantityColor;
    }

    public boolean getInitDropFDS() {
        return this.getInitDrop() > 0 && !this.getMassless();
    }

    public int getInitDrop() {
        return this.d_initDrop;
    }

    public UnitDouble getMassVol() {
        return this.d_udMassVol;
    }

    public int getDropSec() {
        return this.d_dropSec;
    }

    public UnitDouble getAge() {
        return this.d_udAge;
    }

    public UnitDouble getInitTemp() {
        return this.d_udInitTemp;
    }

    public boolean getInitTempFDS() {
        return this.d_initTempFDS;
    }

    @Override
    public String getFDSType() {
        return "PART";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> recs) {
        FDSInputRecord rec = new FDSInputRecord();
        rec.setType("PART");
        FdsSISystem si = FdsSISystem.getInstance();
        rec.setValue("ID", this.getID());
        rec.setValue("MASSLESS", this.getMassless());
        rec.setValue("SAMPLING_FACTOR", this.getSample());
        rec.setValue("AGE", this.getAge().getValue(si.getTimeUnit()));
        if (!this.getQuantity().equals(NO_QUANTITY)) {
            rec.setValue("QUANTITY", this.getQuantity());
        }
        if (!this.getMassless()) {
            rec.setValue("DENSITY", this.getDensity().getValue(si.getDensityUnit()));
            rec.setValue("VAPORIZATION_TEMPERATURE", this.getVapTemp().getValue(si.getTempUnit()));
            rec.setValue("MELTING_TEMPERATURE", this.getMeltTemp().getValue(si.getTempUnit()));
            rec.setValue("SPECIFIC_HEAT", this.getSpecificHeat().getValue(si.getSpecHeatUnit()));
            rec.setValue("HEAT_OF_VAPORIZATION", this.getHeatVap().getValue(si.getSpecEnergyUnit()));
            rec.setValue("DIAMETER", this.getDiameter().getValue(si.getDiameterUnit()));
            rec.setValue("GAMMA_D", this.getGamma());
            rec.setValue("FUEL", this.getFuel());
            if (this.getFuel()) {
                rec.setValue("HEAT_OF_COMBUSTION", this.getHeatCombust().getValue(si.getSpecEnergyUnit()));
            }
            rec.setValue("WATER", this.getWater());
            if (this.getInitDrop() > 0) {
                rec.setValue("STATIC", this.getStatic());
                rec.setValue("NUMBER_INITIAL_DROPLETS", this.getInitDrop());
                rec.setValue("MASS_PER_VOLUME", this.getMassVol().getValue(si.getDensityUnit()));
            }
            rec.setValue("DROPLETS_PER_SECOND", this.getDropSec());
            if (!this.getInitTempFDS()) {
                rec.setValue("INITIAL_TEMPERATURE", this.getInitTemp().getValue(si.getTempUnit()));
            }
        }
        recs.add(rec);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PartRecord) {
            return ((PartRecord)obj).d_ID.equals(this.d_ID) && ((PartRecord)obj).d_udInitTemp.equals(this.d_udInitTemp) && ((PartRecord)obj).d_udDensity.equals(this.d_udDensity) && ((PartRecord)obj).d_udVapTemp.equals(this.d_udVapTemp) && ((PartRecord)obj).d_udMeltTemp.equals(this.d_udMeltTemp) && ((PartRecord)obj).d_udSpecHeat.equals(this.d_udSpecHeat) && ((PartRecord)obj).d_udHeatVap.equals(this.d_udHeatVap) && ((PartRecord)obj).d_udDiameter.equals(this.d_udDiameter) && ((PartRecord)obj).d_gamma == this.d_gamma && ((PartRecord)obj).d_udHeatCombust.equals(this.d_udHeatCombust) && ((PartRecord)obj).d_sample == this.d_sample && ((PartRecord)obj).d_udMassVol.equals(this.d_udMassVol) && ((PartRecord)obj).d_initDrop == this.d_initDrop && ((PartRecord)obj).d_dropSec == this.d_dropSec && ((PartRecord)obj).d_udAge.equals(this.d_udAge) && ((PartRecord)obj).d_massless == this.d_massless && ((PartRecord)obj).d_static == this.d_static && ((PartRecord)obj).d_fuel == this.d_fuel && ((PartRecord)obj).d_water == this.d_water && ((PartRecord)obj).d_quantity.equals(this.d_quantity) && ((PartRecord)obj).d_quantityScalar.equals(this.d_quantityScalar) && ((PartRecord)obj).d_quantityColor.equals(this.d_quantityColor) && ((PartRecord)obj).d_initTempFDS == this.d_initTempFDS;
        }
        return false;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField gf = stream.readFields();
        this.d_ID = (String)gf.get("d_ID", null);
        this.d_gamma = gf.get("d_gamma", 0.0);
        this.d_udAge = (UnitDouble)gf.get("d_udAge", null);
        if (gf.defaulted("d_udAge")) {
            double secondAge = gf.get("d_ageReal", -1.0);
            if (gf.defaulted("d_ageReal")) {
                int firstAge = gf.get("d_age", 0);
                this.d_udAge = new UnitDouble(firstAge, FdsSISystem.getInstance().getTimeUnit());
            } else {
                this.d_udAge = new UnitDouble(secondAge, FdsSISystem.getInstance().getTimeUnit());
            }
        }
        FdsSISystem fdsUS = FdsSISystem.getInstance();
        this.d_udDensity = (UnitDouble)gf.get("d_udDensity", null);
        if (!gf.defaulted("d_udDensity")) {
            this.d_udVapTemp = (UnitDouble)gf.get("d_udVapTemp", null);
            this.d_udMeltTemp = (UnitDouble)gf.get("d_udMeltTemp", null);
            this.d_udSpecHeat = (UnitDouble)gf.get("d_udSpecHeat", null);
            this.d_udHeatVap = (UnitDouble)gf.get("d_udHeatVap", null);
            this.d_udDiameter = (UnitDouble)gf.get("d_udDiameter", null);
            this.d_udHeatCombust = (UnitDouble)gf.get("d_udHeatCombust", null);
            this.d_udMassVol = (UnitDouble)gf.get("d_udMassVol", null);
        } else {
            this.d_udDensity = new UnitDouble(gf.get("d_density", 0.0), fdsUS.getDensityUnit());
            this.d_udVapTemp = new UnitDouble(gf.get("d_vapTemp", 0.0), fdsUS.getTempUnit());
            this.d_udMeltTemp = new UnitDouble(gf.get("d_meltTemp", 0.0), fdsUS.getTempUnit());
            this.d_udSpecHeat = new UnitDouble(gf.get("d_specificHeat", 0.0), fdsUS.getSpecHeatUnit());
            this.d_udHeatVap = new UnitDouble(gf.get("d_heatVap", 0.0), fdsUS.getSpecEnergyUnit());
            this.d_udDiameter = new UnitDouble(gf.get("d_diameter", 0.0), fdsUS.getDiameterUnit());
            this.d_udHeatCombust = new UnitDouble(gf.get("d_heatCombust", 0.0), fdsUS.getSpecEnergyUnit());
            this.d_udMassVol = new UnitDouble(gf.get("d_massVol", 0.0), fdsUS.getDensityUnit());
        }
        this.d_sample = gf.get("d_sample", 0);
        this.d_initDrop = gf.get("d_initDrop", 0);
        this.d_dropSec = gf.get("d_dropSec", 0);
        this.d_massless = gf.get("d_massless", false);
        this.d_static = gf.get("d_static", false);
        this.d_fuel = gf.get("d_fuel", false);
        this.d_water = gf.get("d_water", false);
        this.d_quantity = (String)gf.get("d_quantity", "");
        this.d_quantityScalar = (String)gf.get("d_quantityScalar", "");
        this.d_quantityColor = (String)gf.get("d_quantityColor", "");
        this.d_udInitTemp = new UnitDouble(0.0, fdsUS.getTempUnit());
        if (!(stream instanceof PyroSimObjectInputStream) || stream instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)stream).getVersion() < 13) {
            PartRecord defRec = new PartRecord("default");
            if (!PartRecord.getValueRange("NUMBER_INITIAL_DROPLETS").checkValue(this.d_initDrop)) {
                this.d_initDrop = defRec.d_initDrop;
            }
            if (!PartRecord.getValueRange("DROPLETS_PER_SECOND").checkValue(this.d_dropSec)) {
                this.d_dropSec = defRec.d_dropSec;
            }
            if (!PartRecord.getValueRange("AGE").checkValue(this.d_udAge)) {
                this.d_udAge = defRec.d_udAge;
            }
            if (this.d_udDensity != null && !PartRecord.getValueRange("DENSITY").checkValue(this.d_udDensity)) {
                this.d_udDensity = defRec.d_udDensity;
            }
            if (this.d_udDiameter != null && !PartRecord.getValueRange("DIAMETER").checkValue(this.d_udDiameter)) {
                this.d_udDiameter = defRec.d_udDiameter;
            }
            if (this.d_udHeatCombust != null && !PartRecord.getValueRange("HEAT_OF_COMBUSTION").checkValue(this.d_udHeatCombust)) {
                this.d_udHeatCombust = defRec.d_udHeatCombust;
            }
            if (this.d_udHeatVap != null && !PartRecord.getValueRange("HEAT_OF_VAPORIZATION").checkValue(this.d_udHeatVap)) {
                this.d_udHeatVap = defRec.d_udHeatVap;
            }
            if (this.d_udMassVol != null && !PartRecord.getValueRange("MASS_PER_VOLUME").checkValue(this.d_udMassVol)) {
                this.d_udMassVol = defRec.d_udMassVol;
            }
            if (this.d_udSpecHeat != null && !PartRecord.getValueRange("SPECIFIC_HEAT").checkValue(this.d_udSpecHeat)) {
                this.d_udSpecHeat = defRec.d_udSpecHeat;
            }
        }
    }

    @Override
    public String getUniqueID() {
        return this.getID();
    }

    @Override
    public String getTypeDescription() {
        return "Particle";
    }

    @Override
    public Object getUniqueTypeKey() {
        return this.getFDSType();
    }

    private void fireChangeEvent(boolean updateDependents) {
        this.fireDomainEvent(new PyroDomainEvent(this, PartRecord.class, 5), updateDependents);
    }

    private void resumeWithEvent(boolean updateDependents) {
        this.resumeUpdates(new PyroDomainEvent(this, PartRecord.class, 5), updateDependents);
    }

    public boolean fireDomainEvent(IDomainEvent event, boolean updateDependents) {
        this.pauseUpdates();
        boolean fired = super.fireDomainEvent(event);
        if (updateDependents) {
            new AChangePyroDepOnTask(this, this.getDomains()).run();
        }
        this.resumeUpdates();
        return fired;
    }

    public void resumeUpdates(IDomainEvent event, boolean updateDependents) {
        super.resumeUpdates(event);
        if (updateDependents) {
            new AChangePyroDepOnTask(this, this.getDomains()).run();
        }
    }

    static {
        FdsSISystem si = FdsSISystem.getInstance();
        d_ranges = new Hashtable(2);
        d_ranges.put("NUMBER_INITIAL_DROPLETS", IntValueRange.createCheckedMin(0, true));
        d_ranges.put("DROPLETS_PER_SECOND", IntValueRange.createCheckedMin(1, true));
        d_ranges.put("AGE", UnitDoubleValueRange.createCheckedMin(0.0, si.getTimeUnit(), false));
        d_ranges.put("DENSITY", UnitDoubleValueRange.createCheckedMin(0.0, si.getDensityUnit(), false));
        d_ranges.put("DIAMETER", UnitDoubleValueRange.createCheckedMin(0.0, si.getDiameterUnit(), true));
        d_ranges.put("HEAT_OF_COMBUSTION", UnitDoubleValueRange.createCheckedMin(0.0, si.getSpecEnergyUnit(), true));
        d_ranges.put("HEAT_OF_VAPORIZATION", UnitDoubleValueRange.createCheckedMin(0.0, si.getSpecEnergyUnit(), true));
        d_ranges.put("MASS_PER_VOLUME", UnitDoubleValueRange.createCheckedMin(0.0, si.getDensityUnit(), true));
        d_ranges.put("SPECIFIC_HEAT", UnitDoubleValueRange.createCheckedMin(0.0, si.getSpecHeatUnit(), true));
    }
}

