/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.APyroDomainManager;
import pyrosim.legacy_2006_2.domain.APyroManAddTask;
import pyrosim.legacy_2006_2.domain.APyroManReplaceTask;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.PL3DRecord;
import pyrosim.legacy_2006_2.domain.PyroCollection;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public class PL3DManager
extends APyroDomainManager<PL3DRecord, PL3DRecord> {
    private final PyroMod d_mod;
    private PL3DRecord d_pl3dRec;

    public PL3DManager(PyroMod mod) {
        this.d_mod = mod;
    }

    public void setPL3DRecord(PL3DRecord rec) {
        this.d_pl3dRec = rec;
    }

    public PL3DRecord getPL3DRecord() {
        return this.d_pl3dRec;
    }

    @Override
    public Collection<? extends PL3DRecord> toCollection() {
        return new PyroCollection<PL3DRecord, PL3DRecord>(this);
    }

    @Override
    protected boolean add(PL3DRecord pyroObject) {
        super.add(pyroObject);
        this.d_mod.setPL3DRecord(pyroObject);
        this.fireDomainEvent(new PyroDomainEvent<PL3DManager, PL3DRecord>(this, pyroObject, PL3DRecord.class, 3));
        return true;
    }

    @Override
    protected boolean remove(PL3DRecord key) {
        super.remove(key);
        this.fireDomainEvent(new PyroDomainEvent<PL3DManager, PL3DRecord>(this, key, PL3DRecord.class, 4));
        return true;
    }

    @Override
    public boolean contains(PL3DRecord key) {
        return this.getPL3DRecord().equals(key);
    }

    @Override
    public PL3DRecord get(PL3DRecord key) {
        return this.getPL3DRecord();
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public PL3DRecord[] toArray() {
        return new PL3DRecord[]{this.getPL3DRecord()};
    }

    public PL3DRecord[] toArray(PL3DRecord[] array) {
        array[0] = this.getPL3DRecord();
        return array;
    }

    @Override
    public Iterator<PL3DRecord> iterator() {
        VectorFromArray<PL3DRecord> temp = new VectorFromArray<PL3DRecord>(this.getPL3DRecord());
        return temp.iterator();
    }

    @Override
    public Class<PL3DRecord> getVClass() {
        return PL3DRecord.class;
    }

    @Override
    public Class<PL3DRecord> getKClass() {
        return PL3DRecord.class;
    }

    @Override
    public boolean canMakeUnique(PL3DRecord pyroObject) {
        return false;
    }

    @Override
    public String describeObject(PL3DRecord pyroObject) {
        return null;
    }

    @Override
    public Task taskMakeUnique(PL3DRecord pyroObject) {
        return null;
    }

    @Override
    public Task taskAddAll(Collection<? extends PL3DRecord> pyroObjects) {
        return new APyroManAddTask<PL3DRecord, PL3DRecord>((IPyroManager)this, pyroObjects){

            @Override
            public boolean add(PL3DRecord obj) {
                return PL3DManager.this.add(obj);
            }

            @Override
            public boolean remove(PL3DRecord obj) {
                return PL3DManager.this.remove(obj);
            }
        };
    }

    @Override
    public Task taskRemoveAll(List<PL3DRecord> pyroObjects, List<PL3DRecord> replacements) {
        return new APyroManReplaceTask<PL3DRecord, PL3DRecord>((IPyroManager)this, pyroObjects, replacements){

            @Override
            public boolean add(PL3DRecord obj) {
                return PL3DManager.this.add(obj);
            }

            @Override
            public boolean remove(PL3DRecord obj) {
                return PL3DManager.this.remove(obj);
            }
        };
    }
}

