/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.Serializable;
import javax.vecmath.Point2d;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.UnitPoint2D;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public abstract class ModelImage
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    private Point2d d_anchorImage;
    private UnitPoint2D d_anchorModel;
    private Point2d d_aImage;
    private Point2d d_bImage;
    private UnitDouble d_distABModel;
    private UnitDouble d_zLocationModel;
    private float d_opacity = 1.0f;

    public abstract String getID();

    public ModelImage(Point2d anchorImage, UnitPoint2D anchorModel, Point2d aImage, Point2d bImage, UnitDouble distABModel, UnitDouble zLocModel, float opacity) {
        this.d_anchorImage = new Point2d(anchorImage);
        this.d_anchorModel = (UnitPoint2D)anchorModel.clone();
        this.d_aImage = new Point2d(aImage);
        this.d_bImage = new Point2d(bImage);
        this.d_distABModel = (UnitDouble)distABModel.clone();
        this.d_zLocationModel = (UnitDouble)zLocModel.clone();
        this.d_opacity = opacity;
    }

    public AffineTransform getTransform() {
        Unit u = Geometry.GEOM_LENGTH_UNIT;
        AffineTransform imgTransform = new AffineTransform();
        imgTransform.translate(this.d_anchorModel.x.getValue(u), this.d_anchorModel.y.getValue(u));
        double scale = this.getBackgroundImageScale().getValue(u);
        imgTransform.scale(scale, scale);
        imgTransform.translate(-this.d_anchorImage.x, -this.d_anchorImage.y);
        return imgTransform;
    }

    public UnitDouble getBackgroundImageScale() {
        double pixelDist = this.d_aImage.distance(this.d_bImage);
        Unit u = Geometry.GEOM_LENGTH_UNIT;
        return new UnitDouble(this.d_distABModel.getValue(u) / pixelDist, u);
    }

    public String toString() {
        Point2D.Double anchor = this.d_anchorModel.getValue(Geometry.GEOM_LENGTH_UNIT);
        double distAB = this.d_distABModel.getValue(Geometry.GEOM_LENGTH_UNIT);
        return this.getID() + ";" + this.d_anchorImage + ";" + anchor.getX() + "," + anchor.getY() + ";" + this.d_aImage + ";" + this.d_bImage + ";" + this.d_zLocationModel + ";" + distAB + ";" + this.d_opacity;
    }

    public Object clone() {
        try {
            ModelImage clone = (ModelImage)super.clone();
            clone.d_anchorImage = new Point2d(this.d_anchorImage);
            clone.d_anchorModel = (UnitPoint2D)this.d_anchorModel.clone();
            clone.d_aImage = new Point2d(this.d_aImage);
            clone.d_bImage = new Point2d(this.d_bImage);
            clone.d_distABModel = (UnitDouble)this.d_distABModel.clone();
            clone.d_zLocationModel = (UnitDouble)this.d_zLocationModel.clone();
            clone.d_opacity = this.d_opacity;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof ModelImage)) {
            return false;
        }
        ModelImage i = (ModelImage)o;
        boolean equal = (i.getID() != null ? i.getID().equals(this.getID()) : this.getID() == null) && (i.d_anchorModel != null ? i.d_anchorModel.equals(this.d_anchorModel) : this.d_anchorModel == null) && (i.d_distABModel != null ? i.d_distABModel.equals(this.d_distABModel) : this.d_distABModel == null) && i.d_anchorImage.equals(this.d_anchorImage) && i.d_aImage.equals(this.d_aImage) && i.d_bImage.equals(this.d_bImage) && i.d_zLocationModel.equals(this.d_zLocationModel) && i.d_opacity == this.d_opacity;
        return equal;
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof ModelImage)) {
            return 1;
        }
        return ((ModelImage)obj).getID().compareTo(this.getID());
    }

    public UnitPoint2D getAnchorModel() {
        return this.d_anchorModel;
    }

    public void setAnchorModel(UnitPoint2D bgImageModelPt) {
        this.d_anchorModel = (UnitPoint2D)bgImageModelPt.clone();
    }

    public Point2d getAnchorImage() {
        return this.d_anchorImage;
    }

    public void setAnchorImage(Point2d anchorImage) {
        this.d_anchorImage = new Point2d(anchorImage);
    }

    public UnitDouble getDistABModel() {
        return this.d_distABModel;
    }

    public void setDistABModel(UnitDouble distAB) {
        this.d_distABModel = (UnitDouble)distAB.clone();
    }

    public Point2d getAImage() {
        return this.d_aImage;
    }

    public void setAImage(Point2d ptA) {
        this.d_aImage = new Point2d(ptA);
    }

    public Point2d getBImage() {
        return this.d_bImage;
    }

    public void setBImage(Point2d ptB) {
        this.d_bImage = new Point2d(ptB);
    }

    public UnitDouble getZLocationModel() {
        return this.d_zLocationModel;
    }

    public void setZLocationModel(UnitDouble loc) {
        this.d_zLocationModel = (UnitDouble)loc.clone();
    }

    public float getOpacity() {
        return this.d_opacity;
    }

    public void setOpacity(float opacity) {
        this.d_opacity = opacity;
    }
}

