/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.PyroSimObjectInputStream;
import pyrosim.legacy_2006_2.TextureDB;
import pyrosim.legacy_2006_2.UnitSystem;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.MaterialProfile;
import pyrosim.legacy_2006_2.domain.PartRecord;
import pyrosim.legacy_2006_2.domain.PyroResourceFinder;
import pyrosim.legacy_2006_2.domain.Ramp;
import pyrosim.legacy_2006_2.domain.TextureInfo;
import pyrosim.legacy_2006_2.domain.dependencies.AChangePyroDepOnIDTask;
import pyrosim.legacy_2006_2.domain.dependencies.AChangePyroDepOnTask;
import pyrosim.legacy_2006_2.domain.dependencies.IDependedOn;
import pyrosim.legacy_2006_2.domain.dependencies.IDependent;
import pyrosim.legacy_2006_2.domain.dependencies.IPyroDependedOn;
import pyrosim.legacy_2006_2.events.MaterialDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.gui.IDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.DoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.IntValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.ValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.Warning;

public class Material
extends ADomainObject<PyroMod>
implements Serializable,
Cloneable,
IDependent,
IPyroDependedOn,
IFDSRenderable {
    static final long serialVersionUID = 1L;
    public static final String INERT = "INERT";
    public static final String OPEN = "OPEN";
    public static final String MIRROR = "MIRROR";
    public static final String ADIABATIC_MAT = "ADIABATIC";
    private static final Material s_inert = new Material("INERT", new Color(0.5f, 0.5f, 0.5f));
    private static final Material s_open = new Material("OPEN", new Color(0.0f, 1.0f, 1.0f));
    private static final Material s_mirror = new Material("MIRROR", new Color(0.0f, 1.0f, 1.0f));
    private static final Material s_adiabatic = new Material("ADIABATIC", new Color(0.8f, 0.8f, 0.8f));
    private static Hashtable<String, Material> d_predefinedMaterials = new Hashtable(4);
    public static final String COLOR = "RGB";
    public static final String NAME = "ID";
    public static final String ADIABATIC = "ADIABATIC";
    public static final String ALPHA = "ALPHA";
    public static final String A = "A";
    public static final String BACKING = "BACKING";
    public static final String BURN_AWAY = "BURN_AWAY";
    public static final String BURNING_RATE_MAX = "BURNING_RATE_MAX";
    public static final String C_DELTA_RHO = "C_DELTA_RHO";
    public static final String CHAR_DENSITY = "CHAR_DENSITY";
    public static final String C_P = "C_P";
    public static final String C_P_CHAR = "C_P_CHAR";
    public static final String DELTA = "DELTA";
    public static final String DENSITY = "DENSITY";
    public static final String DX_SOLID = "DX_SOLID";
    public static final String E = "E";
    public static final String E_COEFFICIENT = "E_COEFFICIENT";
    public static final String EMISSIVITY = "EMISSIVITY";
    public static final String FUEL_FRACTION = "FUEL_FRACTION";
    public static final String FYI = "FYI";
    public static final String HEAT_FLUX = "HEAT_FLUX";
    public static final String HEAT_OF_COMBUSTION = "HEAT_OF_COMBUSTION";
    public static final String HEAT_OF_VAPORIZATION = "HEAT_OF_VAPORIZATION";
    public static final String HRRPUA = "HRRPUA";
    public static final String KS = "KS";
    public static final String KS_CHAR = "KS_CHAR";
    public static final String LEAKING = "LEAKING";
    public static final String MASS_FLUX_CRITICAL = "MASS_FLUX_CRITICAL";
    public static final String MOISTURE_FRACTION = "MOISTURE_FRACTION";
    public static final String NPPC = "NPPC";
    public static final String PARTICLES = "PARTICLES";
    public static final String PART_ID = "PART_ID";
    public static final String PHASE = "PHASE";
    public static final String PLE = "PLE";
    public static final String POROSITY = "POROSITY";
    public static final String PROFILE = "PROFILE";
    public static final String RAMP_C_P = "RAMP_C_P";
    public static final String RAMP_C_P_CHAR = "RAMP_C_P_CHAR";
    public static final String RAMP_KS = "RAMP_KS";
    public static final String RAMP_KS_CHAR = "RAMP_KS_CHAR";
    public static final String RAMP_Q = "RAMP_Q";
    public static final String RAMP_V = "RAMP_V";
    public static final String SURFACE_DENSITY = "SURFACE_DENSITY";
    public static final String TAU_Q = "TAU_Q";
    public static final String TAU_V = "TAU_V";
    public static final String TEXTURE_HEIGHT = "TEXTURE_HEIGHT";
    public static final String TEXTURE_MAP = "TEXTURE_MAP";
    public static final String TEXTURE_WIDTH = "TEXTURE_WIDTH";
    public static final String TMPIGN = "TMPIGN";
    public static final String TMPWAL = "TMPWAL";
    public static final String TMPWAL0 = "TMPWAL0";
    public static final String VBC = "VBC";
    public static final String VEL = "VEL";
    public static final String VEL_T = "VEL_T";
    public static final String VOLUME_FLUX = "VOLUME_FLUX";
    public static final String WALL_POINTS = "WALL_POINTS";
    public static final String Z0 = "Z0";
    public static final String DEF_VEL_PROFILE_DESC = "Top Hat (Default)";
    public static final String TOPHAT_PROFILE = "TOP_HAT";
    public static final String PARABOLIC_PROFILE = "PARABOLIC";
    public static final String ATMOSPHERIC_PROFILE = "ATMOSPHERIC";
    public static final String LIQUID = "LIQUID";
    public static final String CHAR = "CHAR";
    public static final String SOLID = "SOLID";
    public static final String INSULATED = "INSULATED";
    public static final String EXPOSED = "EXPOSED";
    private static final Hashtable<String, RampInfo> s_rampInfo;
    private static final TreeMap<String, ValueInfo<? extends Object, ? extends Object>> s_valueInfo;
    private Color d_color;
    private String d_name;
    @Deprecated
    private String d_texname;
    private TextureInfo d_texinfo;
    private Hashtable<String, Object> d_table;
    private MaterialProfile.ProfilePath d_profilePath = null;

    private static DoubleValueRange dur() {
        return DoubleValueRange.createUncheckedRange();
    }

    private static IntValueRange iur() {
        return IntValueRange.createUncheckedRange();
    }

    public static ValueInfo<?, ?> getValueInfo(String valueName) {
        return s_valueInfo.get(valueName);
    }

    public static Set<String> getValueNames() {
        return s_valueInfo.keySet();
    }

    public static int getUnitType(String valueName) {
        ValueInfo<? extends Object, ? extends Object> info = s_valueInfo.get(valueName);
        if (info == null) {
            return 28;
        }
        return info.d_unitType;
    }

    public static Object getDefaultValue(String valueName) {
        ValueInfo<? extends Object, ? extends Object> info = s_valueInfo.get(valueName);
        if (info == null) {
            return null;
        }
        return info.d_defaultValue;
    }

    public static boolean isValueSetByDefault(String valueName) {
        ValueInfo<? extends Object, ? extends Object> info = s_valueInfo.get(valueName);
        if (info == null) {
            return true;
        }
        return info.d_defaultSet;
    }

    public static ValueRange getValueRange(String valueName) {
        ValueInfo<? extends Object, ? extends Object> info = s_valueInfo.get(valueName);
        if (info == null) {
            return null;
        }
        return info.d_valueRange;
    }

    public static boolean isPredefinedMaterial(String mat) {
        return d_predefinedMaterials.get(mat) != null;
    }

    public static Material getPredefinedMaterial(String mat) {
        return d_predefinedMaterials.get(mat);
    }

    public static Collection<Material> getPredefinedMaterials() {
        return d_predefinedMaterials.values();
    }

    public static RampInfo getRampInfo(String rampType) {
        return s_rampInfo.get(rampType);
    }

    public static Collection<String> getRampTypes() {
        return s_rampInfo.keySet();
    }

    public Material(String name) {
        this(name, s_inert.getColor(), (TextureInfo)null);
    }

    public Material(String name, Color c) {
        this(name, c, (TextureInfo)null);
    }

    @Deprecated
    public Material(String name, Color color, String texname) {
        this(name, color, (TextureInfo)null);
    }

    public Material(String name, Color color, TextureInfo texinfo) {
        this.d_name = name;
        this.d_color = color;
        this.d_texname = null;
        this.d_texinfo = texinfo;
        this.d_table = new Hashtable();
        this.d_profilePath = new MaterialProfile.ProfilePath("Default Material Profile");
    }

    public void updateTextureInfo(TextureDB db) {
        if (this.d_texname != null) {
            this.d_texinfo = new TextureInfo(this.d_texname);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (!(in instanceof PyroSimObjectInputStream)) {
            return;
        }
        PyroSimObjectInputStream pyroIn = (PyroSimObjectInputStream)in;
        if (pyroIn.getVersion() < 15) {
            if (this.d_table == null) {
                this.d_table = new Hashtable();
            } else {
                FdsSISystem fdsUS = FdsSISystem.getInstance();
                for (Map.Entry<String, Object> entry : this.d_table.entrySet()) {
                    Unit unit;
                    int unitType;
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    if (value instanceof Double) {
                        unitType = Material.getUnitType(key);
                        if (unitType == 28) continue;
                        unit = fdsUS.getUnit(unitType);
                        UnitDouble newValue = new UnitDouble((Double)value, unit);
                        this.d_table.put(key, newValue);
                        continue;
                    }
                    if (!(value instanceof Vector) || (unitType = Material.getUnitType(key)) == 28) continue;
                    unit = fdsUS.getUnit(unitType);
                    Vector v = (Vector)value;
                    for (int m = 0; m < v.size(); ++m) {
                        Object vValue = v.get(m);
                        if (!(vValue instanceof Double)) continue;
                        UnitDouble newValue = new UnitDouble((Double)vValue, unit);
                        v.set(m, newValue);
                    }
                    this.d_table.put(key, v);
                }
            }
            if (this.d_profilePath == null) {
                this.recalcProfilePath();
            }
        }
    }

    @Override
    public Object clone() {
        Material theClone = new Material(this.d_name, this.d_color, this.d_texinfo);
        theClone.imprint(this, false);
        return theClone;
    }

    @Override
    public boolean equals(Object obj) {
        boolean prsEqual;
        boolean texeq;
        if (!(obj instanceof Material)) {
            return false;
        }
        Material m = (Material)obj;
        boolean bl = texeq = this.d_texinfo == null && m.d_texinfo == null || this.d_texinfo != null && this.d_texinfo.equals(m.d_texinfo);
        if (!(this.d_name.equals(m.d_name) && this.d_color.equals(m.d_color) && texeq && this.d_table.equals(m.d_table))) {
            return false;
        }
        PartRecord prThis = this.getPartRecord();
        PartRecord prOther = m.getPartRecord();
        boolean bl2 = prThis == null ? prOther == null : (prsEqual = prThis.equals(prOther));
        return prsEqual;
    }

    public void clearProps() {
        this.d_table.clear();
    }

    private PartRecord getPartRecord() {
        String partID = (String)this.getValue(PART_ID);
        if (partID != null) {
            return (PartRecord)PyroResourceFinder.find(PartRecord.class, partID, this.getDomains());
        }
        return null;
    }

    public Color getColor() {
        return this.d_color;
    }

    @Deprecated
    public String getTextureName() {
        return this.d_texname;
    }

    public TextureInfo getTextureInfo() {
        return this.d_texinfo;
    }

    @Override
    public String getFDSType() {
        return "SURF";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> recs) {
        if (Material.isPredefinedMaterial(this.getName()) && !this.equals(s_adiabatic)) {
            return;
        }
        FDSInputRecord rec = new FDSInputRecord();
        rec.setType("SURF");
        rec.setValue(NAME, this.getName());
        Vector<Double> rgb = new Vector<Double>(3);
        float[] colors = this.getColor().getRGBColorComponents(null);
        rgb.add(Double.valueOf(colors[0]));
        rgb.add(Double.valueOf(colors[1]));
        rgb.add(Double.valueOf(colors[2]));
        rec.setValue(COLOR, rgb);
        if (this.d_texinfo != null) {
            double ht;
            rec.setValue(TEXTURE_MAP, this.d_texinfo.getTexID());
            double wid = this.d_texinfo.getWidth().getValue(SI.METER);
            if (wid > 0.0) {
                rec.setValue(TEXTURE_WIDTH, wid);
            }
            if ((ht = this.d_texinfo.getHeight().getValue(SI.METER)) > 0.0) {
                rec.setValue(TEXTURE_HEIGHT, ht);
            }
        }
        for (String valueName : this.getUsedKeysC()) {
            Object curVal = this.getValue(valueName);
            if (curVal instanceof Ramp || curVal.equals(SOLID)) continue;
            ValueInfo<?, ?> vi = Material.getValueInfo(valueName);
            rec.setValue(valueName, vi.convertPyroValueToFDSValue(curVal));
        }
        recs.add(rec);
        for (String rampType : Material.getRampTypes()) {
            Ramp r = (Ramp)this.getValue(rampType);
            if (r == null) continue;
            r.setName(rampType + "_" + this.getName());
            rec.setValue(rampType, r.getName());
            r.getInputRecords(recs);
        }
    }

    private void changed() {
        this.fireDomainEvent(new MaterialDomainEvent(this, 5), false);
    }

    public Task taskSetName(String name) {
        return new AChangePyroDepOnIDTask(this, name, this.getDomains()){

            @Override
            public void setID(String newID) {
                Material.this.setName(newID);
            }
        };
    }

    public String getName() {
        return this.d_name;
    }

    protected void setName(String name) {
        this.d_name = name;
        this.changed();
    }

    public void setColor(Color col) {
        this.d_color = col;
        this.changed();
    }

    @Deprecated
    public void setTexture(String tex) {
        this.d_texname = tex;
        this.changed();
    }

    public void setTexture(TextureInfo texinfo) {
        this.d_texinfo = texinfo;
    }

    public Object getValue(String key) {
        return this.d_table.get(key);
    }

    public void setValue(String key, Object value) {
        this.setValue(key, value, false);
    }

    public void setValue(String key, Object value, boolean recalcProfilePath) {
        if (value == null) {
            this.d_table.remove(key);
        } else {
            this.d_table.put(key, value);
        }
        if (recalcProfilePath) {
            this.recalcProfilePath();
        }
        this.fireDomainEvent(new MaterialDomainEvent(this, 5), true);
    }

    public void recalcProfilePath() {
        MaterialProfile defaultProfile = MaterialProfile.getDefaultProfile();
        this.d_profilePath = defaultProfile.buildBestPathForMat(this);
        this.fireDomainEvent(new MaterialDomainEvent(this, 5), true);
    }

    public String[] getUsedKeys() {
        return this.d_table.keySet().toArray(new String[this.d_table.size()]);
    }

    public Set<String> getUsedKeysC() {
        return this.d_table.keySet();
    }

    public boolean isDefined(Object key) {
        return this.d_table.containsKey(key);
    }

    public void imprint(Material mat) {
        this.imprint(mat, true);
    }

    public void imprint(Material mat, boolean purify) {
        this.pauseUpdates(false);
        this.d_color = mat.d_color;
        this.d_texname = mat.d_texname;
        this.d_texinfo = mat.d_texinfo != null ? new TextureInfo(mat.d_texinfo) : null;
        for (String valueName : Material.getValueNames()) {
            if (mat.isDefined(valueName)) {
                this.d_table.put(valueName, mat.getValue(valueName));
                continue;
            }
            if (!purify) continue;
            this.d_table.remove(valueName);
        }
        try {
            for (String rampType : Material.getRampTypes()) {
                Ramp r = (Ramp)mat.getValue(rampType);
                if (r == null) continue;
                this.setValue(rampType, r.clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (purify) {
            this.d_profilePath = mat.d_profilePath;
        } else {
            this.recalcProfilePath();
        }
        this.resumeUpdates(new MaterialDomainEvent(this, 5), true);
    }

    public void setProfilePath(MaterialProfile.ProfilePath path) {
        this.d_profilePath = path;
        this.fireDomainEvent(new MaterialDomainEvent(this, 5), true);
    }

    public MaterialProfile.ProfilePath getProfilePath() {
        return this.d_profilePath;
    }

    public boolean fireDomainEvent(IDomainEvent event, boolean updateDependents) {
        this.pauseUpdates();
        boolean fired = super.fireDomainEvent(event);
        if (updateDependents) {
            new AChangePyroDepOnTask(this, this.getDomains()).run();
        }
        this.resumeUpdates();
        return fired;
    }

    public void resumeUpdates(IDomainEvent event, boolean updateDependents) {
        super.resumeUpdates(event);
        if (updateDependents) {
            new AChangePyroDepOnTask(this, this.getDomains()).run();
        }
    }

    @Override
    public String getTypeDescription() {
        return "Surface";
    }

    @Override
    public String getUniqueID() {
        return this.getName();
    }

    @Override
    public Object getUniqueTypeKey() {
        return this.getFDSType();
    }

    @Override
    public void getObjectsDependedOn(Set<IDependedOn> dependencies, Class<IDependedOn> type) {
        PartRecord particle;
        String partName;
        if (type.isAssignableFrom(PartRecord.class) && (partName = (String)this.getValue(PART_ID)) != null && (particle = (PartRecord)PyroResourceFinder.find(type, partName, this.getDomains())) != null) {
            dependencies.add(particle);
        }
    }

    @Override
    public boolean dependsOnObject(IDependedOn depOn) {
        if (depOn instanceof PartRecord) {
            PartRecord part = (PartRecord)depOn;
            String partName = (String)this.getValue(PART_ID);
            if (partName != null && part.getID().equals(partName)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Task taskUpdateAfterDependedOnReplaced(IDependedOn old, IDependedOn replacement) {
        assert (replacement == null || replacement instanceof PartRecord);
        PartRecord deletedPart = (PartRecord)old;
        PartRecord replPart = (PartRecord)replacement;
        assert (deletedPart == null ? this.getValue(PART_ID) == null : deletedPart.getID().equals(this.getValue(PART_ID)));
        return new SetValueTask(this, PART_ID, replPart != null ? replPart.getID() : null);
    }

    @Override
    public Task taskUpdateBeforeDependedOnRenamed(IDependedOn dep, String newID) {
        assert (dep instanceof PartRecord);
        PartRecord part = (PartRecord)dep;
        assert (part == null ? this.getValue(PART_ID) == null : part.getID().equals(this.getValue(PART_ID)));
        return new SetValueTask(this, PART_ID, newID);
    }

    @Override
    public Task taskUpdateAfterDependedOnChanged(IDependedOn dep, Object info) {
        return null;
    }

    public static Collection<? extends Warning> validateMaterial(Material mat) {
        ArrayList<Warning> warnings = new ArrayList<Warning>();
        Material mat2 = new Material(mat.getName(), mat.getColor());
        HashSet<String> valueNamesSet = new HashSet<String>();
        mat.getProfilePath().initMat(mat2, valueNamesSet);
        HashSet<String> matKeys = new HashSet<String>(mat.getUsedKeysC());
        matKeys.removeAll(valueNamesSet);
        for (String field : matKeys) {
            Map<String, MaterialProfile.ProfilePath> listPaths = mat.getProfilePath().getListPaths();
            String matType = listPaths.values().iterator().next().getProfileName();
            warnings.add(new Warning("The surface, " + mat.getName() + ", appears to be a type of " + matType + ", but it contains the field, " + field + ".  This field is not known to be valid for a " + matType + ".", "Removed field, " + field + ", from the surface, " + mat.getName() + "."));
        }
        for (String usedKey : mat.getUsedKeys()) {
            if (valueNamesSet.contains(usedKey)) continue;
            mat.setValue(usedKey, null);
        }
        return warnings;
    }

    static {
        s_adiabatic.setValue("ADIABATIC", Boolean.TRUE);
        s_valueInfo = new TreeMap();
        s_valueInfo.put("ADIABATIC", new BValueInfo(false, true));
        s_valueInfo.put(A, new UDValueInfo(8, 650000.0, false, Material.dur()));
        s_valueInfo.put(ALPHA, new UDValueInfo(27, 0.0, false, Material.dur()));
        s_valueInfo.put(BACKING, new SValueInfo(null, true));
        s_valueInfo.put(BURN_AWAY, new BValueInfo(false, true));
        s_valueInfo.put(BURNING_RATE_MAX, new UDValueInfo(20, 0.1, true, Material.dur()));
        s_valueInfo.put(C_DELTA_RHO, new UDValueInfo(0, 31.499999999999996, true, Material.dur()));
        s_valueInfo.put(CHAR_DENSITY, new UDValueInfo(4, 120.0, true, Material.dur()));
        s_valueInfo.put(C_P, new UDValueInfo(11, 0.7, false, Material.dur()));
        s_valueInfo.put(C_P_CHAR, new UDValueInfo(11, 0.7, false, Material.dur()));
        s_valueInfo.put(DELTA, new UDValueInfo(0, 0.1, false, Material.dur()));
        s_valueInfo.put(DENSITY, new UDValueInfo(4, 450.0, false, Material.dur()));
        s_valueInfo.put(DX_SOLID, new UDValueInfo(0, 1.0E-4, false, Material.dur()));
        s_valueInfo.put(E, new UDValueInfo(15, 0.0, false, Material.dur()));
        s_valueInfo.put(E_COEFFICIENT, new UDValueInfo(21, 0.0, true, Material.dur()));
        s_valueInfo.put(EMISSIVITY, new DValueInfo(0.9, true, Material.dur()));
        s_valueInfo.put(FUEL_FRACTION, new DValueInfo(1.0, true, Material.dur()));
        s_valueInfo.put(HEAT_FLUX, new UDValueInfo(22, 0.0, true, Material.dur()));
        s_valueInfo.put(HEAT_OF_COMBUSTION, new UDValueInfo(10, 0.0, false, Material.dur()));
        s_valueInfo.put(HEAT_OF_VAPORIZATION, new UDValueInfo(10, 0.0, true, Material.dur()));
        s_valueInfo.put(HRRPUA, new UDValueInfo(22, 0.0, true, Material.dur()));
        s_valueInfo.put(KS, new UDValueInfo(19, 0.0, false, Material.dur()));
        s_valueInfo.put(KS_CHAR, new UDValueInfo(19, 0.1, false, Material.dur()));
        s_valueInfo.put(LEAKING, new BValueInfo(false, true));
        s_valueInfo.put(MASS_FLUX_CRITICAL, new DValueInfo(0.02, false, Material.dur()));
        s_valueInfo.put(MOISTURE_FRACTION, new DValueInfo(0.0, true, Material.dur()));
        s_valueInfo.put(NPPC, new IValueInfo(1, true, Material.iur()));
        s_valueInfo.put(PARTICLES, new BValueInfo(false, true));
        s_valueInfo.put(PART_ID, new SValueInfo(null, true));
        s_valueInfo.put(PHASE, new SValueInfo(SOLID, true));
        s_valueInfo.put(POROSITY, new DValueInfo(0.0, true, Material.dur()));
        s_valueInfo.put(PLE, new DValueInfo(0.3, true, Material.dur()));
        s_valueInfo.put(PROFILE, new SValueInfo(TOPHAT_PROFILE, true));
        s_valueInfo.put(RAMP_C_P, new RampInfo(null, false, RAMP_C_P, 1, 11, "Temperature", "Specific Heat"));
        s_valueInfo.put(RAMP_C_P_CHAR, new RampInfo(null, false, RAMP_C_P_CHAR, 1, 11, "Temperature", "Specific Heat"));
        s_valueInfo.put(RAMP_KS, new RampInfo(null, false, RAMP_KS, 1, 19, "Temperature", "Conductivity"));
        s_valueInfo.put(RAMP_KS_CHAR, new RampInfo(null, false, RAMP_KS_CHAR, 1, 19, "Temperature", "Conductivity"));
        s_valueInfo.put(RAMP_Q, new RampInfo(null, false, RAMP_Q, 2, 28, "Time", "Fraction"));
        s_valueInfo.put(RAMP_V, new RampInfo(null, false, RAMP_V, 2, 28, "Time", "Velocity Fraction"));
        s_valueInfo.put(SURFACE_DENSITY, new UDValueInfo(23, 45.0, false, Material.dur()));
        s_valueInfo.put(TAU_Q, new UDValueInfo(2, 1.0, false, Material.dur()));
        s_valueInfo.put(TAU_V, new UDValueInfo(2, 1.0, false, Material.dur()));
        s_valueInfo.put(TMPIGN, new UDValueInfo(1, 5000.0, false, Material.dur()));
        s_valueInfo.put(TMPWAL, new UDValueInfo(1, 20.0, true, Material.dur()));
        s_valueInfo.put(TMPWAL0, new UDValueInfo(1, 20.0, false, Material.dur()));
        s_valueInfo.put(VBC, new DValueInfo(0.5, false, Material.dur()));
        s_valueInfo.put(VEL, new UDValueInfo(8, 0.0, true, Material.dur()));
        s_valueInfo.put(VEL_T, new VValueInfo<UnitDouble, Double>(2, false, new UDValueInfo(8, 0.0, false, Material.dur())));
        s_valueInfo.put(VOLUME_FLUX, new UDValueInfo(24, 0.0, false, Material.dur()));
        s_valueInfo.put(WALL_POINTS, new IValueInfo(20, true, Material.iur()));
        s_valueInfo.put(Z0, new UDValueInfo(0, 10.0, true, Material.dur()));
        s_inert.recalcProfilePath();
        s_open.recalcProfilePath();
        s_mirror.recalcProfilePath();
        s_adiabatic.recalcProfilePath();
        d_predefinedMaterials.put(s_inert.getName(), s_inert);
        d_predefinedMaterials.put(s_open.getName(), s_open);
        d_predefinedMaterials.put(s_mirror.getName(), s_mirror);
        d_predefinedMaterials.put(s_adiabatic.getName(), s_adiabatic);
        s_rampInfo = new Hashtable(6);
        s_rampInfo.put(RAMP_C_P, (RampInfo)RampInfo.class.cast(s_valueInfo.get(RAMP_C_P)));
        s_rampInfo.put(RAMP_C_P_CHAR, (RampInfo)RampInfo.class.cast(s_valueInfo.get(RAMP_C_P_CHAR)));
        s_rampInfo.put(RAMP_KS, (RampInfo)RampInfo.class.cast(s_valueInfo.get(RAMP_KS)));
        s_rampInfo.put(RAMP_KS_CHAR, (RampInfo)RampInfo.class.cast(s_valueInfo.get(RAMP_KS_CHAR)));
        s_rampInfo.put(RAMP_Q, (RampInfo)RampInfo.class.cast(s_valueInfo.get(RAMP_Q)));
        s_rampInfo.put(RAMP_V, (RampInfo)RampInfo.class.cast(s_valueInfo.get(RAMP_V)));
    }

    private static class SetValueTask
    implements Task {
        private final Material d_owner;
        private final String d_key;
        private Object d_old;
        private final Object d_replacement;

        public SetValueTask(Material owner, String key, Object repl) {
            this.d_owner = owner;
            this.d_key = key;
            this.d_replacement = repl;
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public int getEst() {
            return 0;
        }

        @Override
        public void undo() {
            this.d_owner.setValue(this.d_key, this.d_old, true);
        }

        @Override
        public void run() {
            this.d_old = this.d_owner.getValue(this.d_key);
            this.d_owner.setValue(this.d_key, this.d_replacement, true);
        }
    }

    public static class RampInfo
    extends ValueInfo<Ramp, String> {
        public final String d_rampType;
        public final int d_tUnit;
        public final int d_fUnit;
        public final String d_tDesc;
        public final String d_fDesc;

        public RampInfo(Ramp defaultVal, boolean defaultSet, String rampType, int t, int f, String tDesc, String fDesc) {
            super(Ramp.class, defaultVal, defaultSet, null, String.class);
            this.d_tUnit = t;
            this.d_fUnit = f;
            this.d_tDesc = tDesc;
            this.d_fDesc = fDesc;
            this.d_rampType = rampType;
        }

        @Override
        public Ramp convertFDSValueToPyroValue(String fdsVal) {
            assert (false);
            return null;
        }

        @Override
        public String convertPyroValueToFDSValue(Ramp pyroVal) {
            assert (false);
            return null;
        }
    }

    public static class SValueInfo
    extends ValueInfo<String, String> {
        public SValueInfo(String defaultValue, boolean defaultSet) {
            super(String.class, defaultValue, defaultSet, null, String.class);
        }
    }

    public static class BValueInfo
    extends ValueInfo<Boolean, Boolean> {
        public BValueInfo(boolean defaultValue, boolean defaultSet) {
            super(Boolean.class, defaultValue, defaultSet, null, Boolean.class);
        }
    }

    public static class DValueInfo
    extends ValueInfo<Double, Double> {
        public DValueInfo(double defaultValue, boolean defaultSet, ValueRange<Double> valueRange) {
            super(Double.class, defaultValue, defaultSet, valueRange, Double.class);
        }
    }

    public static class IValueInfo
    extends ValueInfo<Integer, Object> {
        public IValueInfo(int defaultValue, boolean defaultSet, IntValueRange valueRange) {
            super(Integer.class, defaultValue, defaultSet, valueRange, Object.class);
        }

        @Override
        public Integer convertFDSValueToPyroValue(Object fdsVal) {
            return ((Double)fdsVal).intValue();
        }

        @Override
        public Integer convertPyroValueToFDSValue(Integer pyroVal) {
            return pyroVal;
        }
    }

    public static class VValueInfo<T, T2>
    extends ValueInfo<Vector, Vector> {
        private final ValueInfo<T, T2> d_memberInfo;
        private final int d_size;

        public VValueInfo(int size, boolean defaultSet, ValueInfo<T, T2> memberInfo) {
            super(Vector.class, memberInfo.d_unitType, null, defaultSet, null, Vector.class);
            this.d_memberInfo = memberInfo;
            this.d_size = size;
        }

        @Override
        public Vector<T> convertFDSValueToPyroValue(Vector fdsVal) {
            Vector<T> pyroVal = new Vector<T>(fdsVal.size());
            for (Object o : fdsVal) {
                Object fdsValC = this.d_memberInfo.d_fdsParsingDataType.cast(o);
                T memberPyroVal = this.d_memberInfo.convertFDSValueToPyroValue(fdsValC);
                pyroVal.add(memberPyroVal);
            }
            return pyroVal;
        }

        @Override
        public Vector<T2> convertPyroValueToFDSValue(Vector pyroVal) {
            Vector<T2> fdsVal = new Vector<T2>(pyroVal.size());
            for (Object o : pyroVal) {
                Object pyroMemberVal = this.d_memberInfo.d_type.cast(o);
                T2 fdsMemberVal = this.d_memberInfo.convertPyroValueToFDSValue(pyroMemberVal);
                fdsVal.add(fdsMemberVal);
            }
            return fdsVal;
        }

        @Override
        public Object getDefaultValue(UnitSystem us) {
            Vector<Object> returnVal = new Vector<Object>(this.d_size);
            for (int m = 0; m < this.d_size; ++m) {
                returnVal.add(this.d_memberInfo.getDefaultValue(us));
            }
            return returnVal;
        }
    }

    public static class UDValueInfo
    extends ValueInfo<UnitDouble, Double> {
        private static UnitSystem d_si = FdsSISystem.getInstance();

        public UDValueInfo(int unitType, double siDefaultValue, boolean defaultSet, DoubleValueRange siValueRange) {
            super(UnitDouble.class, unitType, new UnitDouble(siDefaultValue, d_si.getUnit(unitType)), defaultSet, UnitDoubleValueRange.createCheckedRange(siValueRange, d_si.getUnit(unitType)), Double.class);
        }

        @Override
        public UnitDouble convertFDSValueToPyroValue(Double fdsVal) {
            return new UnitDouble(fdsVal, FdsSISystem.getInstance().getUnit(this.d_unitType));
        }

        @Override
        public Double convertPyroValueToFDSValue(UnitDouble pyroVal) {
            return pyroVal.getValue(d_si.getUnit(this.d_unitType));
        }

        @Override
        public Object getDefaultValue(UnitSystem us) {
            return ((UnitDouble)super.getDefaultValue(us)).getValue(us.getUnit(this.d_unitType));
        }
    }

    public static class ValueInfo<T, T2> {
        public final int d_unitType;
        private final T d_defaultValue;
        public final boolean d_defaultSet;
        public final ValueRange<T> d_valueRange;
        public final Class<T2> d_fdsParsingDataType;
        public final Class<T> d_type;

        public ValueInfo(Class<T> type, int unitType, T defaultValue, boolean defaultSet, ValueRange<T> valueRange, Class<T2> fdsParsingDT) {
            this.d_unitType = unitType;
            this.d_defaultValue = defaultValue;
            this.d_valueRange = valueRange;
            this.d_fdsParsingDataType = fdsParsingDT;
            this.d_type = type;
            this.d_defaultSet = defaultSet;
        }

        public ValueInfo(Class<T> type, T defaultValue, boolean defaultSet, ValueRange<T> valueRange, Class<T2> fdsParsingDT) {
            this(type, 28, defaultValue, defaultSet, valueRange, fdsParsingDT);
        }

        public T convertFDSValueToPyroValue(T2 fdsVal) {
            return this.d_type.cast(fdsVal);
        }

        public T2 convertPyroValueToFDSValue(T pyroVal) {
            return this.d_fdsParsingDataType.cast(pyroVal);
        }

        public Object getDefaultValue(UnitSystem us) {
            return this.d_defaultValue;
        }
    }
}

