/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.IsofList;
import pyrosim.legacy_2006_2.domain.IsofRecord;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class IsosurfTask
implements Task {
    private final PyroMod d_mediator;
    private final boolean d_density;
    private final boolean d_temp;
    private final boolean d_hrrpuv;
    private final boolean d_mixFrac;
    private final boolean d_specFWI;
    private final Vector d_densityVals;
    private final Vector d_tempVals;
    private final Vector d_hrrpuvVals;
    private final Vector d_fracVals;
    private final double d_fileWriteInterval;
    private final Unit d_timeUnit;
    private final String d_quantity1;
    private final String d_quantity2;
    private final String d_quantity3;
    private final String d_quantity4;

    public IsosurfTask(PyroMod mediator, boolean density, boolean temp, boolean hrrpuv, boolean mixFrac, boolean specFWI, Vector densityVals, Vector tempVals, Vector hrrpuvVals, Vector fracVals, double fileWriteInterval, Unit timeUnit, String quantity1, String quantity2, String quantity3, String quantity4) {
        this.d_mediator = mediator;
        this.d_density = density;
        this.d_temp = temp;
        this.d_hrrpuv = hrrpuv;
        this.d_mixFrac = mixFrac;
        this.d_specFWI = specFWI;
        this.d_densityVals = densityVals;
        this.d_tempVals = tempVals;
        this.d_hrrpuvVals = hrrpuvVals;
        this.d_fracVals = fracVals;
        this.d_fileWriteInterval = fileWriteInterval;
        this.d_timeUnit = timeUnit;
        this.d_quantity1 = quantity1;
        this.d_quantity2 = quantity2;
        this.d_quantity3 = quantity3;
        this.d_quantity4 = quantity4;
    }

    @Override
    public boolean canUndo() {
        return false;
    }

    @Override
    public void undo() {
    }

    @Override
    public int getEst() {
        return 0;
    }

    @Override
    public void run() {
        IsofRecord rec;
        String quantity;
        this.d_mediator.pauseUpdates();
        UnitDouble dtsam = null;
        IsofList il = this.d_mediator.getIsofList();
        il.taskClear().run();
        if (this.d_specFWI) {
            dtsam = new UnitDouble(this.d_fileWriteInterval, this.d_timeUnit);
        }
        if (this.d_density) {
            quantity = this.d_quantity1;
            rec = new IsofRecord(this.d_densityVals, quantity, dtsam);
            il.taskAdd(rec).run();
        }
        if (this.d_temp) {
            quantity = this.d_quantity2;
            rec = new IsofRecord(this.d_tempVals, quantity, dtsam);
            il.taskAdd(rec).run();
        }
        if (this.d_hrrpuv) {
            quantity = this.d_quantity3;
            rec = new IsofRecord(this.d_hrrpuvVals, quantity, dtsam);
            il.taskAdd(rec).run();
        }
        if (this.d_mixFrac) {
            quantity = this.d_quantity4;
            rec = new IsofRecord(this.d_fracVals, quantity, dtsam);
            il.taskAdd(rec).run();
        }
        this.d_mediator.resumeUpdates();
    }
}

