/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.AAddTask;
import pyrosim.legacy_2006_2.domain.ARemoveTask;
import pyrosim.legacy_2006_2.domain.AbstractActivationEventList;
import pyrosim.legacy_2006_2.domain.ActivationEvent;
import pyrosim.legacy_2006_2.domain.ActivationEventList;
import pyrosim.legacy_2006_2.domain.HeatActivationEvent;
import pyrosim.legacy_2006_2.domain.HeatDetector;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public class HeatActivationEventList
extends AbstractActivationEventList
implements ActivationEventList {
    static final long serialVersionUID = 1L;
    private LinkedList<ActivationEvent> d_lEvents = new LinkedList();
    private boolean d_bCanBeActivatedByAny = false;
    private boolean d_bCanBeDeactivatedByAny = false;

    public HeatActivationEventList(Set<PyroMod> domains) {
        super(1, domains);
    }

    private boolean addEvent(ActivationEvent evt) {
        if (this.d_lEvents.contains(evt)) {
            return false;
        }
        ADomainObject.addDomains(evt, this.getDomains());
        return this.d_lEvents.add(evt);
    }

    private boolean removeEvent(ActivationEvent evt) {
        ADomainObject.removeDomains(evt, this.getDomains());
        return this.d_lEvents.remove(evt);
    }

    public Collection getAllEvents() {
        return this.d_lEvents;
    }

    @Override
    public int size() {
        return this.d_lEvents.size();
    }

    @Override
    public Collection getInputRecords(FDSInputRecord baseRecord, Map recordMap) {
        Vector<FDSInputRecord> returnRecords = new Vector<FDSInputRecord>();
        FDSInputRecord record = baseRecord.getValue("T_OPEN") != null || baseRecord.getValue("T_CLOSE") != null || baseRecord.getValue("T_ACTIVATE") != null || baseRecord.getValue("T_DEACTIVATE") != null || baseRecord.getValue("HEAT_ACTIVATE") != null || baseRecord.getValue("HEAT_DEACTIVATE") != null || baseRecord.getValue("T_CREATE") != null || baseRecord.getValue("T_REMOVE") != null || baseRecord.getValue("HEAT_CREATE") != null || baseRecord.getValue("HEAT_REMOVE") != null ? (FDSInputRecord)baseRecord.clone() : baseRecord;
        for (int m = 0; m < this.d_lEvents.size(); ++m) {
            record.removeValue("T_OPEN");
            record.removeValue("T_CLOSE");
            record.removeValue("T_ACTIVATE");
            record.removeValue("T_DEACTIVATE");
            record.removeValue("HEAT_ACTIVATE");
            record.removeValue("HEAT_DEACTIVATE");
            record.removeValue("T_CREATE");
            record.removeValue("T_REMOVE");
            record.removeValue("HEAT_CREATE");
            record.removeValue("HEAT_REMOVE");
            boolean recordChanged = false;
            HeatActivationEvent evt = (HeatActivationEvent)this.d_lEvents.get(m);
            String action = (String)recordMap.get(evt.getAction());
            if (evt.getAction() == 0) {
                if (!this.d_bCanBeActivatedByAny) {
                    record.setValue(action, ((HeatDetector)evt.getCriteria()).getLabel());
                    recordChanged = true;
                }
            } else if (!this.d_bCanBeDeactivatedByAny) {
                record.setValue(action, ((HeatDetector)evt.getCriteria()).getLabel());
                recordChanged = true;
            }
            if (!recordChanged) continue;
            returnRecords.add(record);
            record = (FDSInputRecord)record.clone();
        }
        return returnRecords;
    }

    @Override
    public Object clone() {
        HeatActivationEventList returnList = (HeatActivationEventList)super.clone();
        returnList.d_lEvents = new LinkedList();
        Collection c = this.getAllEvents();
        for (ActivationEvent evt : c) {
            returnList.addEvent((ActivationEvent)evt.clone());
        }
        return returnList;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof HeatActivationEventList)) {
            return false;
        }
        HeatActivationEventList l = (HeatActivationEventList)obj;
        if (l.d_lEvents.size() != this.d_lEvents.size()) {
            return false;
        }
        for (int m = 0; m < this.d_lEvents.size(); ++m) {
            if (this.d_lEvents.get(m).equals(l.d_lEvents.get(m))) continue;
            return false;
        }
        return true;
    }

    public void setCanBeTriggeredByAny(boolean canBeTriggeredByAny, int action) {
        if (action == 0) {
            this.d_bCanBeActivatedByAny = canBeTriggeredByAny;
        } else {
            this.d_bCanBeDeactivatedByAny = canBeTriggeredByAny;
        }
    }

    public boolean getCanBeTriggeredByAny(int action) {
        if (action == 0) {
            return this.d_bCanBeActivatedByAny;
        }
        return this.d_bCanBeDeactivatedByAny;
    }

    @Override
    public Task taskRemoveEvent(ActivationEvent evt) {
        return new ARemoveTask<HeatActivationEvent>(this.getDomains(), new VectorFromArray<HeatActivationEvent>((HeatActivationEvent)evt)){

            @Override
            protected boolean remove(HeatActivationEvent obj) {
                return HeatActivationEventList.this.removeEvent(obj);
            }

            @Override
            protected boolean add(HeatActivationEvent obj) {
                return HeatActivationEventList.this.addEvent(obj);
            }
        };
    }

    @Override
    public Task taskAddEvent(ActivationEvent evt) {
        return new AAddTask<HeatActivationEvent>(this.getDomains(), new VectorFromArray<HeatActivationEvent>((HeatActivationEvent)evt)){

            @Override
            protected boolean remove(HeatActivationEvent obj) {
                return HeatActivationEventList.this.removeEvent(obj);
            }

            @Override
            protected boolean add(HeatActivationEvent obj) {
                return HeatActivationEventList.this.addEvent(obj);
            }
        };
    }

    public String getTypeDescription() {
        return null;
    }
}

