/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;

public class HeadRecord
extends ADomainObject<PyroMod>
implements Serializable,
IFDSRenderable,
IPyroObject {
    static final long serialVersionUID = 1L;
    String d_chid = null;
    String d_title = null;
    public static final int MAX_CHID_LENGTH = 30;
    public static final int MAX_TITLE_LENGTH = 60;

    public HeadRecord() {
    }

    public HeadRecord(String chid, String title) {
        this.setTitle(title);
        this.setCHID(chid);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof HeadRecord)) {
            return false;
        }
        HeadRecord h = (HeadRecord)o;
        boolean equal = (this.d_chid == null ? h.d_chid == null : this.d_chid.equals(h.d_chid)) && (this.d_title == null ? h.d_title == null : this.d_title.equals(h.d_title));
        return equal;
    }

    @Override
    public Object clone() {
        return new HeadRecord(this.d_chid, this.d_title);
    }

    public void setTitle(String title) {
        this.d_title = HeadRecord.getProperTitle(title);
        this.fireDomainEvent(new PyroDomainEvent(this, HeadRecord.class, 5));
    }

    public void setCHID(String chid) {
        this.d_chid = HeadRecord.getProperCHID(chid);
        this.fireDomainEvent(new PyroDomainEvent(this, HeadRecord.class, 5));
    }

    public String getTitle() {
        return this.d_title;
    }

    public String getCHID() {
        return this.d_chid;
    }

    @Override
    public String getFDSType() {
        return "HEAD";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> recs) {
        FDSInputRecord rec = new FDSInputRecord();
        rec.setType("HEAD");
        if (this.d_chid != null) {
            rec.setValue("CHID", this.d_chid);
        }
        if (this.d_title != null) {
            rec.setValue("TITLE", this.d_title);
        }
        if (!rec.empty()) {
            recs.add(rec);
        }
    }

    public static String getProperCHID(String requestedCHID) {
        if (requestedCHID == null) {
            return null;
        }
        String newCHID = requestedCHID.trim();
        File temp = new File(newCHID);
        int extIndex = (newCHID = temp.getName()).lastIndexOf(46);
        if (extIndex >= 0) {
            newCHID = newCHID.substring(0, extIndex);
        }
        newCHID = newCHID.replace('.', '_');
        if ((newCHID = newCHID.replace(' ', '_')).length() > 30) {
            newCHID = newCHID.substring(0, 30);
        }
        return newCHID;
    }

    public static String getProperTitle(String requestedTitle) {
        if (requestedTitle == null) {
            return null;
        }
        String newTitle = requestedTitle.trim();
        if (newTitle.length() > 60) {
            newTitle = newTitle.substring(0, 60);
        }
        return newTitle;
    }

    @Override
    public String getTypeDescription() {
        return "Head Record";
    }
}

