/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.Collection;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class FilterObstructionsTask
implements Task {
    private final PyroMod d_mediator;
    private final Collection<FDSObject> d_selObjs;
    private boolean[] d_oldVisible;
    private final FDSObject[] d_allObjs;

    public FilterObstructionsTask(PyroMod med, FDSObject[] sel) {
        this.d_mediator = med;
        this.d_selObjs = FDSComposite.toCollection(sel);
        this.d_allObjs = this.d_mediator.getFDSObjectManager().toArray();
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        this.d_mediator.pauseUpdates();
        int count = 0;
        for (FDSObject o : this.d_allObjs) {
            o.setVisible(this.d_oldVisible[count++]);
        }
        this.d_oldVisible = null;
        this.d_mediator.resumeUpdates();
    }

    @Override
    public int getEst() {
        return 0;
    }

    @Override
    public void run() {
        this.d_oldVisible = new boolean[this.d_allObjs.length];
        this.d_mediator.pauseUpdates();
        int count = 0;
        for (FDSObject o : this.d_allObjs) {
            this.d_oldVisible[count++] = o.isVisible();
            o.setVisible(false);
        }
        for (FDSObject selObjs : this.d_selObjs) {
            selObjs.setVisible(true);
        }
        this.d_mediator.resumeUpdates();
    }
}

