/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.Collection;
import java.util.Iterator;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.FDSObjectIterator;

public class FDSObjectTypeIterator<T extends FDSObject>
implements Iterator<T> {
    private final FDSObjectIterator d_it;

    public FDSObjectTypeIterator(FDSComposite src, boolean deep, Class<T> filterType) {
        this.d_it = new FDSObjectIterator(src, deep);
        this.initFilter(filterType);
    }

    public FDSObjectTypeIterator(FDSObject[] src, boolean deep, Class<T> filterType) {
        this.d_it = new FDSObjectIterator(src, deep);
        this.initFilter(filterType);
    }

    public FDSObjectTypeIterator(Collection<? extends FDSObject> src, boolean deep, Class<T> filterType) {
        this.d_it = new FDSObjectIterator(src, deep);
        this.initFilter(filterType);
    }

    private void initFilter(Class<T> filterType) {
        if (filterType.equals(FDSObject.class)) {
            this.d_it.setFilter(new FDSObjectTypeFilter<T>(this.d_it, filterType));
        } else {
            this.d_it.setFilter(new TypeFilter<T>(this.d_it, filterType));
        }
    }

    @Override
    public boolean hasNext() {
        return this.d_it.hasNext();
    }

    @Override
    public T next() {
        TypeFilter filter = (TypeFilter)this.d_it.getFilter();
        return (T)((FDSObject)filter.d_type.cast(this.d_it.next()));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static class FDSObjectTypeFilter<TT extends FDSObject>
    extends TypeFilter<TT> {
        private final FDSObjectIterator.DefaultObjectFilter d_defObjFilter;

        public FDSObjectTypeFilter(FDSObjectIterator it, Class<TT> type) {
            super(it, type);
            this.d_defObjFilter = new FDSObjectIterator.DefaultObjectFilter(it);
        }

        @Override
        public FDSObject prefetchNext() {
            return this.d_defObjFilter.prefetchNext();
        }

        @Override
        public Object filterObject(FDSObject arg0) {
            return this.d_defObjFilter.filterObject(arg0);
        }
    }

    private static class TypeFilter<TT extends FDSObject>
    extends FDSObjectIterator.AbstractObjectFilter {
        private Class<TT> d_type;

        public TypeFilter(FDSObjectIterator it, Class<TT> type) {
            super(it);
            this.d_type = type;
        }

        @Override
        public Object filterObject(FDSObject obj) {
            if (this.d_type.isInstance(obj)) {
                return obj;
            }
            return FDSObjectIterator.OBJECT_FILTERED;
        }
    }
}

