/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Icon;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;
import org.jscience.physics.units.SI;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.PyroSimObjectInputStream;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AImprintTask;
import pyrosim.legacy_2006_2.domain.ASetNameTask;
import pyrosim.legacy_2006_2.domain.AbstractActivationEventList;
import pyrosim.legacy_2006_2.domain.Activatable;
import pyrosim.legacy_2006_2.domain.ActivationEvent;
import pyrosim.legacy_2006_2.domain.ActivationEventList;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.FireEventTask;
import pyrosim.legacy_2006_2.domain.HeatActivationEvent;
import pyrosim.legacy_2006_2.domain.HeatActivationEventList;
import pyrosim.legacy_2006_2.domain.HeatDetector;
import pyrosim.legacy_2006_2.domain.IFace;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.dependencies.IDependedOn;
import pyrosim.legacy_2006_2.domain.dependencies.IDependent;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.geom.Quad;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.Point3D;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.ATask;
import pyrosim.legacy_2006_2.thunderheadeng.util.CompositeTask;
import pyrosim.legacy_2006_2.thunderheadeng.util.KeyableObject;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public abstract class AbstractFDSObject
extends KeyableObject
implements FDSObject,
Activatable,
Serializable,
Cloneable,
IDependent {
    static final long serialVersionUID = 1L;
    private String d_name;
    protected Vector<IFace> d_faces;
    private Color d_color = null;
    private boolean d_visible = true;
    private transient boolean d_selected;
    private transient ADomainObject<PyroMod> d_domainHelper = new ADomainObject();
    private Vector<ActivationEventList> d_vAllEvents = new Vector(0);
    private boolean d_bCanBeActivatedByAnyHeatDetector = false;
    private boolean d_bCanBeDeactivatedByAnyHeatDetector = false;
    private FDSComposite d_parent = null;

    public AbstractFDSObject() {
        this(null);
    }

    public AbstractFDSObject(String name) {
        this(name, null);
    }

    public AbstractFDSObject(String name, Color c) {
        this.d_name = name;
        this.d_selected = false;
        this.d_visible = true;
        this.d_color = c;
    }

    public Collection<FDSInputRecord> getInputRecords() {
        ArrayList<FDSInputRecord> recs = new ArrayList<FDSInputRecord>(1);
        this.getInputRecords(recs);
        return recs;
    }

    public static void fromLegacy(AbstractFDSObject oldObj, AbstractFDSObject newObj) {
        ActivationEvent[] allEvents;
        newObj.taskSetName(oldObj.getName()).run();
        newObj.setColor(oldObj.getColor());
        newObj.setVisible(oldObj.isVisible());
        for (int m = 0; m < newObj.getNumFaces(); ++m) {
            newObj.setMaterial(m, oldObj.getMaterial(m));
        }
        for (ActivationEvent evt : allEvents = oldObj.getAllEvents()) {
            newObj.addEvent(evt);
        }
        newObj.setCanBeTriggeredByAnyHeatDetector(oldObj.getCanBeTriggeredByAnyHeatDetector(0), 0);
        newObj.setCanBeTriggeredByAnyHeatDetector(oldObj.getCanBeTriggeredByAnyHeatDetector(1), 1);
    }

    @Override
    public Object clone() {
        AbstractFDSObject clone = (AbstractFDSObject)super.clone();
        clone.d_domainHelper = new ADomainObject();
        clone.d_selected = false;
        clone.imprint(this);
        return clone;
    }

    protected void imprint(Object baseObject) {
        if (!(baseObject instanceof AbstractFDSObject)) {
            return;
        }
        this.d_domainHelper.pauseUpdates(false);
        AbstractFDSObject obj = (AbstractFDSObject)baseObject;
        this.d_faces = new Vector(obj.d_faces.size());
        for (int i = 0; i < obj.d_faces.size(); ++i) {
            this.d_faces.add((IFace)obj.d_faces.get(i).clone());
        }
        this.d_color = obj.d_color;
        this.d_name = obj.d_name;
        this.d_vAllEvents = new Vector(obj.d_vAllEvents.size());
        for (ActivationEventList o : obj.d_vAllEvents) {
            this.d_vAllEvents.add((ActivationEventList)o.clone());
        }
        this.d_bCanBeActivatedByAnyHeatDetector = obj.d_bCanBeActivatedByAnyHeatDetector;
        this.d_bCanBeDeactivatedByAnyHeatDetector = obj.d_bCanBeDeactivatedByAnyHeatDetector;
        this.d_domainHelper.resumeUpdates(new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public Task taskImprint(Object baseObject) {
        if (!(baseObject instanceof AbstractFDSObject)) {
            return null;
        }
        return new AImprintTask<AbstractFDSObject>(this, (AbstractFDSObject)baseObject, AbstractFDSObject.class){

            @Override
            protected void imprint(AbstractFDSObject objToImprint, AbstractFDSObject baseObject) {
                objToImprint.imprint(baseObject);
            }
        };
    }

    @Override
    public boolean equals(Object obj) {
        boolean colorEqual;
        Vector allEventsThat;
        if (!(obj instanceof AbstractFDSObject)) {
            return false;
        }
        AbstractFDSObject fdsObj = (AbstractFDSObject)obj;
        if (!this.d_faces.equals(fdsObj.d_faces)) {
            return false;
        }
        Vector allEventsThis = this.getEventsSeparatedByType();
        if (!allEventsThis.equals(allEventsThat = fdsObj.getEventsSeparatedByType()) || !this.d_name.equals(fdsObj.d_name)) {
            return false;
        }
        boolean bl = this.d_color == null ? fdsObj.getColor() == null : (colorEqual = this.d_color.equals(fdsObj.getColor()));
        return colorEqual;
    }

    @Override
    public FDSComposite getParent() {
        return this.d_parent;
    }

    @Override
    public void setParent(FDSComposite parent) {
        this.d_parent = parent;
    }

    @Override
    public IFace getFace(int index) {
        return this.d_faces.get(index);
    }

    @Override
    public String getPropertyHashString() {
        Object s = "";
        Geometry g = new Geometry();
        for (int m = 0; m < this.d_faces.size(); ++m) {
            IFace face = this.d_faces.get(m);
            g.clear();
            face.getGeometry(g);
            Collection<Quad> quads = g.getQuads();
            for (Quad q : quads) {
                s = (String)s + q.getPoint((int)0).x + "," + q.getPoint((int)0).y + "," + q.getPoint((int)0).z + ";";
                s = (String)s + q.getPoint((int)1).x + "," + q.getPoint((int)1).y + "," + q.getPoint((int)1).z + ";";
                s = (String)s + q.getPoint((int)2).x + "," + q.getPoint((int)2).y + "," + q.getPoint((int)2).z + ";";
                s = (String)s + q.getPoint((int)3).x + "," + q.getPoint((int)3).y + "," + q.getPoint((int)3).z + ";";
            }
            if (face.getMaterial() == null) continue;
            s = (String)s + face.getMaterial().getName() + ";";
        }
        if (this.d_color != null) {
            s = (String)s + this.d_color.getRed() + "," + this.d_color.getGreen() + "," + this.d_color.getBlue() + "," + this.d_color.getAlpha() + ";";
        }
        return s;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.d_domainHelper = new ADomainObject();
        if (stream instanceof PyroSimObjectInputStream) {
            PyroSimObjectInputStream str = (PyroSimObjectInputStream)stream;
            if (str.getVersion() < 15) {
                this.ensureKeyed();
                ObjectInputStream.GetField gf = stream.readFields();
                this.d_name = (String)gf.get("d_name", null);
                this.d_visible = gf.get("d_visible", true);
                this.d_faces = (Vector)gf.get("d_faces", null);
                this.d_color = (Color)gf.get("d_color", null);
                this.d_vAllEvents = (Vector)gf.get("d_vAllEvents", new Vector());
                this.d_bCanBeActivatedByAnyHeatDetector = gf.get("d_bCanBeActivatedByAnyHeatDetector", false);
                this.d_bCanBeDeactivatedByAnyHeatDetector = gf.get("d_bCanBeDeactivatedByAnyHeatDetector", false);
            } else {
                stream.defaultReadObject();
            }
        } else {
            stream.defaultReadObject();
        }
        this.d_vAllEvents.trimToSize();
    }

    protected static void scalePoint(Point2D point, Point3d base, Tuple3d scale) {
        Point3d tempPoint = new Point3d(point.getX(), point.getY(), 0.0);
        AbstractFDSObject.scalePoint(tempPoint, base, scale);
        point.setLocation(tempPoint.x, tempPoint.y);
    }

    protected static void scalePoint(Point3d point, Point3d base, Tuple3d scale) {
        point.sub(base);
        point.x *= scale.x;
        point.y *= scale.y;
        point.z *= scale.z;
        point.add(base);
    }

    protected static void scaleVector(Vector3d vec, Point3d base, Tuple3d scale) {
        vec.x *= scale.x;
        vec.y *= scale.y;
        vec.z *= scale.z;
    }

    protected static void rotatePoint(Point2D point, Point3d base, Matrix3d rotMat) {
        Point3d tempPoint = new Point3d(point.getX(), point.getY(), 0.0);
        AbstractFDSObject.rotatePoint(tempPoint, base, rotMat);
        point.setLocation(tempPoint.x, tempPoint.y);
    }

    protected static void rotatePoint(Point3d point, Point3d base, Matrix3d rotMat) {
        point.sub(base);
        rotMat.transform(point);
        point.add(base);
    }

    protected static Matrix3d getRotateMat(Vector3d rotAxis, UnitDouble angle) {
        Matrix3d rot = new Matrix3d();
        double ang = angle.getValue(SI.RADIAN);
        AxisAngle4d axisAngle = new AxisAngle4d(rotAxis.x, rotAxis.y, rotAxis.z, ang);
        rot.set(axisAngle);
        return rot;
    }

    protected static Vector4d getExternalPlane(int internalPlane, double value) {
        switch (internalPlane) {
            case 0: {
                return new Vector4d(1.0, 0.0, 0.0, -value);
            }
            case 1: {
                return new Vector4d(0.0, 1.0, 0.0, -value);
            }
            case 2: {
                return new Vector4d(0.0, 0.0, 1.0, -value);
            }
        }
        assert (false);
        return null;
    }

    protected static void mirrorPoint(Point3d point, Vector4d plane) {
        double dist = plane.x * point.x + plane.y * point.y + plane.z * point.z + plane.w;
        Vector3d moveVec = new Vector3d(plane.x, plane.y, plane.z);
        moveVec.scale(dist *= -2.0);
        point.add(moveVec);
    }

    protected void scale(UnitPoint3D base, Tuple3d scale) {
    }

    protected void translate(UnitPoint3D delta) {
    }

    protected void rotate(UnitPoint3D base, Vector3d rotAxis, UnitDouble amount) {
    }

    protected void mirror(int internalPlane, UnitDouble value) {
    }

    protected Task taskSaveGeometry() {
        return null;
    }

    @Override
    public Task taskScaleObject(UnitPoint3D base, Tuple3d scale) {
        return new ScaleTask(this.taskSaveGeometry(), base, scale);
    }

    @Override
    public Task taskTranslateObject(UnitPoint3D delta) {
        return new TranslateTask(this.taskSaveGeometry(), delta);
    }

    @Override
    public Task taskRotateObject(UnitPoint3D base, Vector3d rotAxis, UnitDouble amount) {
        return new RotateTask(this.taskSaveGeometry(), base, rotAxis, amount);
    }

    @Override
    public Task taskMirrorObject(int plane, UnitDouble value) {
        return new MirrorTask(this.taskSaveGeometry(), plane, value);
    }

    protected Vector3d getClosestAxis(Vector3d vec) {
        Vector3d axis = Geometry.VEC3D_XNEG;
        double closestDotDiff = Double.MAX_VALUE;
        double xdot = vec.dot(Geometry.VEC3D_XPOS);
        double ydot = vec.dot(Geometry.VEC3D_YPOS);
        double zdot = vec.dot(Geometry.VEC3D_ZPOS);
        double xdotDiff = Math.abs(Math.abs(xdot) - 1.0);
        double ydotDiff = Math.abs(Math.abs(ydot) - 1.0);
        double zdotDiff = Math.abs(Math.abs(zdot) - 1.0);
        if (xdotDiff < closestDotDiff) {
            closestDotDiff = xdotDiff;
            Vector3d vector3d = axis = xdot < 0.0 ? Geometry.VEC3D_XNEG : Geometry.VEC3D_XPOS;
        }
        if (ydotDiff < closestDotDiff) {
            closestDotDiff = ydotDiff;
            Vector3d vector3d = axis = ydot < 0.0 ? Geometry.VEC3D_YNEG : Geometry.VEC3D_YPOS;
        }
        if (zdotDiff < closestDotDiff) {
            closestDotDiff = zdotDiff;
            axis = zdot < 0.0 ? Geometry.VEC3D_ZNEG : Geometry.VEC3D_ZPOS;
        }
        return axis;
    }

    protected void rectifyPoints(Point3d minPoint, Point3d maxPoint) {
        double maxZ;
        double minZ;
        double maxY;
        double minY;
        double maxX;
        double minX;
        if (minPoint.x <= maxPoint.x) {
            minX = minPoint.x;
            maxX = maxPoint.x;
        } else {
            minX = maxPoint.x;
            maxX = minPoint.x;
        }
        if (minPoint.y <= maxPoint.y) {
            minY = minPoint.y;
            maxY = maxPoint.y;
        } else {
            minY = maxPoint.y;
            maxY = minPoint.y;
        }
        if (minPoint.z <= maxPoint.z) {
            minZ = minPoint.z;
            maxZ = maxPoint.z;
        } else {
            minZ = maxPoint.z;
            maxZ = minPoint.z;
        }
        minPoint.set(minX, minY, minZ);
        maxPoint.set(maxX, maxY, maxZ);
    }

    public Iterator<IFace> getFaceIterator() {
        return this.d_faces.iterator();
    }

    @Override
    public void getGeometry(Geometry g) {
        Iterator<IFace> i = this.getFaceIterator();
        while (i.hasNext()) {
            IFace f = i.next();
            f.getGeometry(g);
        }
    }

    @Override
    public UnitPoint3D getMinPoint() {
        Geometry g = new Geometry();
        this.getGeometry(g);
        Point3D min = g.getMinPoint();
        return new UnitPoint3D(min.x, min.y, min.z, Geometry.GEOM_LENGTH_UNIT);
    }

    @Override
    public UnitPoint3D getMaxPoint() {
        Geometry g = new Geometry();
        this.getGeometry(g);
        Point3D max = g.getMaxPoint();
        return new UnitPoint3D(max.x, max.y, max.z, Geometry.GEOM_LENGTH_UNIT);
    }

    @Override
    public String getName() {
        return this.d_name;
    }

    private void setName(String name) {
        this.d_name = name;
        this.d_domainHelper.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public Task taskSetName(String name) {
        return new ASetNameTask(name){

            @Override
            protected void setName(String name) {
                AbstractFDSObject.this.setName(name);
            }

            @Override
            protected String getName() {
                return AbstractFDSObject.this.getName();
            }
        };
    }

    @Override
    public void setColor(Color c) {
        this.d_color = c;
        this.d_domainHelper.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public Color getColor() {
        return this.d_color;
    }

    @Override
    public void setMaterial(Material mat) {
        Iterator<IFace> i = this.getFaceIterator();
        while (i.hasNext()) {
            IFace f = i.next();
            f.setMaterial(mat);
        }
        this.d_domainHelper.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public Material getMaterial() {
        Iterator<IFace> i = this.getFaceIterator();
        if (!this.isUniformMaterial() || !i.hasNext()) {
            return null;
        }
        return i.next().getMaterial();
    }

    @Override
    public boolean isUniformMaterial() {
        Material commonMat = null;
        Iterator<IFace> i = this.getFaceIterator();
        if (!i.hasNext()) {
            return true;
        }
        IFace f = i.next();
        commonMat = f.getMaterial();
        while (i.hasNext()) {
            f = i.next();
            if (f.getMaterial() == commonMat) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addDomain(PyroMod owner) {
        this.d_domainHelper.addDomain(owner);
        for (ActivationEventList list : this.d_vAllEvents) {
            list.addDomain(owner);
        }
    }

    @Override
    public Set<PyroMod> getDomains() {
        return this.d_domainHelper.getDomains();
    }

    @Override
    public void removeDomain(PyroMod owner) {
        this.d_domainHelper.removeDomain(owner);
        for (ActivationEventList list : this.d_vAllEvents) {
            list.removeDomain(owner);
        }
    }

    public Icon getIcon() {
        return null;
    }

    @Override
    public void setSelected(boolean selected) {
        this.d_selected = selected;
        this.d_domainHelper.fireDomainEvent(new FDSObjectDomainEvent(this, 0));
    }

    @Override
    public boolean isSelected() {
        return this.d_selected;
    }

    @Override
    public void setVisible(boolean visible) {
        this.d_visible = visible;
        this.d_domainHelper.fireDomainEvent(new FDSObjectDomainEvent(this, 1));
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public boolean addEvent(ActivationEvent evt) {
        ActivationEventList events = null;
        for (int m = 0; m < this.d_vAllEvents.size(); ++m) {
            events = this.d_vAllEvents.get(m);
            if (events.getEventType() != evt.getEventType()) continue;
            events.taskAddEvent(evt).run();
            this.d_domainHelper.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
            return true;
        }
        events = AbstractActivationEventList.createNewList(evt.getEventType(), this.getDomains());
        events.taskAddEvent(evt).run();
        this.d_vAllEvents.add(events);
        if (evt.getEventType() == 1) {
            ((HeatActivationEventList)events).setCanBeTriggeredByAny(this.d_bCanBeActivatedByAnyHeatDetector, 0);
            ((HeatActivationEventList)events).setCanBeTriggeredByAny(this.d_bCanBeDeactivatedByAnyHeatDetector, 1);
        }
        this.d_domainHelper.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
        return true;
    }

    @Override
    public boolean removeEvent(ActivationEvent evt) {
        ActivationEventList events = null;
        for (int m = 0; m < this.d_vAllEvents.size(); ++m) {
            events = this.d_vAllEvents.get(m);
            if (events.getEventType() != evt.getEventType()) continue;
            events.taskRemoveEvent(evt).run();
            if (events.size() == 0) {
                this.d_vAllEvents.remove(m);
            }
            this.d_domainHelper.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
            return true;
        }
        return false;
    }

    @Override
    public void removeEvents(int type) {
        ActivationEventList events = null;
        for (int m = 0; m < this.d_vAllEvents.size(); ++m) {
            events = this.d_vAllEvents.get(m);
            if (events.getEventType() != type) continue;
            this.d_vAllEvents.remove(m);
        }
        this.d_domainHelper.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public void removeAllEvents() {
        this.d_vAllEvents.clear();
        this.d_domainHelper.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public ActivationEventList getEventsOfType(int type) {
        ActivationEventList events = null;
        for (int m = 0; m < this.d_vAllEvents.size(); ++m) {
            events = this.d_vAllEvents.get(m);
            if (events.getEventType() != type) continue;
            return events;
        }
        return AbstractActivationEventList.createNewList(type, this.getDomains());
    }

    @Override
    public ActivationEvent[] getAllEvents() {
        Vector<ActivationEvent> allEvents = new Vector<ActivationEvent>();
        ActivationEventList events = null;
        for (int m = 0; m < this.d_vAllEvents.size(); ++m) {
            events = this.d_vAllEvents.get(m);
            allEvents.addAll(events.getAllEvents());
        }
        return allEvents.toArray(new ActivationEvent[allEvents.size()]);
    }

    @Override
    public Vector getEventsSeparatedByType() {
        return this.d_vAllEvents;
    }

    @Override
    public void setCanBeTriggeredByAnyHeatDetector(boolean canBeTriggeredByAny, int action) {
        HeatActivationEventList heatEvents = (HeatActivationEventList)this.getEventsOfType(1);
        heatEvents.setCanBeTriggeredByAny(canBeTriggeredByAny, action);
        if (action == 0) {
            this.d_bCanBeActivatedByAnyHeatDetector = canBeTriggeredByAny;
        } else {
            this.d_bCanBeDeactivatedByAnyHeatDetector = canBeTriggeredByAny;
        }
        this.d_domainHelper.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public boolean getCanBeTriggeredByAnyHeatDetector(int action) {
        if (action == 0) {
            return this.d_bCanBeActivatedByAnyHeatDetector;
        }
        return this.d_bCanBeDeactivatedByAnyHeatDetector;
    }

    protected void initEvents() {
        if (this.d_vAllEvents == null) {
            this.d_vAllEvents = new Vector();
        }
    }

    protected void initDomainHelper() {
        this.d_domainHelper = new ADomainObject();
    }

    @Override
    public Collection getEventInputRecords(FDSInputRecord baseRecord) {
        Vector<FDSInputRecord> col = new Vector<FDSInputRecord>();
        Map heatRecordMap = this.getEventInputRecordMap(1);
        if (this.getCanBeTriggeredByAnyHeatDetector(0)) {
            String activateString = (String)heatRecordMap.get(0);
            baseRecord.setValue(activateString, "ALL");
            col.add(baseRecord);
            baseRecord = (FDSInputRecord)baseRecord.clone();
            baseRecord.removeValue(activateString);
        }
        if (this.getCanBeTriggeredByAnyHeatDetector(1)) {
            String deactivateString = (String)heatRecordMap.get(1);
            baseRecord.setValue(deactivateString, "ALL");
            col.add(baseRecord);
            baseRecord = (FDSInputRecord)baseRecord.clone();
            baseRecord.removeValue(deactivateString);
        }
        ActivationEventList events = null;
        Vector allEvents = this.getEventsSeparatedByType();
        for (int m = 0; m < allEvents.size(); ++m) {
            events = (ActivationEventList)allEvents.get(m);
            col.addAll(events.getInputRecords(baseRecord, this.getEventInputRecordMap(events.getEventType())));
        }
        return col;
    }

    @Override
    public Map getEventInputRecordMap(int eventType) {
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        if (eventType == 0) {
            map.put(0, "T_CREATE");
            map.put(1, "T_REMOVE");
        } else if (eventType == 1) {
            map.put(0, "HEAT_CREATE");
            map.put(1, "HEAT_REMOVE");
        }
        return map;
    }

    @Override
    public void getObjectsDependedOn(Set<IDependedOn> dependencies, Class<IDependedOn> type) {
        int m;
        if (type.isAssignableFrom(Material.class)) {
            for (m = 0; m < this.getNumFaces(); ++m) {
                Material mat = this.getMaterial(m);
                if (mat == null) continue;
                dependencies.add(mat);
            }
        }
        if (type.isAssignableFrom(HeatDetector.class)) {
            for (m = 0; m < this.d_vAllEvents.size(); ++m) {
                ActivationEventList l = this.d_vAllEvents.get(m);
                if (l.getEventType() != 1) continue;
                Collection<ActivationEvent> events = l.getAllEvents();
                for (HeatActivationEvent heatActivationEvent : events) {
                    HeatDetector hd = (HeatDetector)heatActivationEvent.getCriteria();
                    dependencies.add(hd);
                }
            }
        }
    }

    @Override
    public boolean dependsOnObject(IDependedOn depOn) {
        block3: {
            block4: {
                if (!(depOn instanceof Material)) break block4;
                for (int m = 0; m < this.getNumFaces(); ++m) {
                    if (!this.getMaterial(m).equals(depOn)) continue;
                    return true;
                }
                break block3;
            }
            if (!(depOn instanceof HeatDetector)) break block3;
            for (int m = 0; m < this.d_vAllEvents.size(); ++m) {
                ActivationEventList l = this.d_vAllEvents.get(m);
                if (l.getEventType() != 1) continue;
                Collection<ActivationEvent> events = l.getAllEvents();
                for (HeatActivationEvent heatActivationEvent : events) {
                    if (!heatActivationEvent.getCriteria().equals(depOn)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    @Override
    public Task taskUpdateAfterDependedOnReplaced(IDependedOn old, IDependedOn replacement) {
        if (old instanceof Material) {
            return new ReplaceMaterialTask((Material)old, (Material)replacement);
        }
        if (old instanceof HeatDetector) {
            return new ReplaceHeatDetectorTask((HeatDetector)old, (HeatDetector)replacement);
        }
        return null;
    }

    @Override
    public Task taskUpdateBeforeDependedOnRenamed(IDependedOn dep, String newID) {
        return null;
    }

    @Override
    public Task taskUpdateAfterDependedOnChanged(IDependedOn dep, Object info) {
        if (dep instanceof Material) {
            return new FireEventTask(this.getDomains(), new FDSObjectDomainEvent(this, 5));
        }
        return null;
    }

    private class ReplaceHeatDetectorTask
    extends CompositeTask<PyroMod> {
        private final HeatDetector d_old;
        private final HeatDetector d_new;

        public ReplaceHeatDetectorTask(HeatDetector oldDet, HeatDetector newDet) {
            super(AbstractFDSObject.this.getDomains());
            this.d_old = oldDet;
            this.d_new = newDet;
        }

        @Override
        protected void queueBeginRuntimeTasks() {
            for (int m = 0; m < AbstractFDSObject.this.d_vAllEvents.size(); ++m) {
                ActivationEventList l = AbstractFDSObject.this.d_vAllEvents.get(m);
                if (l.getEventType() != 1) continue;
                this.queueReplaceTasks((HeatActivationEventList)l);
            }
        }

        private void queueReplaceTasks(HeatActivationEventList list) {
            Collection events = list.getAllEvents();
            for (HeatActivationEvent event : events) {
                if (!event.getCriteria().equals(this.d_old)) continue;
                this.addTask(list.taskRemoveEvent(event));
                if (this.d_new == null) continue;
                HeatActivationEvent newEvent = (HeatActivationEvent)event.clone();
                newEvent.setCriteria(this.d_new);
                this.addTask(list.taskAddEvent(newEvent));
            }
        }

        @Override
        public void undo() {
            super.undo();
            AbstractFDSObject.this.d_domainHelper.fireDomainEvent(new FDSObjectDomainEvent(AbstractFDSObject.this, 5));
        }

        @Override
        public void run() {
            super.run();
            AbstractFDSObject.this.d_domainHelper.fireDomainEvent(new FDSObjectDomainEvent(AbstractFDSObject.this, 5));
        }
    }

    private class ReplaceMaterialTask
    extends CompositeTask<PyroMod> {
        private final Material d_old;
        private final Material d_replacement;

        public ReplaceMaterialTask(Material old, Material replacement) {
            super(AbstractFDSObject.this.getDomains());
            this.d_old = old;
            this.d_replacement = replacement;
        }

        @Override
        protected void queueBeginRuntimeTasks() {
            for (int m = 0; m < AbstractFDSObject.this.getNumFaces(); ++m) {
                if (!AbstractFDSObject.this.getMaterial(m).equals(this.d_old)) continue;
                this.addTask(new SetMaterialTask(m, this.d_replacement));
            }
        }
    }

    private class SetMaterialTask
    extends ATask {
        private final Material d_mat;
        private final int d_face;
        private Material d_oldMat;

        public SetMaterialTask(int face, Material mat) {
            super(0, true);
            this.d_face = face;
            this.d_mat = mat;
        }

        @Override
        public void undo() {
            AbstractFDSObject.this.setMaterial(this.d_face, this.d_oldMat);
        }

        @Override
        public void run() {
            this.d_oldMat = AbstractFDSObject.this.getMaterial(this.d_face);
            AbstractFDSObject.this.setMaterial(this.d_face, this.d_mat);
        }
    }

    private class MirrorTask
    extends ATransformTask {
        private final int d_plane;
        private final UnitDouble d_value;

        public MirrorTask(Task geomSaverTask, int plane, UnitDouble value) {
            super(geomSaverTask);
            this.d_plane = plane;
            this.d_value = value;
        }

        @Override
        public void modify() {
            AbstractFDSObject.this.mirror(this.d_plane, this.d_value);
        }
    }

    private class RotateTask
    extends ATransformTask {
        private final UnitPoint3D d_base;
        private final Vector3d d_rotAxis;
        private final UnitDouble d_amount;

        public RotateTask(Task geomSaverTask, UnitPoint3D base, Vector3d rotAxis, UnitDouble amount) {
            super(geomSaverTask);
            this.d_base = base;
            this.d_amount = amount;
            this.d_rotAxis = rotAxis;
        }

        @Override
        public void modify() {
            AbstractFDSObject.this.rotate(this.d_base, this.d_rotAxis, this.d_amount);
        }
    }

    protected class TranslateTask
    extends ATransformTask {
        private final UnitPoint3D d_delta;

        public TranslateTask(Task geomSaverTask, UnitPoint3D delta) {
            super(geomSaverTask);
            this.d_delta = delta;
        }

        @Override
        public void modify() {
            AbstractFDSObject.this.translate(this.d_delta);
        }
    }

    protected class ScaleTask
    extends ATransformTask {
        private final UnitPoint3D d_base;
        private final Tuple3d d_scale;

        public ScaleTask(Task geomSaverTask, UnitPoint3D base, Tuple3d scale) {
            super(geomSaverTask);
            this.d_base = base;
            this.d_scale = scale;
        }

        @Override
        public void modify() {
            AbstractFDSObject.this.scale(this.d_base, this.d_scale);
        }
    }

    private static abstract class ATransformTask
    extends ATask {
        private final Task d_geomSaverTask;

        protected abstract void modify();

        public ATransformTask(Task geomSaverTask) {
            super(0, true);
            this.d_geomSaverTask = geomSaverTask;
        }

        @Override
        public boolean canUndo() {
            return this.d_geomSaverTask.canUndo();
        }

        @Override
        public void undo() {
            this.d_geomSaverTask.undo();
        }

        @Override
        public void run() {
            this.d_geomSaverTask.run();
            this.modify();
        }
    }
}

