/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.pyrosimV4V5;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.io.pyrosimV4V5.Convert;
import pyrosim.legacy_2012_1.domain.IHeatBasedValue;
import pyrosim.legacy_2012_1.domain.TimeFunction;
import pyrosim.legacy_2012_1.domain.boundcond.mat.Material;
import pyrosim.legacy_2012_1.domain.boundcond.mat.MaterialManager;
import pyrosim.legacy_2012_1.domain.boundcond.mat.ReacByproducts;
import pyrosim.legacy_2012_1.domain.boundcond.mat.SolidPyrolysis;
import pyrosim.legacy_2012_1.domain.boundcond.mat.SolidReaction;
import pyrosim.legacy_2012_1.domain.boundcond.mat.ThermalProps;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ConstantTempSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Fuel;
import pyrosim.legacy_2012_1.domain.boundcond.surf.HeatRelease;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ISlip;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ISurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ParticleInjection;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SpecInjList;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SurfComposition;
import pyrosim.legacy_2012_1.domain.boundcond.surf.TempRegulation;
import pyrosim.legacy_2012_1.domain.managers.Util;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.unitsystem.SIUS;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;

public class CvtSolid {
    private static final String HEAT_OF_VAPORIZATION = "HEAT_OF_VAPORIZATION";
    private static final String HEAT_OF_COMBUSTION = "HEAT_OF_COMBUSTION";
    private static final String BURNING_RATE_MAX = "BURNING_RATE_MAX";
    private static final String HRRPUA = "HRRPUA";
    private static final String FUEL_FRACTION = "FUEL_FRACTION";
    private static final String EMISSIVITY = "EMISSIVITY";
    private static final String E_COEFFICIENT = "E_COEFFICIENT";
    private static final String BACKING = "BACKING";
    private static final String MASS_FLUX_CRITICAL = "MASS_FLUX_CRITICAL";
    private static final String A = "A";
    private static final String E = "E";
    private static final String TMPWAL = "TMPWAL";
    private static final String TAU_Q = "TAU_Q";
    private static final String RAMP_Q = "RAMP_Q";
    private static final String HEAT_FLUX = "HEAT_FLUX";
    private static final String TMPWAL0 = "TMPWAL0";
    private static final String KS = "KS";
    private static final String RAMP_KS = "RAMP_KS";
    private static final String C_P = "C_P";
    private static final String RAMP_C_P = "RAMP_C_P";
    private static final String DELTA = "DELTA";
    private static final String DENSITY = "DENSITY";
    private static final String SURFACE_DENSITY = "SURFACE_DENSITY";
    private static final String ALPHA = "ALPHA";
    private static final String WALL_POINTS = "WALL_POINTS";
    private static final String DX_SOLID = "DX_SOLID";
    private static final String BURN_AWAY = "BURN_AWAY";
    private static final String TMPIGN = "TMPIGN";
    private static final String C_DELTA_RHO = "C_DELTA_RHO";
    private static final String PHASE = "PHASE";
    private static final String MOISTURE_FRACTION = "MOISTURE_FRACTION";
    private static final String POROSITY = "POROSITY";
    private static final String PARTICLES = "PARTICLES";
    private static final String PART_ID = "PART_ID";
    private static final String NPPC = "NPPC";

    private static double getUDVal(String key, UnitDouble value) {
        int type = Convert.fromLegacyUnitType(pyrosim.legacy_2006_2.domain.Material.getUnitType(key));
        return value.getValue(SIUS.unit(type));
    }

    private static SolidReaction.Rate getSolidReacRate(pyrosim.legacy_2006_2.domain.Material matOld, UnitDouble layerThickness, WarningReport rpt) {
        SolidReaction.Rate rate;
        if (matOld.isDefined(A) || matOld.isDefined(E)) {
            UnitDouble a = Convert.getUD(matOld, A);
            UnitDouble e = Convert.getUD(matOld, E);
            double aV = CvtSolid.getUDVal(A, a);
            double thickness = layerThickness.getValue(SI.METER);
            a = SIUS.newud(aV /= thickness, 50);
            rate = new SolidReaction.Rate(1.0, 0.0, null, new SolidReaction.Rate.AESpec(a, e));
        } else {
            double tempExp = 0.0;
            UnitDouble tempign = null;
            if (matOld.isDefined(TMPIGN)) {
                tempExp = 1.0;
                tempign = Convert.getUD(matOld, TMPIGN);
            }
            rate = new SolidReaction.Rate(1.0, tempExp, tempign, new SolidReaction.Rate.RefSpec());
        }
        return rate;
    }

    public static ISurfDesc getDescCharringFuel(pyrosim.legacy_2006_2.domain.Material matOld, MaterialManager matsNew, ParticleInjection partInj, WarningReport rpt) {
        UnitDouble hov = Convert.getUD(matOld, HEAT_OF_VAPORIZATION);
        UnitDouble hoc = matOld.isDefined(HEAT_OF_COMBUSTION) ? Convert.getUD(matOld, HEAT_OF_COMBUSTION) : null;
        Convert.ThermalThickness virginTherm = Convert.getThermalProps(matOld, true, rpt);
        UnitDouble layerThickness = virginTherm.d_thickness;
        ThermalProps virginThermProps = virginTherm.d_thermalProps;
        ThermalProps charThermProps = Convert.getThermalPropsOfChar(matOld, true, rpt);
        Material charMat = new Material(String.format(Intl.intl("%s_CHAR"), matOld.getName()), new SolidPyrolysis(null, new ArrayList<SolidReaction>(0)), charThermProps);
        Util.autoRename(matsNew, charMat);
        matsNew.add(charMat);
        SolidReaction charringReac = new SolidReaction(CvtSolid.getSolidReacRate(matOld, layerThickness, rpt), new ReacByproducts(0.5, 0.0, 0.5, charMat, hov));
        Material virginMat = new Material(String.format(Intl.intl("%s_VIRGIN"), matOld.getName()), new SolidPyrolysis(hoc, Arrays.asList(charringReac)), virginThermProps);
        Util.autoRename(matsNew, virginMat);
        matsNew.add(virginMat);
        double waterFrac = Convert.getD(matOld, MOISTURE_FRACTION, 0.0);
        double virginFrac = 1.0 - waterFrac;
        ArrayList<SurfComposition.SurfLayer.SurfComponent> surfComps = new ArrayList<SurfComposition.SurfLayer.SurfComponent>();
        surfComps.add(new SurfComposition.SurfLayer.SurfComponent(virginFrac, virginMat));
        if (waterFrac > 0.0) {
            String waterName = Intl.intl("Water");
            ThermalProps defTP = new ThermalProps();
            SolidReaction waterReac = new SolidReaction(new SolidReaction.Rate(1.0, 1.0, new UnitDouble(100.0, SI.CELSIUS), new SolidReaction.Rate.AESpec(SIUS.newud(1.0E20, 50), SIUS.newud(162000.0, 54))), new ReacByproducts(0.0, 1.0, 0.0, null, SIUS.newud(2260.0, 47)));
            Material waterMat = new Material(waterName, new SolidPyrolysis(null, Arrays.asList(waterReac)), new ThermalProps(new IHeatBasedValue.Constant(SIUS.newud(0.6, 19)), SIUS.newud(1000.0, 4), new IHeatBasedValue.Constant(SIUS.newud(4.19, 11)), 1.0, defTP.d_absorptionCoeff));
            Material existingWater = (Material)matsNew.get(waterName);
            if (existingWater != null && existingWater.equals(waterMat)) {
                waterMat = existingWater;
            } else {
                Util.autoRename(matsNew, waterMat);
                matsNew.add(waterMat);
            }
            surfComps.add(new SurfComposition.SurfLayer.SurfComponent(waterFrac, waterMat));
        }
        SurfComposition.SurfLayer layer = new SurfComposition.SurfLayer(layerThickness, surfComps);
        String backing = (String)matOld.getValue(BACKING);
        UnitDouble tmpWal0 = matOld.isDefined(TMPWAL0) ? Convert.getUD(matOld, TMPWAL0) : null;
        SurfComposition comp = new SurfComposition(tmpWal0, TimeFunction.newDefault(), Convert.getBacking(backing), false, null, Arrays.asList(layer));
        boolean burnAway = Convert.getB(matOld, BURN_AWAY, false);
        UnitDouble surfDens = Convert.getUD(matOld, SURFACE_DENSITY, null);
        LayeredSurfDesc desc = new LayeredSurfDesc(LayeredSurfDesc.Geometry.FLAT, ISlip.DEFAULT, new Fuel.MaterialReac(), comp, null, partInj, burnAway, null, surfDens);
        Convert.checkForUnusedMatFieldsFromUnused(matOld, rpt, BURNING_RATE_MAX, MASS_FLUX_CRITICAL, FUEL_FRACTION, ALPHA, WALL_POINTS, DX_SOLID);
        rpt.addWarning(new Warning(String.format(Intl.intl("SURF: %s"), matOld.getName()), Intl.intl("Converted from a charring fuel.  Please review.")));
        return desc;
    }

    public static ISurfDesc getDescThermoplastic(pyrosim.legacy_2006_2.domain.Material matOld, MaterialManager matsNew, ParticleInjection partInj, boolean thick, WarningReport rpt) {
        UnitDouble hov = Convert.getUD(matOld, HEAT_OF_VAPORIZATION);
        UnitDouble hoc = matOld.isDefined(HEAT_OF_COMBUSTION) ? Convert.getUD(matOld, HEAT_OF_COMBUSTION) : null;
        Convert.ThermalThickness thermalThickness = Convert.getThermalProps(matOld, thick, rpt);
        double fuelFrac = Convert.getD(matOld, FUEL_FRACTION, 0.0);
        SolidReaction reac = new SolidReaction(CvtSolid.getSolidReacRate(matOld, thermalThickness.d_thickness, rpt), new ReacByproducts(fuelFrac, 0.0, 0.0, null, hov));
        Material virginMat = new Material(matOld.getName() + "_MATL", new SolidPyrolysis(hoc, Arrays.asList(reac)), thermalThickness.d_thermalProps);
        Util.autoRename(matsNew, virginMat);
        matsNew.add(virginMat);
        SurfComposition.SurfLayer layer = new SurfComposition.SurfLayer(thermalThickness.d_thickness, Arrays.asList(new SurfComposition.SurfLayer.SurfComponent(1.0, virginMat)));
        String backing = (String)matOld.getValue(BACKING);
        UnitDouble tmpWal0 = matOld.isDefined(TMPWAL0) ? Convert.getUD(matOld, TMPWAL0) : null;
        SurfComposition comp = new SurfComposition(tmpWal0, TimeFunction.newDefault(), Convert.getBacking(backing), false, null, Arrays.asList(layer));
        boolean burnAway = Convert.getB(matOld, BURN_AWAY, false);
        UnitDouble surfDens = Convert.getUD(matOld, SURFACE_DENSITY, null);
        LayeredSurfDesc desc = new LayeredSurfDesc(LayeredSurfDesc.Geometry.FLAT, ISlip.DEFAULT, new Fuel.MaterialReac(), comp, null, partInj, burnAway, null, surfDens);
        Convert.checkForUnusedMatFieldsFromUnused(matOld, rpt, BURNING_RATE_MAX, MASS_FLUX_CRITICAL, ALPHA, WALL_POINTS, DX_SOLID);
        return desc;
    }

    public static ISurfDesc getDescForcedHRR(pyrosim.legacy_2006_2.domain.Material matOld, MaterialManager matsNew, ParticleInjection partInj, boolean thick, WarningReport rpt) {
        String backing = (String)matOld.getValue(BACKING);
        UnitDouble tmpWal0 = matOld.isDefined(TMPWAL0) ? Convert.getUD(matOld, TMPWAL0) : null;
        UnitDouble hoc = matOld.isDefined(HEAT_OF_COMBUSTION) ? Convert.getUD(matOld, HEAT_OF_COMBUSTION) : null;
        SolidPyrolysis pyrolysis = new SolidPyrolysis(hoc, new ArrayList<SolidReaction>(0));
        UnitDouble tmpign = Convert.getUD(matOld, TMPIGN);
        UnitDouble eCoeff = Convert.getUD(matOld, E_COEFFICIENT);
        UnitDouble hov = matOld.isDefined(HEAT_OF_VAPORIZATION) ? Convert.getUD(matOld, HEAT_OF_VAPORIZATION) : null;
        UnitDouble hrrpua = Convert.getUD(matOld, HRRPUA);
        TimeFunction func = Convert.tfFromMaterial(matOld, TAU_Q, RAMP_Q);
        HeatRelease.HRRType heatReleaseType = new HeatRelease.HRRType(hrrpua, func);
        Fuel.ManualReac reac = new Fuel.ManualReac(new HeatRelease(heatReleaseType, eCoeff), hov, new Fuel.ManualReac.TemperatureIgnite(tmpign));
        Convert.ThermalThickness thermalThickness = Convert.getThermalProps(matOld, thick, rpt);
        Material mat = new Material(matOld.getName() + "_MATL", pyrolysis, thermalThickness.d_thermalProps);
        Util.autoRename(matsNew, mat);
        matsNew.add(mat);
        List<SurfComposition.SurfLayer.SurfComponent> comps = Arrays.asList(new SurfComposition.SurfLayer.SurfComponent(1.0, mat));
        List<SurfComposition.SurfLayer> layers = Arrays.asList(new SurfComposition.SurfLayer(thermalThickness.d_thickness, comps));
        SurfComposition surfComp = new SurfComposition(tmpWal0, TimeFunction.newDefault(), Convert.getBacking(backing), false, null, layers);
        SpecInjList specInj = null;
        boolean burnAway = Convert.getB(matOld, BURN_AWAY, false);
        UnitDouble surfDens = Convert.getUD(matOld, SURFACE_DENSITY, null);
        Convert.checkForUnusedMatFieldsFromUnused(matOld, rpt, FUEL_FRACTION, POROSITY, ALPHA, WALL_POINTS, DX_SOLID);
        return new LayeredSurfDesc(LayeredSurfDesc.Geometry.FLAT, ISlip.DEFAULT, reac, surfComp, specInj, partInj, burnAway, null, surfDens);
    }

    public static ISurfDesc getDescNonFlammable(pyrosim.legacy_2006_2.domain.Material matOld, MaterialManager matsNew, ParticleInjection partInj, boolean thick, WarningReport rpt) {
        String backing = (String)matOld.getValue(BACKING);
        UnitDouble tmpWal0 = matOld.isDefined(TMPWAL0) ? Convert.getUD(matOld, TMPWAL0) : null;
        SolidPyrolysis pyrolysis = new SolidPyrolysis(null, new ArrayList<SolidReaction>(0));
        Convert.ThermalThickness thermalThickness = Convert.getThermalProps(matOld, thick, rpt);
        Material mat = new Material(matOld.getName() + "_MATL", pyrolysis, thermalThickness.d_thermalProps);
        Util.autoRename(matsNew, mat);
        matsNew.add(mat);
        ArrayList<SurfComposition.SurfLayer.SurfComponent> comps = new ArrayList<SurfComposition.SurfLayer.SurfComponent>();
        comps.add(new SurfComposition.SurfLayer.SurfComponent(1.0, mat));
        ArrayList<SurfComposition.SurfLayer> layers = new ArrayList<SurfComposition.SurfLayer>();
        layers.add(new SurfComposition.SurfLayer(thermalThickness.d_thickness, comps));
        SurfComposition surfComp = new SurfComposition(tmpWal0, TimeFunction.newDefault(), Convert.getBacking(backing), false, null, layers);
        Fuel.MaterialReac reac = new Fuel.MaterialReac();
        SpecInjList specInj = null;
        boolean burnAway = Convert.getB(matOld, BURN_AWAY, false);
        UnitDouble surfDens = Convert.getUD(matOld, SURFACE_DENSITY, null);
        Convert.checkForUnusedMatFieldsFromUsed(matOld, rpt, BACKING, EMISSIVITY, PARTICLES, NPPC, PART_ID, PHASE, TMPWAL0, KS, RAMP_KS, C_P, RAMP_C_P, DELTA, DENSITY, C_DELTA_RHO, BURN_AWAY, SURFACE_DENSITY);
        return new LayeredSurfDesc(LayeredSurfDesc.Geometry.FLAT, ISlip.DEFAULT, reac, surfComp, specInj, partInj, burnAway, null, surfDens);
    }

    public static ISurfDesc getDescHeater(pyrosim.legacy_2006_2.domain.Material matOld, ParticleInjection partInj, WarningReport rpt) {
        TempRegulation tReg = CvtSolid.getTempRegulation(matOld, rpt);
        Convert.checkForUnusedMatFieldsFromUsed(matOld, rpt, PARTICLES, NPPC, PART_ID, PHASE, TMPWAL, HEAT_FLUX, TAU_Q, RAMP_Q, EMISSIVITY);
        return new ConstantTempSurfDesc(tReg, partInj);
    }

    public static TempRegulation getTempRegulation(pyrosim.legacy_2006_2.domain.Material matOld, WarningReport rpt) {
        UnitDouble temp = matOld.isDefined(TMPWAL) ? Convert.getUD(matOld, TMPWAL) : null;
        UnitDouble heatFlux = Convert.getUD(matOld, HEAT_FLUX);
        TimeFunction tf = Convert.tfFromMaterial(matOld, TAU_Q, RAMP_Q);
        double emissivity = Convert.getD(matOld, EMISSIVITY, 0.0);
        return TempRegulation.newFixedHeatFluxTR(temp, heatFlux, tf, emissivity);
    }
}

