/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.pyrosimV4V5;

import java.util.ArrayList;
import org.jscience.physics.units.SI;
import pyrosim.io.pyrosimV4V5.Convert;
import pyrosim.legacy_2012_1.domain.TimeFunction;
import pyrosim.legacy_2012_1.domain.boundcond.mat.IPyrolysis;
import pyrosim.legacy_2012_1.domain.boundcond.mat.LiquidPyrolysis;
import pyrosim.legacy_2012_1.domain.boundcond.mat.LiquidReaction;
import pyrosim.legacy_2012_1.domain.boundcond.mat.Material;
import pyrosim.legacy_2012_1.domain.boundcond.mat.MaterialManager;
import pyrosim.legacy_2012_1.domain.boundcond.mat.ReacByproducts;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Fuel;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ISlip;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ISurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ParticleInjection;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SurfComposition;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.unitsystem.SIUS;
import thunderheadeng.util.WarningReport;

public class CvtLiquid {
    private static final String HEAT_OF_VAPORIZATION = "HEAT_OF_VAPORIZATION";
    private static final String HEAT_OF_COMBUSTION = "HEAT_OF_COMBUSTION";
    private static final String BURNING_RATE_MAX = "BURNING_RATE_MAX";
    private static final String FUEL_FRACTION = "FUEL_FRACTION";
    private static final String EMISSIVITY = "EMISSIVITY";
    private static final String BACKING = "BACKING";
    private static final String TMPWAL0 = "TMPWAL0";
    private static final String KS = "KS";
    private static final String RAMP_KS = "RAMP_KS";
    private static final String C_P = "C_P";
    private static final String RAMP_C_P = "RAMP_C_P";
    private static final String DELTA = "DELTA";
    private static final String DENSITY = "DENSITY";
    private static final String SURFACE_DENSITY = "SURFACE_DENSITY";
    private static final String ALPHA = "ALPHA";
    private static final String WALL_POINTS = "WALL_POINTS";
    private static final String DX_SOLID = "DX_SOLID";
    private static final String BURN_AWAY = "BURN_AWAY";
    private static final String TMPIGN = "TMPIGN";
    private static final String PHASE = "PHASE";
    private static final String PARTICLES = "PARTICLES";
    private static final String PART_ID = "PART_ID";
    private static final String NPPC = "NPPC";

    public static ISurfDesc getDescLiqFuel(pyrosim.legacy_2006_2.domain.Material matOld, MaterialManager matsNew, ParticleInjection partInj, WarningReport rpt) {
        UnitDouble tmpWal0 = Convert.getUD(matOld, TMPWAL0);
        String backing = (String)matOld.getValue(BACKING);
        UnitDouble heatOfVap = matOld.isDefined(HEAT_OF_VAPORIZATION) ? Convert.getUD(matOld, HEAT_OF_VAPORIZATION) : null;
        UnitDouble heatOfCombustion = matOld.isDefined(HEAT_OF_COMBUSTION) ? Convert.getUD(matOld, HEAT_OF_COMBUSTION) : null;
        UnitDouble tmpign = matOld.isDefined(TMPIGN) ? Convert.getUD(matOld, TMPIGN) : new UnitDouble(100.0, SI.CELSIUS);
        double fuelFrac = Convert.getD(matOld, FUEL_FRACTION, 0.0);
        IPyrolysis pyrolysis = CvtLiquid.getLiquidPyrolysis(tmpign, heatOfVap, heatOfCombustion, fuelFrac, 0.0);
        Convert.ThermalThickness thermalThickness = Convert.getThermalProps(matOld, true, rpt);
        Material mat = new Material(matOld.getName() + "_MATL", pyrolysis, thermalThickness.d_thermalProps);
        matsNew.add(mat);
        ArrayList<SurfComposition.SurfLayer.SurfComponent> comps = new ArrayList<SurfComposition.SurfLayer.SurfComponent>();
        comps.add(new SurfComposition.SurfLayer.SurfComponent(1.0, mat));
        ArrayList<SurfComposition.SurfLayer> layers = new ArrayList<SurfComposition.SurfLayer>();
        layers.add(new SurfComposition.SurfLayer(thermalThickness.d_thickness, comps));
        SurfComposition surfComp = new SurfComposition(tmpWal0, TimeFunction.newDefault(), Convert.getBacking(backing), false, null, layers);
        boolean burnAway = Convert.getB(matOld, BURN_AWAY, false);
        UnitDouble surfDens = Convert.getUD(matOld, SURFACE_DENSITY, null);
        Fuel.MaterialReac reac = new Fuel.MaterialReac();
        Convert.checkForUnusedMatFieldsFromUsed(matOld, rpt, HEAT_OF_VAPORIZATION, HEAT_OF_COMBUSTION, BACKING, EMISSIVITY, PARTICLES, NPPC, PART_ID, PHASE, TMPWAL0, KS, RAMP_KS, C_P, RAMP_C_P, DELTA, DENSITY, TMPIGN, FUEL_FRACTION, BURN_AWAY, SURFACE_DENSITY);
        return new LayeredSurfDesc(LayeredSurfDesc.Geometry.FLAT, ISlip.DEFAULT, reac, surfComp, null, partInj, burnAway, null, surfDens);
    }

    private static IPyrolysis getLiquidPyrolysis(UnitDouble tBoil, UnitDouble hVap, UnitDouble hoc, double nuFuel, double nuWater) {
        LiquidReaction.Rate liqReacRate = new LiquidReaction.Rate(tBoil);
        if (hVap == null) {
            hVap = SIUS.newud(0.0, 46);
        }
        ReacByproducts byProducts = new ReacByproducts(nuFuel, nuWater, 0.0, null, hVap);
        LiquidPyrolysis defPyro = new LiquidPyrolysis();
        LiquidReaction liqReac = new LiquidReaction(liqReacRate, byProducts);
        return new LiquidPyrolysis(hoc, defPyro.d_iniVaporFlux, liqReac);
    }
}

