/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.pyrosimV4V5;

import java.util.Vector;
import pyrosim.io.pyrosimV4V5.Convert;
import pyrosim.io.pyrosimV4V5.CvtSolid;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2012_1.domain.TimeFunction;
import pyrosim.legacy_2012_1.domain.boundcond.mat.MaterialManager;
import pyrosim.legacy_2012_1.domain.boundcond.surf.AirFlow;
import pyrosim.legacy_2012_1.domain.boundcond.surf.BlowerSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ISurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.InFlowSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ParticleInjection;
import pyrosim.legacy_2012_1.domain.boundcond.surf.TempRegulation;
import pyrosim.legacy_2012_1.domain.particle.ParticleList;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.unitsystem.SIUS;
import thunderheadeng.util.WarningReport;

public class CvtFanWind {
    private static final String TMPWAL = "TMPWAL";
    private static final String TAU_Q = "TAU_Q";
    private static final String RAMP_Q = "RAMP_Q";
    private static final String VEL = "VEL";
    private static final String VOLUME_FLUX = "VOLUME_FLUX";
    private static final String VEL_T = "VEL_T";
    private static final String TAU_V = "TAU_V";
    private static final String RAMP_V = "RAMP_V";
    private static final String VBC = "VBC";
    private static final String PROFILE = "PROFILE";
    private static final String PLE = "PLE";
    private static final String Z0 = "Z0";

    public static ISurfDesc cvtFanWind(Material matOld, MaterialManager matsNew, ParticleList parts, WarningReport rpt) {
        UnitDouble flow;
        UnitDouble unitDouble = flow = matOld.isDefined(VOLUME_FLUX) ? Convert.getUD(matOld, VOLUME_FLUX) : Convert.getUD(matOld, VEL);
        if (flow.getValueNoUnit() < 0.0) {
            return CvtFanWind.createSupply(matOld, parts, rpt);
        }
        return CvtFanWind.createIntake(matOld, parts, rpt);
    }

    public static AirFlow getAirFlow(Material matOld, WarningReport rpt) {
        AirFlow.ValRate rate;
        Vector<UnitDouble> velT = Convert.getVUD(matOld, VEL_T);
        UnitDouble velU = null;
        UnitDouble velV = null;
        if (velT != null) {
            velU = velT.get(0);
            velV = velT.get(1);
        } else {
            velU = SIUS.newud(0.0, 8);
            velV = SIUS.newud(0.0, 8);
        }
        TimeFunction tfVel = Convert.tfFromMaterial(matOld, TAU_V, RAMP_V);
        if (matOld.isDefined(VEL)) {
            UnitDouble udVel = Convert.getUD(matOld, VEL);
            if (udVel.getValueNoUnit() < 0.0) {
                udVel = udVel.negate();
            }
            rate = new AirFlow.NormalVel(udVel, velU, velV, tfVel, null);
        } else {
            UnitDouble udVolFlux = Convert.getUD(matOld, VOLUME_FLUX);
            if (udVolFlux.getValueNoUnit() < 0.0) {
                udVolFlux = udVolFlux.negate();
            }
            rate = new AirFlow.VolumeFlux(udVolFlux, velU, velV, tfVel, null);
        }
        String profile = (String)matOld.getValue(PROFILE);
        AirFlow.IProfile prof = null;
        if (profile != null && profile.equals("PARABOLIC")) {
            prof = new AirFlow.ParabolicProf();
        } else if (profile != null && profile.equals("ATMOSPHERIC")) {
            double ple = Convert.getD(matOld, PLE, 0.0);
            UnitDouble z0 = Convert.getUD(matOld, Z0);
            prof = new AirFlow.AtmosphericProf(ple, z0);
        } else {
            prof = new AirFlow.TopHatProf();
        }
        return new AirFlow(rate, prof, null);
    }

    public static ISurfDesc createSupply(Material matOld, ParticleList parts, WarningReport rpt) {
        TempRegulation tReg = CvtSolid.getTempRegulation(matOld, rpt);
        AirFlow airFlow = CvtFanWind.getAirFlow(matOld, rpt);
        ParticleInjection partInj = Convert.getPartInj(matOld, parts);
        return new BlowerSurfDesc(tReg, airFlow, partInj);
    }

    public static ISurfDesc createIntake(Material matOld, ParticleList parts, WarningReport rpt) {
        AirFlow airFlow = CvtFanWind.getAirFlow(matOld, rpt);
        Convert.checkForUnusedMatFieldsFromUnused(matOld, rpt, TMPWAL, TAU_Q, RAMP_Q);
        return new InFlowSurfDesc(airFlow);
    }
}

