/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.pyrosimV4V5;

import java.awt.Color;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.io.pyrosimV4V5.CvtFanWind;
import pyrosim.io.pyrosimV4V5.CvtLiquid;
import pyrosim.io.pyrosimV4V5.CvtSolid;
import pyrosim.legacy_2006_2.DirectionVector;
import pyrosim.legacy_2006_2.Serialized;
import pyrosim.legacy_2006_2.TextureDB;
import pyrosim.legacy_2006_2.UnitBox3D;
import pyrosim.legacy_2006_2.UnitPoint2D;
import pyrosim.legacy_2006_2.domain.AUnalignedFDSObject;
import pyrosim.legacy_2006_2.domain.Activatable;
import pyrosim.legacy_2006_2.domain.AlignedBlock;
import pyrosim.legacy_2006_2.domain.AlignedHole;
import pyrosim.legacy_2006_2.domain.BNDFList;
import pyrosim.legacy_2006_2.domain.BNDFRecord;
import pyrosim.legacy_2006_2.domain.BufferModelImage;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSConvexPoly;
import pyrosim.legacy_2006_2.domain.FileModelImage;
import pyrosim.legacy_2006_2.domain.Floor;
import pyrosim.legacy_2006_2.domain.HeadRecord;
import pyrosim.legacy_2006_2.domain.HeatActivationEvent;
import pyrosim.legacy_2006_2.domain.HeatActivationEventList;
import pyrosim.legacy_2006_2.domain.HeatDetector;
import pyrosim.legacy_2006_2.domain.HeatDetectorList;
import pyrosim.legacy_2006_2.domain.Hole;
import pyrosim.legacy_2006_2.domain.IsofList;
import pyrosim.legacy_2006_2.domain.IsofRecord;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.MaterialList;
import pyrosim.legacy_2006_2.domain.MaterialProfile;
import pyrosim.legacy_2006_2.domain.ModelImage;
import pyrosim.legacy_2006_2.domain.PL3DRecord;
import pyrosim.legacy_2006_2.domain.PartList;
import pyrosim.legacy_2006_2.domain.PartRecord;
import pyrosim.legacy_2006_2.domain.PipeRecord;
import pyrosim.legacy_2006_2.domain.RampRecord;
import pyrosim.legacy_2006_2.domain.Reaction;
import pyrosim.legacy_2006_2.domain.Slab;
import pyrosim.legacy_2006_2.domain.SlcfList;
import pyrosim.legacy_2006_2.domain.SlcfRecord;
import pyrosim.legacy_2006_2.domain.SmodList;
import pyrosim.legacy_2006_2.domain.SmodRecord;
import pyrosim.legacy_2006_2.domain.SolidPhaseQuantitiesList;
import pyrosim.legacy_2006_2.domain.SprkList;
import pyrosim.legacy_2006_2.domain.SprkRecord;
import pyrosim.legacy_2006_2.domain.TextureInfo;
import pyrosim.legacy_2006_2.domain.ThcpList;
import pyrosim.legacy_2006_2.domain.ThcpRecord;
import pyrosim.legacy_2006_2.domain.TimeActivationEvent;
import pyrosim.legacy_2006_2.domain.TimeActivationEventList;
import pyrosim.legacy_2006_2.domain.Vent;
import pyrosim.legacy_2006_2.domain.Wall;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.nativebuffered.Image;
import pyrosim.legacy_2012_1.domain.APyroObject;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.ExSpecList;
import pyrosim.legacy_2012_1.domain.FloorManager;
import pyrosim.legacy_2012_1.domain.GeomUtil;
import pyrosim.legacy_2012_1.domain.Grid;
import pyrosim.legacy_2012_1.domain.GridList;
import pyrosim.legacy_2012_1.domain.IHeatBasedValue;
import pyrosim.legacy_2012_1.domain.INamed;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.SimParams;
import pyrosim.legacy_2012_1.domain.TimeBasedValue;
import pyrosim.legacy_2012_1.domain.TimeFunction;
import pyrosim.legacy_2012_1.domain.boundcond.mat.MaterialManager;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Backing;
import pyrosim.legacy_2012_1.domain.boundcond.surf.BurnerSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.HeatRelease;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ISurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ParticleInjection;
import pyrosim.legacy_2012_1.domain.boundcond.surf.PredefSurf;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SurfDescStatic;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SurfaceManager;
import pyrosim.legacy_2012_1.domain.boundcond.surf.TempRegulation;
import pyrosim.legacy_2012_1.domain.controls.ControlBridge;
import pyrosim.legacy_2012_1.domain.controls.ControlMgr;
import pyrosim.legacy_2012_1.domain.controls.CustomCtrl;
import pyrosim.legacy_2012_1.domain.controls.LatchCtrl;
import pyrosim.legacy_2012_1.domain.controls.NotOp;
import pyrosim.legacy_2012_1.domain.controls.OrOp;
import pyrosim.legacy_2012_1.domain.devices.DeviceManager;
import pyrosim.legacy_2012_1.domain.devices.IDevice;
import pyrosim.legacy_2012_1.domain.devices.detectors.HeatLinkModel;
import pyrosim.legacy_2012_1.domain.devices.detectors.HeatLinkModelMgr;
import pyrosim.legacy_2012_1.domain.devices.detectors.SmokeDetector;
import pyrosim.legacy_2012_1.domain.devices.detectors.SmokeLinkModel;
import pyrosim.legacy_2012_1.domain.devices.detectors.SmokeLinkModelMgr;
import pyrosim.legacy_2012_1.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.legacy_2012_1.domain.devices.detectors.SprinklerLinkModelMgr;
import pyrosim.legacy_2012_1.domain.devices.detectors.Timer;
import pyrosim.legacy_2012_1.domain.devices.measurers.AABoxMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.AMeasuringDevc;
import pyrosim.legacy_2012_1.domain.devices.measurers.Clock;
import pyrosim.legacy_2012_1.domain.devices.measurers.FlowMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.GasPointMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.Thermocouple;
import pyrosim.legacy_2012_1.domain.devices.sprayers.DryPipe;
import pyrosim.legacy_2012_1.domain.devices.sprayers.SprayModel;
import pyrosim.legacy_2012_1.domain.devices.sprayers.SprayModelMgr;
import pyrosim.legacy_2012_1.domain.devices.sprayers.Sprinkler;
import pyrosim.legacy_2012_1.domain.geom.FDSObject;
import pyrosim.legacy_2012_1.domain.geom.FreePointLoc;
import pyrosim.legacy_2012_1.domain.geom.IObstruction;
import pyrosim.legacy_2012_1.domain.geom.ModelComposite;
import pyrosim.legacy_2012_1.domain.geom.Obstruction;
import pyrosim.legacy_2012_1.domain.geom.PartCloud;
import pyrosim.legacy_2012_1.domain.managers.Util;
import pyrosim.legacy_2012_1.domain.output.Boundaries;
import pyrosim.legacy_2012_1.domain.output.Isosurface;
import pyrosim.legacy_2012_1.domain.output.IsosurfaceMgr;
import pyrosim.legacy_2012_1.domain.output.PlanarSlice;
import pyrosim.legacy_2012_1.domain.output.Plot3d;
import pyrosim.legacy_2012_1.domain.output.SliceList;
import pyrosim.legacy_2012_1.domain.particle.ConstColoring;
import pyrosim.legacy_2012_1.domain.particle.DropletColoring;
import pyrosim.legacy_2012_1.domain.particle.FuelPartDesc;
import pyrosim.legacy_2012_1.domain.particle.FuelPyrolysis;
import pyrosim.legacy_2012_1.domain.particle.GenericPartDesc;
import pyrosim.legacy_2012_1.domain.particle.IColoring;
import pyrosim.legacy_2012_1.domain.particle.IParticleDesc;
import pyrosim.legacy_2012_1.domain.particle.Output;
import pyrosim.legacy_2012_1.domain.particle.Particle;
import pyrosim.legacy_2012_1.domain.particle.ParticleList;
import pyrosim.legacy_2012_1.domain.particle.Pyrolysis;
import pyrosim.legacy_2012_1.domain.particle.SizeDistribution;
import pyrosim.legacy_2012_1.domain.particle.ThermalProps;
import pyrosim.legacy_2012_1.domain.particle.TracerPartDesc;
import pyrosim.legacy_2012_1.domain.particle.WaterPartDesc;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.ObjectQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.domain.quantity.StaticQuantity;
import pyrosim.legacy_2012_1.domain.ramp.IRampInput;
import pyrosim.legacy_2012_1.domain.ramp.Ramp;
import pyrosim.legacy_2012_1.domain.ramp.RampInputs;
import pyrosim.legacy_2012_1.domain.reaction.Byproducts;
import pyrosim.legacy_2012_1.domain.reaction.FireSuppression;
import pyrosim.legacy_2012_1.domain.reaction.Fuel;
import pyrosim.legacy_2012_1.domain.reaction.Reaction;
import pyrosim.legacy_2012_1.domain.reaction.ReactionList;
import pyrosim.legacy_2012_1.domain.reaction.Soot;
import pyrosim.legacy_2012_1.domain.signals.IInPin;
import pyrosim.legacy_2012_1.domain.signals.IOutPin;
import pyrosim.legacy_2012_1.domain.tasks.FillGridsWithPartsTask;
import pyrosim.legacy_2012_1.domain.texture.Texture;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.io.fds.SPKReader;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AARectangle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.BGImageXform;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ExtrudedPoly;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.LineSeg;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.NGon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Quad;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Triangle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.WallGeom;
import pyrosim.legacy_2012_1.thunderheadeng.image.ImageManager;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitAABox;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;
import pyrosim.legacy_2012_1.thunderheadeng.util.IHasher;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashMap;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.Sets;
import pyrosim.legacy_2012_1.thunderheadeng.util.theHashMap;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.unitsystem.SIUS;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;

public class Convert {
    private WarningReport<Warning> d_warnings;
    private Map<IOutPin, List<IInPin>> d_ctrlMap = new LinkedHashMap<IOutPin, List<IInPin>>();
    private final File d_dbDir;
    private static final String EMISSIVITY = "EMISSIVITY";
    private static final String KS = "KS";
    private static final String KS_CHAR = "KS_CHAR";
    private static final String RAMP_KS = "RAMP_KS";
    private static final String RAMP_KS_CHAR = "RAMP_KS_CHAR";
    private static final String C_P = "C_P";
    private static final String C_P_CHAR = "C_P_CHAR";
    private static final String RAMP_C_P = "RAMP_C_P";
    private static final String RAMP_C_P_CHAR = "RAMP_C_P_CHAR";
    private static final String DELTA = "DELTA";
    private static final String DENSITY = "DENSITY";
    private static final String CHAR_DENSITY = "CHAR_DENSITY";
    private static final String ALPHA = "ALPHA";
    private static final String C_DELTA_RHO = "C_DELTA_RHO";
    private static final int PP_INERT = 0;
    private static final int PP_ADIABATIC = 1;
    private static final int PP_BURNER = 2;
    private static final int PP_FANWIND = 3;
    private static final int PP_FLAM_SOLID = 4;
    private static final int PP_FLAM_SOLID_CONST = 5;
    private static final int PP_NON_FLAM_SOLID = 6;
    private static final int PP_LIQ_FUEL = 7;
    private static final int PP_CHAR_FUEL = 8;
    private static final int PP_LIQ_THERMOPLASTIC = 9;
    private static final int PP_CHAR_THERMOPLASTIC = 10;
    private static final int PP_UNKNOWN = -1;
    private Map<String, Integer> PP_LOOKUP = this.getPPLookup();
    private static final int BC_FIXED_TEMP = 0;
    private static final int BC_FIXED_FLUX = 1;
    private static final int BC_THERM_THICK = 2;
    private static final int BC_THERM_THIN = 3;
    private static final int BC_UNDEFINED = -1;
    private Map<String, Integer> d_bcMap = Convert.getBCMap();
    private static final int ACTIVATE = 0;
    private static final int DEACTIVATE = 1;
    private final IObjectFilter<Surface> ACCEPT_NONE_FILTER = new IObjectFilter<Surface>(){

        @Override
        public boolean shouldFilter(Surface o) {
            return true;
        }
    };
    private static final String ANGLE_INCREMENT = "ANGLE_INCREMENT";
    private static final String RADTMP = "RADTMP";
    private static final String KAPPA0 = "KAPPA0";
    private static final String CH4_BANDS = "CH4_BANDS";
    private static final String WIDE_BAND_MODEL = "WIDE_BAND_MODEL";
    private static final String NMIEANG = "NMIEANG";
    private static final String NUMBER_RADIATION_ANGLES = "NUMBER_RADIATION_ANGLES";
    private static final String PATH = "PATH";
    private static final String TIME_STEP_INCREMENT = "TIME_STEP_INCREMENT";
    private final Map<String, IQuantity> d_gasPhaseMap = this.getGasPhaseMap();
    private final Map<String, IQuantity> d_intQuanMap = this.getIntegratedQuantities();
    private Map<String, SPKReader.SPKResult> d_sprkParses = new HashMap<String, SPKReader.SPKResult>();
    private final Map<String, IQuantity> d_solidPhaseMap = this.getSolidPhaseMap();

    public Convert(File dbDir, WarningReport<Warning> warnings) {
        this.d_dbDir = dbDir;
        this.d_warnings = warnings;
    }

    public pyrosim.legacy_2012_1.domain.Serialized fromLegacy(pyrosim.legacy_2012_1.domain.Serialized ser, Serialized old) {
        ModelComposite root;
        ser.initDefaults();
        this.fromLegacy(ser.simParams, old.d_headRecord);
        this.fromLegacy(ser.textures, old.d_textures);
        this.fromLegacy(ser.grids, old.d_grids, old.d_synchronized);
        this.fromLegacy(ser.floors, old.d_floors);
        this.fromLegacy(ser.particles, old.d_partList, old.d_partDtpar);
        this.fromLegacy(ser.simParams, old);
        this.fromLegacy(ser.reactions, old.d_reactions, old.d_reaction, ser.simParams.getRadiTransport());
        IdentityHashMap<HeatDetector, pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector> hdMap = new IdentityHashMap<HeatDetector, pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector>();
        DryPipe dryPipe = this.fromLegacy(ser.devices, old.d_pipeRecord);
        this.fromLegacy(ser.devices, ser.smokeLinkModels, old.d_smodList);
        this.fromLegacy(ser.devices, ser, old.d_thcpList);
        this.fromLegacy(ser.devices, hdMap, ser.heatLinkModels, old.d_heatDetectors);
        this.fromLegacy(ser.devices, ser.particles, ser.sprkLinkModels, ser.sprayModels, dryPipe, old.d_sprkList);
        this.fromLegacy(ser.boundaryOutput, ser, old.d_bndfList);
        this.fromLegacy(ser.plot3d, ser, old.d_pl3dRecord);
        this.fromLegacy(ser.isosurfaces, ser, old.d_isofList);
        this.fromLegacy(ser.slices, ser, old.d_slcfList);
        ser.unprocessedRecords = old.d_unprocessedRecords;
        this.fromLegacy(ser.surfmgr, ser.matmgr, ser.particles, old.d_materials);
        ser.obstructions = root = this.fromLegacy(old.d_walls, ser.devices, hdMap, old.d_materials, ser.surfmgr);
        this.extractParticleClouds(ser.particles, old.d_partList, root, ser.grids);
        this.createControls(ser.controls);
        return ser;
    }

    public static UnitDouble fromLegacy(pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble udOld, int unitType) {
        if (udOld == null) {
            return null;
        }
        Unit unit = SIUS.unit(unitType);
        if (udOld.getUnit() != null) {
            if (unit.isCompatible(udOld.getUnit())) {
                return new UnitDouble(udOld.getValueNoUnit(), udOld.getUnit());
            }
            System.err.println("Trying to convert to an incompatible unit:" + udOld.getUnit() + "->" + unit);
            return new UnitDouble(udOld.getValueNoUnit(), unit);
        }
        System.err.println("Assuming unit of " + unit);
        return new UnitDouble(udOld.getValueNoUnit(), unit);
    }

    public static UnitDouble[] fromLegacy(pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble[] udOlds, int unitType) {
        if (udOlds == null) {
            return null;
        }
        UnitDouble[] vals = new UnitDouble[udOlds.length];
        for (int m = 0; m < vals.length; ++m) {
            vals[m] = Convert.fromLegacy(udOlds[m], unitType);
        }
        return vals;
    }

    private static UnitPoint3D[] fromLegacy(pyrosim.legacy_2006_2.UnitPoint3D[] ptsOld, int unitType) {
        if (ptsOld == null) {
            return null;
        }
        UnitPoint3D[] ptsNew = new UnitPoint3D[ptsOld.length];
        for (int i = 0; i < ptsNew.length; ++i) {
            ptsNew[i] = Convert.fromLegacy(ptsOld[i], unitType);
        }
        return ptsNew;
    }

    private static UnitPoint3D fromLegacy(pyrosim.legacy_2006_2.UnitPoint3D ptOld, int unitType) {
        if (ptOld == null) {
            return null;
        }
        Unit u = SIUS.unit(unitType);
        Unit toUse = ptOld.getUnit();
        if (toUse == null || !toUse.isCompatible(u)) {
            toUse = u;
        }
        Point3d ptRaw = ptOld.getPoint3dValue(ptOld.getUnit());
        return new UnitPoint3D(ptRaw, toUse);
    }

    private static pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint2D fromLegacy(UnitPoint2D ptOld, int unitType) {
        if (ptOld == null) {
            return null;
        }
        Unit u = SIUS.unit(unitType);
        Unit toUse = ptOld.x.getUnit();
        if (toUse == null || !toUse.isCompatible(u)) {
            System.err.println("Trying to convert to an incompatible unit:" + toUse + "->" + u);
            toUse = u;
        }
        Point2d ptRaw = ptOld.getP2dValue(ptOld.x.getUnit());
        return new pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint2D(ptRaw, toUse);
    }

    public static Grid fromLegacy(pyrosim.legacy_2006_2.domain.Grid gridOld) {
        if (gridOld == null) {
            return null;
        }
        UnitPoint3D minPoint = Convert.fromLegacy(gridOld.getMinPoint(), 0);
        UnitPoint3D maxPoint = Convert.fromLegacy(gridOld.getMaxPoint(), 0);
        return new Grid(gridOld.getName(), minPoint, maxPoint, Convert.fromLegacy(gridOld.getXDivisions(), 0), Convert.fromLegacy(gridOld.getYDivisions(), 0), Convert.fromLegacy(gridOld.getZDivisions(), 0));
    }

    private GridList fromLegacy(GridList grids, Vector<pyrosim.legacy_2006_2.domain.Grid> oldGrids, boolean sync) {
        grids.clear();
        for (pyrosim.legacy_2006_2.domain.Grid gOld : oldGrids) {
            Grid gNew = Convert.fromLegacy(gOld);
            gNew.setSyncTimeStep(sync);
            grids.add(gNew);
        }
        return grids;
    }

    private pyrosim.legacy_2012_1.thunderheadeng.image.Image fromLegacy(String id, Image imgOld) {
        pyrosim.legacy_2012_1.thunderheadeng.image.Image img = pyrosim.legacy_2012_1.thunderheadeng.image.Image.load(id, imgOld.d_bytes, imgOld.d_width, imgOld.d_height, imgOld.d_pitch, imgOld.d_redOffset, imgOld.d_greenOffset, imgOld.d_blueOffset);
        if (img == null) {
            img = pyrosim.legacy_2012_1.thunderheadeng.image.Image.loadUncached(id);
        }
        return img;
    }

    private pyrosim.legacy_2012_1.domain.texture.ModelImage fromLegacy(ModelImage imgOld) {
        pyrosim.legacy_2012_1.thunderheadeng.image.Image baseImage;
        if (imgOld == null) {
            return null;
        }
        if (imgOld instanceof BufferModelImage) {
            BufferModelImage bimgOld = (BufferModelImage)imgOld;
            baseImage = this.fromLegacy(bimgOld.getID(), bimgOld.getBaseImage());
        } else {
            FileModelImage fimgOld = (FileModelImage)imgOld;
            baseImage = ImageManager.getImage(fimgOld.getID());
            if (baseImage == null) {
                baseImage = pyrosim.legacy_2012_1.thunderheadeng.image.Image.loadUncached(fimgOld.getID());
            }
        }
        pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint2D anchorModel = Convert.fromLegacy(imgOld.getAnchorModel(), 0);
        UnitDouble distab = Convert.fromLegacy(imgOld.getDistABModel(), 0);
        UnitDouble zloc = Convert.fromLegacy(imgOld.getZLocationModel(), 0);
        BGImageXform xform = new BGImageXform(imgOld.getAnchorImage(), new Point3d(anchorModel.x.getValue(SI.METER), anchorModel.y.getValue(SI.METER), zloc.getValue(SI.METER)), imgOld.getAImage(), imgOld.getBImage(), distab.getValue(SI.METER), Double.NaN);
        return new pyrosim.legacy_2012_1.domain.texture.ModelImage(baseImage, xform, imgOld.getOpacity());
    }

    private FloorManager fromLegacy(FloorManager floors, Map<String, Floor> floorsOld) {
        floors.clear();
        for (String fName : floorsOld.keySet()) {
            UnitDouble top;
            Floor flrOld = floorsOld.get(fName);
            UnitDouble bottom = Convert.fromLegacy(flrOld.getBottom(), 0);
            UnitDouble elevation = bottom.compareTo(top = Convert.fromLegacy(flrOld.getTop(), 0)) <= 0 ? bottom : top;
            UnitDouble wallHeight = top.sub(bottom).abs();
            pyrosim.legacy_2012_1.domain.Floor f = new pyrosim.legacy_2012_1.domain.Floor(flrOld.getName(), elevation, new UnitDouble(0.0, SI.METER), wallHeight, this.fromLegacy(flrOld.getBgImage()));
            floors.add(f);
        }
        return floors;
    }

    private pyrosim.legacy_2012_1.domain.texture.TextureDB fromLegacy(pyrosim.legacy_2012_1.domain.texture.TextureDB dbTex, TextureDB old) {
        for (String texName : old.names()) {
            pyrosim.legacy_2006_2.domain.Texture tex = old.getTexture(texName);
            TextureInfo texinfo = old.getDefaultInfo(texName);
            Texture newTex = Convert.fromLegacy(tex);
            pyrosim.legacy_2012_1.domain.texture.TextureInfo newti = null;
            if (texinfo != null) {
                newti = new pyrosim.legacy_2012_1.domain.texture.TextureInfo(texinfo.getTexID());
                newti.setWidth(Convert.fromLegacy(texinfo.getWidth(), 0));
                newti.setHeight(Convert.fromLegacy(texinfo.getHeight(), 0));
            }
            dbTex.setTexture(texName, newTex);
            dbTex.setDefaultInfo(texName, newti);
        }
        return dbTex;
    }

    private static Texture fromLegacy(pyrosim.legacy_2006_2.domain.Texture tex) {
        try {
            pyrosim.legacy_2012_1.thunderheadeng.image.Image newImg;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            if (ImageIO.write((RenderedImage)tex.getImage(), "jpg", os) && (newImg = pyrosim.legacy_2012_1.thunderheadeng.image.Image.load(tex.getImageID(), os.toByteArray())) != null) {
                return new Texture(tex.getImageID(), newImg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Texture(tex.getImageID(), pyrosim.legacy_2012_1.thunderheadeng.image.Image.loadUncached(tex.getImageID()));
    }

    private static UnitDouble nonNull(pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble val, UnitDouble defVal, int unitType) {
        return val != null ? Convert.fromLegacy(val, unitType) : defVal;
    }

    private static final Map<String, IColoring> getParticleColoringMap() {
        HashMap<String, IColoring> s_partColoringMap = new HashMap<String, IColoring>();
        s_partColoringMap.put("none", null);
        s_partColoringMap.put("VELOCITY", new DropletColoring(2));
        s_partColoringMap.put("TEMPERATURE", new DropletColoring(0));
        s_partColoringMap.put("DIAMETER", new DropletColoring(1));
        s_partColoringMap.put("RED", new ConstColoring(Color.RED));
        s_partColoringMap.put("BLUE", new ConstColoring(Color.BLUE));
        s_partColoringMap.put("BLACK", new ConstColoring(Color.BLACK));
        s_partColoringMap.put("YELLOW", new ConstColoring(Color.YELLOW));
        s_partColoringMap.put("GREEN", new ConstColoring(Color.GREEN));
        s_partColoringMap.put("MAGENTA", new ConstColoring(Color.MAGENTA));
        s_partColoringMap.put("WHITE", new ConstColoring(Color.WHITE));
        s_partColoringMap.put("CYAN", new ConstColoring(Color.CYAN));
        return s_partColoringMap;
    }

    private IParticleDesc extractParticleDesc(PartRecord partOld, pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble dtPar, Map<String, IColoring> coloringMap) {
        IParticleDesc desc;
        int defSampleFreq = partOld.getMassless() ? 1 : 10;
        int sampleFreq = partOld.getSample() == -1 ? defSampleFreq : partOld.getSample();
        Output defOutput = new Output();
        Output output = new Output(Convert.nonNull(partOld.getAge(), defOutput.d_age, 2), dtPar != null ? Convert.fromLegacy(dtPar, 2) : defOutput.d_dtInsert, sampleFreq);
        if (partOld.getMassless()) {
            desc = new TracerPartDesc(null, output);
        } else {
            SizeDistribution defSize = new SizeDistribution();
            SizeDistribution size = new SizeDistribution(Convert.nonNull(partOld.getDiameter(), defSize.d_medianDiameter, 0), new SizeDistribution.RosinRammler(partOld.getGamma()));
            ThermalProps deftp = new ThermalProps();
            UnitDouble initTemp = partOld.getInitTempFDS() ? Convert.fromLegacy(partOld.getInitTemp(), 1) : deftp.d_initTemp;
            ThermalProps tp = new ThermalProps(Convert.nonNull(partOld.getDensity(), deftp.d_density, 4), Convert.nonNull(partOld.getSpecificHeat(), deftp.d_specificHeat, 11), initTemp);
            IColoring coloring = coloringMap.get(partOld.getQuantity());
            int dropsPerSec = partOld.getDropSec();
            Pyrolysis defpy = new Pyrolysis();
            UnitDouble meltingTemp = Convert.nonNull(partOld.getMeltTemp(), defpy.d_meltingTemp, 1);
            UnitDouble vapTemp = Convert.nonNull(partOld.getVapTemp(), defpy.d_vapTemp, 1);
            UnitDouble heatOfVap = Convert.nonNull(partOld.getHeatVap(), defpy.d_heatOfVap, 46);
            if (partOld.getFuel()) {
                FuelPyrolysis deffp = new FuelPyrolysis();
                FuelPyrolysis fp = new FuelPyrolysis(meltingTemp, vapTemp, heatOfVap, Convert.nonNull(partOld.getHeatCombust(), deffp.d_heatOfCombustion, 48));
                desc = new FuelPartDesc(tp, fp, size, output, coloring, dropsPerSec);
            } else if (partOld.getWater()) {
                Pyrolysis wp = Pyrolysis.evapOn(meltingTemp, vapTemp, heatOfVap, null);
                desc = new WaterPartDesc(tp, wp, size, output, coloring, dropsPerSec);
            } else {
                Pyrolysis py = Pyrolysis.evapOn(meltingTemp, vapTemp, heatOfVap, null);
                desc = new GenericPartDesc(tp, py, size, output, coloring, dropsPerSec);
            }
        }
        return desc;
    }

    private ParticleList fromLegacy(ParticleList partsNew, PartList partsOld, pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble dtPar) {
        Map<String, IColoring> coloringMap = Convert.getParticleColoringMap();
        for (PartRecord partOld : partsOld) {
            Particle partNew = new Particle(partOld.getID(), this.extractParticleDesc(partOld, dtPar, coloringMap));
            partsNew.add(partNew);
        }
        return partsNew;
    }

    private void extractParticleClouds(ParticleList partsNew, PartList partsOld, ModelComposite obstructions, GridList grids) {
        for (PartRecord partOld : partsOld) {
            if (!partOld.getInitDropFDS()) continue;
            int initDrops = partOld.getInitDrop();
            Particle partNew = (Particle)partsNew.get(partOld.getID());
            UnitDouble massDensity = Convert.nonNull(partOld.getMassVol(), SIUS.newud(1.0, 4), 4);
            boolean isStatic = partOld.getStatic();
            FillGridsWithPartsTask task = new FillGridsWithPartsTask(null, obstructions, null, grids.flatten(), partNew, new PartCloud.ConstDropletCount(initDrops), new PartCloud.InsertOnce(massDensity), isStatic, false);
            task.run();
        }
    }

    private pyrosim.legacy_2012_1.domain.texture.TextureInfo fromLegacy(TextureInfo tiOld) {
        if (tiOld == null) {
            return null;
        }
        return new pyrosim.legacy_2012_1.domain.texture.TextureInfo(tiOld.getTexID(), Convert.fromLegacy(tiOld.getWidth(), 0), Convert.fromLegacy(tiOld.getHeight(), 0));
    }

    public static UnitDouble getUD(Material matOld, String key) {
        return Convert.getUD(matOld, key, null);
    }

    public static UnitDouble getUD(Material matOld, String key, UnitDouble defVal) {
        pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble val = Convert.getMatVal(matOld, key, null);
        if (val != null) {
            int unitType = Convert.fromLegacyUnitType(Material.getUnitType(key));
            return Convert.fromLegacy(val, unitType);
        }
        return defVal;
    }

    public static double getD(Material matOld, String key, double defVal) {
        return Convert.getMatVal(matOld, key, defVal);
    }

    public static boolean getB(Material matOld, String key, boolean defVal) {
        return Convert.getMatVal(matOld, key, defVal);
    }

    public static int getI(Material matOld, String key, int defVal) {
        return Convert.getMatVal(matOld, key, defVal);
    }

    public static String getS(Material matOld, String key, String defVal) {
        return Convert.getMatVal(matOld, key, defVal);
    }

    public static <T> T getMatVal(Material matOld, String key, T defVal) {
        Object val = matOld.getValue(key);
        if (val != null) {
            return (T)val;
        }
        val = Material.getDefaultValue(key);
        if (val != null) {
            return (T)val;
        }
        return defVal;
    }

    public static Vector<UnitDouble> getVUD(Material matOld, String key) {
        Vector vOld = (Vector)matOld.getValue(key);
        if (vOld == null) {
            return null;
        }
        Vector<UnitDouble> vNew = new Vector<UnitDouble>();
        int unitType = Convert.fromLegacyUnitType(Material.getUnitType(key));
        for (int i = 0; i < vOld.size(); ++i) {
            vNew.add(Convert.fromLegacy((pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble)vOld.get(i), unitType));
        }
        return vNew;
    }

    public static IHeatBasedValue hbvFromMaterial(Material matOld, String constKey, String rampKey) {
        if (matOld.isDefined(rampKey)) {
            pyrosim.legacy_2006_2.domain.Ramp rampQ = (pyrosim.legacy_2006_2.domain.Ramp)matOld.getValue(rampKey);
            ArrayList<Ramp.Entry> entries = new ArrayList<Ramp.Entry>();
            int fUnit = 0;
            for (RampRecord rr : rampQ.getRecords()) {
                fUnit = Convert.fromLegacyUnitType(rr.getFUnit());
                entries.add(new Ramp.Entry(Convert.fromLegacy(rr.getT(), RampInputs.HEAT.getUnitType()), Convert.fromLegacy(rr.getF(), fUnit)));
            }
            Ramp r = new Ramp(entries, RampInputs.HEAT, fUnit);
            return new IHeatBasedValue.Custom(r);
        }
        UnitDouble udConst = Convert.getUD(matOld, constKey);
        return new IHeatBasedValue.Constant(udConst);
    }

    public static TimeFunction tfFromMaterial(Material matOld, String constKey, String rampKey) {
        pyrosim.legacy_2006_2.domain.Ramp rampQ = (pyrosim.legacy_2006_2.domain.Ramp)matOld.getValue(rampKey);
        if (matOld.isDefined(constKey)) {
            UnitDouble udTanQ = Convert.getUD(matOld, constKey);
            if (udTanQ.getValueNoUnit() >= 0.0) {
                return new TimeFunction.TanH(udTanQ);
            }
            return new TimeFunction.TSquared(udTanQ.negate());
        }
        if (rampQ != null && !rampQ.getRecords().isEmpty()) {
            ArrayList<Ramp.Entry> entries = new ArrayList<Ramp.Entry>();
            int fUnit = 0;
            for (RampRecord rr : rampQ.getRecords()) {
                fUnit = Convert.fromLegacyUnitType(rr.getFUnit());
                entries.add(new Ramp.Entry(Convert.fromLegacy(rr.getT(), RampInputs.TIME.getUnitType()), Convert.fromLegacy(rr.getF(), fUnit)));
            }
            Ramp r = new Ramp(entries, RampInputs.TIME, fUnit);
            return new TimeFunction.Custom(r);
        }
        return TimeFunction.newDefault();
    }

    private static IRampInput toRampInput(int unitType) {
        switch (unitType) {
            case 2: {
                return RampInputs.TIME;
            }
            case 1: {
                return RampInputs.HEAT;
            }
        }
        assert (false);
        return RampInputs.TIME;
    }

    public static ParticleInjection getPartInj(Material matOld, ParticleList parts) {
        String PARTICLES = "PARTICLES";
        String PART_ID = "PART_ID";
        String NPPC = "NPPC";
        String partID = (String)matOld.getValue("PART_ID");
        boolean particles = Convert.getB(matOld, "PARTICLES", false);
        if (particles) {
            Particle tracer = (Particle)parts.get(ParticleList.TRACER);
            if (tracer == null || !tracer.isMassless()) {
                Particle p = new Particle(ParticleList.TRACER, new TracerPartDesc(Color.BLACK, new Output(1)));
                parts.add(p);
            }
            assert (partID == null);
            partID = ParticleList.TRACER;
        }
        if (partID != null) {
            Particle p = (Particle)parts.get(partID);
            Output pOut = p.getDescription().getOutput();
            int nppc = Convert.getI(matOld, "NPPC", 1);
            ParticleInjection defPartInj = new ParticleInjection();
            TimeBasedValue<UnitDouble> massFlux = p.isMassless() ? null : defPartInj.getMassFlux();
            return new ParticleInjection(p, nppc, massFlux, pOut.d_dtInsert);
        }
        return null;
    }

    public static void removeIfDefault(Material matOld, Set<String> set, String key) {
        Object def;
        Object val;
        if (set.contains(key) && theUtil.equal(val = matOld.getValue(key), def = Material.getDefaultValue(key))) {
            set.remove(key);
        }
    }

    public ISurfDesc cvtMatBurnerFire(Material matOld, MaterialManager matsNew, ParticleList parts, WarningReport rpt) {
        String HRRPUA = "HRRPUA";
        String E_COEFFICIENT = "E_COEFFICIENT";
        String TAU_Q = "TAU_Q";
        String RAMP_Q = "RAMP_Q";
        String TMPWAL = "TMPWAL";
        String HEAT_FLUX = "HEAT_FLUX";
        String EMISSIVITY = EMISSIVITY;
        TimeFunction fTime = Convert.tfFromMaterial(matOld, "TAU_Q", "RAMP_Q");
        UnitDouble udHRR = Convert.getUD(matOld, "HRRPUA");
        UnitDouble udECOEF = Convert.getUD(matOld, "E_COEFFICIENT");
        HeatRelease.HRRType type = new HeatRelease.HRRType(udHRR, fTime);
        HeatRelease hrr = new HeatRelease(type, udECOEF);
        TempRegulation tr = CvtSolid.getTempRegulation(matOld, rpt);
        ParticleInjection partInj = Convert.getPartInj(matOld, parts);
        Convert.checkForUnusedMatFieldsFromUsed(matOld, rpt, "HRRPUA", "E_COEFFICIENT", "TAU_Q", "RAMP_Q", "PARTICLES", "PART_ID", "NPPC", "PHASE", "TMPWAL", "HEAT_FLUX", "TAU_Q", "RAMP_Q", EMISSIVITY);
        return new BurnerSurfDesc(tr, hrr, partInj);
    }

    public static void checkForUnusedMatFieldsFromUnused(Material matOld, WarningReport rpt, String ... unusedFields) {
        HashSet<String> unusedSet = Sets.fromArrayHS(unusedFields);
        Iterator setit = unusedSet.iterator();
        while (setit.hasNext()) {
            String field = (String)setit.next();
            Object val = matOld.getValue(field);
            if (val != null && !theUtil.equal(val, Material.getDefaultValue(field))) continue;
            setit.remove();
        }
        Convert.checkUnusedMatFields(matOld, rpt, unusedSet);
    }

    public static void checkForUnusedMatFieldsFromUsed(Material matOld, WarningReport rpt, String ... usedFields) {
        TreeSet<String> unusedSet = new TreeSet<String>(matOld.getUsedKeysC());
        for (String usedField : usedFields) {
            unusedSet.remove(usedField);
        }
        Iterator setit = unusedSet.iterator();
        while (setit.hasNext()) {
            String field = (String)setit.next();
            Object val = matOld.getValue(field);
            if (!theUtil.equal(val, Material.getDefaultValue(field))) continue;
            setit.remove();
        }
        Convert.checkUnusedMatFields(matOld, rpt, unusedSet);
    }

    private static void checkUnusedMatFields(Material matOld, WarningReport rpt, Set<String> unusedFields) {
        if (!unusedFields.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (String k : unusedFields) {
                sb.append(k + ",");
            }
            String str = sb.substring(0, sb.length() - 1);
            rpt.addWarning(new Warning(matOld.getFDSType() + ":" + matOld.getName(), Intl.intl("Dropped Record(s): ") + str));
        }
    }

    public static Backing getBacking(String strBacking) {
        if (strBacking != null && strBacking.equalsIgnoreCase("INSULATED")) {
            return new Backing.Insulated();
        }
        if (strBacking != null && strBacking.equalsIgnoreCase("EXPOSED")) {
            return new Backing.Exposed();
        }
        return new Backing.AirGap();
    }

    private static UnitDouble getSteadyStateVal(IHeatBasedValue val) {
        if (val instanceof IHeatBasedValue.Custom) {
            Ramp r = ((IHeatBasedValue.Custom)val).value;
            if (r.getRecords().isEmpty()) {
                return SIUS.newud(0.0, r.getFUnitType());
            }
            return r.getRecords().get((int)(r.getRecords().size() - 1)).f;
        }
        return ((IHeatBasedValue.Constant)val).value;
    }

    private static int getMatUnitType(String key) {
        return Convert.fromLegacyUnitType(Material.getUnitType(key));
    }

    public static ThermalThickness getThermalProps(Material matOld, boolean thick, WarningReport rpt) {
        return Convert.getThermalProps(matOld, thick, KS, RAMP_KS, C_P, RAMP_C_P, DENSITY, null, rpt);
    }

    public static pyrosim.legacy_2012_1.domain.boundcond.mat.ThermalProps getThermalPropsOfChar(Material matOld, boolean thick, WarningReport rpt) {
        return Convert.getThermalProps((Material)matOld, (boolean)thick, (String)KS_CHAR, (String)RAMP_KS_CHAR, (String)C_P_CHAR, (String)RAMP_C_P_CHAR, (String)CHAR_DENSITY, (Double)Double.valueOf((double)1.0), (WarningReport)rpt).d_thermalProps;
    }

    public static ThermalThickness getThermalProps(Material matOld, boolean thick, String condKey, String condRampKey, String spHeatKey, String spHeatRampKey, String densityKey, Double emissivity, WarningReport rpt) {
        UnitDouble defThickness;
        pyrosim.legacy_2012_1.domain.boundcond.mat.ThermalProps defTp = new pyrosim.legacy_2012_1.domain.boundcond.mat.ThermalProps();
        UnitDouble unitDouble = defThickness = thick ? Convert.getUD(matOld, DELTA) : new UnitDouble(0.001, SI.METER);
        if (emissivity == null) {
            emissivity = Convert.getD(matOld, EMISSIVITY, 0.0);
        }
        UnitDouble density = null;
        IHeatBasedValue conductivity = null;
        IHeatBasedValue spHeat = null;
        UnitDouble thickness = null;
        if (matOld.isDefined(condKey) || matOld.isDefined(condRampKey)) {
            conductivity = Convert.hbvFromMaterial(matOld, condKey, condRampKey);
        }
        if (matOld.isDefined(spHeatKey) || matOld.isDefined(spHeatRampKey)) {
            spHeat = Convert.hbvFromMaterial(matOld, spHeatKey, spHeatRampKey);
        }
        if (matOld.isDefined(densityKey)) {
            density = Convert.getUD(matOld, densityKey);
        }
        if (matOld.isDefined(DELTA)) {
            thickness = Convert.getUD(matOld, DELTA);
        }
        if (conductivity != null && spHeat != null && density != null && thickness != null) {
            return new ThermalThickness(new pyrosim.legacy_2012_1.domain.boundcond.mat.ThermalProps(conductivity, density, spHeat, emissivity, defTp.d_absorptionCoeff), thickness);
        }
        if (matOld.isDefined(C_DELTA_RHO)) {
            if (conductivity == null) {
                conductivity = defTp.d_conductivity;
                if (!thick) {
                    rpt.addWarning(new Warning(String.format(Intl.intl("MATL: %s_MATL"), matOld.getName()), String.format(Intl.intl("Conductivity set to default of %s."), conductivity.toString())));
                }
            }
            UnitDouble cDeltaRho = Convert.getUD(matOld, C_DELTA_RHO);
            boolean useDefDelta = false;
            boolean useDefCP = false;
            if (thickness == null && density == null && spHeat == null) {
                useDefDelta = true;
                useDefCP = true;
            } else if (thickness == null && density == null) {
                useDefDelta = true;
            } else if (thickness == null && spHeat == null) {
                useDefDelta = true;
            } else if (density == null && spHeat == null) {
                useDefCP = true;
            }
            if (useDefDelta) {
                thickness = defThickness;
                rpt.addWarning(new Warning(String.format(Intl.intl("SURF: %s"), matOld.getName()), String.format(Intl.intl("Thickness set to default of %s."), defThickness.toString())));
            }
            if (useDefCP) {
                spHeat = defTp.d_specificHeat;
                rpt.addWarning(new Warning(String.format(Intl.intl("MATL: %s_MATL"), matOld.getName()), String.format(Intl.intl("Specific heat set to default of %s."), spHeat.toString())));
            }
            Unit cDeltaRhoUnit = SIUS.unit(Convert.getMatUnitType(C_DELTA_RHO));
            double cDeltaRhoV = cDeltaRho.getValue(cDeltaRhoUnit);
            Unit cpUnit = SIUS.unit(Convert.getMatUnitType(spHeatKey));
            Unit deltaUnit = SIUS.unit(Convert.getMatUnitType(DELTA));
            Unit rhoUnit = SIUS.unit(Convert.getMatUnitType(densityKey));
            if (density == null) {
                double cp = Convert.getSteadyStateVal(spHeat).getValue(cpUnit);
                double delta = thickness.getValue(deltaUnit);
                double rho = cDeltaRhoV / cp / delta;
                density = new UnitDouble(rho, rhoUnit);
            } else if (thickness == null) {
                double cp = Convert.getSteadyStateVal(spHeat).getValue(cpUnit);
                double rho = density.getValue(rhoUnit);
                double delta = cDeltaRhoV / cp / rho;
                thickness = new UnitDouble(delta, deltaUnit);
            } else if (spHeat == null) {
                double rho = density.getValue(rhoUnit);
                double delta = thickness.getValue(deltaUnit);
                double cp = cDeltaRhoV / delta / rho;
                spHeat = new IHeatBasedValue.Constant(new UnitDouble(cp, cpUnit));
            }
        } else {
            if (density == null) {
                density = Convert.getUD(matOld, densityKey);
            }
            if (conductivity == null) {
                conductivity = Convert.hbvFromMaterial(matOld, condKey, condRampKey);
            }
            if (spHeat == null) {
                spHeat = Convert.hbvFromMaterial(matOld, spHeatKey, spHeatRampKey);
            }
            if (thickness == null) {
                thickness = defThickness;
            }
        }
        return new ThermalThickness(new pyrosim.legacy_2012_1.domain.boundcond.mat.ThermalProps(conductivity, density, spHeat, emissivity, defTp.d_absorptionCoeff), thickness);
    }

    private Map<String, Integer> getPPLookup() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("Inert", 0);
        map.put("Adiabatic", 1);
        map.put("Burner Fire", 2);
        map.put("Fan/Wind", 3);
        map.put("Flammable Solid", 4);
        map.put("Flammable Solid (Constant HRR)", 5);
        map.put("Non-Flammable Solid", 6);
        map.put("Liquid Fuel", 7);
        map.put("Charring Fuel", 8);
        map.put("Liquid Thermoplastic", 9);
        map.put("Charring Thermoplastic", 10);
        return map;
    }

    private int getPP(Material matOld) {
        Integer iPP;
        MaterialProfile.ProfilePath path = matOld.getProfilePath().getListPaths().get("Surface Type");
        if (path != null && (iPP = this.PP_LOOKUP.get(path.getProfileName())) != null) {
            return iPP;
        }
        return -1;
    }

    private static Map<String, Integer> getBCMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("Thermally Thick", 2);
        map.put("Thermally Thin", 3);
        map.put("Fixed Temperature", 0);
        map.put("Fixed Heat Flux", 1);
        return map;
    }

    private int getBC(Material matOld) {
        String btName = null;
        MaterialProfile.ProfilePath path = matOld.getProfilePath().getListPaths().get("Surface Type");
        if (path != null && (path = path.getGroupPaths().get("Boundary Conditions")) != null && (path = path.getListPaths().get("Boundary Type")) != null) {
            btName = path.getProfileName();
        }
        if (btName == null) {
            return -1;
        }
        Integer val = this.d_bcMap.get(btName);
        if (val == null) {
            return -1;
        }
        return val;
    }

    private ISurfDesc getSurfDesc(SurfaceManager surfsNew, MaterialManager matsNew, ParticleList partsNew, Material matOld) {
        boolean thick;
        String name = matOld.getName();
        if (Material.isPredefinedMaterial(name)) {
            return ((Surface)surfsNew.get(name)).getSurfDesc();
        }
        int pp = this.getPP(matOld);
        if (pp == 0) {
            return new SurfDescStatic.Inert();
        }
        if (pp == 1) {
            return new SurfDescStatic.Adiabatic();
        }
        if (pp == 2) {
            return this.cvtMatBurnerFire(matOld, matsNew, partsNew, this.d_warnings);
        }
        if (pp == 3) {
            return CvtFanWind.cvtFanWind(matOld, matsNew, partsNew, this.d_warnings);
        }
        if (pp == 8) {
            ParticleInjection partInj = Convert.getPartInj(matOld, partsNew);
            return CvtSolid.getDescCharringFuel(matOld, matsNew, partInj, this.d_warnings);
        }
        if (pp == 7 || pp == 9) {
            ParticleInjection partInj = Convert.getPartInj(matOld, partsNew);
            return CvtLiquid.getDescLiqFuel(matOld, matsNew, partInj, this.d_warnings);
        }
        int bc = this.getBC(matOld);
        if (pp == 5 && (bc == 0 || bc == 1)) {
            return this.cvtMatBurnerFire(matOld, matsNew, partsNew, this.d_warnings);
        }
        ParticleInjection partInj = Convert.getPartInj(matOld, partsNew);
        if (bc == 0) {
            return CvtSolid.getDescHeater(matOld, partInj, this.d_warnings);
        }
        if (bc == 1) {
            return CvtSolid.getDescHeater(matOld, partInj, this.d_warnings);
        }
        boolean bl = thick = bc == 2;
        if (pp == 5) {
            return CvtSolid.getDescForcedHRR(matOld, matsNew, partInj, thick, this.d_warnings);
        }
        if (pp == 6) {
            return CvtSolid.getDescNonFlammable(matOld, matsNew, partInj, thick, this.d_warnings);
        }
        if (pp == 4 || pp == 10) {
            return CvtSolid.getDescThermoplastic(matOld, matsNew, partInj, thick, this.d_warnings);
        }
        this.d_warnings.addWarning(new Warning(Intl.intl("Unable to convert SURF: I wasn't able to classify that material."), String.format(Intl.intl("Converted to Inert: %s"), matOld.getName())));
        return new SurfDescStatic.Inert();
    }

    private Surface fromLegacy(SurfaceManager surfsNew, MaterialManager matsNew, ParticleList partsNew, Material matOld) {
        if (matOld == null) {
            return null;
        }
        return new Surface(matOld.getName(), matOld.getColor(), this.fromLegacy(matOld.getTextureInfo()), this.getSurfDesc(surfsNew, matsNew, partsNew, matOld));
    }

    private SurfaceManager fromLegacy(SurfaceManager surfsNew, MaterialManager matsNew, ParticleList partsNew, MaterialList matsOld) {
        for (Material matOld : matsOld) {
            Surface surf = this.fromLegacy(surfsNew, matsNew, partsNew, matOld);
            if (surfsNew.get(surf.getName()) != null) continue;
            surfsNew.add(surf);
        }
        return surfsNew;
    }

    private IPyroObject fromLegacy(pyrosim.legacy_2006_2.domain.FDSObject old, DeviceManager devices, Map<HeatDetector, pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector> hdMap, MaterialList matsOld, SurfaceManager surfs) {
        if (old instanceof FDSComposite) {
            return this.fromLegacy((FDSComposite)old, devices, hdMap, matsOld, surfs);
        }
        if (old instanceof FDSConvexPoly) {
            return this.fromLegacy((FDSConvexPoly)old, devices, hdMap, matsOld, surfs);
        }
        if (old instanceof Slab) {
            return this.fromLegacy((Slab)old, devices, hdMap, matsOld, surfs);
        }
        if (old instanceof Vent) {
            return this.fromLegacy((Vent)old, devices, hdMap, matsOld, surfs);
        }
        if (old instanceof AlignedBlock) {
            return this.fromLegacy((AlignedBlock)old, devices, hdMap, matsOld, surfs);
        }
        if (old instanceof AlignedHole) {
            return this.fromLegacy((AlignedHole)old, devices, hdMap, matsOld, surfs);
        }
        if (old instanceof Hole) {
            return this.fromLegacy((Hole)old, devices, hdMap, matsOld, surfs);
        }
        if (old instanceof Wall) {
            return this.fromLegacy((Wall)old, devices, hdMap, matsOld, surfs);
        }
        assert (false);
        return null;
    }

    private Surface findSurf(MaterialList matsOld, SurfaceManager surfs, Material mat, IObjectFilter<Surface> surfFilter, Map<Material, Surface> badSurfReplacements) {
        if (mat == null) {
            return (Surface)surfs.get(PredefSurf.INERT.name());
        }
        Surface replSurf = badSurfReplacements.get(mat);
        if (replSurf != null) {
            return replSurf;
        }
        Surface s = (Surface)surfs.get(mat.getName());
        if (s == null) {
            Material tempMat = (Material)mat.clone();
            for (Material oldMat : matsOld) {
                tempMat.taskSetName(oldMat.getName());
                if (!oldMat.equals(tempMat)) continue;
                s = (Surface)surfs.get(oldMat.getName());
                break;
            }
            if (s == null) {
                s = (Surface)surfs.get(PredefSurf.INERT.name());
            }
            badSurfReplacements.put(mat, s);
        }
        if (surfFilter.shouldFilter(s)) {
            s = (Surface)surfs.get(PredefSurf.INERT.name());
            badSurfReplacements.put(mat, s);
        }
        assert (s != null);
        return s;
    }

    private void setSurfs(pyrosim.legacy_2006_2.domain.FDSObject objOld, FDSObject objNew, MaterialList matsOld, SurfaceManager surfs, IObjectFilter<Surface> surfFilter) {
        if (!(objNew instanceof IObstruction) && !(objNew instanceof pyrosim.legacy_2012_1.domain.geom.Vent)) {
            return;
        }
        Surface[] newSurfs = new Surface[objOld.getNumFaces()];
        LinkedIdentityHashMap<Material, Surface> badSurfs = new LinkedIdentityHashMap<Material, Surface>();
        for (int i = 0; i < objOld.getNumFaces(); ++i) {
            Surface s;
            Material mat = objOld.getMaterial(i);
            newSurfs[i] = s = this.findSurf(matsOld, surfs, mat, surfFilter, badSurfs);
        }
        if (newSurfs.length > 1 && GeomUtil.isUniform(newSurfs)) {
            newSurfs = new Surface[]{newSurfs[0]};
        }
        if (objNew instanceof IObstruction) {
            ((IObstruction)objNew).setSurfaces(newSurfs);
        } else if (objNew instanceof pyrosim.legacy_2012_1.domain.geom.Vent) {
            ((pyrosim.legacy_2012_1.domain.geom.Vent)objNew).setSurface(newSurfs[0]);
        }
        for (Map.Entry entry : badSurfs.entrySet()) {
            this.d_warnings.addWarning(new Warning(String.format(Intl.intl("%1$s cannot use the surface, %2$s."), objNew.getName(), ((Material)entry.getKey()).getName()), String.format(Intl.intl("Using the surface, %s, instead."), ((Surface)entry.getValue()).getName())));
        }
    }

    private void convertEvents(String objName, boolean eventsAllowed, Activatable act, IInPin inPin, DeviceManager devices, Map<HeatDetector, pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector> hdMap) {
        boolean anyHDAct = act.getCanBeTriggeredByAnyHeatDetector(0);
        boolean anyHDDeact = act.getCanBeTriggeredByAnyHeatDetector(1);
        TimeActivationEventList tlist = (TimeActivationEventList)act.getEventsOfType(0);
        HeatActivationEventList hlist = (HeatActivationEventList)act.getEventsOfType(1);
        if (!(tlist != null && !tlist.getAllEvents().isEmpty() || hlist != null && !hlist.getAllEvents().isEmpty() || anyHDAct || anyHDDeact)) {
            return;
        }
        OrOp or = new OrOp();
        if (tlist != null && !tlist.getAllEvents().isEmpty()) {
            TreeSet<UnitDouble> actTimes = new TreeSet<UnitDouble>();
            Iterator objit = tlist.getAllEvents().iterator();
            TimeActivationEvent prevEvt = (TimeActivationEvent)objit.next();
            boolean initState = prevEvt.getAction() == 1;
            actTimes.add(Convert.fromLegacy((pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble)prevEvt.getCriteria(), 2));
            while (objit.hasNext()) {
                TimeActivationEvent evt = (TimeActivationEvent)objit.next();
                if (prevEvt.getAction() != evt.getAction()) {
                    actTimes.add(Convert.fromLegacy((pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble)evt.getCriteria(), 2));
                }
                prevEvt = evt;
            }
            if (actTimes.size() == 1) {
                Timer timer = new Timer((UnitDouble)actTimes.first(), initState);
                or.getInputPin().connect(timer.getOutputPins().get(0));
            } else if (actTimes.size() > 1) {
                CustomCtrl ctrl = new CustomCtrl(initState, (SortedSet<UnitDouble>)actTimes);
                ctrl.getInputPin().connect(Clock.INSTANCE.getOutputPins().get(0));
                or.getInputPin().connect(ctrl.getOutputPins().get(0));
            }
        }
        Collection<pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector> heatDetectors = ((APyroObject)devices).flatten(pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector.class);
        LinkedIdentityHashSet activateHDs = new LinkedIdentityHashSet();
        LinkedIdentityHashSet deactivateHDs = new LinkedIdentityHashSet();
        if (anyHDAct) {
            activateHDs.addAll(heatDetectors);
        }
        if (anyHDDeact) {
            deactivateHDs.addAll(heatDetectors);
        }
        if (hlist != null && !hlist.getAllEvents().isEmpty()) {
            for (Object o : hlist.getAllEvents()) {
                HeatActivationEvent evt = (HeatActivationEvent)o;
                Iterator<Object> hd = (HeatDetector)evt.getCriteria();
                int action = evt.getAction();
                pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector heatDet = hdMap.get(hd);
                if (action == 0) {
                    activateHDs.add(heatDet);
                    continue;
                }
                if (action != 1) continue;
                deactivateHDs.add(heatDet);
            }
        }
        boolean invert = false;
        boolean latch = false;
        if (!activateHDs.isEmpty() || !deactivateHDs.isEmpty()) {
            OrOp newOrOp = new OrOp();
            if (deactivateHDs.isEmpty()) {
                latch = true;
                invert = false;
                for (pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector devc : activateHDs) {
                    newOrOp.getInputPin().connect(devc.getOutputPins().get(0));
                }
            } else if (activateHDs.isEmpty()) {
                latch = true;
                invert = true;
                for (pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector devc : deactivateHDs) {
                    newOrOp.getInputPin().connect(devc.getOutputPins().get(0));
                }
            } else {
                latch = false;
                invert = false;
                for (pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector devc : heatDetectors) {
                    boolean activate = activateHDs.contains(devc);
                    boolean deactivate = deactivateHDs.contains(devc);
                    IOutPin outPin = this.convertHDEvent(devc, activate, deactivate);
                    newOrOp.getInputPin().connect(outPin);
                }
            }
            IOutPin result = newOrOp.getOutputPins().get(0);
            if (latch) {
                LatchCtrl lc = new LatchCtrl();
                lc.getInputPin().connect(result);
                result = lc.getOutputPins().get(0);
            }
            if (invert) {
                NotOp no = new NotOp();
                no.getInputPin().connect(result);
                result = no.getOutputPins().get(0);
            }
            or.getInputPin().connect(result);
        }
        inPin.connect(or.getOutputPins().get(0));
        pyrosim.legacy_2012_1.domain.controls.Util.deleteNoops(inPin);
        if (!inPin.getConnections().isEmpty()) {
            if (eventsAllowed) {
                IOutPin finalOut = inPin.getConnections().iterator().next();
                List<IInPin> connections = this.d_ctrlMap.get(finalOut);
                if (connections == null) {
                    connections = new ArrayList<IInPin>();
                    this.d_ctrlMap.put(finalOut, connections);
                }
                connections.add(inPin);
            } else {
                this.d_warnings.addWarning(new Warning(Intl.intl("OPEN vents may not be created or removed."), String.format(Intl.intl("Ignoring events specified for \"%s.\""), objName)));
            }
            inPin.disconnectAll();
        }
    }

    private IOutPin convertHDEvent(pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector hd, boolean activate, boolean deactivate) {
        boolean latch = !activate || !deactivate;
        boolean initState = deactivate && !activate;
        IOutPin outPin = hd.getOutputPins().get(0);
        if (latch) {
            LatchCtrl ctrl = new LatchCtrl();
            ctrl.getInputPin().connect(outPin);
            outPin = ctrl.getOutputPins().get(0);
        }
        if (initState) {
            NotOp not = new NotOp();
            not.getInputPin().connect(outPin);
            outPin = not.getOutputPins().get(0);
        }
        return outPin;
    }

    private void createControls(ControlMgr controls) {
        for (Map.Entry<IOutPin, List<IInPin>> entry : this.d_ctrlMap.entrySet()) {
            ControlBridge bridge = new ControlBridge(Intl.intl("CTRL"));
            Util.autoRename(controls, bridge);
            bridge.getInputPin().connect(entry.getKey());
            IOutPin bout = bridge.getOutputPins().get(0);
            for (IInPin inPin : entry.getValue()) {
                inPin.connect(bout);
            }
            controls.add(bridge);
        }
    }

    private void setFDSProps(pyrosim.legacy_2006_2.domain.FDSObject objOld, FDSObject objNew, DeviceManager devices, Map<HeatDetector, pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector> hdMap, MaterialList matsOld, SurfaceManager surfs, IObjectFilter<Surface> surfFilter) {
        objNew.setName(objOld.getName());
        objNew.setColors(objOld.getColor());
        objNew.setVisible(objOld.isVisible());
        this.setSurfs(objOld, objNew, matsOld, surfs, surfFilter);
        boolean isOpenVent = objNew instanceof pyrosim.legacy_2012_1.domain.geom.Vent && ((pyrosim.legacy_2012_1.domain.geom.Vent)objNew).getSurface().equals(surfs.get(PredefSurf.OPEN.name()));
        boolean eventsAllowed = !isOpenVent;
        this.convertEvents(objNew.getName(), eventsAllowed, objOld, objNew.getInputPin(), devices, hdMap);
    }

    private ModelComposite fromLegacy(FDSComposite objOld, DeviceManager devices, Map<HeatDetector, pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector> hdMap, MaterialList matsOld, SurfaceManager surfs) {
        ModelComposite group = new ModelComposite(objOld.getName());
        for (int i = 0; i < objOld.size(); ++i) {
            IPyroObject objNew = this.fromLegacy(objOld.get(i), devices, hdMap, matsOld, surfs);
            if (objNew == null) continue;
            group.add(objNew);
        }
        return group;
    }

    private FDSObject fromLegacy(FDSConvexPoly objOld, DeviceManager devices, Map<HeatDetector, pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector> hdMap, MaterialList matsOld, SurfaceManager surfs) {
        Surface surf0 = (Surface)surfs.get(PredefSurf.INERT.name());
        UnitPoint3D[] oldPoints = Convert.fromLegacy(objOld.getPoints(), 0);
        Point3d[] newPoints = new Point3d[oldPoints.length];
        for (int m = 0; m < oldPoints.length; ++m) {
            newPoints[m] = oldPoints[m].getPoint3dValue(Geometry.LU);
        }
        AFace geom = newPoints.length == 3 ? new Triangle(newPoints[0], newPoints[1], newPoints[2]) : (newPoints.length == 4 ? new Quad(newPoints[0], newPoints[1], newPoints[2], newPoints[3]) : new NGon(newPoints));
        Obstruction poly = new Obstruction(objOld.getName(), geom, new Surface[]{surf0});
        this.setFDSProps(objOld, poly, devices, hdMap, matsOld, surfs, Obstruction.getSurfaceFilter());
        return poly;
    }

    private FDSObject fromLegacy(Slab objOld, DeviceManager devices, Map<HeatDetector, pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector> hdMap, MaterialList matsOld, SurfaceManager surfs) {
        Surface surf0 = (Surface)surfs.get(PredefSurf.INERT.name());
        UnitPoint3D[] oldPoints = Convert.fromLegacy(objOld.getPoints(), 0);
        Point3d[] newPoints = new Point3d[oldPoints.length];
        for (int m = 0; m < oldPoints.length; ++m) {
            newPoints[m] = oldPoints[m].getPoint3dValue(Geometry.LU);
        }
        assert (newPoints.length == 3);
        Vector3d extrusion = Util3D.simplePolygonNormal(Arrays.asList(newPoints));
        if (extrusion == null) {
            extrusion = new Vector3d(0.0, 0.0, 1.0);
        }
        extrusion.scale(-Convert.fromLegacy(objOld.getThickness(), 0).getValue(Geometry.LU));
        ExtrudedPoly geom = new ExtrudedPoly(new Triangle(newPoints[0], newPoints[1], newPoints[2]), extrusion);
        Obstruction s = new Obstruction(objOld.getName(), geom, new Surface[]{surf0});
        s.setOptions(2, !objOld.isSawtoothed());
        s.setOptions(1, objOld.isThickened());
        s.setOptions(4, objOld.permitsHole());
        this.setFDSProps(objOld, s, devices, hdMap, matsOld, surfs, Obstruction.getSurfaceFilter());
        return s;
    }

    private FDSObject fromLegacy(Vent objOld, DeviceManager devices, Map<HeatDetector, pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector> hdMap, MaterialList matsOld, SurfaceManager surfs) {
        Surface surf0 = (Surface)surfs.get(PredefSurf.INERT.name());
        UnitPoint3D min = Convert.fromLegacy(objOld.getMinPoint(), 0);
        UnitPoint3D max = Convert.fromLegacy(objOld.getMaxPoint(), 0);
        AARectangle geom = AARectangle.construct(min.getPoint3dValue(Geometry.LU), max.getPoint3dValue(Geometry.LU));
        pyrosim.legacy_2012_1.domain.geom.Vent v = new pyrosim.legacy_2012_1.domain.geom.Vent(objOld.getName(), surf0, geom);
        Vector3d normal = null;
        UnitPoint3D normalU = Convert.fromLegacy(objOld.getNormal(), 0);
        if (normalU != null) {
            normal = normalU.getVector3dValue(SI.METER);
            normal.normalize();
        }
        v.setNormal(normal);
        this.setFDSProps(objOld, v, devices, hdMap, matsOld, surfs, pyrosim.legacy_2012_1.domain.geom.Vent.getSurfaceFilter());
        return v;
    }

    private static AABoxGeom constructGeom(pyrosim.legacy_2006_2.UnitPoint3D oldMin, pyrosim.legacy_2006_2.UnitPoint3D oldMax) {
        UnitPoint3D min = Convert.fromLegacy(oldMin, 0);
        UnitPoint3D max = Convert.fromLegacy(oldMax, 0);
        return new AABoxGeom(min.getPoint3dValue(Geometry.LU), max.getPoint3dValue(Geometry.LU), 0);
    }

    private FDSObject fromLegacy(AlignedBlock objOld, DeviceManager devices, Map<HeatDetector, pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector> hdMap, MaterialList matsOld, SurfaceManager surfs) {
        Surface surf0 = (Surface)surfs.get(PredefSurf.INERT.name());
        AABoxGeom geom = Convert.constructGeom(objOld.getMinPoint(), objOld.getMaxPoint());
        Obstruction ab = new Obstruction(objOld.getName(), geom, new Surface[]{surf0});
        ab.setOptions(2, !objOld.isSawtoothed());
        ab.setOptions(1, objOld.isThickened());
        ab.setOptions(4, objOld.permitsHole());
        this.setFDSProps(objOld, ab, devices, hdMap, matsOld, surfs, Obstruction.getSurfaceFilter());
        return ab;
    }

    private FDSObject fromLegacy(AlignedHole objOld, DeviceManager devices, Map<HeatDetector, pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector> hdMap, MaterialList matsOld, SurfaceManager surfs) {
        AABoxGeom geom = Convert.constructGeom(objOld.getMinPoint(), objOld.getMaxPoint());
        pyrosim.legacy_2012_1.domain.geom.Hole ah = new pyrosim.legacy_2012_1.domain.geom.Hole(objOld.getName(), geom);
        this.setFDSProps(objOld, ah, devices, hdMap, matsOld, surfs, this.ACCEPT_NONE_FILTER);
        return ah;
    }

    private FDSObject fromLegacy(Hole objOld, DeviceManager devices, Map<HeatDetector, pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector> hdMap, MaterialList matsOld, SurfaceManager surfs) {
        WallGeom geom = Convert.constructGeom(objOld);
        pyrosim.legacy_2012_1.domain.geom.Hole h = new pyrosim.legacy_2012_1.domain.geom.Hole(objOld.getName(), geom);
        this.setFDSProps(objOld, h, devices, hdMap, matsOld, surfs, this.ACCEPT_NONE_FILTER);
        return h;
    }

    private static WallGeom constructGeom(AUnalignedFDSObject objOld) {
        Unit lu = Geometry.LU;
        Point2d a = Convert.fromLegacy(objOld.getStartPoint(), 0).getP2dValue(lu);
        Point2d b = Convert.fromLegacy(objOld.getEndPoint(), 0).getP2dValue(lu);
        double bottom = Convert.fromLegacy(objOld.getBottom(), 0).getValue(lu);
        double top = Convert.fromLegacy(objOld.getTop(), 0).getValue(lu);
        double thickness = Convert.fromLegacy(objOld.getThickness(), 0).getValue(lu);
        LineSeg ls = new LineSeg(new Point3d(a.x, a.y, bottom), new Point3d(b.x, b.y, bottom));
        WallGeom.Alignment alignment = thickness < 0.0 ? WallGeom.Alignment.RIGHT : WallGeom.Alignment.LEFT;
        return new WallGeom(ls, alignment, Math.abs(thickness), top - bottom);
    }

    private FDSObject fromLegacy(Wall objOld, DeviceManager devices, Map<HeatDetector, pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector> hdMap, MaterialList matsOld, SurfaceManager surfs) {
        Surface surf0 = (Surface)surfs.get(PredefSurf.INERT.name());
        WallGeom geom = Convert.constructGeom(objOld);
        Obstruction w = new Obstruction(objOld.getName(), geom, new Surface[]{surf0});
        w.setOptions(2, !objOld.isSawtoothed());
        w.setOptions(1, objOld.isThickened());
        w.setOptions(4, objOld.permitsHole());
        this.setFDSProps(objOld, w, devices, hdMap, matsOld, surfs, Obstruction.getSurfaceFilter());
        return w;
    }

    private SimParams fromLegacy(SimParams simParams, Serialized old) {
        SlcfList slcfList;
        IsofList isofList;
        BNDFList bndfList;
        if (old.d_simulationType == 0) {
            simParams.getCalculations().setCalcDNS(false);
        } else {
            simParams.getCalculations().setCalcDNS(true);
        }
        simParams.getCalculations().setCalcIsothermal(old.d_isothermal);
        if (old.d_baroclinic == 0) {
            simParams.getCalculations().setCorrectBaroclinicTorque(false);
        } else {
            simParams.getCalculations().setCorrectBaroclinicTorque(true);
        }
        simParams.getCalculations().setCsmag(old.d_smag);
        if (old.d_useGasPhaseFireSuppression.booleanValue()) {
            simParams.getCalculations().setGPFlameExtinction(old.d_useGasPhaseFireSuppression);
        }
        simParams.getCalculations().setPrandtlNum(old.d_prandtl);
        simParams.getCalculations().setSchmidtNum(old.d_schmidt);
        if (old.d_ambientPressure != null) {
            simParams.getEnvironment().setAmbPressure(Convert.fromLegacy(old.d_ambientPressure, 39));
        }
        if (old.d_ambientTemp != null) {
            simParams.getEnvironment().setAmbTemp(Convert.fromLegacy(old.d_ambientTemp, 1));
        }
        if (old.d_initVel != null) {
            simParams.getEnvironment().setAmbVel(Convert.fromLegacy(old.d_initVel, 8));
        }
        if (old.d_atmTempLapse != null) {
            simParams.getEnvironment().setAtmLapseRate(Convert.fromLegacy(old.d_atmTempLapse, 5));
        }
        if (old.d_gvec != null) {
            simParams.getEnvironment().setGravityAccel(Convert.fromLegacy(old.d_gvec, 6));
        }
        if (!(bndfList = old.d_bndfList).isEmpty()) {
            BNDFRecord bndfRecord = bndfList.iterator().next();
            simParams.getFileOutput().setDtBoundaryFile(Convert.fromLegacy(bndfRecord.getDTSam(), 2));
        }
        if (!(isofList = old.d_isofList).isEmpty()) {
            IsofRecord isofRecord = isofList.iterator().next();
            simParams.getFileOutput().setDtIsofFiles(Convert.fromLegacy(isofRecord.getDtsam(), 2));
        }
        if (old.d_partDtsam != null) {
            simParams.getFileOutput().setDtParticleFiles(Convert.fromLegacy(old.d_partDtsam, 2));
        }
        if (old.d_pl3dRecord.getDTSam() != null) {
            simParams.getFileOutput().setDtPlot3dFile(Convert.fromLegacy(old.d_pl3dRecord.getDTSam(), 2));
        }
        if (old.d_dtcore != null) {
            simParams.getFileOutput().setDtRestartFile(Convert.fromLegacy(old.d_dtcore, 2));
        }
        if (!(slcfList = old.d_slcfList).isEmpty()) {
            SlcfRecord slcfRecord = slcfList.iterator().next();
            simParams.getFileOutput().setDtSliceFiles(Convert.fromLegacy(slcfRecord.getDtsam(), 2));
        }
        simParams.getFileOutput().setNumOutputFrames(old.d_numFrames);
        simParams.getFileOutput().setVisualize3dSmoke(!old.d_smokeOff);
        simParams.getParticles().setMaxParticlesPerMesh(old.d_partMaxDrop);
        simParams.getParticles().setPourousFloor(!old.d_notPorousFloor);
        simParams.getRadiTransport().setAngleIncrement(old.d_radi.getInt(ANGLE_INCREMENT));
        if (old.d_radi.getUD(RADTMP) != null) {
            simParams.getRadiTransport().setAssumedRadSourceTemp(Convert.fromLegacy(old.d_radi.getUD(RADTMP), 1));
        }
        if (old.d_radi.getUD(KAPPA0) != null) {
            simParams.getRadiTransport().setConstAbsorptionCoef(Convert.fromLegacy(old.d_radi.getUD(KAPPA0), 13));
        }
        simParams.getRadiTransport().setIncludeExtraFuelBands(old.d_radi.getBool(CH4_BANDS));
        simParams.getRadiTransport().setNonGrayGasAssumption(old.d_radi.getBool(WIDE_BAND_MODEL));
        simParams.getRadiTransport().setNumPolarAngles(old.d_radi.getInt(NMIEANG));
        simParams.getRadiTransport().setNumSolidAngles(old.d_radi.getInt(NUMBER_RADIATION_ANGLES));
        UnitDouble udPath = Convert.fromLegacy(old.d_radi.getUD(PATH), 0);
        if (udPath != null && udPath.getValueNoUnit() != 0.0) {
            simParams.getRadiTransport().setRadCalcPathLen(udPath);
        }
        simParams.getRadiTransport().setRadiationOn(!old.d_radSolverOff);
        simParams.getRadiTransport().setTimeStepInc(old.d_radi.getInt(TIME_STEP_INCREMENT));
        if (old.d_simulationEndTime != null) {
            simParams.getTime().setStopTime(Convert.fromLegacy(old.d_simulationEndTime, 2));
        }
        if (old.d_initialTimeStep != null) {
            simParams.getTime().setInitTimeStep(Convert.fromLegacy(old.d_initialTimeStep, 2));
        }
        if (old.d_incompressible) {
            this.d_warnings.addWarning(new Warning("INCOMPRESSIBLE not supported in FDS5", "Dropped"));
        }
        if (old.d_outsideTemp != null && !old.d_outsideTemp.equals(FDSInputRecord.DEF_OUTSIDE_TEMP)) {
            this.d_warnings.addWarning(new Warning("TMP0 (outside temp) not supported in FDS5", "Dropped"));
        }
        if (old.d_charVel != null && !old.d_charVel.equals(FDSInputRecord.DEF_CHARACTERISTIC_VELOCITY)) {
            this.d_warnings.addWarning(new Warning("Characteristic velocity not converted", "Dropped"));
        }
        if (old.d_gaugeTemp != null && !old.d_gaugeTemp.equals(FDSInputRecord.DEF_GAUGE_TEMPERATURE)) {
            this.d_warnings.addWarning(new Warning("Default gauge temperature not converted", "Dropped"));
        }
        if (old.d_sprkDtspar != null && !old.d_sprkDtspar.equals(FDSInputRecord.DEF_DTSPAR)) {
            this.d_warnings.addWarning(new Warning("DTSPAR not supported in FDS5", "Dropped"));
        }
        if (old.d_partNpps != null && !old.d_partNpps.equals(FDSInputRecord.DEF_NPPS)) {
            this.d_warnings.addWarning(new Warning("NPPS not supported in FDS5", "Dropped"));
        }
        return simParams;
    }

    private ObjectQuantity getSpecMsr(ExSpecList.MixFrac specid, Quantity quant) {
        return quant.create(specid.spec);
    }

    private static StaticQuantity newQuant(Quantity quant) {
        return quant.create();
    }

    private static ObjectQuantity newQuant(IPyroObject obj, Quantity quant) {
        return quant.create(obj);
    }

    private Map<String, IQuantity> getGasPhaseMap() {
        HashMap<String, IQuantity> gasPhaseMap = new HashMap<String, IQuantity>();
        gasPhaseMap.put(DENSITY, Convert.newQuant(Quantity.DENSITY));
        gasPhaseMap.put("TEMPERATURE", Convert.newQuant(Quantity.TEMPERATURE));
        gasPhaseMap.put("THERMOCOUPLE", Convert.newQuant(Quantity.THERMOCOUPLE));
        gasPhaseMap.put("U-VELOCITY", Convert.newQuant(Quantity.U_VELOCITY));
        gasPhaseMap.put("V-VELOCITY", Convert.newQuant(Quantity.V_VELOCITY));
        gasPhaseMap.put("W-VELOCITY", Convert.newQuant(Quantity.W_VELOCITY));
        gasPhaseMap.put("VELOCITY", Convert.newQuant(Quantity.VELOCITY));
        gasPhaseMap.put("PRESSURE", Convert.newQuant(Quantity.PRESSURE));
        gasPhaseMap.put("H", Convert.newQuant(Quantity.H));
        gasPhaseMap.put("HRRPUV", Convert.newQuant(Quantity.HRRPUV));
        gasPhaseMap.put("MIXTURE_FRACTION", Convert.newQuant(Quantity.MIXTURE_FRACTION));
        gasPhaseMap.put("DYNAMIC_VISCOSITY", Convert.newQuant(Quantity.VISCOSITY));
        gasPhaseMap.put("DIVERGENCE", Convert.newQuant(Quantity.DIVERGENCE));
        gasPhaseMap.put("WATER VAPOR", this.getSpecMsr(ExSpecList.MixFrac.WATER_VAPOR, Quantity.SPEC_MASS_FRACTION));
        gasPhaseMap.put("ABSORPTION_COEFFICIENT", Convert.newQuant(Quantity.ABSORPTION_COEFFICIENT));
        gasPhaseMap.put("oxygen", this.getSpecMsr(ExSpecList.MixFrac.OXYGEN, Quantity.SPEC_VOLUME_FRACTION));
        gasPhaseMap.put("oxygen mass friction", this.getSpecMsr(ExSpecList.MixFrac.OXYGEN, Quantity.SPEC_MASS_FRACTION));
        gasPhaseMap.put("fuel", this.getSpecMsr(ExSpecList.MixFrac.FUEL, Quantity.SPEC_VOLUME_FRACTION));
        gasPhaseMap.put("nitrogen", this.getSpecMsr(ExSpecList.MixFrac.NITROGEN, Quantity.SPEC_VOLUME_FRACTION));
        gasPhaseMap.put("water vapor", this.getSpecMsr(ExSpecList.MixFrac.WATER_VAPOR, Quantity.SPEC_VOLUME_FRACTION));
        gasPhaseMap.put("carbon dioxide", this.getSpecMsr(ExSpecList.MixFrac.CARBON_DIOXIDE, Quantity.SPEC_VOLUME_FRACTION));
        gasPhaseMap.put("carbon monoxide", this.getSpecMsr(ExSpecList.MixFrac.CARBON_MONOXIDE, Quantity.SPEC_VOLUME_FRACTION));
        gasPhaseMap.put("soot volume fraction", this.getSpecMsr(ExSpecList.MixFrac.SOOT, Quantity.SPEC_VOLUME_FRACTION));
        gasPhaseMap.put("soot density", this.getSpecMsr(ExSpecList.MixFrac.SOOT, Quantity.SPEC_DENSITY));
        gasPhaseMap.put("extinction coefficient", Convert.newQuant(Quantity.EXTINCTION_COEFFICIENT));
        gasPhaseMap.put("visibility", Convert.newQuant(Quantity.VISIBILITY));
        return gasPhaseMap;
    }

    private Map<String, IQuantity> getIntegratedQuantities() {
        HashMap<String, IQuantity> intQuanMap = new HashMap<String, IQuantity>();
        intQuanMap.put("VOLUME FLOW", Convert.newQuant(Quantity.VOLUME_FLOW));
        intQuanMap.put("MASS FLOW", Convert.newQuant(Quantity.MASS_FLOW));
        intQuanMap.put("HEAT FLOW", Convert.newQuant(Quantity.HEAT_FLOW));
        intQuanMap.put("HRR", Convert.newQuant(Quantity.HRR));
        return intQuanMap;
    }

    private List<IQuantity> getGasPhaseMsrs(String name, pyrosim.legacy_2012_1.domain.Serialized ser, String forDesc) {
        IQuantity msr = this.d_gasPhaseMap.get(name);
        if (msr != null) {
            return Arrays.asList(msr);
        }
        ArrayList<IQuantity> msrs = new ArrayList<IQuantity>();
        if (name.equals("DROPLET_FLUX_X")) {
            for (Particle part : ser.particles.flatten()) {
                if (part.isMassless()) continue;
                msrs.add(Convert.newQuant(part, Quantity.PART_MASS_FLUX_X));
            }
        } else if (name.equals("DROPLET_FLUX_Y")) {
            for (Particle part : ser.particles.flatten()) {
                if (part.isMassless()) continue;
                msrs.add(Convert.newQuant(part, Quantity.PART_MASS_FLUX_Y));
            }
        } else if (name.equals("DROPLET_FLUX_Z")) {
            for (Particle part : ser.particles.flatten()) {
                if (part.isMassless()) continue;
                msrs.add(Convert.newQuant(part, Quantity.PART_MASS_FLUX_Z));
            }
        } else if (name.equals("WMPUV")) {
            for (Particle part : ser.particles.flatten()) {
                if (!part.isWater()) continue;
                msrs.add(Convert.newQuant(part, Quantity.PART_MPUV));
            }
        }
        if (msrs.isEmpty()) {
            this.d_warnings.addWarning(new Warning(String.format(Intl.intl("Unsupported %1$s Quantity: %2$s"), forDesc, name), String.format(Intl.intl("%s quantity dropped."), forDesc)));
        }
        return msrs;
    }

    private DeviceManager fromLegacy(DeviceManager mgr, pyrosim.legacy_2012_1.domain.Serialized ser, ThcpList old) {
        ArrayList<AMeasuringDevc> devcs = new ArrayList<AMeasuringDevc>(old.size());
        for (ThcpRecord thcpRecord : old) {
            String name = thcpRecord.getLabel();
            FreePointLoc loc = new FreePointLoc(Convert.fromLegacy(thcpRecord.getLocation(), 0));
            String gasQuant = thcpRecord.getGasPhaseQuantity();
            if (gasQuant.equals("THERMOCOUPLE")) {
                devcs.add(new Thermocouple(name, loc));
                continue;
            }
            if (gasQuant.equalsIgnoreCase("VOLUME FLOW") || gasQuant.equalsIgnoreCase("MASS FLOW") || gasQuant.equalsIgnoreCase("HEAT FLOW")) {
                IQuantity quant = this.d_intQuanMap.get(gasQuant);
                FlowMeasurer fm = new FlowMeasurer(thcpRecord.getLabel(), quant, this.box2AARect(thcpRecord.d_xb), 2);
                devcs.add(fm);
                continue;
            }
            if (gasQuant.equalsIgnoreCase("HRR")) {
                UnitBox3D oldBox = thcpRecord.d_xb;
                UnitPoint3D ptMin = new UnitPoint3D(Convert.fromLegacy(oldBox.minX, 0), Convert.fromLegacy(oldBox.minY, 0), Convert.fromLegacy(oldBox.minZ, 0));
                UnitPoint3D ptMax = new UnitPoint3D(Convert.fromLegacy(oldBox.maxX, 0), Convert.fromLegacy(oldBox.maxY, 0), Convert.fromLegacy(oldBox.maxZ, 0));
                UnitAABox uBox = new UnitAABox(ptMin, ptMax);
                AABoxMeasurer hrrMeasure = new AABoxMeasurer(thcpRecord.getLabel(), Convert.newQuant(Quantity.HRR), uBox);
                devcs.add(hrrMeasure);
                continue;
            }
            List<IQuantity> msrs = this.getGasPhaseMsrs(gasQuant, ser, Intl.intl("Thermocouple"));
            if (msrs.size() > 1) {
                for (IQuantity msr : msrs) {
                    String id = name + "_" + gasQuant;
                    devcs.add(new GasPointMeasurer(id, msr, loc));
                }
                continue;
            }
            if (msrs.isEmpty()) continue;
            devcs.add(new GasPointMeasurer(name, msrs.iterator().next(), loc));
        }
        for (IDevice iDevice : devcs) {
            Util.autoRename(mgr, iDevice);
            mgr.add(iDevice);
        }
        return mgr;
    }

    private AARectangle box2AARect(UnitBox3D oldBox) {
        UnitPoint3D ptMin = new UnitPoint3D(Convert.fromLegacy(oldBox.minX, 0), Convert.fromLegacy(oldBox.minY, 0), Convert.fromLegacy(oldBox.minZ, 0));
        UnitPoint3D ptMax = new UnitPoint3D(Convert.fromLegacy(oldBox.maxX, 0), Convert.fromLegacy(oldBox.maxY, 0), Convert.fromLegacy(oldBox.maxZ, 0));
        return AARectangle.construct(ptMin.getPoint3dValue(Geometry.LU), ptMax.getPoint3dValue(Geometry.LU));
    }

    private static <T extends IPyroObject> Map<T, T> newModelLookup(IHasher<T> hasher, Composite<? extends T> mgr) {
        theHashMap<T, IPyroObject> modelLookup = new theHashMap<T, IPyroObject>(hasher);
        for (IPyroObject model : mgr.flatten()) {
            modelLookup.put(model, model);
        }
        return modelLookup;
    }

    private static <T extends INamed> T lookupModel(T key, Map<T, T> lookupMap, Composite<T> modelMgr) {
        INamed existingFromMgr = (INamed)modelMgr.get(key.getName());
        if (existingFromMgr != null && key.equals(existingFromMgr)) {
            return (T)existingFromMgr;
        }
        INamed existingMod = (INamed)lookupMap.get(key);
        if (existingMod != null) {
            return (T)existingMod;
        }
        Util.autoRename(modelMgr, key);
        modelMgr.add(key);
        lookupMap.put(key, key);
        return key;
    }

    private DeviceManager fromLegacy(DeviceManager mgr, SmokeLinkModelMgr modelMgr, SmodList smods) {
        Map<SmokeLinkModel, SmokeLinkModel> modelLookup = Convert.newModelLookup(new SmokeLinkHasher(), modelMgr);
        for (SmodRecord smod : smods) {
            int type = smod.getType();
            String name = smod.getUniqueID();
            UnitDouble actObscuration = Convert.fromLegacy(smod.getObscuration(), 31);
            FreePointLoc ptLoc = new FreePointLoc(Convert.fromLegacy(smod.getLocation(), 0));
            SmokeLinkModel.ISpec spec = null;
            if (1 == type) {
                double cAlpha = Convert.fromLegacy(smod.getCAlphaC(), 28).getValueNoUnit();
                double cBeta = Convert.fromLegacy(smod.getCBetaC(), 28).getValueNoUnit();
                double eAlpha = Convert.fromLegacy(smod.getCAlphaE(), 28).getValueNoUnit();
                double eBeta = Convert.fromLegacy(smod.getCBetaE(), 28).getValueNoUnit();
                spec = new SmokeLinkModel.Cleary(cAlpha, cBeta, eAlpha, eBeta);
            } else if (0 == type) {
                UnitDouble len = Convert.fromLegacy(smod.getLength(), 0);
                spec = new SmokeLinkModel.Heskestad(len);
            }
            assert (spec != null);
            String modName = String.format(Intl.intl("%s Model"), name);
            SmokeLinkModel mod = new SmokeLinkModel(modName, actObscuration, null, spec);
            mod = Convert.lookupModel(mod, modelLookup, modelMgr);
            mgr.add(new SmokeDetector(name, mod, ptLoc));
        }
        return mgr;
    }

    private DeviceManager fromLegacy(DeviceManager mgr, Map<HeatDetector, pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector> hdMap, HeatLinkModelMgr linkModMgr, HeatDetectorList hds) {
        Map<HeatLinkModel, HeatLinkModel> modMap = Convert.newModelLookup(new HeatLinkHasher(), linkModMgr);
        for (HeatDetector hd : hds) {
            String name = hd.getUniqueID();
            UnitDouble rti = Convert.fromLegacy(hd.getRTI(), 3);
            UnitDouble tActivate = Convert.fromLegacy(hd.getActivationTemp(), 1);
            HeatLinkModel lnk = new HeatLinkModel(name, rti, tActivate);
            lnk = Convert.lookupModel(lnk, modMap, linkModMgr);
            FreePointLoc ptLoc = new FreePointLoc(Convert.fromLegacy(hd.getLocation(), 0));
            pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector hdNew = new pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector(name, lnk, ptLoc);
            mgr.add(hdNew);
            hdMap.put(hd, hdNew);
        }
        return mgr;
    }

    private DryPipe fromLegacy(DeviceManager mgr, PipeRecord pipe) {
        UnitDouble delay;
        UnitDouble pipePress = Convert.fromLegacy(pipe.getPressure(), 39);
        if (pipePress != null && pipePress.getValueNoUnit() != 0.0) {
            this.d_warnings.addWarning(new Warning("PIPE: Unable to convert pipe pressure (" + pipePress.toString() + ")", "Pipe pressure data ignored."));
        }
        if ((delay = Convert.fromLegacy(pipe.getDelay(), 2)).getValueNoUnit() > 0.0) {
            DryPipe dryPipe = new DryPipe(Intl.intl("DRYPIPE"), delay);
            mgr.add(dryPipe);
            return dryPipe;
        }
        return null;
    }

    private DeviceManager fromLegacy(DeviceManager mgr, ParticleList parts, SprinklerLinkModelMgr sprkLinkModels, SprayModelMgr sprayModels, DryPipe dryPipe, SprkList sprks) {
        Map<SprinklerLinkModel, SprinklerLinkModel> linkModLookup = Convert.newModelLookup(new SprkLinkHasher(), sprkLinkModels);
        Map<SprayModel, SprayModel> sprayModLookup = Convert.newModelLookup(new SprayModelHasher(), sprayModels);
        Map<Particle, Particle> partLookup = Convert.newModelLookup(new ParticleHasher(), parts);
        for (SprkRecord sprk : sprks) {
            Particle particle;
            String name = sprk.getLabel();
            String make = sprk.getMake();
            String partID = sprk.getPartID();
            Particle particle2 = particle = partID == null ? null : (Particle)parts.get(partID);
            if (particle != null && particle.isMassless()) {
                this.d_warnings.addWarning(new Warning(String.format(Intl.intl("Sprinkler particle, %s, is massless."), partID), Intl.intl("Using particle specified in sprinkler make file.")));
                particle = null;
            }
            UnitPoint3D loc = Convert.fromLegacy(sprk.getXYZ(), 0);
            DirectionVector dv = sprk.getOrientation();
            Vector3d orientation = new Vector3d(dv.x, dv.y, dv.z);
            UnitDouble rot = Convert.fromLegacy(sprk.getRotation(), 29);
            FreePointLoc ptLoc = new FreePointLoc(loc, orientation, rot);
            SprayModel sprayDesc = null;
            SprinklerLinkModel linkDesc = null;
            File makeFile = null;
            if (this.d_dbDir != null && this.d_dbDir.exists()) {
                makeFile = new File(this.d_dbDir, make + ".spk");
            }
            if (makeFile != null && makeFile.exists()) {
                SPKReader.SPKResult result = this.d_sprkParses.get(make);
                if (result != null) {
                    sprayDesc = result.d_sprayModel;
                    linkDesc = result.d_linkModel;
                } else {
                    SPKReader spkReader = new SPKReader();
                    try {
                        result = spkReader.parse(makeFile.getAbsolutePath(), 0.0);
                        sprayDesc = result.d_sprayModel;
                        linkDesc = result.d_linkModel;
                        sprayDesc.setName(make);
                        if (particle != null) {
                            sprayDesc.setParticle(particle);
                        }
                        this.d_sprkParses.put(make, result);
                    }
                    catch (Exception e) {
                        this.d_warnings.addWarning(new Warning(String.format(Intl.intl("Error in sprinkler file, %1$s:  \n%2$s"), makeFile.getAbsolutePath(), e.getMessage()), Intl.intl("Using default sprinkler properties.")));
                    }
                }
            } else {
                Iterator makeName = makeFile != null ? makeFile.getAbsolutePath() : make + ".spk";
                this.d_warnings.addWarning(new Warning(String.format(Intl.intl("Could not find sprinkler file, %s."), makeName), Intl.intl("Using default sprinkler properties.")));
            }
            if (sprayDesc == null || linkDesc == null) {
                if (particle == null) {
                    for (Particle part : parts.flatten()) {
                        if (!part.isWater()) continue;
                        particle = part;
                        break;
                    }
                    if (particle == null) {
                        particle = new Particle(Intl.intl("Water"), new WaterPartDesc());
                    }
                }
                sprayDesc = new SprayModel(String.format(Intl.intl("%s_SPRAY"), name), particle);
                linkDesc = new SprinklerLinkModel(String.format(Intl.intl("%s_LINK"), name));
            }
            Particle sprayPart = sprayDesc.getParticle();
            sprayPart = Convert.lookupModel(sprayPart, partLookup, parts);
            sprayDesc.setParticle(sprayPart);
            sprayDesc = Convert.lookupModel(sprayDesc, sprayModLookup, sprayModels);
            linkDesc = Convert.lookupModel(linkDesc, linkModLookup, sprkLinkModels);
            Sprinkler s = new Sprinkler(name, sprayDesc, new Sprinkler.TraditionalModel(linkDesc), ptLoc);
            if (dryPipe != null) {
                s.setDryPipe(dryPipe);
            }
            mgr.add(s);
        }
        return mgr;
    }

    private SimParams fromLegacy(SimParams sParams, HeadRecord head) {
        if (head.getTitle() != null) {
            sParams.setJobTitle(head.getTitle());
        }
        return sParams;
    }

    public static int fromLegacyUnitType(int oldType) {
        if (oldType == 14) {
            return 50;
        }
        if (oldType == 16) {
            return 52;
        }
        return oldType;
    }

    private static UnitDouble getUnitDouble(pyrosim.legacy_2006_2.domain.Reaction reacOld, String key, UnitDouble defaultVal) {
        pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble val = (pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble)reacOld.getValue(key);
        Reaction.ValueInfo vi = pyrosim.legacy_2006_2.domain.Reaction.getValueInfo(key);
        if (val != null) {
            return Convert.fromLegacy(val, Convert.fromLegacyUnitType(vi.d_unitType));
        }
        if (vi != null && vi.d_defaultValue != null) {
            return Convert.fromLegacy(vi.d_defaultValue, Convert.fromLegacyUnitType(vi.d_unitType));
        }
        return defaultVal;
    }

    private static double getDouble(pyrosim.legacy_2006_2.domain.Reaction reacOld, String key, double defaultVal) {
        Object val = reacOld.getValue(key);
        if (val instanceof Double) {
            return (Double)val;
        }
        if (val != null) {
            return Convert.fromLegacy((pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble)val, 28).getValueNoUnit();
        }
        Reaction.ValueInfo vi = pyrosim.legacy_2006_2.domain.Reaction.getValueInfo(key);
        if (vi != null && vi.d_defaultValue != null) {
            return vi.d_defaultValue.getValueNoUnit();
        }
        return defaultVal;
    }

    private ReactionList fromLegacy(ReactionList mgr, pyrosim.legacy_2006_2.domain.ReactionList reacs, String defReac, SimParams.RadiationTransport radiation) {
        for (pyrosim.legacy_2006_2.domain.Reaction reacOld : reacs) {
            Reaction reacNew = new Reaction(reacOld.getName());
            FireSuppression suppression = this.convertReacSupp(reacOld);
            Fuel fuel = this.convertReacFuel(reacOld);
            Byproducts byproducts = this.convertReacByp(reacOld, fuel);
            reacNew.setFuel(fuel);
            reacNew.setSuppression(suppression);
            reacNew.setByproducts(byproducts);
            mgr.add(reacNew);
        }
        Reaction defReaction = defReac != null ? (Reaction)mgr.get(defReac) : null;
        mgr.taskSetActiveReaction(defReaction).run();
        if (defReaction != null) {
            double radLossFrac = Convert.getDouble(reacs.get(defReac), "RADIATIVE_FRACTION", 0.0);
            radiation.setRadiativeLossFraction(radLossFrac);
        }
        return mgr;
    }

    private FireSuppression convertReacSupp(pyrosim.legacy_2006_2.domain.Reaction reacOld) {
        FireSuppression defSupp = new FireSuppression();
        double oxIx = Convert.getDouble(reacOld, "X_O2_LL", defSupp.d_limitingOxygenIndex);
        UnitDouble flameTemp = Convert.getUnitDouble(reacOld, "CRITICAL_FLAME_TEMPERATURE", defSupp.d_criticalFlameTemp);
        return new FireSuppression(oxIx, flameTemp);
    }

    private Fuel convertReacFuel(pyrosim.legacy_2006_2.domain.Reaction reacOld) {
        double nuH2O = Convert.getDouble(reacOld, "NU_H2O", 0.0);
        double nuO2 = Convert.getDouble(reacOld, "NU_O2", 0.0);
        double nuCO2 = Convert.getDouble(reacOld, "NU_CO2", 0.0);
        double H = 2.0 * nuH2O;
        double C = nuCO2;
        double O = 2.0 * (C - nuO2 + H / 4.0);
        double N2 = Convert.getDouble(reacOld, "FUEL_N2", 0.0);
        double N = N2 * 2.0;
        double ambO2 = Convert.getDouble(reacOld, "Y_O2_INFTY", 0.0);
        double fuelMassFrac = Convert.getDouble(reacOld, "Y_F_INLET", 0.0);
        double mwH = 1.0;
        double mwC = 12.0;
        double mwO = 16.0;
        double mwN = 14.0;
        double calcMwFuel = H * mwH + C * mwC + O * mwO + N * mwN;
        double mwFuel = Convert.getUnitDouble(reacOld, "MW_FUEL", null).getValue(SI.GRAM.divide(SI.MOLE));
        if (Math.abs(calcMwFuel - mwFuel) > 0.1) {
            this.d_warnings.addWarning(new Warning(String.format(Intl.intl("REAC:%1$s"), reacOld.getName()), String.format(Intl.intl("Converted stoichiometry does not add to molecular weight of %1$g."), mwFuel)));
        }
        return new Fuel(C, H, O, N, 0.0, null, ambO2, fuelMassFrac);
    }

    private Byproducts convertReacByp(pyrosim.legacy_2006_2.domain.Reaction reacOld, Fuel fuel) {
        double yCO;
        double ySoot = Convert.getDouble(reacOld, "SOOT_YIELD", 0.0);
        if (reacOld.isDefined("CO_YIELD")) {
            yCO = Convert.getDouble(reacOld, "CO_YIELD", 0.0);
        } else {
            double mwC = 12.0;
            double mwFuel = Convert.getUnitDouble(reacOld, "MW_FUEL", null).getValue(SI.GRAM.divide(SI.MOLE));
            double nuFuel = Convert.getDouble(reacOld, "NU_FUEL", 0.0);
            double C = fuel.d_carbon;
            yCO = 12.0 * C / (mwFuel * nuFuel) * 0.0014 + 0.37 * ySoot;
        }
        Soot defSoot = new Soot();
        Soot soot = null;
        if (ySoot > 0.0) {
            UnitDouble massExtCoeff = Convert.getUnitDouble(reacOld, "MASS_EXTINCTION_COEFFICIENT", defSoot.d_massExtCoeff);
            double visFactor = Convert.getDouble(reacOld, "VISIBILITY_FACTOR", defSoot.d_visFactor);
            UnitDouble maxVis = Convert.getUnitDouble(reacOld, "MAXIMUM_VISIBILITY", defSoot.d_maxVisibility);
            soot = new Soot(defSoot.d_hydrogenFrac, maxVis, massExtCoeff, visFactor);
        }
        Byproducts.OxygenEnergy defOxEnergy = new Byproducts.OxygenEnergy();
        UnitDouble energy = Convert.getUnitDouble(reacOld, "EPUMO2", defOxEnergy.d_epumo2);
        Byproducts defByp = new Byproducts();
        return new Byproducts(yCO, defByp.d_h2Yield, ySoot, soot, new Byproducts.OxygenEnergy(energy, true));
    }

    private Map<String, IQuantity> getSolidPhaseMap() {
        HashMap<String, IQuantity> solidPhaseMap = new HashMap<String, IQuantity>();
        solidPhaseMap.put(SolidPhaseQuantitiesList.RADIATIVE_FLUX.getName(), Convert.newQuant(Quantity.RADIATIVE_FLUX));
        solidPhaseMap.put(SolidPhaseQuantitiesList.CONVECTIVE_FLUX.getName(), Convert.newQuant(Quantity.CONVECTIVE_FLUX));
        solidPhaseMap.put(SolidPhaseQuantitiesList.HEAT_FLUX.getName(), Convert.newQuant(Quantity.HEAT_FLUX));
        solidPhaseMap.put(SolidPhaseQuantitiesList.GAUGE_HEAT_FLUX.getName(), Convert.newQuant(Quantity.GAUGE_HEAT_FLUX));
        solidPhaseMap.put(SolidPhaseQuantitiesList.INCIDENT_HEAT_FLUX.getName(), Convert.newQuant(Quantity.INCIDENT_HEAT_FLUX));
        solidPhaseMap.put(SolidPhaseQuantitiesList.WALL_TEMPERATURE.getName(), Convert.newQuant(Quantity.WALL_TEMPERATURE));
        solidPhaseMap.put(SolidPhaseQuantitiesList.INSIDE_WALL_TEMPERATURE.getName(), Convert.newQuant(Quantity.INSIDE_WALL_TEMPERATURE));
        solidPhaseMap.put(SolidPhaseQuantitiesList.BURNING_RATE.getName(), Convert.newQuant(Quantity.BURNING_RATE));
        solidPhaseMap.put(SolidPhaseQuantitiesList.PRESSURE_COEFFICIENT.getName(), Convert.newQuant(Quantity.PRESSURE_COEFFICIENT));
        return solidPhaseMap;
    }

    private List<IQuantity> getSolidPhaseMsrs(String name, pyrosim.legacy_2012_1.domain.Serialized ser, String forDesc) {
        IQuantity msr = this.d_solidPhaseMap.get(name);
        if (msr != null) {
            return Arrays.asList(msr);
        }
        ArrayList<IQuantity> msrs = new ArrayList<IQuantity>();
        if (name.equals(SolidPhaseQuantitiesList.WMPUA.getName())) {
            for (Particle part : ser.particles.flatten()) {
                if (!part.isWater()) continue;
                msrs.add(Convert.newQuant(part, Quantity.PART_MPUA));
            }
        } else if (name.equals(SolidPhaseQuantitiesList.WCPUA.getName())) {
            for (Particle part : ser.particles.flatten()) {
                if (!part.isWater()) continue;
                msrs.add(Convert.newQuant(part, Quantity.PART_CPUA));
            }
        }
        if (msrs.isEmpty()) {
            this.d_warnings.addWarning(new Warning(String.format(Intl.intl("Unsupported %1$s Quantity: %2$s"), forDesc, name), String.format(Intl.intl("%s quantity dropped."), forDesc)));
        }
        return msrs;
    }

    private Boundaries fromLegacy(Boundaries boundaryOutput, pyrosim.legacy_2012_1.domain.Serialized ser, BNDFList bndfList) {
        ArrayList<IQuantity> measurements = new ArrayList<IQuantity>();
        for (BNDFRecord rec : bndfList) {
            String bndQuant = rec.getQuantity();
            measurements.addAll(this.getSolidPhaseMsrs(bndQuant, ser, Intl.intl("Boundary")));
        }
        if (!measurements.isEmpty()) {
            boundaryOutput.setQuantities(measurements);
        }
        return boundaryOutput;
    }

    private Plot3d fromLegacy(Plot3d plot3d, pyrosim.legacy_2012_1.domain.Serialized ser, PL3DRecord old) {
        String[] quantities = old.getQuantities();
        ArrayList<IQuantity> measurements = new ArrayList<IQuantity>();
        for (int i = 0; i < quantities.length; ++i) {
            List<IQuantity> msrs = this.getGasPhaseMsrs(quantities[i], ser, Intl.intl("Plot3D"));
            if (msrs.isEmpty()) continue;
            IQuantity m = msrs.iterator().next();
            measurements.add(m);
            if (msrs.size() <= 1) continue;
            ObjectQuantity om = (ObjectQuantity)m;
            Object src = om.objects[0];
            this.d_warnings.addWarning(new Warning(String.format(Intl.intl("Cannot add all new Plot3D quantities for the old quantity, %s, due to limited Plot3D size."), quantities[i]), String.format(Intl.intl("Only adding quantity for object, \"%s.\""), pyrosim.legacy_2012_1.util.Util.getName(src))));
        }
        plot3d.setQuantities(measurements);
        return plot3d;
    }

    private IsosurfaceMgr fromLegacy(IsosurfaceMgr mgr, pyrosim.legacy_2012_1.domain.Serialized ser, IsofList old) {
        ArrayList<Isosurface> newIsofs = new ArrayList<Isosurface>();
        for (IsofRecord rec : old) {
            String gasQuant = rec.getGasPhaseQuantity();
            Vector values = rec.getValues();
            List<IQuantity> msrs = this.getGasPhaseMsrs(gasQuant, ser, Intl.intl("Isosurface"));
            if (msrs.isEmpty()) continue;
            int unitType = msrs.iterator().next().get().unitType;
            ArrayList<UnitDouble> vals = new ArrayList<UnitDouble>();
            for (pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble ud : values) {
                vals.add(Convert.fromLegacy(ud, unitType));
            }
            for (IQuantity msr : msrs) {
                newIsofs.add(new Isosurface(msr, vals));
            }
        }
        mgr.addAll(newIsofs);
        return mgr;
    }

    private SliceList fromLegacy(SliceList slcList, pyrosim.legacy_2012_1.domain.Serialized ser, SlcfList old) {
        ArrayList<PlanarSlice> newSlcs = new ArrayList<PlanarSlice>();
        for (SlcfRecord rec : old) {
            String gasQuant = rec.getGasPhaseQuantity();
            String xyzPlane = rec.getPlane();
            pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble value = rec.getValue();
            boolean useVec = rec.getUseVector();
            int plane = 0;
            if (xyzPlane.compareTo("PBY") == 0) {
                plane = 1;
            } else if (xyzPlane.compareTo("PBZ") == 0) {
                plane = 2;
            }
            UnitDouble location = Convert.fromLegacy(value, 0);
            List<IQuantity> msrs = this.getGasPhaseMsrs(gasQuant, ser, Intl.intl("Slice"));
            for (IQuantity msr : msrs) {
                newSlcs.add(new PlanarSlice(plane, location, msr, useVec));
            }
        }
        slcList.addAll(newSlcs);
        return slcList;
    }

    private static class ParticleHasher
    implements IHasher<Particle> {
        private static final long serialVersionUID = -9116519426979874883L;

        private ParticleHasher() {
        }

        @Override
        public boolean equal(Particle o1, Object o2) {
            return o1.propEquals(o2);
        }

        @Override
        public int hash(Object o) {
            return o instanceof Particle ? ((Particle)o).propHash() : o.hashCode();
        }
    }

    private static class SprayModelHasher
    implements IHasher<SprayModel> {
        private static final long serialVersionUID = 1464529085164440650L;

        private SprayModelHasher() {
        }

        @Override
        public boolean equal(SprayModel o1, Object o2) {
            return o1.propEquals(o2);
        }

        @Override
        public int hash(Object o) {
            return o instanceof SprayModel ? ((SprayModel)o).propHash() : o.hashCode();
        }
    }

    private static class SprkLinkHasher
    implements IHasher<SprinklerLinkModel> {
        private static final long serialVersionUID = -8885859096348427403L;

        private SprkLinkHasher() {
        }

        @Override
        public boolean equal(SprinklerLinkModel o1, Object o2) {
            return o1.propEquals(o2);
        }

        @Override
        public int hash(Object o) {
            return o instanceof SprinklerLinkModel ? ((SprinklerLinkModel)o).propHash() : o.hashCode();
        }
    }

    private static class SmokeLinkHasher
    implements IHasher<SmokeLinkModel> {
        private static final long serialVersionUID = -4675213479638304632L;

        private SmokeLinkHasher() {
        }

        @Override
        public boolean equal(SmokeLinkModel o1, Object o2) {
            return o1.propEquals(o2);
        }

        @Override
        public int hash(Object o) {
            return o instanceof SmokeLinkModel ? ((SmokeLinkModel)o).propHash() : o.hashCode();
        }
    }

    private static class HeatLinkHasher
    implements IHasher<HeatLinkModel> {
        private static final long serialVersionUID = -7409016088485187926L;

        private HeatLinkHasher() {
        }

        @Override
        public boolean equal(HeatLinkModel o1, Object o2) {
            return o1.propEquals(o2);
        }

        @Override
        public int hash(Object o) {
            return o instanceof HeatLinkModel ? ((HeatLinkModel)o).propHash() : o.hashCode();
        }
    }

    public static class ThermalThickness {
        public final pyrosim.legacy_2012_1.domain.boundcond.mat.ThermalProps d_thermalProps;
        public final UnitDouble d_thickness;

        public ThermalThickness(pyrosim.legacy_2012_1.domain.boundcond.mat.ThermalProps tp, UnitDouble thick) {
            this.d_thermalProps = tp;
            this.d_thickness = thick;
        }
    }
}

