/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v7.renderers;

import java.util.List;
import java.util.Map;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v7.FDS7Const;
import pyrosim.io.fds.v7.renderers.FDSNameMap;

public class TableRenderer {
    public static boolean render(IFDSRecordRenderer props, Map<String, List<List<Double>>> tables) {
        boolean rendered = false;
        for (Map.Entry<String, List<List<Double>>> entry : tables.entrySet()) {
            if (!TableRenderer.render(props, entry.getKey(), entry.getValue())) continue;
            rendered = true;
        }
        return rendered;
    }

    public static boolean render(IFDSRecordRenderer props, String name, List<List<Double>> table) {
        for (List<Double> tableRow : table) {
            FDSRenderRecord rec = FDS7Const.newRenderRecord("TABL");
            rec.setValue("ID", name);
            rec.setValue("TABLE_DATA", tableRow);
            props.render(rec, null);
        }
        return !table.isEmpty();
    }

    public static String createID(FDSNameMap nameMap, String ownerID, String fieldName) {
        String baseName = ownerID + "_" + fieldName;
        String id = nameMap.generateName("TABL", baseName);
        return id;
    }
}

