/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v7.renderers;

import java.util.Set;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.output.PlanarSlice;
import pyrosim.domain.output.Slice;
import pyrosim.domain.output.VolumeSlice;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v7.FDS7Const;
import pyrosim.io.fds.v7.FDS7QuantityMap;
import pyrosim.io.fds.v7.renderers.AFDS7Renderer;
import thunderheadeng.units.UnitAABox;

public class SliceRenderer
extends AFDS7Renderer {
    private final FDS7QuantityMap d_quantityMap;

    public SliceRenderer(FDS7QuantityMap mmap) {
        this.d_quantityMap = mmap;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> types) {
        types.add(Slice.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer props, IPyroObject o) {
        Slice obj = (Slice)o;
        FDSRenderRecord rec = FDS7Const.newRenderRecord("SLCF");
        this.d_quantityMap.renderQuantity(rec, "QUANTITY", "PART_ID", "SPEC_ID", null, null, null, obj.getQuantity());
        rec.setValue("VECTOR", obj.includeFlowVector(), false);
        rec.setValue("CELL_CENTERED", obj.isCellCentered(), false);
        rec.setValue("ID", obj.getName(), false);
        if (obj instanceof PlanarSlice) {
            String planeName;
            PlanarSlice pslice = (PlanarSlice)obj;
            switch (pslice.getPlane()) {
                case 0: {
                    planeName = "PBX";
                    break;
                }
                case 1: {
                    planeName = "PBY";
                    break;
                }
                case 2: {
                    planeName = "PBZ";
                    break;
                }
                default: {
                    assert (false);
                    planeName = "";
                }
            }
            rec.setValue(planeName, pslice.getLocation());
        } else if (obj instanceof VolumeSlice) {
            VolumeSlice vslice = (VolumeSlice)obj;
            UnitAABox box = GeomUtil.getUnitBounds(vslice);
            SliceRenderer.renderXB(rec, "XB", box.getMin(), box.getMax());
        }
        props.render(rec, o);
        return true;
    }
}

