/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v7.renderers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.reaction.Reaction;
import pyrosim.domain.variant.Variant;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v7.FDS7Const;
import pyrosim.io.fds.v7.renderers.AFDS7Renderer;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.NameGenerator;
import thunderheadeng.util.theUtil;

public class ReactionRenderer
extends AFDS7Renderer {
    private final List<ExSpec> d_renderedSpec = new ArrayList<ExSpec>();

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> types) {
        types.add(Reaction.class);
        types.add(ExSpec.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer props, Collection<? extends IPyroObject> objs) {
        this.d_renderedSpec.addAll(theUtil.filter(objs, ExSpec.class));
        return super.render(props, theUtil.filter(objs, Reaction.class));
    }

    @Override
    public boolean render(IFDSRecordRenderer props, IPyroObject o) {
        Reaction obj = (Reaction)o;
        FDSRenderRecord rec = FDS7Const.newRenderRecord("REAC");
        rec.setValue("ID", obj.getName());
        rec.setValue("FYI", obj.getFYI(), false);
        if (obj.getReacType().equals((Object)Reaction.ReacType.SIMPLE)) {
            this.renderSimple(rec, obj);
        } else if (obj.getReacType().equals((Object)Reaction.ReacType.COMPLEX)) {
            this.renderComplex(rec, obj);
        }
        ReactionRenderer.renderCustomFDSProps(rec, obj);
        props.props().pushProps();
        props.props().setRenderMultiLine(true);
        props.render(rec, o);
        props.props().popProps();
        return true;
    }

    private void renderComplex(FDSRenderRecord rec, Reaction reac) {
        if (reac.getHeatOfCombustion().getType() == Variant.Type.CONSTANT) {
            rec.setValue("HEAT_OF_COMBUSTION", reac.getHeatOfCombustion().val, false);
        }
        rec.setValue("FUEL", reac.getFuel().getName());
        Map<ExSpec, Double> chem = reac.getComplexStoichiometry();
        ArrayList specsToRender = new ArrayList();
        ArrayList nuVals = new ArrayList();
        chem.entrySet().stream().sorted((kvPair1, kvPair2) -> ((Double)kvPair1.getValue()).compareTo((Double)kvPair2.getValue())).forEachOrdered(kvPair -> {
            specsToRender.add(((ExSpec)kvPair.getKey()).getName());
            nuVals.add((Double)kvPair.getValue());
        });
        rec.setValue("SPEC_ID_NU", specsToRender);
        rec.setValue("NU", nuVals);
    }

    private void renderSimple(FDSRenderRecord rec, Reaction reac) {
        this.renderFuel(rec, reac);
        if (reac.allowSuppression()) {
            this.renderSuppression(rec, reac);
        }
        this.renderByProducts(rec, reac);
    }

    private void renderFuel(FDSRenderRecord rec, Reaction reac) {
        if (reac.getFuel() != null) {
            rec.setValue("FUEL", reac.getFuel().getName());
        } else {
            String baseName = reac.getName() + "_" + Intl.intl("FUEL");
            NameGenerator nameGen = new NameGenerator("");
            for (ExSpec spec : this.d_renderedSpec) {
                nameGen.registerName(spec.getName());
            }
            nameGen.registerNames(ExSpecList.PREDEFINED.keySet());
            String generatedName = nameGen.generateValidName(baseName);
            nameGen.registerName(generatedName);
            rec.setValue("FUEL", generatedName);
        }
        int iC = (int)reac.getC();
        int iH = (int)reac.getH();
        int iO = (int)reac.getO();
        int iN = (int)reac.getN();
        if ((double)iC == reac.getC() && (double)iH == reac.getH() && (double)iO == reac.getO() && (double)iN == reac.getN()) {
            this.renderFormulaString(rec, iC, iH, iO, iN);
        } else {
            this.renderFormulaReals(rec, reac);
        }
    }

    private void renderFormulaString(FDSRenderRecord rec, int iC, int iH, int iO, int iN) {
        String formula = "";
        if (iC > 0) {
            String cFormula = String.format("C%d", iC);
            String string = formula = formula.length() > 0 ? formula.concat(cFormula) : cFormula;
        }
        if (iH > 0) {
            String hFormula = String.format("H%d", iH);
            String string = formula = formula.length() > 0 ? formula.concat(hFormula) : hFormula;
        }
        if (iO > 0) {
            String oFormula = String.format("O%d", iO);
            String string = formula = formula.length() > 0 ? formula.concat(oFormula) : oFormula;
        }
        if (iN > 0) {
            String nFormula = String.format("N%d", iN);
            String string = formula = formula.length() > 0 ? formula.concat(nFormula) : nFormula;
        }
        if (!formula.isEmpty()) {
            rec.setValue("FORMULA", formula);
        }
    }

    private void renderFormulaReals(FDSRenderRecord rec, Reaction reac) {
        rec.setValue("C", reac.getC(), false);
        rec.setValue("H", reac.getH(), false);
        rec.setValue("O", reac.getO(), false);
        rec.setValue("N", reac.getN(), false);
    }

    private void renderSuppression(FDSRenderRecord rec, Reaction reac) {
        rec.setValue("CRITICAL_FLAME_TEMPERATURE", reac.getCritFlameTemp(), false);
        if (reac.getAutoIgnitionTemp().getType() == Variant.Type.CONSTANT) {
            rec.setValue("AUTO_IGNITION_TEMPERATURE", reac.getAutoIgnitionTemp().val, false);
        }
    }

    private void renderByProducts(FDSRenderRecord rec, Reaction reac) {
        rec.setValue("CO_YIELD", reac.getCOYield(), false);
        rec.setValue("SOOT_YIELD", reac.getSootYield(), false);
        rec.setValue("HCN_YIELD", reac.getHCNYield(), false);
        if (reac.getEnergyType() == Reaction.EnergyRelease.EPUMO2) {
            rec.setValue("EPUMO2", reac.getEpumo2(), false);
        } else if (reac.getHeatOfCombustion().getType() == Variant.Type.CONSTANT) {
            rec.setValue("HEAT_OF_COMBUSTION", reac.getHeatOfCombustion().val, false);
        }
        if (reac.getRadiativeFraction().getType() != Variant.Type.DEFAULT) {
            rec.setValue("RADIATIVE_FRACTION", (UnitDouble)reac.getRadiativeFraction().val);
        }
        rec.setValue("IDEAL", reac.isIdeal(), false);
    }

    @Override
    public boolean markDependency(DepSnapshot deps, IPyroObject obj, boolean renderExplicit) {
        return !(obj instanceof ExSpec);
    }
}

