/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v7.renderers;

import java.util.Set;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.geom.PartCloud;
import pyrosim.domain.particle.Particle;
import pyrosim.geom.Geometry;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v7.FDS7Const;
import pyrosim.io.fds.v7.renderers.AFDS7UniqueRenderer;
import pyrosim.io.fds.v7.renderers.FDSNameMap;
import pyrosim.io.fds.v7.renderers.PinConnectionRenderer;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.units.UnitPoint3D;

public class PartCloudRenderer
extends AFDS7UniqueRenderer {
    private final PinConnectionRenderer d_pinConns;

    public PartCloudRenderer(FDSNameMap nameMap, PinConnectionRenderer pinConns) {
        super(nameMap);
        this.d_pinConns = pinConns;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> types) {
        types.add(PartCloud.class);
    }

    @Override
    protected boolean render(IFDSRecordRenderer props, IPyroObject o) {
        PartCloud obj = (PartCloud)o;
        if (obj.getParticle() == null) {
            return false;
        }
        FDSRenderRecord rec = FDS7Const.newRenderRecord("INIT");
        rec.setValue("ID", obj.getName());
        rec.setComment(obj.getDesc());
        rec.setValue("PART_ID", obj.getParticle().getName());
        IGeom geom = obj.getPartCloudGeom();
        PartCloudRenderer.renderCount(rec, obj, obj.getInitDrops());
        PartCloudRenderer.renderInsertion(rec, obj.getParticle(), obj.getInsertion(), geom);
        PartCloudRenderer.renderGeom(rec, obj, geom);
        PartCloudRenderer.renderCustomFDSProps(rec, obj);
        if (obj.getInsertion() instanceof PartCloud.InsertPeriodically) {
            this.d_pinConns.markForInputRetrieval(obj.getInputPin(), rec, "CTRL_ID", "DEVC_ID");
            this.d_pinConns.renderConnections(props, obj);
        } else {
            props.render(rec, obj);
        }
        return true;
    }

    private static void renderGeom(FDSRenderRecord rec, PartCloud cloud, IGeom geom) {
        if (geom instanceof AABoxGeom) {
            AABoxGeom box = (AABoxGeom)geom;
            PartCloudRenderer.renderXB(rec, "XB", box.min, box.max);
        } else if (geom instanceof Point) {
            Point p = (Point)geom;
            PartCloudRenderer.renderLoc(rec, "XYZ", new UnitPoint3D(p.loc, Geometry.LU));
        }
    }

    private static void renderCount(FDSRenderRecord rec, PartCloud cloud, PartCloud.IDropletCount count) {
        if (count instanceof PartCloud.PerCellCount) {
            PartCloud.PerCellCount pc = (PartCloud.PerCellCount)count;
            rec.setValue("N_PARTICLES_PER_CELL", pc.partPerCell, false);
            rec.setValue("CELL_CENTERED", pc.cellCentered, false);
        } else {
            rec.setValue("N_PARTICLES", count.getNumDrops(cloud), false);
        }
    }

    private static void renderInsertion(FDSRenderRecord rec, Particle particle, PartCloud.IInsertion insertion, IGeom geom) {
        boolean massless = particle.isType(Particle.Type.TRACER);
        if (insertion instanceof PartCloud.InsertOnce) {
            PartCloud.InsertOnce ionce = (PartCloud.InsertOnce)insertion;
            if (!massless && !(geom instanceof Point)) {
                rec.setValue("MASS_PER_VOLUME", ionce.massPerVolume, false);
            }
        } else if (insertion instanceof PartCloud.InsertPeriodically) {
            PartCloud.InsertPeriodically iper = (PartCloud.InsertPeriodically)insertion;
            rec.setValue("DT_INSERT", iper.dt, true);
            if (!massless) {
                rec.setValue("MASS_PER_TIME", iper.massPerTime, true);
            }
        }
    }
}

