/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v7.renderers;

import java.util.Set;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.evac.Evss;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v7.FDS7Const;
import pyrosim.io.fds.v7.renderers.AFDS7Renderer;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class EvssRenderer
extends AFDS7Renderer {
    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> types) {
        types.add(Evss.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer props, IPyroObject o) {
        Evss obj = (Evss)o;
        FDSRenderRecord rec = FDS7Const.newRenderRecord("EVSS");
        rec.setValue("ID", obj.getName());
        rec.setValue("FYI", obj.getProp("FYI"), false);
        UnitDouble[] xb = (UnitDouble[])obj.getProp("XB");
        UnitAABox xbBox = new UnitAABox(new UnitPoint3D(xb[0], xb[2], xb[4]), new UnitPoint3D(xb[1], xb[3], xb[5]));
        EvssRenderer.renderXB(rec, "XB", xbBox.getMin(), xbBox.getMax());
        rec.setValue("IOR", obj.getProp("IOR"), false);
        Grid meshId = (Grid)obj.getProp("MESH_ID");
        if (meshId != null) {
            rec.setValue("MESH_ID", meshId.getName());
        }
        rec.setValue("HEIGHT", obj.getProp("HEIGHT"), false);
        rec.setValue("HEIGHT0", obj.getProp("HEIGHT0"), false);
        rec.setValue("FAC_V0_UP", obj.getProp("FAC_V0_UP"), false);
        rec.setValue("FAC_V0_DOWN", obj.getProp("FAC_V0_DOWN"), false);
        rec.setValue("FAC_V0_HORI", obj.getProp("FAC_V0_HORI"), false);
        rec.setValue("ESC_SPEED", obj.getProp("ESC_SPEED"), false);
        props.render(rec, o);
        return true;
    }
}

