/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v7.renderers;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.evac.Evac;
import pyrosim.domain.evac.Pers;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v7.FDS7Const;
import pyrosim.io.fds.v7.renderers.AFDS7Renderer;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class EvacRenderer
extends AFDS7Renderer {
    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> types) {
        types.add(Evac.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer props, IPyroObject o) {
        Map knownDoors;
        Evac obj = (Evac)o;
        FDSRenderRecord rec = FDS7Const.newRenderRecord("EVAC");
        rec.setValue("ID", obj.getName());
        rec.setValue("FYI", obj.getProp("FYI"), false);
        UnitDouble[] xb = (UnitDouble[])obj.getProp("XB");
        UnitAABox xbBox = new UnitAABox(new UnitPoint3D(xb[0], xb[2], xb[4]), new UnitPoint3D(xb[1], xb[3], xb[5]));
        EvacRenderer.renderXB(rec, "XB", xbBox.getMin(), xbBox.getMax());
        Grid meshId = (Grid)obj.getProp("MESH_ID");
        if (meshId != null) {
            rec.setValue("MESH_ID", meshId.getName());
        }
        rec.setValue("NUMBER_INITIAL_PERSONS", obj.getProp("NUMBER_INITIAL_PERSONS"));
        Pers persId = (Pers)obj.getProp("PERS_ID");
        if (persId != null) {
            rec.setValue("PERS_ID", persId.getName());
        }
        rec.setValue("ANGLE", obj.getProp("ANGLE"));
        EvacRenderer.renderColor(rec, true, (Color)obj.getProp("AVATAR_RGB"), "AVATAR_RGB", "AVATAR_COLOR", null);
        Grid flowFieldId = (Grid)obj.getProp("FLOW_FIELD_ID");
        if (flowFieldId != null) {
            rec.setValue("FLOW_FIELD_ID", flowFieldId.getName());
        }
        if ((knownDoors = (Map)obj.getProp("KNOWN_DOOR_PROBS")) != null && !knownDoors.isEmpty()) {
            ArrayList<String> doorNames = new ArrayList<String>();
            ArrayList<Double> doorProbs = new ArrayList<Double>();
            for (NamedPyroObject door : knownDoors.keySet()) {
                doorNames.add(door.getName());
                doorProbs.add((Double)knownDoors.get(door));
            }
            rec.setValue("KNOWN_DOOR_NAMES", doorNames);
            rec.setValue("KNOWN_DOOR_PROBS", doorProbs);
        }
        props.render(rec, o);
        return true;
    }
}

