/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v7.renderers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.controls.CustomCtrl;
import pyrosim.domain.controls.DeadbandCtrl;
import pyrosim.domain.controls.IControl;
import pyrosim.domain.controls.LatchCtrl;
import pyrosim.domain.controls.LogicOps.ADblCompareOp;
import pyrosim.domain.controls.LogicOps.AIntCompareOp;
import pyrosim.domain.controls.LogicOps.AndOp;
import pyrosim.domain.controls.LogicOps.DblGreaterThanOp;
import pyrosim.domain.controls.LogicOps.DblLessThanOp;
import pyrosim.domain.controls.LogicOps.IntEqualOp;
import pyrosim.domain.controls.LogicOps.IntGreaterThanOp;
import pyrosim.domain.controls.LogicOps.IntLessThanOp;
import pyrosim.domain.controls.LogicOps.IntNotEqualOp;
import pyrosim.domain.controls.LogicOps.NotOp;
import pyrosim.domain.controls.LogicOps.OrOp;
import pyrosim.domain.controls.ManualCtrl;
import pyrosim.domain.controls.MathOps.AMathOp;
import pyrosim.domain.controls.MathOps.ArcCosOp;
import pyrosim.domain.controls.MathOps.ArcSinOp;
import pyrosim.domain.controls.MathOps.ArcTanOp;
import pyrosim.domain.controls.MathOps.ConstantMathSource;
import pyrosim.domain.controls.MathOps.CosOp;
import pyrosim.domain.controls.MathOps.CountOp;
import pyrosim.domain.controls.MathOps.DivideOp;
import pyrosim.domain.controls.MathOps.ExpOp;
import pyrosim.domain.controls.MathOps.LogOp;
import pyrosim.domain.controls.MathOps.MaxOp;
import pyrosim.domain.controls.MathOps.MinOp;
import pyrosim.domain.controls.MathOps.MultiplyOp;
import pyrosim.domain.controls.MathOps.PIDControllerOp;
import pyrosim.domain.controls.MathOps.PercentileOp;
import pyrosim.domain.controls.MathOps.PowerOp;
import pyrosim.domain.controls.MathOps.SinOp;
import pyrosim.domain.controls.MathOps.SubtractOp;
import pyrosim.domain.controls.MathOps.SumOp;
import pyrosim.domain.controls.TimeDelayCtrl;
import pyrosim.domain.devices.AlarmInfo;
import pyrosim.domain.devices.TripFlags;
import pyrosim.domain.ramp.IRampInput;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v7.renderers.AFDS7UniqueRenderer;
import pyrosim.io.fds.v7.renderers.FDSNameMap;
import pyrosim.io.fds.v7.renderers.PinConnectionRenderer;
import pyrosim.io.fds.v7.renderers.RampRenderer;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class ControlRenderer
extends AFDS7UniqueRenderer {
    private final PinConnectionRenderer d_pinConnections;

    public ControlRenderer(FDSNameMap nameMap, PinConnectionRenderer pinConns) {
        super(nameMap);
        this.d_pinConnections = pinConns;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> types) {
        types.add(IControl.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer props, IPyroObject c) {
        IControl obj = (IControl)c;
        if (obj.isWire() || obj instanceof CountOp) {
            return false;
        }
        if (obj instanceof ManualCtrl) {
            this.renderManualCtrl(props, (ManualCtrl)obj);
        } else {
            String id = obj.getName();
            if (id != null) {
                LinkedHashMap<String, Ramp> ramps = new LinkedHashMap<String, Ramp>();
                FDSRenderRecord rec = this.newControlRec(obj);
                if (rec != null) {
                    this.render(rec, obj, ramps);
                }
                RampRenderer.render(props, ramps, this.d_pinConnections);
            }
        }
        return false;
    }

    private boolean render(FDSRenderRecord rec, IControl obj, Map<String, Ramp> ramps) {
        if (!(obj instanceof CountOp)) {
            if (obj instanceof IntGreaterThanOp) {
                this.renderIntGreaterThanOp(rec, (IntGreaterThanOp)obj);
            } else if (obj instanceof IntLessThanOp) {
                this.renderIntLessThanOp(rec, (IntLessThanOp)obj);
            } else if (obj instanceof IntEqualOp) {
                this.renderIntEqualOp(rec, (IntEqualOp)obj);
            } else if (obj instanceof IntNotEqualOp) {
                this.renderIntNotEqualOp(rec, (IntNotEqualOp)obj);
            } else if (obj instanceof DblGreaterThanOp) {
                this.renderDblCompareOp(rec, ramps, (DblGreaterThanOp)obj, false);
            } else if (obj instanceof DblLessThanOp) {
                this.renderDblCompareOp(rec, ramps, (DblLessThanOp)obj, true);
            } else if (obj instanceof AndOp) {
                this.renderAndOp(rec, (AndOp)obj);
            } else if (obj instanceof OrOp) {
                this.renderOrOp(rec, (OrOp)obj);
            } else if (obj instanceof NotOp) {
                this.renderNotOp(rec, (NotOp)obj, ramps);
            } else if (obj instanceof LatchCtrl) {
                this.renderLatchCtrl(rec, (LatchCtrl)obj, ramps);
            } else if (obj instanceof CustomCtrl) {
                this.renderCustomCtrl(rec, ramps, (CustomCtrl)obj);
            } else if (obj instanceof TimeDelayCtrl) {
                this.renderTimeDelayCtrl(rec, (TimeDelayCtrl)obj);
            } else if (obj instanceof DeadbandCtrl) {
                this.renderDeadbandCtrl(rec, (DeadbandCtrl)obj);
            } else if (obj instanceof SumOp) {
                this.renderAMathOp(rec, (AMathOp)obj, "SUM");
            } else if (obj instanceof MaxOp) {
                this.renderAMathOp(rec, (AMathOp)obj, "MAX");
            } else if (obj instanceof MinOp) {
                this.renderAMathOp(rec, (AMathOp)obj, "MIN");
            } else if (obj instanceof SubtractOp) {
                this.renderAMathOp(rec, (AMathOp)obj, "SUBTRACT");
            } else if (obj instanceof MultiplyOp) {
                this.renderAMathOp(rec, (AMathOp)obj, "MULTIPLY");
            } else if (obj instanceof DivideOp) {
                this.renderAMathOp(rec, (AMathOp)obj, "DIVIDE");
            } else if (obj instanceof PowerOp) {
                this.renderAMathOp(rec, (AMathOp)obj, "POWER");
            } else if (obj instanceof ExpOp) {
                this.renderAMathOp(rec, (AMathOp)obj, "EXP");
            } else if (obj instanceof LogOp) {
                this.renderAMathOp(rec, (AMathOp)obj, "LOG");
            } else if (obj instanceof CosOp) {
                this.renderAMathOp(rec, (AMathOp)obj, "COS");
            } else if (obj instanceof ArcCosOp) {
                this.renderAMathOp(rec, (AMathOp)obj, "ACOS");
            } else if (obj instanceof SinOp) {
                this.renderAMathOp(rec, (AMathOp)obj, "SIN");
            } else if (obj instanceof ArcSinOp) {
                this.renderAMathOp(rec, (AMathOp)obj, "ASIN");
            } else if (obj instanceof ArcTanOp) {
                this.renderAMathOp(rec, (AMathOp)obj, "ATAN");
            } else if (obj instanceof PercentileOp) {
                this.renderPercentileOp(rec, (PercentileOp)obj);
            } else if (obj instanceof PIDControllerOp) {
                this.renderPIDController(rec, (PIDControllerOp)obj);
            } else assert (false);
        }
        return false;
    }

    public void renderManualCtrl(IFDSRecordRenderer props, ManualCtrl ctrl) {
        FDSRenderRecord rec = this.newControlRec(ctrl);
        if (rec != null) {
            rec.setCustomText(ctrl.getFDSText());
            props.render(rec, ctrl);
        }
    }

    public void renderDeadbandCtrl(FDSRenderRecord rec, DeadbandCtrl ctrl) {
        rec.setValue("FUNCTION_TYPE", "DEADBAND");
        IDoubleOutPin outPin = this.getDoubleInput(ctrl);
        if (outPin != null) {
            Unit unit = SIUS.unit(outPin.getUnitType());
            ArrayList<Double> bounds = new ArrayList<Double>(2);
            bounds.add(ctrl.getLowerBound().getValue(unit));
            bounds.add(ctrl.getUpperBound().getValue(unit));
            rec.setValue("SETPOINT", bounds, false);
        }
        String onBoundVal = ctrl.getTripDirection() == 0 ? "LOWER" : "UPPER";
        rec.setValue("ON_BOUND", onBoundVal);
        rec.setValue("INITIAL_STATE", false, false);
        rec.setValue("LATCH", false, false);
        this.markInputs(rec, ctrl);
    }

    public void renderTimeDelayCtrl(FDSRenderRecord rec, TimeDelayCtrl ctrl) {
        rec.setValue("FUNCTION_TYPE", "TIME_DELAY");
        rec.setValue("DELAY", ctrl.getTimeDelay());
        rec.setValue("LATCH", ctrl.latches(null), false);
        rec.setValue("INITIAL_STATE", false, false);
        this.markInputs(rec, ctrl);
    }

    public void renderCustomCtrl(FDSRenderRecord rec, Map<String, Ramp> ramps, CustomCtrl ctrl) {
        Ramp ramp = this.newCustomRamp(ctrl, !ctrl.getInitialState(), ctrl.getTripValues());
        this.renderCustomRecord(rec, ctrl, ramp, ramps);
    }

    public void renderDblCompareOp(FDSRenderRecord rec, Map<String, Ramp> ramps, ADblCompareOp op, boolean lessThan) {
        Ramp ramp = this.newCustomRamp(op, !lessThan, Arrays.asList(op.getN()));
        this.renderCustomRecord(rec, op, ramp, ramps);
    }

    private FDSRenderRecord renderCustomRecord(FDSRenderRecord rec, IControl ctrl, Ramp ramp, Map<String, Ramp> ramps) {
        rec.setValue("FUNCTION_TYPE", "CUSTOM");
        if (ramp != null) {
            String rampID = RampRenderer.createID(this.getNameMap(), (String)rec.get("ID"), "RAMP");
            ramps.put(rampID, ramp);
            rec.setValue("RAMP_ID", rampID);
        }
        rec.setValue("LATCH", false, false);
        rec.setValue("INITIAL_STATE", false, false);
        this.markInputs(rec, ctrl);
        return rec;
    }

    private IDoubleOutPin getDoubleInput(IControl ctrl) {
        Set<? extends IOutPin> outPins = ctrl.getInputPin().getConnections();
        if (outPins.size() != 1 || !(outPins.iterator().next() instanceof IDoubleOutPin)) {
            return null;
        }
        return (IDoubleOutPin)outPins.iterator().next();
    }

    private Ramp newCustomRamp(IControl ctrl, boolean initiallyOff, Collection<UnitDouble> crossVals) {
        if (crossVals.isEmpty()) {
            return null;
        }
        IDoubleOutPin outPin = this.getDoubleInput(ctrl);
        if (outPin == null) {
            return null;
        }
        final int unitType = outPin.getUnitType();
        Unit unit = SIUS.unit(unitType);
        IRampInput rampInput = new IRampInput(){
            private static final long serialVersionUID = 2846399992315901851L;

            @Override
            public String getName() {
                return "";
            }

            @Override
            public int getUnitType() {
                return unitType;
            }

            @Override
            public String getTVar() {
                return "T";
            }
        };
        double inc = 0.25;
        if (crossVals.size() == 1) {
            double crossVal = crossVals.iterator().next().getValue(unit);
            float smallestInc = theUtil.floatResolution((float)crossVal);
            if (smallestInc > (float)inc) {
                inc = (double)smallestInc * 4.0;
            }
        } else {
            double smallestDiff = 1.0;
            Iterator<UnitDouble> crossit = crossVals.iterator();
            double lastCross = crossit.next().getValue(unit);
            while (crossit.hasNext()) {
                double currCross = crossit.next().getValue(unit);
                double diff = currCross - lastCross;
                assert (diff > 0.0);
                if (diff < smallestDiff) {
                    smallestDiff = diff;
                }
                lastCross = currCross;
            }
            inc = smallestDiff * 0.25;
        }
        boolean lastState = !initiallyOff;
        ArrayList<Ramp.Entry> entries = new ArrayList<Ramp.Entry>(crossVals.size() * 2);
        for (UnitDouble crossVal : crossVals) {
            double val = crossVal.getValue(unit);
            UnitDouble stateBefore = this.customStateToRampVal(lastState);
            entries.add(new Ramp.Entry(new UnitDouble(val - inc, unit), stateBefore));
            lastState = !lastState;
            UnitDouble stateAfter = this.customStateToRampVal(lastState);
            entries.add(new Ramp.Entry(new UnitDouble(val + inc, unit), stateAfter));
        }
        return new Ramp(entries, rampInput, 28);
    }

    private UnitDouble customStateToRampVal(boolean state) {
        return state ? new UnitDouble(1.0, Unit.ONE) : new UnitDouble(-1.0, Unit.ONE);
    }

    public void renderIntGreaterThanOp(FDSRenderRecord rec, IntGreaterThanOp op) {
        this.renderIntCompareOp(rec, op, "AT_LEAST", op.getN() + 1, false);
    }

    public void renderIntLessThanOp(FDSRenderRecord rec, IntLessThanOp op) {
        this.renderIntCompareOp(rec, op, "AT_LEAST", op.getN(), true);
    }

    public void renderIntEqualOp(FDSRenderRecord rec, IntEqualOp op) {
        this.renderIntCompareOp(rec, op, "ONLY", op.getN(), false);
    }

    public void renderIntNotEqualOp(FDSRenderRecord rec, IntNotEqualOp op) {
        this.renderIntCompareOp(rec, op, "ONLY", op.getN(), true);
    }

    private void renderIntCompareOp(FDSRenderRecord rec, AIntCompareOp op, String controlType, int value, boolean invert) {
        rec.setValue("FUNCTION_TYPE", controlType);
        rec.setValue("N", value, true);
        rec.setValue("LATCH", op.latches(null), false);
        rec.setValue("INITIAL_STATE", invert, false);
        Set<ISignalSource> sources = op.getInputPin().getConnectedSources();
        if (sources.size() == 1) {
            ISignalSource source = sources.iterator().next();
            if (!(source instanceof CountOp)) assert (false);
            CountOp summer = (CountOp)source;
            this.markInputs(rec, summer);
        }
    }

    public void renderAndOp(FDSRenderRecord rec, AndOp op) {
        this.renderLogicRecord(rec, op, "ALL", op.latches(null));
    }

    public void renderOrOp(FDSRenderRecord rec, OrOp op) {
        this.renderLogicRecord(rec, op, "ANY", op.latches(null));
    }

    public void renderNotOp(FDSRenderRecord rec, NotOp ctrl, Map<String, Ramp> ramps) {
        this.renderLogicRecord(rec, ctrl, "ALL", ctrl.latches(null));
        rec.setValue("INITIAL_STATE", true);
    }

    public void renderLatchCtrl(FDSRenderRecord rec, LatchCtrl ctrl, Map<String, Ramp> ramps) {
        assert (false) : "LatchCtrls should no longer be present in PyroSim models";
        this.renderLogicRecord(rec, ctrl, "ALL", ctrl.latches(null));
        rec.setValue("LATCH", true);
    }

    private FDSRenderRecord renderLogicRecord(FDSRenderRecord rec, IControl ctrl, String controlType, boolean latches) {
        rec.setValue("FUNCTION_TYPE", controlType);
        rec.setValue("INITIAL_STATE", false, false);
        rec.setValue("LATCH", latches, false);
        this.markInputs(rec, ctrl);
        return rec;
    }

    private void renderPercentileOp(FDSRenderRecord rec, PercentileOp op) {
        this.renderAMathOp(rec, op, "PERCENTILE");
        rec.setValue("PERCENTILE", op.getPercentile());
    }

    private void renderPIDController(FDSRenderRecord rec, PIDControllerOp op) {
        this.renderAMathOp(rec, op, "PID");
        rec.setValue("PROPORTIONAL_GAIN", op.getProportionalGain());
        rec.setValue("INTEGRAL_GAIN", op.getIntegralGain());
        rec.setValue("DIFFERENTIAL_GAIN", op.getDerivativeGain());
        rec.setValue("TARGET_VALUE", op.getTargetValue());
    }

    private void renderAMathOp(FDSRenderRecord rec, AMathOp ctrl, String controlType) {
        rec.setValue("FUNCTION_TYPE", controlType);
        rec.setValue("INITIAL_STATE", false, false);
        ConstantMathSource constPin = this.getConstInputPin(ctrl);
        if (constPin != null) {
            rec.setValue("CONSTANT", constPin.getConstInput());
        }
        this.renderAlarm(rec, ctrl.getMeasureInfo().getAlarmInfo());
        this.markInputs(rec, ctrl);
    }

    private void renderAlarm(FDSRenderRecord rec, AlarmInfo ai) {
        if (ai != null) {
            Double setpoint = ai.setpoint.getValue(SIUS.unit(28));
            rec.setValue("SETPOINT", Arrays.asList(setpoint), true);
            this.renderTripFlags(rec, ai.tripFlags);
        }
    }

    private void renderTripFlags(FDSRenderRecord rec, int tripFlags) {
        rec.setValue("INITIAL_STATE", TripFlags.initiallyOn(tripFlags));
        rec.setValue("LATCH", TripFlags.latch(tripFlags));
        int tripDirection = TripFlags.tripDirDescending(tripFlags) ? -1 : 1;
        rec.setValue("TRIP_DIRECTION", tripDirection, false);
    }

    private ConstantMathSource getConstInputPin(AMathOp mathOp) {
        Set<ISignalSource> sources = mathOp.getInputPin().getConnectedSources();
        for (ISignalSource source : sources) {
            if (!(source instanceof ConstantMathSource)) continue;
            this.d_pinConnections.generateRecord("CONSTANT", "CONSTANT", source.getOutputPins().iterator().next());
            return (ConstantMathSource)source;
        }
        return null;
    }

    private void markInputs(FDSRenderRecord rec, ISignalSink sink) {
        this.d_pinConnections.markForInputRetrieval(sink.getInputPin(), rec, "INPUT_ID", "INPUT_ID");
    }

    private FDSRenderRecord newControlRec(ISignalSource ctrl) {
        IOutPin outPin = ctrl.getOutputPins().get(0);
        Pair<FDSRenderRecord, Boolean> res = this.d_pinConnections.generateRecord("CTRL", "ID", outPin);
        if (!((Boolean)res.v2).booleanValue()) {
            return null;
        }
        return (FDSRenderRecord)res.v1;
    }
}

