/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v7.renderers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.rasterization.FDSObjectRasterization;
import pyrosim.domain.rasterization.FDSRasterization;
import pyrosim.domain.rasterization.FaceProps;
import pyrosim.domain.rasterization.RasterizationOptions;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v7.renderers.AFDS7Renderer;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.util.Pair;

public abstract class AFDSObjRenderer<T extends FDSObject>
extends AFDS7Renderer {
    private final FDSRasterization d_raster;

    public AFDSObjRenderer(FDSRasterization raster) {
        this.d_raster = raster;
    }

    @Override
    public boolean render(IFDSRecordRenderer props, Collection<? extends IPyroObject> objs) {
        RasterizationOptions options = this.d_raster.getRastOptions();
        if (options.mergeIdentical) {
            return this.renderMerged(props, objs);
        }
        return super.render(props, objs);
    }

    protected abstract boolean renderBlock(IFDSRecordRenderer var1, T var2);

    protected abstract boolean renderBlock(IFDSRecordRenderer var1, AABoxGeom var2, Collection<T> var3, FaceProps[] var4);

    private boolean renderMerged(IFDSRecordRenderer props, Collection<? extends IPyroObject> objs) {
        FDSObjectRasterization[] rasts;
        boolean modified = false;
        ArrayList<FDSObject> toRast = new ArrayList<FDSObject>();
        for (IPyroObject iPyroObject : objs) {
            FDSObject fdsobj = (FDSObject)iPyroObject;
            if (!this.d_raster.shouldRasterize(fdsobj)) {
                modified |= this.renderBlock(props, fdsobj);
                continue;
            }
            toRast.add(fdsobj);
        }
        for (FDSObjectRasterization rast : rasts = this.d_raster.rasterize(toRast)) {
            List srcs = rast.sources.stream().map(o -> o).collect(Collectors.toList());
            for (Pair<IGeom, FaceProps[]> pair : rast.geoms) {
                modified |= this.renderBlock(props, AFDSObjRenderer.toBlock((IGeom)pair.v1), srcs, (FaceProps[])pair.v2);
            }
        }
        return modified;
    }

    @Override
    protected boolean render(IFDSRecordRenderer props, IPyroObject obj) {
        FDSObject fdsobj = (FDSObject)obj;
        if (!this.d_raster.shouldRasterize(fdsobj)) {
            return this.renderBlock(props, fdsobj);
        }
        boolean modified = false;
        FDSObjectRasterization rast = this.d_raster.rasterize(fdsobj);
        Set<FDSObject> srcs = Collections.singleton(fdsobj);
        for (Pair<IGeom, FaceProps[]> pair : rast.geoms) {
            modified |= this.renderBlock(props, AFDSObjRenderer.toBlock((IGeom)pair.v1), srcs, (FaceProps[])pair.v2);
        }
        return modified;
    }

    protected static AABoxGeom toBlock(IGeom geom) {
        if (geom instanceof AABoxGeom) {
            return (AABoxGeom)geom;
        }
        AABox bb = geom.getBoundingBox(new AABox());
        return new AABoxGeom(bb.getMin(), bb.getMax());
    }
}

