/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v7.parsers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.geom.Geometry;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v7.parsers.AFDSObjParser;
import pyrosim.io.fds.v7.parsers.FDS7ParsingInfo;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.IdentityXform;
import thunderheadeng.geometry.objs.transform.MatrixXform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.units.UnitDouble;

public class MoveParser
extends AFDSObjParser {
    private final Map<String, ITransform> d_components = new HashMap<String, ITransform>();

    public MoveParser(FDS7ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    public ITransform getTransform(String id) {
        return this.d_components.get(id);
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("MOVE");
    }

    @Override
    public void getUnsupportedFields(String type, Map<String, String> unsupportedFields) {
    }

    @Override
    protected boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        String id = rec.getString("ID");
        if (!this.checkName(rec, id)) {
            return false;
        }
        if (this.d_components.containsKey(id)) {
            this.addWarning(rec, String.format(Intl.intl("&MOVE ID %s has already been used."), id), Intl.intl("Ignoring duplicate MOVE record."));
            return false;
        }
        List transMatrix = rec.getList("T34", true);
        if (!transMatrix.isEmpty()) {
            Matrix4d matrix = new Matrix4d((Double)transMatrix.get(0), (Double)transMatrix.get(3), (Double)transMatrix.get(6), (Double)transMatrix.get(9), (Double)transMatrix.get(1), (Double)transMatrix.get(4), (Double)transMatrix.get(7), (Double)transMatrix.get(10), (Double)transMatrix.get(2), (Double)transMatrix.get(5), (Double)transMatrix.get(8), (Double)transMatrix.get(11), 0.0, 0.0, 0.0, 1.0);
            ITransform xform = new MatrixXform(matrix);
            if (xform.isIdentity()) {
                xform = IdentityXform.INSTANCE;
            }
            this.d_components.put(id, xform);
        } else {
            FDSArray scale = MoveParser.parseScale(rec);
            FDSArray gaxis = rec.getArray("AXIS", true);
            Vector3d axis = new Vector3d((Double)gaxis.get(0), (Double)gaxis.get(1), (Double)gaxis.get(2));
            if (Util3D.safeNormalize(axis, 0.0) == 0.0) {
                this.addWarning(rec, Intl.intl("The specified axis of rotation is approximately zero."), Intl.intl("The resulting transformation may behave unexpectedly."));
            }
            Vector3d xyz = MoveParser.getOffset(rec, "DX", "DY", "DZ");
            Vector3d xyz0 = MoveParser.getOffset(rec, "X0", "Y0", "Z0");
            double grotate = rec.getUnitDouble("ROTATION_ANGLE", true).get(Geometry.AU);
            ITransform xform = TransformUtil.translate(xyz.x, xyz.y, xyz.z).concatenate(TransformUtil.translate(xyz0.x, xyz0.y, xyz0.z)).concatenate(TransformUtil.rotate(axis.x, axis.y, axis.z, grotate)).concatenate(TransformUtil.scale((Double)scale.get(0), (Double)scale.get(1), (Double)scale.get(2))).concatenate(TransformUtil.translate(-xyz0.x, -xyz0.y, -xyz0.z));
            this.d_components.put(id, xform);
        }
        return true;
    }

    private static Vector3d getOffset(FDSParseRecord rec, String xkey, String ykey, String zkey) {
        FDSArray<UnitDouble> offset = new FDSArray<UnitDouble>(rec.getUnitDouble(xkey), rec.getUnitDouble(ykey), rec.getUnitDouble(zkey));
        return new Vector3d(offset.get(0) != null ? offset.get(0).get(Geometry.LU) : 0.0, offset.get(1) != null ? offset.get(1).get(Geometry.LU) : 0.0, offset.get(2) != null ? offset.get(2).get(Geometry.LU) : 0.0);
    }

    private static FDSArray parseScale(FDSParseRecord rec) throws FDSRecordFormatException {
        Double scaleAllDir = rec.getDouble("SCALE");
        if (scaleAllDir != null) {
            return new FDSArray<Double>(scaleAllDir, scaleAllDir, scaleAllDir);
        }
        Double scaleX = rec.getDouble("SCALEX");
        Double scaleY = rec.getDouble("SCALEY");
        Double scaleZ = rec.getDouble("SCALEZ");
        if (scaleX != null && scaleY != null && scaleZ != null) {
            return new FDSArray<Double>(scaleX, scaleY, scaleZ);
        }
        Double[] def = new Double[]{1.0, 1.0, 1.0};
        return new FDSArray<Double>(def);
    }
}

