/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v7.parsers;

import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.domain.geom.Hole;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v7.parsers.AFDSObjParser;
import pyrosim.io.fds.v7.parsers.FDS7ParsingInfo;
import pyrosim.io.fds.v7.parsers.PinConnParser;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.util.Pair;

public class HoleParser
extends AFDSObjParser {
    private final PinConnParser d_pinConns;

    public HoleParser(FDS7ParsingInfo parsingInfo, PinConnParser pinConns) {
        super(parsingInfo);
        this.d_pinConns = pinConns;
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("HOLE");
    }

    @Override
    public void getUnsupportedFields(String type, Map<String, String> unsupportedFields) {
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        String name = this.generateName(rec, "ID", Intl.intl("Hole"));
        AABoxGeom geom = this.parseXBGeom(rec, "HOLE", "XB", true);
        Hole hole = new Hole(name, GeomNodeUtil.newNode(geom));
        Color color = this.parseColor(rec, "RGB", "COLOR", "TRANSPARENCY", false);
        if (color == INVISIBLE_COLOR) {
            hole.setVisible(false);
            hole.setColors(new Color[]{null});
        } else {
            hole.setColors(color);
        }
        hole.setEvac(this.parseEvac(rec, "EVACUATION", "MESH_ID"));
        HoleParser.markSingleInputForRetrieval(rec, hole, this.d_pinConns, "DEVC_ID", "CTRL_ID");
        this.parseCustomFDSProps(hole, rec);
        Pair<String, List<Hole>> holes = this.applyMult(rec, "MULT_ID", hole);
        this.addObjects((String)holes.v1, (List)holes.v2);
        return true;
    }
}

