/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v7.parsers;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.boundcond.surf.DefaultSurface;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.Obstruction;
import pyrosim.geom.Geometry;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSParseWarning;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v7.parsers.AFDSObjParser;
import pyrosim.io.fds.v7.parsers.FDS7ParsingInfo;
import pyrosim.io.fds.v7.parsers.MoveParser;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.ExtrudedPoly;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.SolidGeom;
import thunderheadeng.geometry.objs.elem.ElementMesh;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeLeaf;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.io.LEDataInputStream;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.theUtil;

public class GeomParser
extends AFDSObjParser {
    private final Map<String, Pair<IGeomNode, Surface[]>> d_components = new LinkedHashMap<String, Pair<IGeomNode, Surface[]>>();
    private final MoveParser d_move;
    private List<MeshData> d_meshes = new ArrayList<MeshData>();

    public GeomParser(FDS7ParsingInfo parsingInfo, MoveParser move) {
        super(parsingInfo);
        this.d_move = move;
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("GEOM");
        types.add("MESH");
    }

    @Override
    public void getUnsupportedFields(String type, Map<String, String> unsupportedFields) {
    }

    @Override
    protected boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        if (rec.getType().equals("MESH")) {
            UnitPoint3D[] meshXB = GeomParser.parseXB(rec, "MESH", "XB", true);
            FDSArray<Integer> meshIJK = rec.getArray("IJK", true);
            this.d_meshes.add(new MeshData(meshIJK, meshXB));
            return true;
        }
        String id = rec.getString("ID");
        if (id == null) {
            id = "Geom";
        }
        IGeom geom = EmptyGeom.INSTANCE;
        Surface[] surfs = new Surface[]{};
        IPropertySet elements = Elements.newElements();
        if (GeomParser.isBinGeom(rec)) {
            Pair<IGeom, Surface[]> binResult = this.parseBinaryFile(rec, elements);
            geom = (IGeom)binResult.v1;
            surfs = (Surface[])binResult.v2;
        } else if (GeomParser.isBlock(rec)) {
            Pair<IGeom, Surface[]> blockResult = this.parseBlock(rec);
            geom = (IGeom)blockResult.v1;
            surfs = (Surface[])blockResult.v2;
        } else if (GeomParser.isSphere(rec)) {
            Pair<IGeom, Surface[]> sphereResult = this.parseSphere(rec, elements);
            geom = (IGeom)sphereResult.v1;
            surfs = (Surface[])sphereResult.v2;
            elements.set(Elements.CREASE, Elements.NO_CREASE);
        } else if (GeomParser.isCylinder(rec)) {
            Pair<IGeom, Surface[]> cylinderResult = this.parseCylinder(rec, elements);
            geom = (IGeom)cylinderResult.v1;
            surfs = (Surface[])cylinderResult.v2;
        } else if (GeomParser.isTerrainWithZvals(rec)) {
            Pair<IGeom, Surface[]> terrainWithZvals = this.parseXYZTerrain(rec, elements);
            geom = (IGeom)terrainWithZvals.v1;
            surfs = (Surface[])terrainWithZvals.v2;
        } else if (GeomParser.isTerrainWithVertsandFaces(rec)) {
            Pair<IGeom, Surface[]> terrainWithVertsFaces = this.parseTerrainFaces(rec, elements);
            geom = (IGeom)terrainWithVertsFaces.v1;
            surfs = (Surface[])terrainWithVertsFaces.v2;
        } else if (GeomParser.isExtrudedPoly(rec)) {
            Pair<IGeom, Surface[]> extrudedPolyResult = this.parseExtrudedPolygon(rec);
            geom = (IGeom)extrudedPolyResult.v1;
            surfs = (Surface[])extrudedPolyResult.v2;
        } else {
            Pair<IGeom, Surface[]> unstructuredSolid = this.parseUnstructuredSolid(rec, elements);
            geom = (IGeom)unstructuredSolid.v1;
            surfs = (Surface[])unstructuredSolid.v2;
        }
        ITransform xform = TransformUtil.IDENTITY;
        String idMove = rec.getString("MOVE_ID");
        if (idMove != null && (xform = this.d_move.getTransform(idMove)) == null) {
            this.addWarning(new FDSParseWarning(rec, String.format(Intl.intl("The MOVE record, %s, does not exist."), idMove), String.format(Intl.intl("Ignoring unrecognized MOVE record for GEOM, %s."), id)));
        }
        elements = Elements.finalizeElements(elements);
        GeomNodeLeaf geomNode = GeomNodeUtil.newNode(xform, geom, elements);
        surfs = GeomUtil.optimize(surfs);
        this.d_components.put(id, new Pair<GeomNodeLeaf, Surface[]>(geomNode, surfs));
        Obstruction obst = new Obstruction(id, geomNode, surfs);
        obst.setOptions(128, true);
        this.parseCustomFDSProps(obst, rec);
        this.addObject(obst);
        return true;
    }

    private static void InitSphere2(int nLat, int nLong, List<Double> sphereVert, List<Integer> sphereFaces) {
        int iLong;
        int i;
        ArrayList<Double> cosLat = new ArrayList<Double>();
        ArrayList<Double> sinLat = new ArrayList<Double>();
        ArrayList<Double> cosLong = new ArrayList<Double>();
        ArrayList<Double> sinLong = new ArrayList<Double>();
        for (i = 1; i <= nLat; ++i) {
            double lat = 1.5707963267948966 - Math.PI * (double)(i - 1) / (double)(nLat - 1);
            cosLat.add(Math.cos(lat));
            sinLat.add(Math.sin(lat));
        }
        for (i = 1; i <= nLong; ++i) {
            double longitude = -Math.PI + Math.PI * 2 * (double)(i - 1) / (double)nLong;
            cosLong.add(Math.cos(longitude));
            sinLong.add(Math.sin(longitude));
        }
        sphereVert.add(0.0);
        sphereVert.add(0.0);
        sphereVert.add(1.0);
        for (i = 1; i < nLat - 1; ++i) {
            for (int j = 0; j < nLong; ++j) {
                sphereVert.add((Double)cosLong.get(j) * (Double)cosLat.get(i));
                sphereVert.add((Double)sinLong.get(j) * (Double)cosLat.get(i));
                sphereVert.add((Double)sinLat.get(i));
            }
        }
        sphereVert.add(0.0);
        sphereVert.add(0.0);
        sphereVert.add(-1.0);
        for (iLong = 0; iLong < nLong; ++iLong) {
            int I11 = iLong + 1;
            int I12 = iLong + 2;
            int I22 = 0;
            sphereFaces.add(I22);
            sphereFaces.add(I11);
            sphereFaces.add(iLong == nLong - 1 ? 1 : I12);
        }
        for (int iLat = 1; iLat < nLat - 2; ++iLat) {
            for (int iLong2 = 0; iLong2 < nLong; ++iLong2) {
                int i11 = 1 + iLong2 + nLong * iLat;
                int i21 = i11 + 1;
                int i12 = 1 + iLong2 + nLong * (iLat - 1);
                int i22 = i12 + 1;
                if (iLong2 == nLong - 1) {
                    i21 = 1 + nLong * iLat;
                    i22 = 1 + nLong * (iLat - 1);
                }
                sphereFaces.add(i12);
                sphereFaces.add(i11);
                sphereFaces.add(i22);
                sphereFaces.add(i22);
                sphereFaces.add(i11);
                sphereFaces.add(i21);
            }
        }
        for (iLong = 0; iLong < nLong; ++iLong) {
            int i11 = iLong + 1 + nLong * (nLat - 3);
            int i12 = iLong == nLong - 1 ? 1 + nLong * (nLat - 3) : i11 + 1;
            int i22 = nLong * (nLat - 2) + 1;
            sphereFaces.add(i11);
            sphereFaces.add(i22);
            sphereFaces.add(i12);
        }
    }

    private static void InitSphere(int nLevels, int maxFaces, int maxVerts, List<Double> sphereVerts, List<Integer> sphereFaces) {
        double ARG;
        int i;
        vertsAndFaces vf = new vertsAndFaces();
        sphereVerts.add(0.0);
        sphereVerts.add(0.0);
        sphereVerts.add(1.0);
        double[] VERT = new double[]{0.0, 0.0, 0.0};
        int[] FACE_LIST = new int[]{0, 1, 2, 0, 2, 3, 0, 3, 4, 0, 4, 5, 0, 5, 1, 1, 6, 2, 2, 6, 7, 2, 7, 3, 3, 7, 8, 3, 8, 4, 4, 8, 9, 4, 9, 5, 5, 9, 10, 5, 10, 1, 1, 10, 6, 11, 7, 6, 11, 8, 7, 11, 9, 8, 11, 10, 9, 11, 6, 10};
        for (i = 2; i <= 6; ++i) {
            ARG = (i - 2) * 72;
            ARG = Math.PI * 2 * ARG / 360.0;
            VERT[0] = Math.cos(ARG);
            VERT[1] = Math.sin(ARG);
            VERT[2] = 1.0 / Math.sqrt(5.0);
            double NormVert = GeomParser.norm2(VERT);
            sphereVerts.add(VERT[0] / NormVert);
            sphereVerts.add(VERT[1] / NormVert);
            sphereVerts.add(VERT[2] / NormVert);
        }
        for (i = 7; i <= 11; ++i) {
            ARG = 36.0 + (double)(i - 7) * 72.0;
            ARG = Math.PI * 2 * ARG / 360.0;
            VERT[0] = Math.cos(ARG);
            VERT[1] = Math.sin(ARG);
            VERT[2] = -1.0 / Math.sqrt(5.0);
            double NormVert2 = GeomParser.norm2(VERT);
            sphereVerts.add(VERT[0] / NormVert2);
            sphereVerts.add(VERT[1] / NormVert2);
            sphereVerts.add(VERT[2] / NormVert2);
        }
        sphereVerts.add(0.0);
        sphereVerts.add(0.0);
        sphereVerts.add(-1.0);
        for (int face : FACE_LIST) {
            sphereFaces.add(face);
        }
        for (int i2 = 0; i2 < 20; ++i2) {
            GeomParser.refineFace(nLevels, i2, maxFaces, maxVerts, vf, sphereVerts, sphereFaces);
        }
    }

    private static void refineFace(int nLevels, int IFace2, int maxFaces, int maxVerts, vertsAndFaces vf, List<Double> sphereVerts, List<Integer> sphereFaces) {
        if (nLevels == 0 || vf.getFaces() + 3 > maxFaces || vf.getVerts() + 3 > maxVerts) {
            return;
        }
        int[] face1 = new int[]{sphereFaces.get(3 * IFace2), sphereFaces.get(3 * IFace2 + 1), sphereFaces.get(3 * IFace2 + 2)};
        double[] v1 = new double[]{sphereVerts.get(3 * face1[0]), sphereVerts.get(3 * face1[0] + 1), sphereVerts.get(3 * face1[0] + 2)};
        double[] v2 = new double[]{sphereVerts.get(3 * face1[1]), sphereVerts.get(3 * face1[1] + 1), sphereVerts.get(3 * face1[1] + 2)};
        double[] v3 = new double[]{sphereVerts.get(3 * face1[2]), sphereVerts.get(3 * face1[2] + 1), sphereVerts.get(3 * face1[2] + 2)};
        double[] v12 = new double[]{(v1[0] + v2[0]) / 2.0, (v1[1] + v2[1]) / 2.0, (v1[2] + v2[2]) / 2.0};
        double[] v13 = new double[]{(v1[0] + v3[0]) / 2.0, (v1[1] + v3[1]) / 2.0, (v1[2] + v3[2]) / 2.0};
        double[] v23 = new double[]{(v2[0] + v3[0]) / 2.0, (v2[1] + v3[1]) / 2.0, (v2[2] + v3[2]) / 2.0};
        double norm2V12 = GeomParser.norm2(v12);
        double norm2V13 = GeomParser.norm2(v13);
        double norm2V23 = GeomParser.norm2(v23);
        int i = 0;
        while (i < 3) {
            int n = i;
            v12[n] = v12[n] / norm2V12;
            int n2 = i;
            v13[n2] = v13[n2] / norm2V13;
            int n3 = i++;
            v23[n3] = v23[n3] / norm2V23;
        }
        sphereVerts.add(v12[0]);
        sphereVerts.add(v12[1]);
        sphereVerts.add(v12[2]);
        sphereVerts.add(v13[0]);
        sphereVerts.add(v13[1]);
        sphereVerts.add(v13[2]);
        sphereVerts.add(v23[0]);
        sphereVerts.add(v23[1]);
        sphereVerts.add(v23[2]);
        int[] face2 = new int[]{vf.getVerts(), face1[1], vf.getVerts() + 2};
        int[] face3 = new int[]{vf.getVerts(), vf.getVerts() + 2, vf.getVerts() + 1};
        int[] face4 = new int[]{vf.getVerts() + 1, vf.getVerts() + 2, face1[2]};
        sphereFaces.set(3 * IFace2, face1[0]);
        sphereFaces.set(3 * IFace2 + 1, vf.getVerts());
        sphereFaces.set(3 * IFace2 + 2, vf.getVerts() + 1);
        sphereFaces.add(face2[0]);
        sphereFaces.add(face2[1]);
        sphereFaces.add(face2[2]);
        sphereFaces.add(face3[0]);
        sphereFaces.add(face3[1]);
        sphereFaces.add(face3[2]);
        sphereFaces.add(face4[0]);
        sphereFaces.add(face4[1]);
        sphereFaces.add(face4[2]);
        int n1 = IFace2;
        int n2 = vf.getFaces();
        int n3 = vf.getFaces() + 1;
        int n4 = vf.getFaces() + 2;
        vf.setFaces(vf.getFaces() + 3);
        vf.setVerts(vf.getVerts() + 3);
        if (nLevels == 1) {
            return;
        }
        GeomParser.refineFace(nLevels - 1, n1, maxFaces, maxVerts, vf, sphereVerts, sphereFaces);
        GeomParser.refineFace(nLevels - 1, n2, maxFaces, maxVerts, vf, sphereVerts, sphereFaces);
        GeomParser.refineFace(nLevels - 1, n3, maxFaces, maxVerts, vf, sphereVerts, sphereFaces);
        GeomParser.refineFace(nLevels - 1, n4, maxFaces, maxVerts, vf, sphereVerts, sphereFaces);
    }

    /*
     * Unable to fully structure code
     */
    private static void defineCylinder(FDSArray<Double> cylinderAxis, double cylinderLength, Integer cylinderNsegAxis, Integer cylinderNsegTheta, List<Double> verts, List<Integer> faces, List<Vector3d> normalVecs, List<Integer> normalIndices, int[][] surfaceList, UnitDouble cylinderRadius, UnitPoint3D cylinderOrigin) {
        block19: {
            block20: {
                block18: {
                    ex = new double[]{1.0, 0.0, 0.0};
                    e1 = new double[3];
                    e2 = new double[3];
                    e3 = new double[3];
                    cylinderAxisVec = (Vector3d)GeomConstants.VEC3D_XPOS.clone();
                    twoEpsilonEB = 9.9E-324;
                    v0 = new int[]{1};
                    if (!(Math.abs(cylinderAxis.get(v0)) < twoEpsilonEB)) break block18;
                    v1 = new int[]{2};
                    if (!(Math.abs(cylinderAxis.get(v1)) < twoEpsilonEB)) break block18;
                    e1 = (double[])ex.clone();
                    e2[0] = 0.0;
                    e2[1] = 1.0;
                    e2[2] = 0.0;
                    e3[0] = 0.0;
                    e3[1] = 0.0;
                    e3[2] = 1.0;
                    break block19;
                }
                v2 = new int[]{2};
                if (!(Math.abs(cylinderAxis.get(v2)) < twoEpsilonEB)) break block20;
                v3 = new int[]{0};
                if (!(Math.abs(cylinderAxis.get(v3)) < twoEpsilonEB)) break block20;
                e3 = (double[])ex.clone();
                e1[0] = 0.0;
                e1[1] = 1.0;
                e1[2] = 0.0;
                e2[0] = 0.0;
                e2[1] = 0.0;
                e2[2] = 1.0;
                break block19;
            }
            v4 = new int[]{0};
            if (!(Math.abs(cylinderAxis.get(v4)) < twoEpsilonEB)) ** GOTO lbl-1000
            v5 = new int[]{1};
            if (Math.abs(cylinderAxis.get(v5)) < twoEpsilonEB) {
                e2 = (double[])ex.clone();
                e3[0] = 0.0;
                e3[1] = 1.0;
                e3[2] = 0.0;
                e1[0] = 0.0;
                e1[1] = 0.0;
                e1[2] = 1.0;
            } else lbl-1000:
            // 2 sources

            {
                norm = GeomParser.norm3(cylinderAxis);
                e1[0] = cylinderAxis.get(new int[]{0}) / norm;
                e1[1] = cylinderAxis.get(new int[]{1}) / norm;
                e1[2] = cylinderAxis.get(new int[]{2}) / norm;
                e2 = GeomParser.crossProduct(ex, e1);
                norm = GeomParser.norm3(e2);
                for (i = 0; i < 3; ++i) {
                    e2[i] = e2[i] / norm;
                }
                e3 = GeomParser.crossProduct(e1, e2);
            }
        }
        tgl = new double[3][3];
        for (i = 0; i < 3; ++i) {
            tgl[i][0] = e1[i];
            tgl[i][1] = e2[i];
            tgl[i][2] = e3[i];
        }
        npL = cylinderNsegAxis + 1;
        npT = cylinderNsegTheta;
        deltaL = cylinderLength / Double.valueOf(cylinderNsegAxis.intValue());
        deltaT = 6.283185307179586 / Double.valueOf(cylinderNsegTheta.intValue());
        pos1 = -cylinderLength / 2.0;
        pos2 = 0.0;
        pos3 = 0.0;
        verts.add(pos1);
        verts.add(pos2);
        verts.add(pos3);
        for (i = 1; i <= npL; ++i) {
            pos1 = -cylinderLength / 2.0 + (double)(i - 1) * deltaL;
            for (j = 1; j <= npT; ++j) {
                theta = (double)(j - 1) * deltaT;
                pos2 = cylinderRadius.getValue(Geometry.LU) * Math.cos(theta);
                pos3 = cylinderRadius.getValue(Geometry.LU) * Math.sin(theta);
                verts.add(pos1);
                verts.add(pos2);
                verts.add(pos3);
            }
        }
        pos1 = cylinderLength / 2.0;
        pos2 = 0.0;
        pos3 = 0.0;
        verts.add(pos1);
        verts.add(pos2);
        verts.add(pos3);
        nVerts = verts.size();
        iVert = 1;
        counter = 0;
        surfaceList[0][0] = counter + 1;
        lowAxisPlaneVector = (Vector3d)GeomConstants.VEC3D_XNEG.clone();
        normalMap = new LinkedHashMap<Vector3d, Integer>();
        normalMap.put(cylinderAxisVec, 0);
        normalMap.put(lowAxisPlaneVector, 1);
        for (i = 1; i <= npT; ++i) {
            if (i < npT) {
                I1 = 1 + i + 1;
                I2 = 1 + i;
                I3 = iVert;
            } else {
                I1 = iVert + 1;
                I2 = i + 1;
                I3 = iVert;
            }
            faces.add(I1 - 1);
            normalIndices.add(1);
            faces.add(I2 - 1);
            normalIndices.add(1);
            faces.add(I3 - 1);
            normalIndices.add(1);
            ++counter;
        }
        surfaceList[1][0] = counter;
        surfaceList[0][1] = counter + 1;
        for (i = 2; i <= npL; ++i) {
            for (j = 1; j <= npT; ++j) {
                if (j < npT) {
                    I1 = (i - 1) * npT + 1 + j - 1;
                    I2 = (i - 1) * npT + 1 + j + 1 - 1;
                    I3 = (i - 2) * npT + 1 + j - 1;
                    I4 = (i - 2) * npT + 1 + j + 1 - 1;
                } else {
                    I1 = (i - 1) * npT + 1 + j - 1;
                    I2 = (i - 1) * npT + 1 + 1 - 1;
                    I3 = (i - 2) * npT + 1 + j - 1;
                    I4 = (i - 2) * npT + 1 + 1 - 1;
                }
                ni1 = normalMap.computeIfAbsent(GeomParser.cylinderSideVecHelper(GeomParser.ixToPointHelper(I1, verts)), (Function<Vector3d, Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$defineCylinder$0(java.util.Map javax.vecmath.Vector3d ), (Ljavax/vecmath/Vector3d;)Ljava/lang/Integer;)(normalMap));
                ni2 = normalMap.computeIfAbsent(GeomParser.cylinderSideVecHelper(GeomParser.ixToPointHelper(I2, verts)), (Function<Vector3d, Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$defineCylinder$1(java.util.Map javax.vecmath.Vector3d ), (Ljavax/vecmath/Vector3d;)Ljava/lang/Integer;)(normalMap));
                ni3 = normalMap.computeIfAbsent(GeomParser.cylinderSideVecHelper(GeomParser.ixToPointHelper(I3, verts)), (Function<Vector3d, Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$defineCylinder$2(java.util.Map javax.vecmath.Vector3d ), (Ljavax/vecmath/Vector3d;)Ljava/lang/Integer;)(normalMap));
                ni4 = normalMap.computeIfAbsent(GeomParser.cylinderSideVecHelper(GeomParser.ixToPointHelper(I4, verts)), (Function<Vector3d, Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$defineCylinder$3(java.util.Map javax.vecmath.Vector3d ), (Ljavax/vecmath/Vector3d;)Ljava/lang/Integer;)(normalMap));
                faces.add(I1);
                normalIndices.add(ni1);
                faces.add(I3);
                normalIndices.add(ni3);
                faces.add(I2);
                normalIndices.add(ni2);
                faces.add(I3);
                normalIndices.add(ni3);
                faces.add(I4);
                normalIndices.add(ni4);
                faces.add(I2);
                normalIndices.add(ni2);
                counter += 2;
            }
        }
        surfaceList[1][1] = counter;
        surfaceList[0][2] = counter + 1;
        iVert = nVerts / 3;
        for (i = 1; i <= npT; ++i) {
            if (i < npT) {
                I1 = (npL - 1) * npT + 1 + i;
                I2 = (npL - 1) * npT + 1 + i + 1;
                I3 = iVert;
            } else {
                I1 = (npL - 1) * npT + 1 + i;
                I2 = (npL - 1) * npT + 1 + 1;
                I3 = iVert;
            }
            faces.add(I1 - 1);
            normalIndices.add(0);
            faces.add(I2 - 1);
            normalIndices.add(0);
            faces.add(I3 - 1);
            normalIndices.add(0);
            ++counter;
        }
        surfaceList[1][2] = counter;
        v = new double[3];
        r = new double[3];
        cylinderOriginConverted = cylinderOrigin.getValue(Geometry.LU);
        for (i = 0; i < nVerts; i += 3) {
            v[0] = verts.get(i);
            v[1] = verts.get(i + 1);
            v[2] = verts.get(i + 2);
            r = GeomParser.matrixVectorTransform(tgl, v);
            verts.set(i, r[0] + cylinderOriginConverted.x);
            verts.set(i + 1, r[1] + cylinderOriginConverted.y);
            verts.set(i + 2, r[2] + cylinderOriginConverted.z);
        }
        transform = new Matrix3d(Stream.of(tgl).flatMapToDouble((Function<double[], DoubleStream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, of(double[] ), ([D)Ljava/util/stream/DoubleStream;)()).toArray());
        normalVecs.addAll(normalMap.keySet());
        for (i = 0; i < normalVecs.size(); ++i) {
            transform.transform(normalVecs.get(i));
        }
    }

    private static Point3d ixToPointHelper(int index, List<Double> verts) {
        return new Point3d(verts.get(3 * index), verts.get(3 * index + 1), verts.get(3 * index + 2));
    }

    private static Vector3d cylinderSideVecHelper(Point3d vertex) {
        Point3d nearest = Inter3D.nearestPointOnLine(GeomConstants.PNT3D_ORIGIN, GeomConstants.VEC3D_XPOS, vertex);
        Vector3d vec = nearest.epsilonEquals(vertex, 1.0E-4) ? Util3D.vector(GeomConstants.PNT3D_ORIGIN, vertex) : Util3D.vector(nearest, vertex);
        vec.normalize();
        return vec;
    }

    private static double norm2(double[] verts) {
        return Math.sqrt(verts[0] * verts[0] + verts[1] * verts[1] + verts[2] * verts[2]);
    }

    private static double norm3(FDSArray<Double> axis) {
        return Math.sqrt(axis.get(0) * axis.get(0) + axis.get(1) * axis.get(1) + axis.get(2) * axis.get(2));
    }

    private static double norm3(double[] axis) {
        return Math.sqrt(axis[0] * axis[0] + axis[1] * axis[1] + axis[2] * axis[2]);
    }

    private static double[] crossProduct(double[] v1, double[] v2) {
        Vector3d t1 = new Vector3d(v1);
        Vector3d t2 = new Vector3d(v2);
        t1.cross(t1, t2);
        double[] result = new double[]{t1.x, t1.y, t1.z};
        return result;
    }

    private static double[] matrixVectorTransform(double[][] tgl, double[] v) {
        double[] result = new double[3];
        for (int j = 0; j < 3; ++j) {
            for (int k = 0; k < 3; ++k) {
                int n = j;
                result[n] = result[n] + tgl[j][k] * v[k];
            }
        }
        return result;
    }

    private Pair<IGeom, Surface[]> parseBinaryFile(FDSParseRecord rec, IPropertySet elements) throws FDSRecordFormatException {
        String fdsFilename = super.getParsingInfo().getParsingFile();
        File dirPath = new File(fdsFilename).getParentFile();
        File bingeom = new File(dirPath, rec.getString("BINARY_FILE"));
        Point3d[] verts = null;
        int[] faceIndices = null;
        int[] surfIndices = null;
        boolean isTerrain = false;
        try (LEDataInputStream ds = new LEDataInputStream(new FileInputStream(bingeom));){
            int i;
            ds.skipBytes(4);
            int geomType = ds.readInt();
            isTerrain = geomType == 2;
            ds.skipBytes(8);
            int nVerts = ds.readInt();
            int nFaces = ds.readInt();
            ds.skipBytes(8);
            ds.skipBytes(8);
            verts = new Point3d[nVerts];
            for (int i2 = 0; i2 < nVerts; ++i2) {
                double x = ds.readDouble();
                double y = ds.readDouble();
                double z = ds.readDouble();
                verts[i2] = new Point3d(x, y, z);
            }
            ds.skipBytes(8);
            faceIndices = new int[3 * nFaces];
            int faceIndiceIter = 0;
            for (i = 0; i < nFaces; ++i) {
                faceIndices[faceIndiceIter++] = ds.readInt() - 1;
                faceIndices[faceIndiceIter++] = ds.readInt() - 1;
                faceIndices[faceIndiceIter++] = ds.readInt() - 1;
            }
            ds.skipBytes(8);
            surfIndices = new int[nFaces];
            for (i = 0; i < nFaces; ++i) {
                surfIndices[i] = ds.readInt();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new FDSRecordFormatException(rec, String.format(Intl.intl("The %s record cannot be read."), "BINARY_FILE"));
        }
        if (isTerrain) {
            ArrayList<Double> vertValsList = new ArrayList<Double>(3 * verts.length);
            for (Point3d vert : verts) {
                vertValsList.add(vert.x);
                vertValsList.add(vert.y);
                vertValsList.add(vert.z);
            }
            ArrayList<Integer> facesList = new ArrayList<Integer>(faceIndices.length);
            for (int faceIx : faceIndices) {
                facesList.add(faceIx + 1);
            }
            ArrayList<Integer> surfsList = new ArrayList<Integer>(surfIndices.length);
            for (int surfIx : surfIndices) {
                surfsList.add(surfIx);
            }
            return this.parseTerrainFaces(rec, elements, () -> facesList, () -> vertValsList, () -> surfsList);
        }
        Surface[] surfs = this.getSurfArray(this.getUniqueSurfs(rec), surfIndices);
        Mesh tempMesh = new Mesh(verts, faceIndices, 2);
        IElemSource<Elements.Orient> faceOrients = Elements.CCW;
        double degree = 60.0;
        IElemSource<Vector3d> normalMesh = Elements.generateNormals(tempMesh, faceOrients, Math.toRadians(degree));
        IPropsSrc props = IObstruction.getDisplayProps(surfs, new Color[]{null}, false, GeomUtil.isCullGeom(tempMesh));
        IElemSource<Boolean> creases = Elements.generateCreasesFromNormals(tempMesh, props, normalMesh, faceOrients);
        elements.setIfNotDefault(Elements.NORMAL, normalMesh);
        elements.setIfNotDefault(Elements.CREASE, creases);
        Mesh geom = tempMesh;
        return new Pair<IGeom, Surface[]>(geom, surfs);
    }

    private List<Surface> getUniqueSurfs(FDSParseRecord rec) throws FDSRecordFormatException {
        List names = rec.getList("SURF_ID", true);
        Predicate<Surface> filter = Obstruction.getSurfaceFilter();
        ArrayList<Surface> uniqueSurfs = new ArrayList<Surface>(names.size());
        for (String name : names) {
            uniqueSurfs.add(this.getSurfaceSafe(rec, name, filter));
        }
        return uniqueSurfs;
    }

    private Surface[] getSurfArray(List<Surface> uniqueSurfs, int[] surfIxs) {
        Surface[] surfs = new Surface[surfIxs.length];
        for (int i = 0; i < surfIxs.length; ++i) {
            surfs[i] = surfIxs[i] == 0 ? this.getDefaultMat() : uniqueSurfs.get(surfIxs[i] - 1);
        }
        return surfs;
    }

    private Pair<IGeom, Surface[]> parseBlock(FDSParseRecord rec) throws FDSRecordFormatException {
        AABoxGeom geom = this.parseXBGeom(rec, "GEOM", "XB", true);
        Surface[] surfs = this.getSurfs(rec);
        return new Pair<IGeom, Surface[]>(geom, surfs);
    }

    private Surface[] getSurfs(FDSParseRecord rec) throws FDSRecordFormatException {
        FDSArray surfIDs;
        Predicate<Surface> surfFilter = Obstruction.getSurfaceFilter();
        Surface[] surfs = null;
        if (rec.contains("SURF_ID")) {
            List names = rec.getList("SURF_ID", true);
            Surface surf = this.getSurfaceSafe(rec, (String)names.get(0), surfFilter);
            surfs = new Surface[]{surf};
        } else if (rec.contains("SURF_IDS")) {
            surfIDs = rec.getArray("SURF_IDS", false);
            surfs = new Surface[]{this.getSurfaceSafe(rec, (String)surfIDs.get(1), surfFilter), this.getSurfaceSafe(rec, (String)surfIDs.get(1), surfFilter), this.getSurfaceSafe(rec, (String)surfIDs.get(1), surfFilter), this.getSurfaceSafe(rec, (String)surfIDs.get(1), surfFilter), this.getSurfaceSafe(rec, (String)surfIDs.get(2), surfFilter), this.getSurfaceSafe(rec, (String)surfIDs.get(0), surfFilter)};
        } else if (rec.contains("SURF_ID6")) {
            surfIDs = rec.getArray("SURF_ID6", false);
            surfs = new Surface[]{this.getSurfaceSafe(rec, (String)surfIDs.get(0), surfFilter), this.getSurfaceSafe(rec, (String)surfIDs.get(1), surfFilter), this.getSurfaceSafe(rec, (String)surfIDs.get(2), surfFilter), this.getSurfaceSafe(rec, (String)surfIDs.get(3), surfFilter), this.getSurfaceSafe(rec, (String)surfIDs.get(4), surfFilter), this.getSurfaceSafe(rec, (String)surfIDs.get(5), surfFilter)};
        } else {
            DefaultSurface defSurf = this.getDefaultMat();
            surfs = new Surface[]{defSurf};
        }
        if (surfs.length > 1 && GeomUtil.isUniform(surfs)) {
            surfs = new Surface[]{surfs[0]};
        }
        if (surfs.length == 1) {
            return surfs;
        }
        Surface[] finalSurfs = new Surface[]{surfs[0], surfs[1], surfs[2], surfs[3], surfs[4], surfs[5]};
        return finalSurfs;
    }

    private Pair<IGeom, Surface[]> parseSphere(FDSParseRecord rec, IPropertySet elements) throws FDSRecordFormatException {
        int i;
        int sphereType;
        Surface[] surfs = null;
        if (rec.contains("SURF_IDS") || rec.contains("SURF_ID6")) {
            String errorRec = rec.contains("SURF_IDS") ? "SURF_IDS" : "SURF_ID6";
            this.addWarning(rec, String.format(Intl.intl("Spherical GEOM records do not support %s."), errorRec), String.format(Intl.intl("%s dropped from record."), errorRec));
            surfs = new Surface[]{this.getDefaultMat()};
        } else if (rec.contains("SURF_ID")) {
            Predicate<Surface> surfFilter = Obstruction.getSurfaceFilter();
            List names = rec.getList("SURF_ID", true);
            Surface surf = this.getSurfaceSafe(rec, (String)names.get(0), surfFilter);
            surfs = new Surface[]{surf};
        }
        UnitPoint3D sphereOrigin = GeomParser.parseLoc(rec, "GEOM", "SPHERE_ORIGIN", true);
        UnitDouble sphereRadius = rec.getUnitDouble("SPHERE_RADIUS");
        if (sphereRadius == null) {
            throw new FDSRecordFormatException(rec, String.format(Intl.intl("%s is missing in a geom record."), "SPHERE_RADIUS"));
        }
        Integer nLevels = rec.getInteger("N_LEVELS");
        Integer nLat = rec.getInteger("N_LAT");
        Integer nLong = rec.getInteger("N_LONG");
        if (nLevels == null && (nLat == null || nLong == null)) {
            this.addWarning(rec, Intl.intl("Spherical GEOM records need either the N_LEVELS parameter or both the N_LAT and N_LONG parameter"), Intl.intl("Substituting default values for N_LEVEL"));
            nLevels = 1;
        }
        double meshDx = this.d_meshes.get(0).getMeshDx();
        int nFaces = 0;
        int n = sphereType = nLevels == null && nLat > 0 && nLong > 0 ? 2 : 1;
        if (sphereType == 1) {
            if (nLevels == -1) {
                nLevels = (int)(Math.log(Math.PI * 2 * sphereRadius.getValue(Geometry.LU) / (5.0 * meshDx)) / Math.log(2.0));
            }
            nLevels = Math.min(7, Math.max(0, nLevels));
            nFaces = (int)(20.0 * (Math.pow(4.0, nLevels.intValue()) + 1.0));
        } else {
            if (nLong < 6) {
                nLong = Math.max(6, (int)(Math.PI * 2 * sphereRadius.getValue(Geometry.LU) / meshDx) + 1);
            }
            if (nLat < 3) {
                nLat = Math.max(3, (int)(Math.PI * sphereRadius.getValue(Geometry.LU) / meshDx) + 1);
            }
            nFaces = 2 * nLat * nLong;
        }
        ArrayList<Double> sphereVerts = new ArrayList<Double>();
        ArrayList<Integer> sphereFaces = new ArrayList<Integer>();
        int maxFaces = nFaces;
        maxFaces = Math.max(maxFaces, 24000);
        int maxVerts = Math.max(24000, 3 * maxFaces);
        if (sphereType == 1) {
            GeomParser.InitSphere(nLevels, maxFaces, maxVerts, sphereVerts, sphereFaces);
        } else {
            GeomParser.InitSphere2(nLat, nLong, sphereVerts, sphereFaces);
        }
        double sphere_radius = sphereRadius.getValue(Geometry.LU);
        Point3d origin = sphereOrigin.getValue(Geometry.LU);
        Point3d[] verts = new Point3d[sphereVerts.size() / 3];
        int m = 0;
        while (m < sphereVerts.size()) {
            int vix = m / 3;
            verts[vix] = new Point3d(origin.x + sphere_radius * (Double)sphereVerts.get(m++), origin.y + sphere_radius * (Double)sphereVerts.get(m++), origin.z + sphere_radius * (Double)sphereVerts.get(m++));
        }
        int[] indicies = new int[sphereFaces.size()];
        Vector3d[] sphereNormals = new Vector3d[verts.length];
        for (i = 0; i < sphereFaces.size(); ++i) {
            indicies[i] = (Integer)sphereFaces.get(i);
        }
        for (i = 0; i < sphereNormals.length; ++i) {
            sphereNormals[i] = Util3D.vector(sphereOrigin.getValue(Geometry.LU), verts[i]);
            sphereNormals[i].normalize();
        }
        ElementMesh<Vector3d> normalMesh = new ElementMesh<Vector3d>(ElementMesh.Mapping.PER_PRIM_VERTEX, sphereNormals, indicies, 3);
        elements.setIfNotDefault(Elements.NORMAL, normalMesh);
        SolidGeom geom = new SolidGeom(new Mesh(verts, indicies, 2));
        return new Pair<IGeom, Surface[]>(geom, surfs);
    }

    private Pair<IGeom, Surface[]> parseCylinder(FDSParseRecord rec, IPropertySet elements) throws FDSRecordFormatException {
        Surface[] surfs = null;
        Predicate<Surface> surfFilter = Obstruction.getSurfaceFilter();
        ArrayList<Surface> surfList = new ArrayList<Surface>();
        int[][] surfaceList = new int[2][3];
        UnitDouble cylinderLength = rec.getUnitDouble("CYLINDER_LENGTH");
        UnitDouble cylinderRadius = rec.getUnitDouble("CYLINDER_RADIUS");
        UnitPoint3D cylinderOrigin = GeomParser.parseLoc(rec, "GEOM", "CYLINDER_ORIGIN", true);
        FDSArray<Double> cylinderAxis = rec.getArray("CYLINDER_AXIS", true);
        Integer cylinderNsegTheta = rec.getInteger("CYLINDER_NSEG_THETA");
        Integer cylinderNsegAxis = rec.getInteger("CYLINDER_NSEG_AXIS");
        if (cylinderNsegAxis == null) {
            cylinderNsegAxis = 1;
        }
        if (cylinderNsegTheta == null) {
            cylinderNsegTheta = 8;
        }
        ArrayList<Double> verts = new ArrayList<Double>();
        ArrayList<Integer> faces = new ArrayList<Integer>();
        ArrayList<Vector3d> normalVerts = new ArrayList<Vector3d>();
        ArrayList<Integer> normalIndices = new ArrayList<Integer>();
        GeomParser.defineCylinder(cylinderAxis, cylinderLength.getValue(Geometry.LU), cylinderNsegAxis, cylinderNsegTheta, verts, faces, normalVerts, normalIndices, surfaceList, cylinderRadius, cylinderOrigin);
        if (rec.contains("SURF_ID6")) {
            this.addWarning(rec, String.format(Intl.intl("Cylindrical GEOM records do not support %s."), "SURF_ID6"), String.format(Intl.intl("%s dropped from record."), "SURF_ID6"));
            surfs = new Surface[]{this.getDefaultMat()};
        } else if (rec.contains("SURF_ID")) {
            List names = rec.getList("SURF_ID", true);
            Surface surf = this.getSurfaceSafe(rec, (String)names.get(0), surfFilter);
            surfs = new Surface[]{surf};
        } else if (rec.contains("SURF_IDS")) {
            int i;
            FDSArray surfIDs = rec.getArray("SURF_IDS", false);
            for (i = 1; i <= surfaceList[1][0]; ++i) {
                surfList.add(this.getSurfaceSafe(rec, (String)surfIDs.get(2), surfFilter));
            }
            for (i = surfaceList[0][1]; i <= surfaceList[1][1]; ++i) {
                surfList.add(this.getSurfaceSafe(rec, (String)surfIDs.get(1), surfFilter));
            }
            for (i = surfaceList[0][2]; i <= surfaceList[1][2]; ++i) {
                surfList.add(this.getSurfaceSafe(rec, (String)surfIDs.get(0), surfFilter));
            }
            surfs = new Surface[surfList.size()];
            for (i = 0; i < surfList.size(); ++i) {
                surfs[i] = (Surface)surfList.get(i);
            }
        }
        int[] indicies = new int[faces.size()];
        for (int i = 0; i < faces.size(); ++i) {
            indicies[i] = (Integer)faces.get(i);
        }
        Point3d[] verts3d = new Point3d[verts.size() / 3];
        int m = 0;
        while (m < verts.size()) {
            int vix = m / 3;
            verts3d[vix] = new Point3d((Double)verts.get(m++), (Double)verts.get(m++), (Double)verts.get(m++));
        }
        Vector3d[] cylinderNorms = theUtil.toArray(normalVerts);
        ElementMesh<Vector3d> normalMesh = new ElementMesh<Vector3d>(ElementMesh.Mapping.PER_PRIM_VERTEX, cylinderNorms, theUtil.toIntArray(normalIndices), 3);
        elements.setIfNotDefault(Elements.NORMAL, normalMesh);
        SolidGeom geom = new SolidGeom(new Mesh(verts3d, indicies, 2));
        IPropsSrc dispProps = IObstruction.getDisplayProps(surfs, new Color[]{null}, false, GeomUtil.isCullGeom(geom));
        elements.setIfNotDefault(Elements.CREASE, Elements.generateCreasesFromNormals(geom, dispProps, normalMesh, Elements.CCW));
        return new Pair<IGeom, Surface[]>(geom, surfs);
    }

    private Pair<IGeom, Surface[]> parseTerrainFaces(FDSParseRecord rec, IPropertySet elements) throws FDSRecordFormatException {
        return this.parseTerrainFaces(rec, elements, () -> rec.getList("FACES", true), () -> rec.getList("VERTS", true), () -> Collections.emptyList());
    }

    private Pair<IGeom, Surface[]> parseTerrainFaces(FDSParseRecord rec, IPropertySet elements, Supplier<List<Integer>> faceSupplier, Supplier<List<Double>> vertSupplier, Supplier<List<Integer>> surfIDSupplier) throws FDSRecordFormatException {
        int i;
        Double zvalHorizon;
        Iterator<Integer> edge;
        int i2;
        int i3;
        FDSArray surfIDs;
        boolean shouldExtend = rec.getBoolean("EXTEND_TERRAIN", true);
        boolean isBinaryFile = !surfIDSupplier.get().isEmpty();
        int facesExtendedIter = isBinaryFile ? 3 : 4;
        Surface[] surfs = new Surface[]{};
        List<Object> uniqueSurfs = new ArrayList();
        if (rec.contains("SURF_ID")) {
            uniqueSurfs = this.getUniqueSurfs(rec);
        } else if (rec.contains("SURF_IDS")) {
            surfIDs = rec.getArray("SURF_IDS", false);
            i3 = 0;
            while (i3 < 3) {
                uniqueSurfs.add(this.getSurfaceSafe(rec, (String)surfIDs.get(i3++), Obstruction.getSurfaceFilter()));
            }
        } else if (rec.contains("SURF_ID6")) {
            surfIDs = rec.getArray("SURF_ID6", false);
            i3 = 0;
            while (i3 < 6) {
                uniqueSurfs.add(this.getSurfaceSafe(rec, (String)surfIDs.get(i3++), Obstruction.getSurfaceFilter()));
            }
        }
        List<Integer> faces = faceSupplier.get();
        int numFaces = isBinaryFile ? faces.size() / 3 : faces.size() / 4;
        List<Double> vertValues = vertSupplier.get();
        int numPoints = vertValues.size() / 3;
        LinkedHashMap<UnorderedPair<Integer, Integer>, Integer> edgeCounts = new LinkedHashMap<UnorderedPair<Integer, Integer>, Integer>();
        for (int i4 = 0; i4 < faces.size(); i4 += facesExtendedIter) {
            UnorderedPair<Integer, Integer> e1 = new UnorderedPair<Integer, Integer>(faces.get(i4), faces.get(i4 + 1));
            UnorderedPair<Integer, Integer> e2 = new UnorderedPair<Integer, Integer>(faces.get(i4 + 1), faces.get(i4 + 2));
            UnorderedPair<Integer, Integer> e3 = new UnorderedPair<Integer, Integer>(faces.get(i4 + 2), faces.get(i4));
            Integer count1 = (Integer)edgeCounts.get(e1);
            if (count1 == null) {
                edgeCounts.put(e1, 1);
            } else {
                edgeCounts.put(e1, count1 + 1);
            }
            Integer count2 = (Integer)edgeCounts.get(e2);
            if (count2 == null) {
                edgeCounts.put(e2, 1);
            } else {
                edgeCounts.put(e2, count2 + 1);
            }
            Integer count3 = (Integer)edgeCounts.get(e3);
            if (count3 == null) {
                edgeCounts.put(e3, 1);
                continue;
            }
            edgeCounts.put(e3, count3 + 1);
        }
        List boundEdges = edgeCounts.entrySet().stream().filter(kvPair -> (Integer)kvPair.getValue() == 1).map(kvPair -> (UnorderedPair)kvPair.getKey()).collect(Collectors.toList());
        int n_bedges = boundEdges.size();
        boolean edgeDirIncreasing = true;
        UnorderedPair<Integer, Integer> startingEdge = null;
        for (int i5 = 0; i5 < faces.size(); i5 += facesExtendedIter) {
            UnorderedPair<Integer, Integer> e3;
            int v0 = faces.get(i5);
            int v1 = faces.get(i5 + 1);
            int v2 = faces.get(i5 + 2);
            UnorderedPair<Integer, Integer> e1 = new UnorderedPair<Integer, Integer>(v0, v1);
            if ((Integer)edgeCounts.get(e1) == 1) {
                startingEdge = e1;
                edgeDirIncreasing = v0 < v1;
                break;
            }
            UnorderedPair<Integer, Integer> e2 = new UnorderedPair<Integer, Integer>(v1, v2);
            if ((Integer)edgeCounts.get(e2) == 1) {
                startingEdge = e2;
                boolean bl = edgeDirIncreasing = v1 < v2;
            }
            if ((Integer)edgeCounts.get(e3 = new UnorderedPair<Integer, Integer>(v2, v0)) != 1) continue;
            startingEdge = e3;
            edgeDirIncreasing = v2 < v0;
        }
        int searchVert = -1;
        searchVert = edgeDirIncreasing ? Integer.min((Integer)startingEdge.v1, (Integer)startingEdge.v2) : Integer.max((Integer)startingEdge.v1, (Integer)startingEdge.v2);
        ArrayList<Integer> sortedEdges = new ArrayList<Integer>(n_bedges);
        sortedEdges.add(searchVert);
        boolean[] counted = new boolean[n_bedges];
        for (i2 = 0; i2 < n_bedges; ++i2) {
            counted[i2] = false;
        }
        for (i2 = 0; i2 < n_bedges; ++i2) {
            for (int j = 0; j < n_bedges; ++j) {
                if (counted[j]) continue;
                edge = (UnorderedPair)boundEdges.get(j);
                if ((Integer)((UnorderedPair)((Object)edge)).v1 == searchVert) {
                    sortedEdges.add((Integer)((UnorderedPair)((Object)edge)).v2);
                    searchVert = (Integer)((UnorderedPair)((Object)edge)).v2;
                    counted[j] = true;
                    continue;
                }
                if ((Integer)((UnorderedPair)((Object)edge)).v2 != searchVert) continue;
                sortedEdges.add((Integer)((UnorderedPair)((Object)edge)).v1);
                searchVert = (Integer)((UnorderedPair)((Object)edge)).v1;
                counted[j] = true;
            }
        }
        ArrayList<Double> vertsExtended = new ArrayList<Double>();
        ArrayList<Integer> facesExtended = new ArrayList<Integer>();
        edge = vertValues.iterator();
        while (edge.hasNext()) {
            double vert = (Double)edge.next();
            vertsExtended.add(vert);
        }
        for (int faceIx : faces) {
            facesExtended.add(faceIx);
        }
        Double zminSpecified = rec.getDouble("ZMIN", false);
        double zmin2 = Double.MAX_VALUE;
        double deltaZ = 0.0;
        int nguard = 6;
        for (MeshData mesh : this.d_meshes) {
            deltaZ = Double.max(deltaZ, (double)(nguard / mesh.meshIJK.get(2)) * (mesh.meshXB[1].z() - mesh.meshXB[0].z()));
            zmin2 = Double.min(zmin2, mesh.meshXB[0].z() - (double)(nguard / mesh.meshIJK.get(2)) * (mesh.meshXB[1].z() - mesh.meshXB[0].z()));
        }
        double zhi = -1.7976931348623157E308;
        double zlow = Double.MAX_VALUE;
        for (int i6 = 0; i6 < numPoints; ++i6) {
            zhi = Math.max(zhi, vertValues.get(3 * i6 + 2));
            zlow = Math.min(zlow, vertValues.get(3 * i6 + 2));
        }
        zlow = Math.min(zlow - deltaZ, zmin2);
        if (zminSpecified != null) {
            zlow = Math.min(zlow, zminSpecified);
        }
        if ((zvalHorizon = rec.getDouble("ZVAL_HORIZON", true)) == null) {
            zvalHorizon = 1.0009999999999998E20;
        }
        double zval_factor = 1.0;
        if (zvalHorizon > 1.0E20) {
            zval_factor = 0.0;
        }
        if (shouldExtend) {
            int i32;
            int i1;
            int icpt;
            int i7;
            double xlow = Double.MAX_VALUE;
            double xhi = -1.7976931348623157E308;
            double ylow = Double.MAX_VALUE;
            double yhi = -1.7976931348623157E308;
            for (MeshData mesh : this.d_meshes) {
                xlow = Math.min(xlow, mesh.meshXB[0].x());
                xhi = Math.max(xhi, mesh.meshXB[1].x());
                ylow = Math.min(ylow, mesh.meshXB[0].y());
                yhi = Math.max(yhi, mesh.meshXB[1].y());
            }
            int[] B_IND = new int[2 * n_bedges + 1];
            int[] E_IND = new int[2 * n_bedges + 1];
            int[] F_IND = new int[2 * n_bedges + 1];
            for (int i8 = 0; i8 < n_bedges; ++i8) {
                B_IND[i8] = (Integer)sortedEdges.get(i8);
                B_IND[i8 + n_bedges] = (Integer)sortedEdges.get(i8);
            }
            B_IND[2 * n_bedges] = (Integer)sortedEdges.get(0);
            Point2d[] corners = new Point2d[]{new Point2d(xhi, ylow), new Point2d(xhi, yhi), new Point2d(xlow, yhi), new Point2d(xlow, ylow), new Point2d(xhi, ylow)};
            int[] nearestBounds = new int[5];
            for (i7 = 0; i7 < 4; ++i7) {
                double minDistance = Double.MAX_VALUE;
                int nearestBoundIx = -1;
                for (int j = 0; j < n_bedges; ++j) {
                    int vertIx = (Integer)sortedEdges.get(j);
                    Point2d testPt = new Point2d(vertValues.get(3 * (vertIx - 1)), vertValues.get(3 * (vertIx - 1) + 1));
                    double testDistance = testPt.distance(corners[i7]);
                    if (!(testDistance < minDistance)) continue;
                    nearestBoundIx = j;
                    minDistance = testDistance;
                }
                nearestBounds[i7] = nearestBoundIx;
            }
            for (i7 = 1; i7 < 4; ++i7) {
                if (nearestBounds[i7] >= nearestBounds[i7 - 1]) continue;
                nearestBounds[i7] = nearestBounds[i7] + n_bedges;
            }
            nearestBounds[4] = nearestBounds[0] + n_bedges;
            int ij = numPoints;
            for (int icpt2 = 0; icpt2 < 4; ++icpt2) {
                int ije = nearestBounds[icpt2 + 1] - nearestBounds[icpt2];
                double disti = corners[icpt2].distance(corners[icpt2 + 1]) / (double)ije;
                int j = 0;
                int[] verxy_i = new int[]{0, -1, 0, 1};
                int[] verxy_j = new int[]{1, 0, -1, 0};
                for (int i9 = nearestBounds[icpt2]; i9 < nearestBounds[icpt2 + 1]; ++i9) {
                    double x = corners[icpt2].x + disti * (double)verxy_i[icpt2] * (double)j;
                    double y = corners[icpt2].y + disti * (double)verxy_j[icpt2] * (double)j;
                    double z = (1.0 - zval_factor) * vertValues.get(3 * (B_IND[i9] - 1) + 2) + zval_factor * zvalHorizon;
                    vertsExtended.add(x);
                    vertsExtended.add(y);
                    vertsExtended.add(z);
                    E_IND[i9] = ij++;
                    ++j;
                }
            }
            E_IND[nearestBounds[4]] = E_IND[nearestBounds[0]];
            double x_center = 0.0;
            double y_center = 0.0;
            for (int icpt3 = 0; icpt3 < 4; ++icpt3) {
                for (int i10 = nearestBounds[icpt3]; i10 < nearestBounds[icpt3 + 1]; ++i10) {
                    double x = (Double)vertsExtended.get(3 * E_IND[i10]);
                    double y = (Double)vertsExtended.get(3 * E_IND[i10] + 1);
                    double z = zlow;
                    vertsExtended.add(x);
                    vertsExtended.add(y);
                    vertsExtended.add(z);
                    F_IND[i10] = ij++;
                    x_center += ((Double)vertsExtended.get(3 * E_IND[i10])).doubleValue();
                    y_center += ((Double)vertsExtended.get(3 * E_IND[i10] + 1)).doubleValue();
                }
            }
            F_IND[nearestBounds[4]] = F_IND[nearestBounds[0]];
            vertsExtended.add(x_center / (double)n_bedges);
            vertsExtended.add(y_center / (double)n_bedges);
            vertsExtended.add(zlow);
            ++ij;
            int ijf = numFaces;
            for (icpt = 0; icpt < 4; ++icpt) {
                for (int i11 = nearestBounds[icpt]; i11 < nearestBounds[icpt + 1]; ++i11) {
                    i1 = E_IND[i11] + 1;
                    int i22 = E_IND[i11 + 1] + 1;
                    i32 = B_IND[i11 + 1 - 1];
                    int i4 = B_IND[i11 - 1];
                    facesExtended.add(i1);
                    facesExtended.add(i22);
                    facesExtended.add(i32);
                    if (!isBinaryFile) {
                        facesExtended.add(0);
                    }
                    ++ijf;
                    facesExtended.add(i1);
                    facesExtended.add(i32);
                    facesExtended.add(i4);
                    if (!isBinaryFile) {
                        facesExtended.add(0);
                    }
                    ++ijf;
                }
            }
            for (icpt = 0; icpt < 4; ++icpt) {
                for (int i12 = nearestBounds[icpt]; i12 < nearestBounds[icpt + 1]; ++i12) {
                    i1 = F_IND[i12] + 1;
                    int i23 = F_IND[i12 + 1] + 1;
                    i32 = E_IND[i12 + 1] + 1;
                    int i4 = E_IND[i12] + 1;
                    facesExtended.add(i1);
                    facesExtended.add(i23);
                    facesExtended.add(i32);
                    if (!isBinaryFile) {
                        facesExtended.add(0);
                    }
                    ++ijf;
                    facesExtended.add(i1);
                    facesExtended.add(i32);
                    facesExtended.add(i4);
                    if (!isBinaryFile) {
                        facesExtended.add(0);
                    }
                    ++ijf;
                }
            }
            for (icpt = 0; icpt < 4; ++icpt) {
                for (int i13 = nearestBounds[icpt]; i13 < nearestBounds[icpt + 1]; ++i13) {
                    i1 = F_IND[i13] + 1;
                    int i24 = ij;
                    i32 = F_IND[i13 + 1] + 1;
                    facesExtended.add(i1);
                    facesExtended.add(i24);
                    facesExtended.add(i32);
                    if (!isBinaryFile) {
                        facesExtended.add(0);
                    }
                    ++ijf;
                }
            }
        } else {
            int i33;
            int i1;
            int i14;
            int[] B_IND = new int[n_bedges + 1];
            int[] F_IND = new int[n_bedges + 1];
            for (int i15 = 0; i15 < n_bedges; ++i15) {
                B_IND[i15] = (Integer)sortedEdges.get(i15);
            }
            B_IND[n_bedges] = B_IND[0];
            int ij = numPoints;
            double xCenter = 0.0;
            double yCenter = 0.0;
            for (i = 0; i < n_bedges; ++i) {
                double x = vertValues.get(3 * (B_IND[i] - 1));
                double y = vertValues.get(3 * (B_IND[i] - 1) + 1);
                double z = zlow;
                vertsExtended.add(x);
                vertsExtended.add(y);
                vertsExtended.add(z);
                F_IND[i] = ij++;
                xCenter += x;
                yCenter += y;
            }
            F_IND[n_bedges] = F_IND[0];
            vertsExtended.add(xCenter / (double)n_bedges);
            vertsExtended.add(yCenter / (double)n_bedges);
            vertsExtended.add(zlow);
            ++ij;
            int ijf = numFaces;
            for (i14 = 0; i14 < n_bedges; ++i14) {
                i1 = F_IND[i14] + 1;
                int i25 = F_IND[i14 + 1] + 1;
                i33 = B_IND[i14 + 1];
                int i4 = B_IND[i14];
                facesExtended.add(i1);
                facesExtended.add(i25);
                facesExtended.add(i33);
                if (!isBinaryFile) {
                    facesExtended.add(0);
                }
                ++ijf;
                facesExtended.add(i1);
                facesExtended.add(i33);
                facesExtended.add(i4);
                if (!isBinaryFile) {
                    facesExtended.add(0);
                }
                ++ijf;
            }
            for (i14 = 0; i14 < n_bedges; ++i14) {
                i1 = F_IND[i14] + 1;
                int i26 = ij;
                i33 = F_IND[i14 + 1] + 1;
                facesExtended.add(i1);
                facesExtended.add(i26);
                facesExtended.add(i33);
                if (!isBinaryFile) {
                    facesExtended.add(0);
                }
                ++ijf;
            }
        }
        Point3d[] vertices = new Point3d[vertsExtended.size() / 3];
        for (int i16 = 0; i16 < vertsExtended.size() / 3; ++i16) {
            vertices[i16] = new Point3d((Double)vertsExtended.get(3 * i16), (Double)vertsExtended.get(3 * i16 + 1), (Double)vertsExtended.get(3 * i16 + 2));
        }
        int numFacesExt = facesExtended.size() / facesExtendedIter;
        surfs = new Surface[numFacesExt];
        int[] indices = new int[numFacesExt * 3];
        int surfIx = 0;
        int indicesIx = 0;
        for (int i17 = 0; i17 < facesExtended.size(); i17 += facesExtendedIter) {
            indices[indicesIx++] = (Integer)facesExtended.get(i17) - 1;
            indices[indicesIx++] = (Integer)facesExtended.get(i17 + 1) - 1;
            indices[indicesIx++] = (Integer)facesExtended.get(i17 + 2) - 1;
            if (isBinaryFile) continue;
            int surf = (Integer)facesExtended.get(i17 + 3);
            surfs[surfIx] = surf == 0 ? (uniqueSurfs.size() >= 0 ? (Surface)uniqueSurfs.get(0) : this.getDefaultMat()) : (Surface)uniqueSurfs.get(surf - 1);
            ++surfIx;
        }
        if (isBinaryFile) {
            List<Integer> surfIds = surfIDSupplier.get();
            int iter = 0;
            for (int id : surfIds) {
                surfs[iter] = id == 0 ? (uniqueSurfs.size() >= 0 ? (Surface)uniqueSurfs.get(0) : this.getDefaultMat()) : (Surface)uniqueSurfs.get(id - 1);
                ++iter;
            }
            for (i = iter; i < numFacesExt; ++i) {
                surfs[iter] = uniqueSurfs.size() >= 0 ? (Surface)uniqueSurfs.get(0) : this.getDefaultMat();
                ++iter;
            }
        }
        Mesh tempMesh = new Mesh(vertices, indices, 2);
        IElemSource<Elements.Orient> faceOrients = Elements.CCW;
        double degree = 60.0;
        IElemSource<Vector3d> normalMesh = Elements.generateNormals(tempMesh, faceOrients, Math.toRadians(degree));
        IPropsSrc props = IObstruction.getDisplayProps(surfs, new Color[]{null}, false, GeomUtil.isCullGeom(tempMesh));
        IElemSource<Boolean> creases = PyroSim.FDS7_DEBUG ? Elements.ALL_CREASE : Elements.generateCreasesFromNormals(tempMesh, props, normalMesh, faceOrients);
        elements.setIfNotDefault(Elements.NORMAL, normalMesh);
        elements.setIfNotDefault(Elements.CREASE, creases);
        return new Pair<IGeom, Surface[]>(tempMesh, surfs);
    }

    private Pair<IGeom, Surface[]> parseXYZTerrain(FDSParseRecord rec, IPropertySet elements) throws FDSRecordFormatException {
        int i;
        int i4;
        int i3;
        int i2;
        int i1;
        int i5;
        int j;
        int numZ_expected;
        Surface surf;
        Object names;
        Surface[] surfs = null;
        Predicate<Surface> surfFilter = Obstruction.getSurfaceFilter();
        if (rec.contains("SURF_ID6")) {
            this.addWarning(rec, String.format(Intl.intl("Terrain GEOM records do not support %s."), "SURF_ID6"), String.format(Intl.intl("%s dropped from record."), "SURF_ID6"));
            surfs = new Surface[]{this.getDefaultMat()};
        } else if (rec.contains("SURF_ID")) {
            names = rec.getList("SURF_ID", true);
            surf = this.getSurfaceSafe(rec, (String)names.get(0), surfFilter);
            surfs = new Surface[]{surf};
        } else {
            names = rec.getArray("SURF_IDS", true);
            surf = this.getSurfaceSafe(rec, (String)((FDSArray)names).get(0), surfFilter);
            surfs = new Surface[]{surf};
        }
        FDSArray xb = rec.getArray("XB", true);
        double xb_xMin = ((UnitDouble)xb.get(0)).get(SI.METER);
        double xb_xMax = ((UnitDouble)xb.get(1)).get(SI.METER);
        double xb_yMin = ((UnitDouble)xb.get(2)).get(SI.METER);
        double xb_yMax = ((UnitDouble)xb.get(3)).get(SI.METER);
        Double zMin_specified = rec.getDouble("ZMIN");
        FDSArray terrainIJK = rec.getArray("IJK", true);
        int n_xVals = (Integer)terrainIJK.get(0);
        int n_yVals = (Integer)terrainIJK.get(1);
        if (n_xVals < 2 || n_yVals < 2) {
            throw new FDSRecordFormatException(rec, Intl.intl("Error: IJK(1) and IJK(2) on %GEOM line needs to be at least 2"));
        }
        List zValsAsUD = rec.getList("ZVALS", true);
        ArrayList<Double> zvals = new ArrayList<Double>();
        for (UnitDouble item : zValsAsUD) {
            zvals.add(item.getValue(SI.METER));
        }
        int n_zvals = zValsAsUD.size();
        if (n_zvals != (numZ_expected = n_xVals * n_yVals)) {
            throw new FDSRecordFormatException(rec, String.format(Intl.intl("ERROR: Expected %d Z values, found %d"), numZ_expected, n_zvals));
        }
        boolean extendTerrain = rec.getBoolean("EXTEND_TERRAIN", true);
        Double zvalHorizon = rec.getDouble("ZVAL_HORIZON", true);
        double zvalFactor = 1.0;
        if (zvalHorizon == null) {
            zvalHorizon = 1.0009999999999998E20;
        }
        if (zvalHorizon > 1.0E20) {
            zvalFactor = 0.0;
        }
        double XLOW = Double.MAX_VALUE;
        double XHI = -1.7976931348623157E308;
        double YLOW = Double.MAX_VALUE;
        double YHI = -1.7976931348623157E308;
        if (extendTerrain) {
            for (MeshData mesh : this.d_meshes) {
                XLOW = Math.min(XLOW, mesh.meshXB[0].x());
                XHI = Math.max(XHI, mesh.meshXB[1].x());
                YLOW = Math.min(YLOW, mesh.meshXB[0].y());
                YHI = Math.max(YHI, mesh.meshXB[1].y());
            }
            boolean write_warning = false;
            if (xb_xMin <= XLOW || xb_xMax >= XHI) {
                write_warning = true;
                extendTerrain = false;
            }
            if (xb_yMin <= YLOW || xb_yMax >= YHI) {
                write_warning = true;
                extendTerrain = false;
            }
            if (write_warning) {
                throw new FDSRecordFormatException(rec, Intl.intl("Cannot be extended. When setting EXTEND_TERRAIN= TRUE, make sure it lays entirely within the computational domain"));
            }
        }
        double ZMIN2 = 1.0E10;
        for (MeshData mesh : this.d_meshes) {
            ZMIN2 = Math.min(ZMIN2, mesh.meshXB[0].z() - (double)(6 / mesh.meshIJK.get(2)) * (mesh.meshXB[1].z() - mesh.meshXB[0].z()));
        }
        double ZHI = (Double)Collections.max(zvals);
        double ZLOW = (Double)Collections.min(zvals);
        ZLOW = Math.min(Math.floor(ZLOW - 0.1 * (ZHI - ZLOW)), ZMIN2);
        if (zMin_specified != null) {
            ZLOW = Math.min(ZLOW, zMin_specified);
        }
        ArrayList<Double> verts = new ArrayList<Double>();
        int z_index = 1;
        for (int j2 = 1; j2 <= n_yVals; ++j2) {
            for (int i6 = 1; i6 <= n_xVals; ++i6) {
                verts.add((xb_xMin * (double)(n_xVals - i6) + xb_xMax * (double)(i6 - 1)) / (double)(n_xVals - 1));
                verts.add((xb_yMin * (double)(n_yVals - j2) + xb_yMax * (double)(j2 - 1)) / (double)(n_yVals - 1));
                verts.add((Double)zvals.get(z_index - 1));
                ++z_index;
            }
        }
        int[] B_IND = new int[2 * (n_xVals + n_yVals) - 3];
        int[] E_IND = new int[2 * (n_xVals + n_yVals) - 3];
        int[] F_IND = new int[2 * (n_xVals + n_yVals) - 3];
        int bIndIx = 0;
        int i7 = 1;
        while (i7 <= n_xVals) {
            B_IND[bIndIx] = i7++;
            ++bIndIx;
        }
        for (j = 2; j <= n_yVals; ++j) {
            B_IND[bIndIx] = (j - 1) * n_xVals + n_xVals;
            ++bIndIx;
        }
        for (i7 = n_xVals - 1; i7 >= 1; --i7) {
            B_IND[bIndIx] = (n_yVals - 1) * n_xVals + i7;
            ++bIndIx;
        }
        for (j = n_yVals - 1; j >= 2; --j) {
            B_IND[bIndIx] = (j - 1) * n_xVals + 1;
            ++bIndIx;
        }
        B_IND[bIndIx] = B_IND[0];
        int IJB = bIndIx + 1;
        ArrayList<Integer> faces = new ArrayList<Integer>();
        for (int j3 = 1; j3 <= n_yVals - 1; ++j3) {
            for (i5 = 1; i5 <= n_xVals - 1; ++i5) {
                i1 = (j3 - 1) * n_xVals + i5;
                i2 = i1 + 1;
                i3 = i2 + n_xVals;
                i4 = i3 - 1;
                faces.add(i1 - 1);
                faces.add(i2 - 1);
                faces.add(i3 - 1);
                faces.add(i1 - 1);
                faces.add(i3 - 1);
                faces.add(i4 - 1);
            }
        }
        if (extendTerrain) {
            int i42;
            int i32;
            int i22;
            int i12;
            int j4;
            int i8;
            double DELX = (XHI - XLOW) / (double)(n_xVals - 1);
            double DELY = (YHI - YLOW) / (double)(n_yVals - 1);
            int IJE = 1;
            int IJ = z_index;
            for (i8 = 1; i8 <= n_xVals; ++i8) {
                verts.add(XLOW + DELX * (double)(i8 - 1));
                verts.add(YLOW);
                verts.add((1.0 - zvalFactor) * (Double)zvals.get(i8 - 1) + zvalFactor * zvalHorizon);
                E_IND[IJE - 1] = IJ++;
                ++IJE;
            }
            for (j4 = 2; j4 <= n_yVals; ++j4) {
                verts.add(XLOW + DELX * (double)(n_xVals - 1));
                verts.add(YLOW + DELY * (double)(j4 - 1));
                verts.add((1.0 - zvalFactor) * (Double)zvals.get((j4 - 1) * n_xVals + n_xVals - 1) + zvalFactor * zvalHorizon);
                E_IND[IJE - 1] = IJ++;
                ++IJE;
            }
            for (i8 = n_xVals - 1; i8 >= 1; --i8) {
                verts.add(XLOW + DELX * (double)(i8 - 1));
                verts.add(YLOW + DELY * (double)((Integer)terrainIJK.get(1) - 1));
                verts.add((1.0 - zvalFactor) * (Double)zvals.get((n_yVals - 1) * n_xVals + i8 - 1) + zvalFactor * zvalHorizon);
                E_IND[IJE - 1] = IJ++;
                ++IJE;
            }
            for (j4 = n_yVals - 1; j4 >= 2; --j4) {
                verts.add(XLOW);
                verts.add(YLOW + DELY * (double)(j4 - 1));
                verts.add((1.0 - zvalFactor) * (Double)zvals.get((j4 - 1) * n_xVals + 1 - 1) + zvalFactor * zvalHorizon);
                E_IND[IJE - 1] = IJ++;
                ++IJE;
            }
            E_IND[IJE - 1] = E_IND[0];
            for (i8 = 1; i8 <= IJE - 1; ++i8) {
                verts.add((Double)verts.get(3 * E_IND[i8 - 1] - 2 - 1));
                verts.add((Double)verts.get(3 * E_IND[i8 - 1] - 1 - 1));
                verts.add(ZLOW);
                F_IND[i8 - 1] = IJ++;
            }
            F_IND[IJE - 1] = F_IND[0];
            for (i8 = 1; i8 <= 2 * (n_xVals + n_yVals) - 4; ++i8) {
                i12 = E_IND[i8 - 1];
                i22 = E_IND[i8 + 1 - 1];
                i32 = B_IND[i8 + 1 - 1];
                i42 = B_IND[i8 - 1];
                faces.add(i12 - 1);
                faces.add(i22 - 1);
                faces.add(i32 - 1);
                faces.add(i12 - 1);
                faces.add(i32 - 1);
                faces.add(i42 - 1);
            }
            for (i8 = 1; i8 <= 2 * (n_xVals + n_yVals) - 4; ++i8) {
                i12 = F_IND[i8 - 1];
                i22 = F_IND[i8 + 1 - 1];
                i32 = E_IND[i8 + 1 - 1];
                i42 = E_IND[i8 - 1];
                faces.add(i12 - 1);
                faces.add(i22 - 1);
                faces.add(i32 - 1);
                faces.add(i12 - 1);
                faces.add(i32 - 1);
                faces.add(i42 - 1);
            }
        } else {
            int IJ = z_index;
            for (i5 = 1; i5 <= IJB - 1; ++i5) {
                verts.add((Double)verts.get(3 * B_IND[i5 - 1] - 2 - 1));
                verts.add((Double)verts.get(3 * B_IND[i5 - 1] - 1 - 1));
                verts.add(ZLOW);
                F_IND[i5 - 1] = IJ++;
            }
            F_IND[bIndIx] = F_IND[0];
            for (i5 = 1; i5 <= 2 * (n_xVals + n_yVals) - 4; ++i5) {
                i1 = F_IND[i5 - 1];
                i2 = F_IND[i5 + 1 - 1];
                i3 = B_IND[i5 + 1 - 1];
                i4 = B_IND[i5 - 1];
                faces.add(i1 - 1);
                faces.add(i2 - 1);
                faces.add(i3 - 1);
                faces.add(i1 - 1);
                faces.add(i3 - 1);
                faces.add(i4 - 1);
            }
        }
        int i13 = F_IND[0];
        int i23 = F_IND[1];
        int i33 = F_IND[2 * (n_xVals + n_yVals) - 3 - 1 - 1];
        faces.add(i23 - 1);
        faces.add(i13 - 1);
        faces.add(i33 - 1);
        for (i = 2; i <= (2 * (n_xVals + n_yVals) - 6) / 2; ++i) {
            i13 = F_IND[i - 1];
            i23 = F_IND[i + 1 - 1];
            i33 = F_IND[2 * (n_xVals + n_yVals) - 3 - i - 1];
            int i43 = F_IND[2 * (n_xVals + n_yVals) - 2 - i - 1];
            faces.add(i23 - 1);
            faces.add(i13 - 1);
            faces.add(i43 - 1);
            faces.add(i23 - 1);
            faces.add(i43 - 1);
            faces.add(i33 - 1);
        }
        i = (2 * (n_xVals + n_yVals) - 4) / 2;
        i13 = F_IND[i - 1];
        i23 = F_IND[i + 1 - 1];
        i33 = F_IND[i + 2 - 1];
        faces.add(i23 - 1);
        faces.add(i13 - 1);
        faces.add(i33 - 1);
        int[] indicies = new int[faces.size()];
        for (i = 0; i < faces.size(); ++i) {
            indicies[i] = (Integer)faces.get(i);
        }
        Point3d[] verts3d = new Point3d[verts.size() / 3];
        int m = 0;
        while (m < verts.size()) {
            int vix = m / 3;
            verts3d[vix] = new Point3d((Double)verts.get(m++), (Double)verts.get(m++), (Double)verts.get(m++));
        }
        Mesh tempMesh = new Mesh(verts3d, indicies, 2);
        IElemSource<Elements.Orient> faceOrients = Elements.CCW;
        double degree = 60.0;
        IElemSource<Vector3d> normalMesh = Elements.generateNormals(tempMesh, faceOrients, Math.toRadians(degree));
        IPropsSrc props = IObstruction.getDisplayProps(surfs, new Color[]{null}, false, GeomUtil.isCullGeom(tempMesh));
        IElemSource<Boolean> creases = Elements.generateCreasesFromNormals(tempMesh, props, normalMesh, faceOrients);
        elements.setIfNotDefault(Elements.NORMAL, normalMesh);
        elements.setIfNotDefault(Elements.CREASE, creases);
        Mesh geom = tempMesh;
        return new Pair<IGeom, Surface[]>(geom, surfs);
    }

    private Pair<IGeom, Surface[]> parseExtrudedPolygon(FDSParseRecord rec) throws FDSRecordFormatException {
        int i;
        double geomEPS = 1.0E-12;
        UnitDouble extrude = rec.getUnitDouble("EXTRUDE");
        List poly = rec.getList("POLY", true);
        List verts = rec.getList("VERTS", true);
        Surface[] surfs = new Surface[]{this.getDefaultMat()};
        Predicate<Surface> surfFilter = Obstruction.getSurfaceFilter();
        if (rec.contains("SURF_ID6")) {
            this.addWarning(rec, String.format(Intl.intl("Extruded polygon GEOM records do not support %s."), "SURF_ID6"), String.format(Intl.intl("%s dropped from record."), "SURF_ID6"));
            surfs = new Surface[]{this.getDefaultMat()};
        } else if (rec.contains("SURF_ID")) {
            List names = rec.getList("SURF_ID", true);
            Surface surf = this.getSurfaceSafe(rec, (String)names.get(0), surfFilter);
            surfs = new Surface[]{surf};
        } else if (rec.contains("SURF_IDS")) {
            FDSArray surfIDs = rec.getArray("SURF_IDS", false);
            if (surfIDs.getTotalLength() != 3) {
                this.addWarning(rec, String.format(Intl.intl("%s only supports 3 elements."), "SURF_IDS"), String.format(Intl.intl("%s dropped from record."), "SURF_IDS"));
                surfs = new Surface[]{this.getDefaultMat()};
            } else {
                surfs = new Surface[poly.size() + 2];
                surfs[0] = this.getSurfaceSafe(rec, (String)surfIDs.get(0), surfFilter);
                surfs[1] = this.getSurfaceSafe(rec, (String)surfIDs.get(2), surfFilter);
                Surface rest = this.getSurfaceSafe(rec, (String)surfIDs.get(1), surfFilter);
                for (i = 2; i < surfs.length; ++i) {
                    surfs[i] = rest;
                }
            }
        }
        ArrayList<Point3d> vertPoints = new ArrayList<Point3d>();
        for (int i2 = 0; i2 < verts.size(); i2 += 3) {
            vertPoints.add(new Point3d((Double)verts.get(i2), (Double)verts.get(i2 + 1), (Double)verts.get(i2 + 2)));
        }
        if (Math.abs(extrude.get(Geometry.LU)) < geomEPS) {
            throw new FDSRecordFormatException("Extruded polygon GEOM: Extrusion distance in EXTRUDE field not defined or zero. Define EXTRUDE value in &GEOM.");
        }
        if (poly.size() > vertPoints.size()) {
            throw new FDSRecordFormatException("Extruded polygon GEOM: Number of POLY indexes (" + poly.size() + ") is greater than the number of VERTS (" + verts.size() + ").");
        }
        for (int j = 0; j < poly.size(); ++j) {
            for (i = j + 1; i < poly.size(); ++i) {
                if (poly.get(i) == poly.get(j)) {
                    throw new FDSRecordFormatException("Extruded polygon GEOM: Repeated vertex " + poly.get(i) + " in Polyline");
                }
                Vector3d v1 = Util3D.vector((Point3d)vertPoints.get((Integer)poly.get(i) - 1), (Point3d)vertPoints.get((Integer)poly.get(j) - 1));
                if (!(v1.length() < geomEPS)) continue;
                throw new FDSRecordFormatException("Extruded polygon GEOM: Vertices " + poly.get(i) + " and " + poly.get(j) + " have the same position");
            }
        }
        Point3d[] vertPointsArray = new Point3d[vertPoints.size()];
        for (i = 0; i < poly.size(); ++i) {
            vertPointsArray[i] = (Point3d)vertPoints.get((Integer)poly.get(i) - 1);
        }
        if (!Util3D.areCoplanar(0.001, vertPointsArray)) {
            throw new FDSRecordFormatException("Extruded polygon GEOM: not all verticies are on the same plane");
        }
        Plane3d polyPlane = Util3D.simplePolygonPlane(vertPoints, false, 0.001);
        if (polyPlane == null) {
            throw new FDSRecordFormatException("Extruded polygon GEOM: Issue with verts, check their definition");
        }
        IPolygon polyObj = PolyUtil.newPoly(vertPointsArray);
        Vector3d extrudeVec = polyPlane.getNormal();
        extrudeVec.scale(extrude.get(Geometry.LU));
        ExtrudedPoly extPoly = new ExtrudedPoly(polyObj, extrudeVec);
        return new Pair<IGeom, Surface[]>(extPoly, surfs);
    }

    private Pair<IGeom, Surface[]> parseUnstructuredSolid(FDSParseRecord rec, IPropertySet elements) throws FDSRecordFormatException {
        List faces = rec.getList("FACES", true);
        List vertComps = rec.getList("VERTS", true);
        IGeom geom = EmptyGeom.INSTANCE;
        Surface[] surfs = new Surface[]{};
        List<Object> uniqueSurfs = new ArrayList();
        if (!faces.isEmpty() && !vertComps.isEmpty()) {
            int i;
            FDSArray surfIDs;
            if (rec.contains("SURF_ID")) {
                uniqueSurfs = this.getUniqueSurfs(rec);
            } else if (rec.contains("SURF_IDS")) {
                surfIDs = rec.getArray("SURF_IDS", false);
                i = 0;
                while (i < 3) {
                    uniqueSurfs.add(this.getSurfaceSafe(rec, (String)surfIDs.get(i++), Obstruction.getSurfaceFilter()));
                }
            } else if (rec.contains("SURF_ID6")) {
                surfIDs = rec.getArray("SURF_ID6", false);
                i = 0;
                while (i < 6) {
                    uniqueSurfs.add(this.getSurfaceSafe(rec, (String)surfIDs.get(i++), Obstruction.getSurfaceFilter()));
                }
            }
            Point3d[] verts = new Point3d[vertComps.size() / 3];
            int m = 0;
            while (m < vertComps.size()) {
                int vix = m / 3;
                verts[vix] = new Point3d((Double)vertComps.get(m++), (Double)vertComps.get(m++), (Double)vertComps.get(m++));
            }
            int nfaces = faces.size() / 4;
            surfs = new Surface[nfaces];
            int soffset = 0;
            int[] indices = new int[nfaces * 3];
            int ioffset = 0;
            int m2 = 0;
            while (m2 < faces.size()) {
                indices[ioffset++] = (Integer)faces.get(m2++) - 1;
                indices[ioffset++] = (Integer)faces.get(m2++) - 1;
                indices[ioffset++] = (Integer)faces.get(m2++) - 1;
                int isurf = (Integer)faces.get(m2++);
                surfs[soffset++] = isurf == 0 ? this.getDefaultMat() : (Surface)uniqueSurfs.get(isurf - 1);
            }
            Mesh tempMesh = new Mesh(verts, indices, 2);
            IElemSource<Elements.Orient> faceOrients = Elements.CCW;
            double degree = 60.0;
            IElemSource<Vector3d> normalMesh = Elements.generateNormals(tempMesh, faceOrients, Math.toRadians(degree));
            IPropsSrc props = IObstruction.getDisplayProps(surfs, new Color[]{null}, false, GeomUtil.isCullGeom(tempMesh));
            IElemSource<Boolean> creases = PyroSim.FDS7_DEBUG ? Elements.ALL_CREASE : Elements.generateCreasesFromNormals(tempMesh, props, normalMesh, faceOrients);
            elements.setIfNotDefault(Elements.NORMAL, normalMesh);
            elements.setIfNotDefault(Elements.CREASE, creases);
            geom = tempMesh;
        }
        return new Pair<IGeom, Surface[]>(geom, surfs);
    }

    private static boolean isBinGeom(FDSParseRecord rec) {
        return rec.contains("BINARY_FILE");
    }

    private static boolean isBlock(FDSParseRecord rec) {
        return rec.contains("XB") && !rec.contains("ZVALS") && !rec.contains("IS_TERRAIN");
    }

    private static boolean isSphere(FDSParseRecord rec) {
        return rec.contains("SPHERE_ORIGIN");
    }

    private static boolean isCylinder(FDSParseRecord rec) {
        return rec.contains("CYLINDER_LENGTH");
    }

    private static boolean isTerrainWithZvals(FDSParseRecord rec) {
        return rec.contains("ZVALS");
    }

    private static boolean isTerrainWithVertsandFaces(FDSParseRecord rec) {
        return rec.contains("IS_TERRAIN");
    }

    private static boolean isExtrudedPoly(FDSParseRecord rec) {
        return rec.contains("EXTRUDE");
    }

    private static /* synthetic */ Integer lambda$defineCylinder$3(Map normalMap, Vector3d ti) {
        return normalMap.size();
    }

    private static /* synthetic */ Integer lambda$defineCylinder$2(Map normalMap, Vector3d ti) {
        return normalMap.size();
    }

    private static /* synthetic */ Integer lambda$defineCylinder$1(Map normalMap, Vector3d ti) {
        return normalMap.size();
    }

    private static /* synthetic */ Integer lambda$defineCylinder$0(Map normalMap, Vector3d ti) {
        return normalMap.size();
    }

    private static class MeshData {
        private final FDSArray<Integer> meshIJK;
        private final UnitPoint3D[] meshXB;

        public MeshData(FDSArray<Integer> meshIJK, UnitPoint3D[] meshXB) {
            this.meshIJK = meshIJK;
            this.meshXB = meshXB;
        }

        public double getMeshDx() {
            return (this.meshXB[1].x() - this.meshXB[0].x()) / (double)this.meshIJK.get(0).intValue();
        }
    }

    private static class vertsAndFaces {
        private int nVerts = 12;
        private int nFaces = 20;

        private vertsAndFaces() {
        }

        public int getVerts() {
            return this.nVerts;
        }

        public int getFaces() {
            return this.nFaces;
        }

        public void setVerts(int v) {
            this.nVerts = v;
        }

        public void setFaces(int f) {
            this.nFaces = f;
        }
    }
}

