/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v7.parsers;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import pyrosim.Intl;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.DefaultSurface;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.EvacProps;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v7.parsers.AFDS7Parser;
import pyrosim.io.fds.v7.parsers.FDS7ParsingInfo;
import pyrosim.util.Util;

public abstract class AFDSObjParser
extends AFDS7Parser {
    private int d_nextObjNum = 1;
    private Map<String, Object> d_compositesMap = new LinkedHashMap<String, Object>();

    public AFDSObjParser(FDS7ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    protected String generateName(FDSParseRecord rec, String idKey, String baseName) {
        String id;
        if (idKey != null && (id = rec.getString(idKey)) != null && !id.isEmpty()) {
            return id;
        }
        String desc = rec.getComment();
        if (desc == null || desc.equals("")) {
            desc = String.format(Intl.intl("%1$s #%2$d"), baseName, this.d_nextObjNum++);
        }
        return desc;
    }

    protected void addObjects(String name, List<? extends IPyroObject> objs) {
        if (objs.isEmpty()) {
            return;
        }
        if (objs.size() == 1) {
            this.addObject(objs.get(0));
        } else {
            ModelComposite group = new ModelComposite(name);
            group.addAll(objs);
            this.addObject(group);
        }
    }

    protected void addObject(IPyroObject obj) {
        String name = Util.getName(obj);
        Object existingEntry = this.d_compositesMap.get(name);
        if (existingEntry != null) {
            if (existingEntry instanceof List) {
                ((List)existingEntry).add(obj);
            } else {
                ArrayList<IPyroObject> list = new ArrayList<IPyroObject>();
                list.add((IPyroObject)existingEntry);
                list.add(obj);
                this.d_compositesMap.put(name, list);
            }
        } else {
            this.d_compositesMap.put(name, obj);
        }
    }

    @Override
    public void done() throws FDSRecordFormatException {
        ModelComposite root = this.getContainer().getObstructions();
        for (Map.Entry<String, Object> entry : this.d_compositesMap.entrySet()) {
            Object objVal = entry.getValue();
            if (objVal instanceof IPyroObject) {
                IPyroObject obj = (IPyroObject)objVal;
                root.add(obj);
                this.flagObjectAdded(obj);
                continue;
            }
            assert (objVal instanceof List);
            List objs = (List)objVal;
            ModelComposite comp = new ModelComposite(entry.getKey());
            comp.addAll(objs);
            root.add(comp);
            this.flagObjectAdded(comp);
        }
    }

    protected DefaultSurface getDefaultMat() {
        return this.getContainer().getSurfaceMgr().getDefaultSurfaceObj();
    }

    protected Surface getSurfaceSafe(FDSParseRecord rec, String surfaceName, Predicate<Surface> filter) throws FDSRecordFormatException {
        if (surfaceName == null) {
            return this.getDefaultMat();
        }
        Surface mat = this.findObject(Surface.class, surfaceName);
        if (mat == null) {
            throw new FDSRecordFormatException(rec, String.format(Intl.intl("The SURF, %s, does not exist in the model."), surfaceName));
        }
        if (!filter.test(mat)) {
            throw new FDSRecordFormatException(rec, String.format(Intl.intl("The SURF, %1$s, cannot be applied to the %2$s."), surfaceName, rec.getType()));
        }
        return mat;
    }

    protected EvacProps parseEvac(FDSParseRecord rec, String evacKey, String meshIDKey) throws FDSRecordFormatException {
        int options = 0;
        Boolean evacFlag = rec.getBoolean("EVACUATION");
        if (evacFlag == null) {
            options = 0;
        } else if (evacFlag.booleanValue()) {
            options = 2;
        } else if (!evacFlag.booleanValue()) {
            options = 1;
        }
        Grid mesh = null;
        if (rec.contains("MESH_ID")) {
            mesh = this.findObject(rec, Grid.class, rec.getString("MESH_ID"), true);
        }
        return mesh == null && options == 0 ? EvacProps.DEFAULT : EvacProps.get(options, mesh);
    }
}

