/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v7.common;

import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;

public class GeomUtil {
    public static int toFDSVec(Vector3d worldVec) {
        if (worldVec == null) {
            return 0;
        }
        Vector3d axisVec = thunderheadeng.geometry.objs.GeomUtil.getClosestAxis(worldVec);
        if (axisVec == GeomConstants.VEC3D_XNEG) {
            return -1;
        }
        if (axisVec == GeomConstants.VEC3D_XPOS) {
            return 1;
        }
        if (axisVec == GeomConstants.VEC3D_YNEG) {
            return -2;
        }
        if (axisVec == GeomConstants.VEC3D_YPOS) {
            return 2;
        }
        if (axisVec == GeomConstants.VEC3D_ZNEG) {
            return -3;
        }
        if (axisVec == GeomConstants.VEC3D_ZPOS) {
            return 3;
        }
        return 0;
    }

    public static Vector3d toWorldVec(int fdsVec) {
        switch (fdsVec) {
            case 0: {
                return null;
            }
            case -1: {
                return GeomConstants.VEC3D_XNEG;
            }
            case 1: {
                return GeomConstants.VEC3D_XPOS;
            }
            case -2: {
                return GeomConstants.VEC3D_YNEG;
            }
            case 2: {
                return GeomConstants.VEC3D_YPOS;
            }
            case -3: {
                return GeomConstants.VEC3D_ZNEG;
            }
            case 3: {
                return GeomConstants.VEC3D_ZPOS;
            }
        }
        return null;
    }
}

