/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.DefaultSurface;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.ramp.Ramp;
import pyrosim.geom.Geometry;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.common.GeomUtil;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import pyrosim.io.fds.v6.renderers.ExSpecRenderer;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import pyrosim.io.fds.v6.renderers.PinConnectionRenderer;
import pyrosim.io.fds.v6.renderers.RampRenderer;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.RTree;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.NameGenerator;
import thunderheadeng.util.theUtil;

public class VentRenderer
extends AFDS6Renderer {
    private final ExSpecRenderer d_specRend;
    private final FDSNameMap d_nameMap;
    private final PinConnectionRenderer d_pinConns;
    private final Map<Vent, String> d_ventNames;
    private final NameGenerator d_nameGen;
    private RTree<Grid> d_grids;
    private final Map<Vent, Integer> d_ventIxes = new LinkedIdentityHashMap<Vent, Integer>();
    private int d_ventIx = 0;

    public VentRenderer(PinConnectionRenderer pinConns, FDSNameMap nameMap, ExSpecRenderer specRend, Map<Vent, String> ventNames) {
        this.d_pinConns = pinConns;
        this.d_nameMap = nameMap;
        this.d_specRend = specRend;
        this.d_ventNames = ventNames;
        this.d_nameGen = new NameGenerator(Intl.intl("Vent"), 2, false);
        this.d_grids = new RTree();
    }

    public Map<Vent, Integer> getVentIxes() {
        return this.d_ventIxes;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> types) {
        types.add(Grid.class);
        types.add(Vent.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer props, Collection<? extends IPyroObject> objs) {
        this.d_grids.clear();
        for (Grid g : (Collection)props.props().getRasterGridSupplier().apply(objs)) {
            this.d_grids.insert(g.getBounds(), g);
        }
        return super.render(props, theUtil.filter(objs, Vent.class));
    }

    @Override
    public boolean markDependency(DepSnapshot deps, IPyroObject obj, boolean renderExplicit) {
        if (!(obj instanceof Vent)) {
            return false;
        }
        Vent v = (Vent)obj;
        String name = this.d_nameGen.generateValidName(v.getName());
        this.d_nameGen.registerName(name);
        this.d_ventNames.put(v, name);
        return true;
    }

    private Vent.VentGeom snapGeom(Vent.VentGeom vg) {
        Grid[] maxAreaGrid = new Grid[]{null};
        IsectArea[] maxAreaOnGrid = new IsectArea[]{new IsectArea(0.0, 0.0)};
        this.d_grids.find(new AABoxTest(vg.getBoundingBox(new AABox()), 1.0E-6), (grid, ctmt) -> {
            IsectArea isectArea = VentRenderer.getIsectArea(grid, vg);
            if (isectArea == null) {
                return;
            }
            if (isectArea.area > maxAreaOnGrid[0].area) {
                maxAreaOnGrid[0] = isectArea;
                maxAreaGrid[0] = grid;
            }
        });
        if (maxAreaGrid[0] == null) {
            return vg;
        }
        return new Vent.VentGeom(new AARectangle(vg.d_plane, maxAreaOnGrid[0].snapLoc, vg.d_minx, vg.d_miny, vg.d_maxx, vg.d_maxy, vg.flipped), vg.normal, vg.centerPoint, vg.louver, vg.radius);
    }

    private static IsectArea getIsectArea(Grid grid, Vent.VentGeom vg) {
        double[] pbounds;
        double pval2;
        double pval1;
        AABox gridBounds = grid.getBounds();
        switch (vg.d_plane) {
            case 0: {
                pval1 = gridBounds.getMinX();
                pval2 = gridBounds.getMaxX();
                pbounds = new double[]{gridBounds.getMinY(), gridBounds.getMinZ(), gridBounds.getMaxY(), gridBounds.getMaxZ()};
                break;
            }
            case 1: {
                pval1 = gridBounds.getMinY();
                pval2 = gridBounds.getMaxY();
                pbounds = new double[]{gridBounds.getMinX(), gridBounds.getMinZ(), gridBounds.getMaxX(), gridBounds.getMaxZ()};
                break;
            }
            default: {
                pval1 = gridBounds.getMinZ();
                pval2 = gridBounds.getMaxZ();
                pbounds = new double[]{gridBounds.getMinX(), gridBounds.getMinY(), gridBounds.getMaxX(), gridBounds.getMaxY()};
            }
        }
        boolean aligned1 = theUtil.eq(vg.d_planeVal, pval1, 1.0E-6);
        boolean aligned2 = theUtil.eq(vg.d_planeVal, pval2, 1.0E-6);
        if (aligned1 || aligned2) {
            double area;
            double maxx = Double.min(vg.d_maxx, pbounds[2]);
            double minx = Double.max(vg.d_minx, pbounds[0]);
            double maxy = Double.min(vg.d_maxy, pbounds[3]);
            double miny = Double.max(vg.d_miny, pbounds[1]);
            if (minx < maxx && miny < maxy && (area = (maxx - minx) * (maxy - miny)) > 1.0E-6) {
                return new IsectArea(area, aligned1 ? pval1 : pval2);
            }
        }
        return null;
    }

    @Override
    public boolean render(IFDSRecordRenderer props, IPyroObject o) {
        boolean isCircVent;
        Vent obj = (Vent)o;
        FDSRenderRecord rec = FDS6Const.newRenderRecord("VENT");
        if (this.d_ventNames.containsKey(obj)) {
            String name = this.d_ventNames.get(obj);
            rec.setValue("ID", name);
        } else {
            rec.setValue("ID", obj.getName());
        }
        rec.setComment(obj.getDesc());
        Surface surf = obj.getSurface();
        if (!surf.getClass().equals(DefaultSurface.class)) {
            rec.setValue("SURF_ID", surf.getName());
        } else {
            rec.setValue("SURF_ID", ((DefaultSurface)surf).getDefaultSurfaceName());
        }
        Vent.VentGeom geom = this.snapGeom(obj.getVentGeom());
        AABox bounds = geom.getBoundingBox(new AABox());
        VentRenderer.renderAABox(rec, "XB", bounds);
        int normal = GeomUtil.toFDSVec(obj.getNormal());
        if (normal != 0) {
            rec.setValue("IOR", normal, true);
        }
        Color color = VentRenderer.resolveSurfaceColor(obj.getColors()[0], surf);
        VentRenderer.renderColor(rec, obj.isVisible(), color, "RGB", "COLOR", "TRANSPARENCY");
        VentRenderer.renderTextureOrigin(rec, "TEXTURE_ORIGIN", obj, obj.getTextureOrigin());
        rec.setValue("OUTLINE", obj.getOptions(1), false);
        VentRenderer.renderEvac(rec, "EVACUATION", "MESH_ID", obj.getEvac());
        boolean requireXYZ = false;
        if (obj.getFireSpreadRate() != null) {
            rec.setValue("SPREAD_RATE", obj.getFireSpreadRate());
            requireXYZ = true;
        }
        if (obj.getRadius() != null) {
            rec.setValue("RADIUS", obj.getRadius(), false);
            requireXYZ = true;
        }
        boolean useSpreadRate = obj.getFireSpreadRate() != null && obj.getFireSpreadRate().getValueNoUnit() > 0.0;
        boolean bl = isCircVent = obj.getRadius() != null && obj.getRadius().getValueNoUnit() > 0.0;
        if (obj.getCenterPoint() != null && (useSpreadRate || isCircVent)) {
            VentRenderer.renderLoc(rec, "XYZ", obj.getCenterPoint(), true);
        } else if (requireXYZ) {
            VentRenderer.renderLoc(rec, "XYZ", new UnitPoint3D((bounds.getMaxX() + bounds.getMinX()) / 2.0, (bounds.getMaxY() + bounds.getMinY()) / 2.0, (bounds.getMaxZ() + bounds.getMinZ()) / 2.0, Geometry.LU), true);
        }
        HashMap<String, Ramp> ramps = new HashMap<String, Ramp>();
        this.renderOpenProps(rec, obj, ramps);
        this.renderLouver(rec, obj.getLouver());
        VentRenderer.renderCustomFDSProps(rec, obj);
        if (!surf.getName().equals("OPEN") && !surf.getName().equals("MIRROR")) {
            this.d_pinConns.markForInputRetrieval(obj.getInputPin(), rec, "CTRL_ID", "DEVC_ID");
            this.d_pinConns.renderConnections(props, obj);
        } else {
            props.render(rec, o);
        }
        this.d_ventIxes.put(obj, this.d_ventIx);
        ++this.d_ventIx;
        RampRenderer.render(props, ramps, this.d_pinConns);
        return true;
    }

    private void renderLouver(FDSRenderRecord rec, Vector3d louver) {
        if (louver == null) {
            return;
        }
        FDSArray<Double> uvw = new FDSArray<Double>(louver.x, louver.y, louver.z);
        rec.setValue("UVW", uvw);
    }

    private void renderOpenProps(FDSRenderRecord rec, Vent vent, Map<String, Ramp> ramps) {
        if (vent.getOpenProps() == null) {
            return;
        }
        Vent.OpenProps openProps = vent.getOpenProps();
        rec.setValue("TMP_EXTERIOR", openProps.temp, false);
        rec.setValue("DYNAMIC_PRESSURE", openProps.pressure.val, false);
        if (((UnitDouble)openProps.pressure.val).getValueNoUnit() > 0.0) {
            VentRenderer.renderTimeFunc(rec, this.d_nameMap, ramps, vent.getName(), openProps.pressure.func, "PRESSURE_RAMP", null);
        }
    }

    private static class IsectArea {
        public final double area;
        public final double snapLoc;

        public IsectArea(double area, double snapLoc) {
            this.area = area;
            this.snapLoc = snapLoc;
        }
    }
}

