/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.Set;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.output.GasMsrStat;
import pyrosim.domain.output.IMeasurementStat;
import pyrosim.domain.output.SolidMsrStat;
import pyrosim.domain.output.StatGeom;
import pyrosim.domain.quantity.StatisticsUtil;
import pyrosim.geom.Geometry;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.FDS6QuantityMap;
import pyrosim.io.fds.v6.common.StatisticMap;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class StatisticsRenderer
extends AFDS6Renderer {
    private final FDS6QuantityMap d_msrMap;
    private final FDSNameMap d_nameMap;

    public StatisticsRenderer(FDS6QuantityMap msrMap, FDSNameMap nameMap) {
        this.d_msrMap = msrMap;
        this.d_nameMap = nameMap;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> types) {
        types.add(IMeasurementStat.class);
    }

    @Override
    protected boolean render(IFDSRecordRenderer props, IPyroObject obj) {
        IMeasurementStat stat = (IMeasurementStat)obj;
        if (stat instanceof SolidMsrStat) {
            return this.renderSolidStat(props, (SolidMsrStat)stat);
        }
        assert (stat instanceof GasMsrStat);
        return this.renderGasStat(props, (GasMsrStat)stat);
    }

    private FDSRenderRecord newStatRecord(String baseID, IMeasurementStat stat, String statName, long pyroStat) {
        String fdsStr;
        String id = this.d_nameMap.generateName("DEVC", baseID);
        FDSRenderRecord rec = FDS6Const.newRenderRecord("DEVC");
        rec.setValue("ID", id);
        this.d_msrMap.renderQuantity(rec, "QUANTITY", "PART_ID", "SPEC_ID", "MATL_ID", "DUCT_ID", "NODE_ID", stat.getQuantity());
        String key = StatisticsRenderer.getStatisticsKey(pyroStat);
        if (!(statName.equals("STEADY STATE") || StatisticsUtil.isLineStatistic(pyroStat) || StatisticsUtil.is2dAs3dStatistic(pyroStat))) {
            rec.setValue(key, statName);
        } else if (StatisticsUtil.is2dAs3dStatistic(pyroStat)) {
            fdsStr = StatisticMap.getAreaForVolume(statName);
            rec.setValue(key, fdsStr);
        } else if (StatisticsUtil.isLineStatistic(pyroStat)) {
            fdsStr = StatisticMap.getFDSTemporalForLineVal(statName);
            rec.setValue(key, fdsStr);
        }
        IGeom geom = stat.getGeom().flatten().getLocalGeom();
        AABox box = geom.getBoundingBox(new AABox());
        if (geom instanceof StatGeom.LinearArrayGeom) {
            StatisticsRenderer.renderXB(rec, "XBP", box.getMin(), box.getMax());
            rec.setValue("POINTS", ((StatGeom.LinearArrayGeom)geom).d_numPoints);
            if (geom instanceof StatGeom.LinearVolumeArrayGeom) {
                Point3d delta = ((StatGeom.LinearVolumeArrayGeom)geom).getDelta();
                rec.setValue("DX", new UnitDouble(delta.x, SI.METER));
                rec.setValue("DY", new UnitDouble(delta.y, SI.METER));
                rec.setValue("DZ", new UnitDouble(delta.z, SI.METER));
            }
        } else if (box.getMin().equals(box.getMax())) {
            Point3d center = box.getCenter();
            StatisticsRenderer.renderLoc(rec, "XYZ", new UnitPoint3D(center, Geometry.LU));
        } else {
            StatisticsRenderer.renderXB(rec, "XB", box.getMin(), box.getMax());
        }
        StatisticsRenderer.renderCustomFDSProps(rec, stat);
        return rec;
    }

    private boolean renderGasStat(IFDSRecordRenderer props, GasMsrStat stat) {
        boolean rendered = false;
        for (Long statType : stat.getStats()) {
            String fdsStat = StatisticsRenderer.getFDSStat(statType);
            String id = stat.getName() + "_" + fdsStat;
            FDSRenderRecord rec = this.newStatRecord(id, stat, fdsStat, statType);
            props.render(rec, stat);
            rendered = true;
        }
        return rendered;
    }

    private boolean renderSolidStat(IFDSRecordRenderer props, SolidMsrStat stat) {
        if (stat.getSurfaces().size() == 0) {
            return this.renderSolidStat(props, null, stat);
        }
        boolean rendered = false;
        for (Surface surf : stat.getSurfaces()) {
            rendered |= this.renderSolidStat(props, surf, stat);
        }
        return rendered;
    }

    private boolean renderSolidStat(IFDSRecordRenderer props, Surface surf, SolidMsrStat stat) {
        boolean rendered = false;
        for (Long statType : stat.getStats()) {
            String fdsStat = StatisticsRenderer.getFDSStat(statType);
            Object id = stat.getName();
            if (surf != null) {
                id = (String)id + "_" + surf.getName();
            }
            id = (String)id + "_" + fdsStat;
            FDSRenderRecord rec = this.newStatRecord((String)id, stat, fdsStat, statType);
            if (surf != null) {
                rec.setValue("SURF_ID", surf.getName());
            }
            props.render(rec, stat);
            rendered = true;
        }
        return rendered;
    }

    private static String getFDSStat(long pyroStat) {
        String key = StatisticsRenderer.getStatisticsKey(pyroStat);
        if (key.equals("SPATIAL_STATISTIC")) {
            return StatisticMap.getFDSVal_spatial(pyroStat);
        }
        if (key.equals("TEMPORAL_STATISTIC")) {
            return StatisticMap.getFDSVal_temporal(pyroStat);
        }
        if (pyroStat == 0x2000000L) {
            return "STEADY STATE";
        }
        return "";
    }

    private static String getStatisticsKey(long statType) {
        if (statType == 65536L || statType == 131072L || statType == 262144L || statType == 524288L || statType == 0x100000L || statType == 0x200000L || statType == 0x4000000L || statType == 0x400000L || statType == 0x800000L || statType == 0x1000000000L || statType == 0x2000000000L || statType == 0x4000000000L || statType == 0x8000000000L || statType == 0x10000000000L || statType == 0x20000000000L || statType == 0x4000000000000L || statType == 0x10000000000000L || statType == 0x20000000000000L || statType == 0x40000000000000L) {
            return "SPATIAL_STATISTIC";
        }
        if (statType == 0x80000000L || statType == 0x100000000L || statType == 0x200000000L || statType == 0x1000000L || statType == 0x400000000L || statType == 0x800000000L || statType == 0x8000000L || statType == 0x10000000L || statType == 0x20000000L || statType == 0x40000000000L || statType == 0x80000000000L || statType == 0x100000000000L || statType == 0x200000000000L || statType == 0x400000000000L || statType == 0x800000000000L || statType == 0x40000000L || statType == 0x2000000000000L || statType == 0x1000000000000L || statType == 0x80000000000000L || statType == 0x100000000000000L || statType == 0x200000000000000L || statType == 0x400000000000000L) {
            return "TEMPORAL_STATISTIC";
        }
        if (statType != 0x2000000L) assert (false);
        return "";
    }
}

