/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.domain.ExSpec;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.TimeBasedValue;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.HvacAircoil;
import pyrosim.domain.hvac.HvacComponent;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacDuctLoss;
import pyrosim.domain.hvac.HvacFan;
import pyrosim.domain.hvac.HvacFilter;
import pyrosim.domain.hvac.HvacLeak;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.hvac.HvacUtil;
import pyrosim.domain.ramp.Ramp;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import pyrosim.io.fds.v6.renderers.PinConnectionRenderer;
import pyrosim.io.fds.v6.renderers.RampRenderer;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.theUtil;

public class HvacRenderer
extends AFDS6Renderer {
    private static final String LEAK_AMBIENT = "AMBIENT";
    private final FDSNameMap d_uniqueNameMap;
    private final PinConnectionRenderer d_pinConnRenderer;
    private final Map<Vent, String> d_ventNames;
    private final Map<String, Ramp> d_rampsUsed;
    private final List<HvacDuctLoss> d_ductLosses;
    private final List<HvacDuct> d_ducts;

    public HvacRenderer(FDSNameMap uniqueNameMap, PinConnectionRenderer pinConnRend, Map<Vent, String> ventNames) {
        this.d_uniqueNameMap = uniqueNameMap;
        this.d_pinConnRenderer = pinConnRend;
        this.d_ventNames = ventNames;
        this.d_rampsUsed = new HashMap<String, Ramp>();
        this.d_ductLosses = new ArrayList<HvacDuctLoss>();
        this.d_ducts = new ArrayList<HvacDuct>();
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> types) {
        types.add(HvacComponent.class);
        types.add(HvacDuctLoss.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer props, Collection<? extends IPyroObject> objs) {
        this.d_ductLosses.addAll(theUtil.filter(objs, HvacDuctLoss.class));
        this.d_ducts.addAll(theUtil.filter(objs, HvacDuct.class));
        boolean recWritten = false;
        for (HvacComponent o : theUtil.filter(objs, HvacComponent.class)) {
            recWritten |= this.render(props, o);
        }
        this.doneRendering(props);
        return recWritten;
    }

    public boolean render(IFDSRecordRenderer props, HvacComponent o) {
        FDSRenderRecord rec = FDS6Const.newRenderRecord("HVAC");
        rec.setValue("ID", o.getName());
        rec.setValue("TYPE_ID", o.getProp("TYPE_ID"));
        if (o instanceof HvacAircoil && !this.renderAircoil(props, rec, this.d_uniqueNameMap, this.d_rampsUsed, (HvacAircoil)o)) {
            return false;
        }
        if (o instanceof HvacDuct && !this.renderDuct(props, rec, this.d_uniqueNameMap, this.d_rampsUsed, (HvacDuct)o)) {
            return false;
        }
        if (o instanceof HvacFan && !this.renderFan(props, rec, this.d_uniqueNameMap, this.d_rampsUsed, (HvacFan)o)) {
            return false;
        }
        if (o instanceof HvacFilter && !this.renderFilter(props, rec, this.d_uniqueNameMap, this.d_rampsUsed, (HvacFilter)o)) {
            return false;
        }
        if (o instanceof HvacLeak && !this.renderLeak(props, rec, (HvacLeak)o)) {
            return false;
        }
        return !(o instanceof HvacNode) || this.renderNode(props, rec, (HvacNode)o);
    }

    private boolean renderDuct(IFDSRecordRenderer props, FDSRenderRecord rec, FDSNameMap nameMap, Map<String, Ramp> ramps, HvacDuct obj) {
        HvacDuct.Shape shape = (HvacDuct.Shape)((Object)obj.getProp("opt_shape"));
        switch (shape) {
            case CIRCULAR: {
                rec.setValue("DIAMETER", obj.getProp("DIAMETER"), true);
                break;
            }
            case NON_CIRCULAR: {
                rec.setValue("AREA", obj.getProp("AREA"), true);
                rec.setValue("PERIMETER", obj.getProp("PERIMETER"), true);
            }
        }
        HvacDuct.AirflowObj optAirFlow = (HvacDuct.AirflowObj)((Object)obj.getProp("opt_none_damper_fan"));
        switch (optAirFlow) {
            case DAMPER: {
                rec.setValue("DAMPER", true, false);
                break;
            }
            case VOLFLOW: {
                HvacRenderer.renderTVal(rec, nameMap, ramps, obj.getName(), obj.getVolflow(), "VOLUME_FLOW", "RAMP_ID", "TAU_VF", true);
                break;
            }
            case FAN: {
                NamedPyroObject fan = (NamedPyroObject)obj.getProp("FAN_ID");
                rec.setValue("FAN_ID", fan.getName());
                break;
            }
            case AIRCOIL: {
                NamedPyroObject aircoil = (NamedPyroObject)obj.getProp("AIRCOIL_ID");
                rec.setValue("AIRCOIL_ID", aircoil.getName());
                break;
            }
        }
        List lossList = (List)obj.getProp("LOSS");
        assert (lossList != null);
        assert (lossList.size() == 2);
        rec.setValue("LOSS", HvacRenderer.convertLossListToArray(lossList, 2, 0.0), true);
        List nodes = (List)obj.getProp("NODE_ID");
        ArrayList<String> nodeNames = new ArrayList<String>();
        for (HvacNode n : nodes) {
            if (n == null) continue;
            nodeNames.add(n.getName());
        }
        rec.setValue("NODE_ID", nodeNames);
        String networkId = (String)obj.getProp("NETWORK_ID");
        if (networkId != null && !networkId.isBlank()) {
            rec.setValue("NETWORK_ID", networkId);
        }
        rec.setValue("REVERSE", obj.getProp("REVERSE"), false);
        HvacDuct.FrictionType roughType = (HvacDuct.FrictionType)((Object)obj.getProp("opt_friction_type"));
        if (roughType.equals((Object)HvacDuct.FrictionType.EXPLICIT)) {
            rec.setValue("ROUGHNESS", obj.getProp("ROUGHNESS"), true);
        } else if (roughType.equals((Object)HvacDuct.FrictionType.COMPUTED_FRICTION)) {
            rec.setValue("ROUGHNESS", new UnitDouble(0.0, SI.METER), true);
        }
        rec.setValue("LENGTH", obj.getFinalLength(), false);
        FDSArray<Double> waypointsOutput = new FDSArray<Double>(FDS6Const.HVAC_WAYPOINTS_DIMENSIONS);
        List waypointsInput = (List)obj.getProp("WAYPOINTS");
        int i = 0;
        while (i < waypointsInput.size()) {
            Point3d waypoint = (Point3d)waypointsInput.get(i);
            waypointsOutput.set(waypoint.x, new int[]{i, 0});
            waypointsOutput.set(waypoint.y, new int[]{i, 1});
            waypointsOutput.set(waypoint.z, new int[]{i++, 2});
        }
        rec.setValue("WAYPOINTS", waypointsOutput);
        HvacRenderer.renderCustomFDSProps(rec, obj);
        this.d_pinConnRenderer.markForInputRetrieval(obj.getInputPin(), rec, "CTRL_ID", "DEVC_ID");
        this.d_pinConnRenderer.renderConnections(props, obj);
        return true;
    }

    private boolean renderFan(IFDSRecordRenderer props, FDSRenderRecord rec, FDSNameMap nameMap, Map<String, Ramp> ramps, HvacFan obj) {
        List lossList = (List)obj.getProp("LOSS");
        rec.setValue("LOSS", HvacRenderer.convertLossListToArray(lossList, 1, 0.0), true);
        HvacRenderer.renderTimeFunc(rec, nameMap, ramps, obj.getName(), obj.getTauFunc(), null, "TAU_FAN");
        int fanModel = (Integer)obj.getProp("opt_fan_model");
        if (fanModel == HvacFan.FAN_MODEL_QUADRATIC) {
            rec.setValue("MAX_FLOW", obj.getProp("MAX_FLOW"));
            rec.setValue("MAX_PRESSURE", obj.getProp("MAX_PRESSURE"));
        } else if (fanModel == HvacFan.FAN_MODEL_PRESDROP) {
            this.renderVariant(props, rec, nameMap, ramps, obj.getName(), obj.getPressureFlow(), null, "RAMP_ID");
        } else if (fanModel == HvacFan.FAN_MODEL_VOLFLOW) {
            rec.setValue("VOLUME_FLOW", obj.getProp("VOLUME_FLOW"));
        }
        HvacRenderer.renderCustomFDSProps(rec, obj);
        this.d_pinConnRenderer.markForInputRetrieval(obj.getInputPin(), rec, "CTRL_ID", "DEVC_ID");
        this.d_pinConnRenderer.renderConnections(props, obj);
        return true;
    }

    private boolean renderNode(IFDSRecordRenderer props, FDSRenderRecord rec, HvacNode obj) {
        List<UnitDouble> losses;
        HvacFilter filter;
        IFilteredCollection<HvacDuct> connectedDucts = theUtil.filter(this.d_ducts, HvacUtil.getConnectedDuctsFilter(obj));
        ArrayList<String> ductNames = new ArrayList<String>();
        for (HvacDuct d : connectedDucts) {
            if (d == null) continue;
            ductNames.add(d.getName());
        }
        rec.setValue("DUCT_ID", ductNames);
        String networkId = (String)obj.getProp("NETWORK_ID");
        if (networkId != null && !networkId.isBlank()) {
            rec.setValue("NETWORK_ID", networkId);
        }
        HvacNode.NodeType type = obj.getFinalNodeType(connectedDucts.size());
        switch (type) {
            case AMBIENT: {
                rec.setValue(LEAK_AMBIENT, true, true);
                break;
            }
            case VENT: {
                Vent vent = obj.getVent();
                assert (vent != null);
                String vname = this.d_ventNames.get(vent);
                if (vname == null) {
                    System.err.printf("HVAC Vent not assigned a unique name: %s%n", vent.getName());
                    vname = vent.getName();
                }
                rec.setValue("VENT_ID", vname);
                break;
            }
        }
        if (type != HvacNode.NodeType.VENT) {
            UnitPoint3D xyz = (UnitPoint3D)obj.getProp("XYZ");
            assert (xyz != null);
            HvacRenderer.renderLoc(rec, "XYZ", xyz);
        }
        if ((filter = obj.getFilter()) != null) {
            rec.setValue("FILTER_ID", filter.getName());
        }
        if (type.terminal) {
            losses = obj.getTerminalLoss();
            rec.setValue("LOSS", HvacRenderer.convertLossListToArray(losses, 2, 0.0), false);
        } else {
            losses = this.getLossList(obj, connectedDucts);
            if (losses != null && losses.size() > 0) {
                rec.setValue("LOSS", HvacRenderer.convertLossListToArray(losses, connectedDucts.size(), 0.0), false);
            }
        }
        HvacRenderer.renderCustomFDSProps(rec, obj);
        props.render(rec, obj);
        return true;
    }

    protected List<UnitDouble> getLossList(HvacNode node, Collection<HvacDuct> attachedDucts) {
        boolean containsNonZero = false;
        ArrayList<UnitDouble> losses = new ArrayList<UnitDouble>(attachedDucts.size() * attachedDucts.size());
        for (HvacDuct toDuct : attachedDucts) {
            for (HvacDuct fromDuct : attachedDucts) {
                UnitDouble value;
                IFilteredCollection<HvacDuctLoss> flosses = theUtil.filter(this.d_ductLosses, HvacUtil.getDuctLossFilter(node, fromDuct, toDuct));
                UnitDouble unitDouble = value = flosses.isEmpty() ? null : ((HvacDuctLoss)flosses.iterator().next()).getLoss(fromDuct);
                if (value != null && theUtil.eq0(value.getValue(Unit.ONE), 1.0E-9)) {
                    value = null;
                }
                containsNonZero |= value != null;
                losses.add(value);
            }
        }
        return containsNonZero ? losses : null;
    }

    private static FDSArray<UnitDouble> convertLossListToArray(List<UnitDouble> losses, int nPerRow, Double defaultFDSValue) {
        FDSArray<UnitDouble> lossArr = new FDSArray<UnitDouble>(FDS6Const.HVAC_LOSS_DIMENSIONS);
        Iterator<UnitDouble> lossIt = losses.iterator();
        for (int i = 0; i < losses.size() / nPerRow; ++i) {
            int j = 0;
            while (j < nPerRow) {
                UnitDouble loss = lossIt.next();
                if (loss != null && theUtil.eq(loss.getValueNoUnit(), defaultFDSValue, 1.0E-9)) {
                    loss = null;
                }
                lossArr.set(loss, new int[]{j++, i});
            }
        }
        assert (!lossIt.hasNext());
        return lossArr;
    }

    private boolean renderAircoil(IFDSRecordRenderer props, FDSRenderRecord rec, FDSNameMap nameMap, Map<String, Ramp> ramps, HvacAircoil obj) {
        HvacAircoil.Model optModel = (HvacAircoil.Model)((Object)obj.getProp("opt_aircoil_model"));
        switch (optModel) {
            case COOLANT: {
                rec.setValue("COOLANT_SPECIFIC_HEAT", obj.getProp("COOLANT_SPECIFIC_HEAT"));
                rec.setValue("COOLANT_MASS_FLOW", obj.getProp("COOLANT_MASS_FLOW"));
                rec.setValue("COOLANT_TEMPERATURE", obj.getProp("COOLANT_TEMPERATURE"));
                ArrayList<Object> efficiency = new ArrayList<Object>();
                efficiency.add(obj.getProp("EFFICIENCY"));
                rec.setValue("EFFICIENCY", efficiency);
                break;
            }
            case FIXEDQ: {
                TimeBasedValue<UnitDouble> fixedQ = obj.getFixedQ();
                HvacRenderer.renderTVal(rec, nameMap, ramps, obj.getName(), fixedQ, "FIXED_Q", "RAMP_ID", "TAU_AC", false);
                break;
            }
        }
        HvacRenderer.renderCustomFDSProps(rec, obj);
        this.d_pinConnRenderer.markForInputRetrieval(obj.getInputPin(), rec, "CTRL_ID", "DEVC_ID");
        this.d_pinConnRenderer.renderConnections(props, obj);
        return true;
    }

    private boolean renderFilter(IFDSRecordRenderer props, FDSRenderRecord rec, FDSNameMap nameMap, Map<String, Ramp> ramps, HvacFilter obj) {
        HvacFilter.LossModel optLossModel = (HvacFilter.LossModel)((Object)obj.getProp("opt_loss_ramp"));
        switch (optLossModel) {
            case LINEAR: {
                List lossList = (List)obj.getProp("LOSS");
                rec.setValue("LOSS", HvacRenderer.convertLossListToArray(lossList, 1, 0.0), true);
                rec.setValue("CLEAN_LOSS", obj.getProp("CLEAN_LOSS"));
                break;
            }
            case CUSTOM: {
                assert (obj.getCustomLoss().isRamp());
                String rName = RampRenderer.createID(nameMap, obj.getName(), "RAMP_ID");
                ramps.put(rName, (Ramp)obj.getCustomLoss().val);
                rec.setValue("RAMP_ID", rName, false);
                break;
            }
        }
        rec.setValue("LOADING", obj.getProp("LOADING"));
        rec.setValue("LOADING_MULTIPLIER", obj.getProp("LOADING_MULTIPLIER"));
        rec.setValue("EFFICIENCY", obj.getProp("EFFICIENCY"));
        List exSpecs = (List)obj.getProp("SPEC_ID");
        ArrayList<String> specId = new ArrayList<String>();
        if (exSpecs.size() > 0) {
            for (ExSpec exSpec : exSpecs) {
                specId.add(exSpec.getName());
            }
            rec.setValue("SPEC_ID", specId);
        }
        HvacRenderer.renderCustomFDSProps(rec, obj);
        props.render(rec, obj);
        return true;
    }

    private boolean renderLeak(IFDSRecordRenderer props, FDSRenderRecord rec, HvacLeak obj) {
        HvacRenderer.renderLeakVent(rec, obj.getVent1(), "VENT_ID");
        HvacRenderer.renderLeakVent(rec, obj.getVent2(), "VENT2_ID");
        rec.setValue("AREA", obj.getLeakArea(), false);
        rec.setValue("LEAK_ENTHALPY", obj.isEnthalpyCalc(), false);
        rec.setValue("LOSS", HvacRenderer.convertLossListToArray((List)obj.getProp("LOSS"), 1, 1.0), false);
        HvacRenderer.renderCustomFDSProps(rec, obj);
        props.render(rec, obj);
        return true;
    }

    private static void renderLeakVent(FDSRenderRecord rec, Vent v, String key) {
        String ventId = v == null ? LEAK_AMBIENT : v.getName();
        rec.setValue(key, ventId);
    }

    @Override
    public void doneRendering(IFDSRecordRenderer props) {
        super.doneRendering(props);
        RampRenderer.render(props, this.d_rampsUsed, this.d_pinConnRenderer);
    }
}

