/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.ramp.IRampInput;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.ramp.RampInputs;
import pyrosim.domain.variant.Variant;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.FDSRecordSpec;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.io.fds.FDSStringRenderer;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import pyrosim.io.fds.v6.renderers.PinConnectionRenderer;
import pyrosim.io.fds.v6.renderers.RampRenderer;
import thunderheadeng.units.UnitDouble;

public class ExSpecParser
extends AFDS6Parser {
    private int d_specIx = 0;
    private boolean d_isReactionDefined = false;
    private final List<ExSpec> d_parsedSpecs = new ArrayList<ExSpec>();
    private final Map<FDSParseRecord, ExSpec> d_lumpedSpecs = new LinkedHashMap<FDSParseRecord, ExSpec>();

    public ExSpecParser(FDS6ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("SPEC");
        types.add("REAC");
    }

    @Override
    public void getUnsupportedFields(String type, Map<String, String> unsupportedFields) {
        unsupportedFields.put("ALIAS", "UNSUPPORTED");
        unsupportedFields.put("CONDUCTIVITY", "UNSUPPORTED");
        unsupportedFields.put("FIC_CONCENTRATION", "UNSUPPORTED");
        unsupportedFields.put("FLD_LETHAL_DOSE", "UNSUPPORTED");
        unsupportedFields.put("MASS_EXTINCTION_COEFFICIENT", "UNSUPPORTED");
        unsupportedFields.put("PR_GAS", "UNSUPPORTED");
        unsupportedFields.put("PRIMITIVE", "UNSUPPORTED");
        unsupportedFields.put("RAMP_K", "UNSUPPORTED");
        unsupportedFields.put("THIRD_BODY", "UNSUPPORTED");
    }

    public ExSpec getSpec(int ix) {
        if (ix >= this.d_parsedSpecs.size()) {
            return null;
        }
        return this.d_parsedSpecs.get(ix);
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        boolean isLumped;
        if (rec.getType().equals("REAC")) {
            this.d_isReactionDefined = true;
            return true;
        }
        if (!rec.contains("ID")) {
            this.addWarning(rec, Intl.intl("Unable to process SPEC record: ID missing"), Intl.intl("SPEC Record Ignored"));
            return false;
        }
        ExSpecList specs = this.getContainer().getExSpecList();
        String id = rec.getString("ID");
        boolean predef = ExSpecList.isPredefinedSpecies(id);
        if (specs.get(id) != null && this.d_parsedSpecs.contains(specs.get(id))) {
            this.addWarning(rec, Intl.intl("Unable to process SPEC record: Duplicate ID"), Intl.intl("SPEC Record Ignored"));
            return false;
        }
        ExSpec spec = predef ? (specs.contains(ExSpecList.getPredefinedSpecies(id)) ? specs.get(id) : new ExSpec(ExSpecList.getPredefinedSpecies(id))) : new ExSpec(id, 1);
        spec.setFYI(rec.getString("FYI", false));
        if (rec.contains("MASS_FRACTION_0")) {
            spec.setMassFrac0(rec.getDouble("MASS_FRACTION_0"));
        }
        if (rec.contains("LUMPED_COMPONENT_ONLY")) {
            boolean rule = rec.getBoolean("LUMPED_COMPONENT_ONLY");
            if (rule) {
                spec.setLumpedComponentOnlyRule(ExSpec.LUMPED_RULE.TRUE);
            } else {
                spec.setLumpedComponentOnlyRule(ExSpec.LUMPED_RULE.FALSE);
            }
        } else {
            spec.setLumpedComponentOnlyRule(ExSpec.LUMPED_RULE.AUTO);
        }
        spec.setIsBackgroundSpec(rec.getBoolean("BACKGROUND", true));
        boolean bl = isLumped = rec.contains("MASS_FRACTION") || rec.contains("VOLUME_FRACTION") || rec.contains("SPEC_ID");
        if (isLumped || predef) {
            this.d_lumpedSpecs.put(rec, spec);
        } else if (!predef) {
            Variant specHeatLiquid;
            Variant specHeat;
            boolean aerosol;
            Variant viscosity;
            spec.setType(1);
            ExSpec.PrimitiveParams primParams = spec.getPrimParams();
            Variant diffusivity = this.getRampableValue(rec, "DIFFUSIVITY", "RAMP_D", RampInputs.HEAT, 27);
            if (diffusivity != null) {
                primParams.setDiffusivity(diffusivity);
            }
            if ((viscosity = this.getRampableValue(rec, "VISCOSITY", "RAMP_MU", RampInputs.HEAT, 41)) != null) {
                primParams.setViscosity(viscosity);
            }
            if (rec.contains("SIGMALJ")) {
                primParams.setSigmaLJ(rec.getDouble("SIGMALJ", true), true);
            }
            if (rec.contains("EPSILONKLJ")) {
                primParams.setEpsilonKLJ(rec.getDouble("EPSILONKLJ", true), true);
            }
            if (rec.contains("RADCAL_ID")) {
                primParams.setRadCalSurrogate(rec.getString("RADCAL_ID", true));
            }
            if (aerosol = rec.getBoolean("AEROSOL", true).booleanValue()) {
                primParams.setAerosol(aerosol);
                primParams.setDensitySolid(rec.getUnitDouble("DENSITY_SOLID", true));
                primParams.setConductivitySolid(rec.getUnitDouble("CONDUCTIVITY_SOLID", true));
                primParams.setMeanDiameter(rec.getUnitDouble("MEAN_DIAMETER", true));
            }
            if ((specHeat = this.getRampableValue(rec, "SPECIFIC_HEAT", "RAMP_CP", RampInputs.TIME, 11)) != null) {
                primParams.setSpecHeat(specHeat);
            }
            if (rec.contains("REFERENCE_TEMPERATURE")) {
                primParams.setRefTemp(rec.getUnitDouble("REFERENCE_TEMPERATURE", true), true);
            }
            if (rec.contains("REFERENCE_ENTHALPY")) {
                primParams.setRefEnthalpy(rec.getUnitDouble("REFERENCE_ENTHALPY", true));
            }
            if (rec.contains("DENSITY_LIQUID")) {
                primParams.setDensityLiquid(rec.getUnitDouble("DENSITY_LIQUID", true));
            }
            if ((specHeatLiquid = this.getRampableValue(rec, "SPECIFIC_HEAT_LIQUID", "RAMP_CP_L", RampInputs.TIME, 11)) != null) {
                primParams.setSpecHeatLiquid(specHeatLiquid);
            }
            if (rec.contains("VAPORIZATION_TEMPERATURE")) {
                primParams.setVapTemp(rec.getUnitDouble("VAPORIZATION_TEMPERATURE", true));
            }
            if (rec.contains("MELTING_TEMPERATURE")) {
                primParams.setMeltingTemp(rec.getUnitDouble("MELTING_TEMPERATURE", true));
            }
            if (rec.contains("HEAT_OF_VAPORIZATION")) {
                primParams.setHoVaporization(rec.getUnitDouble("HEAT_OF_VAPORIZATION", true));
            }
            if (rec.contains("ENTHALPY_OF_FORMATION")) {
                primParams.setEoFormation(rec.getUnitDouble("ENTHALPY_OF_FORMATION", true));
            }
            if (rec.contains("H_V_REFERENCE_TEMPERATURE")) {
                primParams.setHVRefTemp(rec.getUnitDouble("H_V_REFERENCE_TEMPERATURE", true));
            }
            if (rec.contains("MW")) {
                spec.setMolecularWeight(rec.getUnitDouble("MW"));
            }
            if (rec.contains("FORMULA")) {
                spec.setChemFormula(rec.getString("FORMULA", true));
            }
        }
        this.parseCustomFDSProps(spec, rec);
        if (isLumped || predef) {
            this.parsePrimforAdvanced(rec, spec, predef);
        }
        this.addSpec(rec, spec);
        return true;
    }

    private void addSpec(FDSParseRecord rec, ExSpec spec) {
        ExSpecList specs = this.getContainer().getExSpecList();
        specs.add(spec);
        this.flagObjectAdded(spec);
        this.d_parsedSpecs.add(spec);
    }

    private Variant getRampableValue(FDSParseRecord rec, String valID, String rampID, IRampInput input, int fUnit) throws FDSRecordFormatException {
        Variant value;
        String valueRampID = rec.getString(rampID);
        if (valueRampID != null) {
            Ramp r = this.getParsingInfo().getRamp(valueRampID, input, fUnit, true);
            if (r == null) {
                throw new FDSRecordFormatException(rec, Intl.intl("Invalid ramp specified."));
            }
            value = Variant.ramp(r);
        } else {
            UnitDouble udval = rec.getUnitDouble(valID, true);
            value = udval != null ? Variant.constant(udval) : null;
        }
        return value;
    }

    private void parsePrimforAdvanced(FDSParseRecord rec, ExSpec spec, boolean isPredef) {
        String rampName;
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("MW");
        keys.add("FORMULA");
        keys.add("DIFFUSIVITY");
        keys.add("VISCOSITY");
        keys.add("SIGMALJ");
        keys.add("EPSILONKLJ");
        keys.add("RADCAL_ID");
        keys.add("AEROSOL");
        keys.add("DENSITY_SOLID");
        keys.add("CONDUCTIVITY_SOLID");
        keys.add("MEAN_DIAMETER");
        keys.add("SPECIFIC_HEAT");
        keys.add("REFERENCE_TEMPERATURE");
        keys.add("REFERENCE_ENTHALPY");
        keys.add("DENSITY_LIQUID");
        keys.add("SPECIFIC_HEAT_LIQUID");
        keys.add("VAPORIZATION_TEMPERATURE");
        keys.add("MELTING_TEMPERATURE");
        keys.add("HEAT_OF_VAPORIZATION");
        keys.add("ENTHALPY_OF_FORMATION");
        keys.add("H_V_REFERENCE_TEMPERATURE");
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        FDSRenderProps renderer = PyroSim.getApp().getFDSRenderProps();
        for (String key : keys) {
            FDSRecordSpec.Field field;
            Object val = rec.get(key);
            if (val == null || (field = rec.getSpec().fields.get(key)) == null) continue;
            String strval = field.render(renderer, val);
            this.collectCustomVal(props, strval);
        }
        if (!props.isEmpty()) {
            String problem = isPredef ? Intl.intl("PyroSim does not support modifying predefined species.") : Intl.intl("PyroSim does not support changing primitive parameters for lumped species.");
            this.addWarning(rec, problem, String.format(Intl.intl("Nonbasic fields used by Species %s moved to Advanced Records."), spec.getName()));
        }
        LinkedHashMap<String, Ramp> ramps = new LinkedHashMap<String, Ramp>();
        if (rec.contains("RAMP_D")) {
            rampName = rec.getString("RAMP_D");
            props.put("RAMP_D", "'" + rampName + "'");
            ramps.put(rampName, this.getParsingInfo().getRamp(rampName, RampInputs.TIME, 27, true));
        }
        if (rec.contains("RAMP_MU")) {
            rampName = rec.getString("RAMP_MU");
            props.put("RAMP_MU", "'" + rampName + "'");
            ramps.put(rampName, this.getParsingInfo().getRamp(rampName, RampInputs.TIME, 41, true));
        }
        if (rec.contains("RAMP_CP")) {
            rampName = rec.getString("RAMP_CP");
            props.put("RAMP_CP", "'" + rampName + "'");
            ramps.put(rampName, this.getParsingInfo().getRamp(rampName, RampInputs.TIME, 11, true));
        }
        if (rec.contains("RAMP_CP_L")) {
            rampName = rec.getString("RAMP_CP_L");
            props.put("RAMP_CP_L", "'" + rampName + "'");
            ramps.put(rampName, this.getParsingInfo().getRamp(rampName, RampInputs.TIME, 11, true));
        }
        if (!ramps.isEmpty()) {
            String problem = isPredef ? Intl.intl("PyroSim does not support modifying predefined species.") : Intl.intl("PyroSim does not support changing primitive parameters for lumped species.");
            this.addWarning(rec, problem, String.format(Intl.intl("Ramps used by Species %s moved to Additional Records."), spec.getName()));
            FDSRenderProps renderProps = PyroSim.getApp() != null ? PyroSim.getApp().getFDSRenderProps() : new FDSRenderProps();
            FDSNameMap nameMap = new FDSNameMap();
            PinConnectionRenderer pinConnRenderer = new PinConnectionRenderer(nameMap);
            FDSStringRenderer stringRenderer = new FDSStringRenderer(renderProps);
            RampRenderer.render(stringRenderer, ramps, pinConnRenderer);
            this.getParsingInfo().getContainer().setUnprocessedRecords(this.getParsingInfo().getContainer().getUnprocessedRecords() + stringRenderer.toString());
        }
        CustomFDSProps primProps = CustomFDSProps.get(props);
        spec.setCustomFDSProps(CustomFDSProps.union(primProps, spec.getCustomFDSProps()));
    }

    @Override
    protected void done() throws FDSRecordFormatException {
        if (this.d_isReactionDefined) {
            this.getContainer().getExSpecList().addImplicitSpecs();
        } else {
            this.getContainer().getExSpecList().addAirSpecs();
        }
    }

    @Override
    public void postProcess() throws FDSRecordFormatException {
        List backGroundSpecs = this.d_parsedSpecs.stream().filter(spec -> spec.isBackgroundSpec()).collect(Collectors.toList());
        if (backGroundSpecs.size() > 1) {
            for (ExSpec spec2 : backGroundSpecs) {
                spec2.setIsBackgroundSpec(false);
            }
        }
        ExSpecList specList = this.getContainer().getExSpecList();
        for (Map.Entry<FDSParseRecord, ExSpec> entr : this.d_lumpedSpecs.entrySet()) {
            int compositionType;
            if (!entr.getKey().contains("SPEC_ID")) continue;
            List<Object> composition = new ArrayList();
            List<Object> species = new ArrayList();
            species = entr.getKey().getList("SPEC_ID", false);
            if (entr.getKey().contains("SPEC_ID") && !entr.getKey().contains("MASS_FRACTION") && !entr.getKey().contains("VOLUME_FRACTION")) {
                if (species.size() > 1) {
                    this.addWarning(entr.getKey(), Intl.intl("Failed to parse lumped species parameters."), Intl.intl(String.format("Species %s imported as a primitive species.", entr.getValue().getName())));
                    continue;
                }
                LinkedHashMap<ExSpec, Double> compMap = new LinkedHashMap<ExSpec, Double>();
                compMap.put(specList.get((String)species.get(0)), 1.0);
                entr.getValue().setComposition(2, compMap);
                continue;
            }
            if (entr.getKey().contains("MASS_FRACTION")) {
                composition = entr.getKey().getList("MASS_FRACTION", false);
                compositionType = 2;
            } else {
                composition = entr.getKey().getList("VOLUME_FRACTION", false);
                compositionType = 3;
            }
            if (composition.size() <= 0 || species.size() != composition.size()) continue;
            LinkedHashMap<ExSpec, Double> compositionMap = new LinkedHashMap<ExSpec, Double>();
            for (int i = 0; i < composition.size(); ++i) {
                ExSpec spec3 = specList.get((String)species.get(i));
                if (spec3 == null) {
                    if (!ExSpecList.isPredefinedSpecies((String)species.get(i))) continue;
                    spec3 = new ExSpec(ExSpecList.getPredefinedSpecies((String)species.get(i)));
                    specList.add(spec3);
                }
                compositionMap.put(spec3, (Double)composition.get(i));
            }
            entr.getValue().setComposition(compositionType, compositionMap);
        }
        super.postProcess();
    }
}

