/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3d;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.ICustomFDSPropsContainer;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.geom.TexOrigin;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.domain.quantity.VelocitySign;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.ramp.RampInputs;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.geom.Geometry;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSParseResult;
import pyrosim.io.fds.FDSParseWarning;
import pyrosim.io.fds.FDSParsingInfo;
import pyrosim.io.fds.FDSRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.FDSRecordSpec;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.io.fds.IFDSRecordParser;
import pyrosim.io.fds.v6.FDS6Colors;
import pyrosim.io.fds.v6.FDS6QuantityMap;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.io.fds.v6.parsers.Multiplier;
import pyrosim.io.fds.v6.parsers.PinConnParser;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.units.GeomUtil;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitLineSeg3D;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.NameGenerator;
import thunderheadeng.util.Pair;

public abstract class AFDS6Parser
implements IFDSRecordParser {
    protected static final int VALID = 0;
    protected static final int IGNORE = 1;
    protected static final int ADDITIONAL_RECORD = 2;
    protected static final Color INVISIBLE_COLOR = new InvsColor();
    private FDS6ParsingInfo d_parsingInfo;
    protected static final int NAMEOPT_WARN_EMPTY = 1;

    public AFDS6Parser(FDS6ParsingInfo parsingInfo) {
        this.d_parsingInfo = parsingInfo;
    }

    @Override
    public void process(Collection<FDSParseRecord> recs, Collection<FDSParseRecord> unprocessed) throws FDSRecordFormatException {
        for (FDSParseRecord rec : recs) {
            boolean result = false;
            try {
                result = this.process(rec);
            }
            catch (FDSRecordFormatException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new FDSRecordFormatException(rec);
            }
            if (result) continue;
            unprocessed.add(rec);
        }
        this.done();
    }

    protected abstract boolean process(FDSParseRecord var1) throws FDSRecordFormatException;

    protected void done() throws FDSRecordFormatException {
    }

    @Override
    public void postProcess() throws FDSRecordFormatException {
    }

    public PyroMod getContainer() {
        return this.d_parsingInfo.getContainer();
    }

    public FDS6ParsingInfo getParsingInfo() {
        return this.d_parsingInfo;
    }

    protected FDSParseResult getResult() {
        return this.d_parsingInfo.getParseResult();
    }

    public boolean isNameUsed(Class<?> type, String name) {
        return this.getNames(type).isRegistered(name);
    }

    public NameGenerator getNames(Class<?> type) {
        return this.d_parsingInfo.getNames(type);
    }

    public String getValidName(FDSParseRecord rec, String idKey, Class<?> type) {
        String id = rec.getString(idKey);
        if (id == null || id.trim().isEmpty()) {
            id = this.getNames(type).generateName();
        }
        return id;
    }

    private static boolean test(int options, int option) {
        return (options & option) == option;
    }

    protected String parseName(FDSParseRecord rec, String idKey, Class<?> type) {
        return this.parseName(rec, idKey, type, 0);
    }

    protected String parseName(FDSParseRecord rec, String idKey, Class<?> type, int options) {
        String id = rec.getString(idKey);
        if (id == null || id.isEmpty()) {
            id = this.getNames(type).generateName();
            if (AFDS6Parser.test(options, 1)) {
                this.addWarning(rec, String.format(Intl.intl("%s missing ID."), rec.getType()), String.format(Intl.intl("Setting ID to %s."), id));
            }
            return id;
        }
        NameGenerator names = this.getNames(type);
        String validName = names.generateValidName(id);
        if (!validName.equals(id)) {
            this.getParsingInfo().addAlias(type, id, validName);
            this.addWarning(rec, String.format(Intl.intl("Duplicate %1$s ID found: %2$s"), rec.getType(), id), String.format(Intl.intl("Renaming to \"%s\". Conflicting references now point to \"%s\"."), validName, validName));
        }
        return validName;
    }

    public void autoRename(INamed obj) {
        if (obj.isSetNameSupported()) {
            String newName = this.getNames(obj.getClass()).generateValidName(obj.getName());
            obj.setName(newName);
        }
    }

    public void flagObjectAdded(IPyroObject obj) {
        this.d_parsingInfo.getParseResult().extractedObjs.add(obj);
        if (obj instanceof INamed) {
            this.d_parsingInfo.getNames(obj.getClass()).registerName(((INamed)obj).getName());
        }
    }

    public void flagObjectsAdded(Collection<? extends IPyroObject> objs) {
        for (IPyroObject iPyroObject : objs) {
            this.flagObjectAdded(iPyroObject);
        }
    }

    public void flagEvac() {
        this.getContainer().setEvacEnabled(true);
    }

    public void addWarning(FDSParseWarning warning) {
        this.d_parsingInfo.addWarning(warning);
    }

    public void addWarning(FDSParseRecord rec, String warning, String actionTaken) {
        this.d_parsingInfo.addWarning(new FDSParseWarning(rec, warning, actionTaken));
    }

    public FDS6QuantityMap getQuantityMap() {
        return this.d_parsingInfo.getQuantityMap();
    }

    public IQuantity parseQuantity(FDSParseRecord rec, String quantityKey, String partIdKey, String specIdKey, String matIdKey, String ductIdKey, String nodeIdKey, long outputType, String failAction, boolean quantityRequired, boolean throwException, boolean addWarning) throws FDSRecordFormatException {
        try {
            IQuantity m = this.getQuantityMap().parseQuantity(this.getParsingInfo(), rec, quantityKey, partIdKey, specIdKey, matIdKey, ductIdKey, nodeIdKey, quantityRequired);
            if (m != null && !QuantityUtil.canOutputAll(m.get(), outputType) && addWarning) {
                this.addWarning(rec, String.format(Intl.intl("Quantity %s is invalid for output."), rec.getString(quantityKey)), failAction);
                return null;
            }
            return m;
        }
        catch (FDSRecordFormatException e) {
            if (throwException) {
                throw e;
            }
            this.addWarning(rec, e.getError(), failAction);
            return null;
        }
    }

    protected Color parseColor(FDSParseRecord rec, String rgbKey, String colorKey, String transparencyKey, boolean getDefault) {
        return AFDS6Parser.parseColor(this.getParsingInfo(), rec, rgbKey, colorKey, transparencyKey, getDefault);
    }

    protected static Color parseColor(FDSParsingInfo pi, FDSParseRecord rec, String rgbKey, String colorKey, String transparencyKey, boolean getDefault) {
        FDSArray rgb;
        Color color = null;
        if (rgbKey != null && rec.contains(rgbKey)) {
            rgb = rec.getArray(rgbKey, false);
            color = AFDS6Parser.interpColor(pi, rec, (Double)rgb.get(0), (Double)rgb.get(1), (Double)rgb.get(2));
        } else if (colorKey != null && rec.contains(colorKey)) {
            String colorName = (String)rec.get(colorKey);
            if (colorName.equals("INVISIBLE")) {
                return INVISIBLE_COLOR;
            }
            color = FDS6Colors.getColor(colorName);
            if (color == null) {
                pi.addWarning(rec, String.format(Intl.intl("%s is not a valid FDS color name."), colorName), String.format(Intl.intl("Using default color."), new Object[0]));
            }
        }
        if (color == null) {
            if (!getDefault) {
                return null;
            }
            rgb = rec.getArray(rgbKey, true);
            if (rgb != null) {
                color = AFDS6Parser.interpColor(pi, rec, (Double)rgb.get(0), (Double)rgb.get(1), (Double)rgb.get(2));
            } else {
                String defColorName = (String)rec.get(colorKey, true);
                if (defColorName != null) {
                    color = FDS6Colors.getColor(defColorName);
                }
            }
        }
        int alpha = 255;
        if (transparencyKey != null && rec.contains(transparencyKey)) {
            alpha = (int)((Double)rec.get(transparencyKey) * 255.0);
        }
        if (color == null) {
            return new Color(128, 128, 128, alpha);
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    private static Color interpColor(FDSParsingInfo pi, FDSParseRecord rec, double r, double g, double b) {
        if (0.0 < r && r < 1.0 || 0.0 < g && g < 1.0 || 0.0 < b && b < 1.0) {
            pi.addWarning(rec, Intl.intl("Old-style RGB value detected."), Intl.intl("Converted to new range [0...255]."));
            return new Color((float)r, (float)g, (float)b);
        }
        return new Color((int)r, (int)g, (int)b);
    }

    protected <T extends IPyroGeomSrc> Pair<String, List<T>> applyMult(FDSParseRecord rec, String multIDKey, T obj) {
        String multID = rec.getString(multIDKey, false);
        if (multID != null) {
            Multiplier mult = this.getParsingInfo().getMultiplier(multID);
            if (mult == null) {
                this.addWarning(rec, String.format(Intl.intl("Could not find MULT record, \"%s\""), multID), String.format(Intl.intl("Ignoring MULT and adding %s as defined."), rec.getType()));
            } else {
                return mult.applyTo(obj);
            }
        }
        String name = obj instanceof INamed ? ((INamed)((Object)obj)).getName() : "";
        return new Pair<String, List<T>>(name, Arrays.asList(obj));
    }

    protected AABoxGeom parseXBGeom(FDSParseRecord rec, String type, String key, boolean required) throws FDSRecordFormatException {
        UnitPoint3D[] xb = this.parseGeomXB(rec, type, key, required);
        if (xb == null) {
            return null;
        }
        return new AABoxGeom(xb[0].getPoint3dValue(Geometry.LU), xb[1].getPoint3dValue(Geometry.LU));
    }

    protected static UnitPoint3D[] parseXB(FDSParseRecord rec, String type, String key, boolean required) throws FDSRecordFormatException {
        FDSArray xb = null;
        if (rec.contains(key)) {
            xb = rec.getArray(key, true);
        }
        if (xb == null) {
            if (required) {
                throw new FDSRecordFormatException(rec, String.format(Intl.intl("%s must specify geometry."), type));
            }
            return null;
        }
        UnitPoint3D min = new UnitPoint3D((UnitDouble)xb.get(0), (UnitDouble)xb.get(2), (UnitDouble)xb.get(4));
        UnitPoint3D max = new UnitPoint3D((UnitDouble)xb.get(1), (UnitDouble)xb.get(3), (UnitDouble)xb.get(5));
        return GeomUtil.rectify(min, max);
    }

    protected static UnitAABox parseAABox(FDSParseRecord rec, String type, String xbKey, boolean required) throws FDSRecordFormatException {
        UnitPoint3D[] xb = AFDS6Parser.parseXB(rec, type, xbKey, required);
        if (xb == null) {
            return null;
        }
        return new UnitAABox(xb[0], xb[1]);
    }

    protected static UnitLineSeg3D parseLineSeg3D(FDSParseRecord rec, String type, String xbKey, boolean required) throws FDSRecordFormatException {
        UnitPoint3D[] xb = AFDS6Parser.parseXB(rec, type, xbKey, required);
        if (xb == null) {
            return null;
        }
        return new UnitLineSeg3D(xb[0], xb[1]);
    }

    protected UnitPoint3D[] parseGeomXB(FDSParseRecord rec, String type, String key, boolean required) throws FDSRecordFormatException {
        FDSArray xb = null;
        if (rec.contains(key)) {
            xb = rec.getArray(key, true);
        }
        if (xb == null) {
            if (required) {
                throw new FDSRecordFormatException(rec, String.format(Intl.intl("%s must specify geometry."), type));
            }
            return null;
        }
        UnitPoint3D min = new UnitPoint3D((UnitDouble)xb.get(0), (UnitDouble)xb.get(2), (UnitDouble)xb.get(4));
        UnitPoint3D max = new UnitPoint3D((UnitDouble)xb.get(1), (UnitDouble)xb.get(3), (UnitDouble)xb.get(5));
        if (min.x() > max.x() || min.y() > max.y() || min.z() > max.z()) {
            this.addWarning(new FDSParseWarning(rec, String.format(Intl.intl("%s has an inverted XB record."), rec.getType()), Intl.intl("Inverted XB Fixed")));
        }
        return GeomUtil.rectify(min, max);
    }

    protected static UnitPoint3D parseLoc(FDSParseRecord rec, String type, String xyzKey, boolean required) throws FDSRecordFormatException {
        return AFDS6Parser.parseLoc(rec, type, xyzKey, true, required);
    }

    protected static UnitPoint3D parseLoc(FDSParseRecord rec, String type, String xyzKey, boolean getDef, boolean required) throws FDSRecordFormatException {
        FDSArray xyz = rec.getArray(xyzKey, getDef);
        if (xyz == null || xyz.get(0) == null || xyz.get(1) == null || xyz.get(2) == null) {
            if (required) {
                throw new FDSRecordFormatException(rec, String.format(Intl.intl("%s is missing a location."), type));
            }
            return null;
        }
        return new UnitPoint3D((UnitDouble)xyz.get(0), (UnitDouble)xyz.get(1), (UnitDouble)xyz.get(2));
    }

    protected static TexOrigin parseTexLoc(FDSParseRecord rec, Point3d minPoint, String type, String xyzKey) throws FDSRecordFormatException {
        UnitPoint3D loc = AFDS6Parser.parseLoc(rec, type, xyzKey, false);
        if (loc != null && !loc.equals(TexOrigin.DEF_LOC)) {
            if (loc.getPoint3dValue(Geometry.LU).equals(minPoint)) {
                return TexOrigin.defaultLocal();
            }
            return new TexOrigin(loc, false);
        }
        return TexOrigin.defaultWorld();
    }

    protected static int countDimensions(UnitPoint3D min, UnitPoint3D max) {
        int count = 0;
        if (min.xu().equals(max.xu())) {
            ++count;
        }
        if (min.yu().equals(max.yu())) {
            ++count;
        }
        if (min.zu().equals(max.zu())) {
            ++count;
        }
        return count;
    }

    protected <T extends IPyroObject> T findObject(Class<T> clazz, String name) {
        try {
            return this.findObject(null, clazz, name, false);
        }
        catch (FDSRecordFormatException e) {
            assert (false);
            return null;
        }
    }

    protected <T extends IPyroObject> T findObject(FDSParseRecord rec, Class<T> clazz, String name, boolean required) throws FDSRecordFormatException {
        T obj = this.getParsingInfo().findObject(clazz, name);
        if (obj == null && required) {
            throw new FDSRecordFormatException(rec, String.format(Intl.intl("Could not find %s."), name));
        }
        return obj;
    }

    protected <T extends IPyroObject> T findReplacementObject(Class<T> clazz, String name) {
        return this.getParsingInfo().findReplacementObject(clazz, name);
    }

    protected boolean checkName(FDSParseRecord rec, String id) {
        if (id == null || id.trim().equals("")) {
            this.addWarning(rec, String.format(Intl.intl("%s has no ID."), rec.getType()), String.format(Intl.intl("Adding %s to additional records section."), rec.getType()));
            return false;
        }
        return true;
    }

    protected <T extends INamed> int existsStatus(FDSParseRecord rec, T obj, Class<T> clazz) {
        if (!this.getNames(clazz).isRegistered(obj.getName())) {
            return 0;
        }
        T existingInFile = this.findReplacementObject(clazz, obj.getName());
        if (existingInFile == null) {
            return 0;
        }
        T existing = this.findObject(clazz, obj.getName());
        if (existing != null && existing.equals(obj)) {
            return 1;
        }
        this.addWarning(rec, String.format(Intl.intl("Duplicate %1$s ID found: %2$s"), rec.getType(), obj.getName()), String.format(Intl.intl("Adding to additional records section."), rec.getType()));
        return 2;
    }

    protected boolean convertToReturn(int returnMessage) {
        switch (returnMessage) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return false;
    }

    protected TimeFunction parseTimeFunction(FDSParseRecord rec, String tauKey, String rampKey) {
        UnitDouble tau = tauKey != null ? rec.getUnitDouble(tauKey, true) : null;
        String rampName = rampKey != null ? rec.getString(rampKey, false) : null;
        return this.parseTimeFunction(rec, tau, rampName);
    }

    protected TimeFunction parseTimeFunction(FDSParseRecord rec, UnitDouble tau, String rampName) {
        TimeFunction tf = null;
        if (rampName != null) {
            Ramp r = this.getParsingInfo().getRamp(rampName, RampInputs.TIME, 28, true);
            if (r == null) {
                this.addWarning(rec, String.format(Intl.intl("Ramp %s could not be found."), rampName), Intl.intl("Using the default ramp function."));
            } else {
                tf = new TimeFunction.Custom(r);
            }
        }
        if (tf == null) {
            tf = AFDS6Parser.parseTCurve(rec, tau);
        }
        assert (tf != null);
        return tf;
    }

    protected static TimeFunction parseTCurve(FDSParseRecord rec, String tauKey) {
        UnitDouble tau = rec.getUnitDouble(tauKey);
        return AFDS6Parser.parseTCurve(rec, tau);
    }

    protected static TimeFunction parseTCurve(FDSParseRecord rec, UnitDouble tau) {
        if (tau != null) {
            double val = tau.getValueNoUnit();
            if (val < 0.0) {
                return new TimeFunction.TSquared(tau.negate());
            }
            return new TimeFunction.TanH(tau);
        }
        return TimeFunction.newDefault();
    }

    protected static String getInputID(FDSParseRecord rec, String devcIDKey, String ctrlIDKey) {
        String inputID = rec.getString(devcIDKey);
        if (inputID != null) {
            return inputID;
        }
        return rec.getString(ctrlIDKey);
    }

    protected static void markSingleInputForRetrieval(FDSParseRecord rec, ISignalSink sink, PinConnParser pinConns, String devcIDKey, String ctrlIDKey) {
        String inputID = AFDS6Parser.getInputID(rec, devcIDKey, ctrlIDKey);
        if (inputID != null) {
            pinConns.markInputForRetrieval(rec, sink.getInputPin(), Arrays.asList(inputID));
        }
    }

    protected VelocitySign parseVelocitySign(FDSParseRecord rec, Integer veloIndex) {
        if (veloIndex == null) {
            return VelocitySign.ALWAYS_POSITIVE;
        }
        switch (veloIndex) {
            case 1: {
                return VelocitySign.MATCH_U;
            }
            case 2: {
                return VelocitySign.MATCH_V;
            }
            case 3: {
                return VelocitySign.MATCH_W;
            }
            case 0: {
                return VelocitySign.ALWAYS_POSITIVE;
            }
        }
        this.addWarning(new FDSParseWarning(rec, String.format(Intl.intl("Unknown Velocity Index: %d"), veloIndex), Intl.intl("Ignoring Velocity Index")));
        return VelocitySign.ALWAYS_POSITIVE;
    }

    protected boolean parseCustomFDSProps(ICustomFDSPropsContainer obj, FDSParseRecord rec) {
        if (obj.getCustomFDSTypes().contains(rec.getType())) {
            obj.setCustomFDSProps(rec.getType(), CustomFDSProps.union(obj.getCustomFDSProps(rec.getType()), rec.getType().equals("PRES") ? this.getValsForPres(rec) : this.getCustomVals(rec)));
            this.getParsingInfo().getParseResult().extractedUnsupportedRecs.add(rec);
            return true;
        }
        return false;
    }

    protected CustomFDSProps getValsForPres(FDSParseRecord rec) {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Object> entry : rec.getProperties().entrySet()) {
            props.put(entry.getKey(), entry.getValue().toString());
        }
        return CustomFDSProps.get(props);
    }

    protected CustomFDSProps getCustomVals(FDSParseRecord rec) {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        FDSRenderProps renderer = PyroSim.getApp().getFDSRenderProps();
        HashMap<String, String> unsupported = new HashMap<String, String>();
        this.getUnsupportedFields(rec.getType(), unsupported);
        for (Map.Entry entr : unsupported.entrySet()) {
            FDSRecordSpec.Field field;
            Object val;
            if (!((String)entr.getValue()).equals("UNSUPPORTED") || (val = rec.get((String)entr.getKey())) == null || (field = rec.getSpec().fields.get(entr.getKey())) == null) continue;
            String strVal = field.render(renderer, val);
            this.collectCustomVal(props, strVal);
        }
        for (FDSRecord.UnknownProp prop : rec.getUnknownProps()) {
            props.put(prop.key, prop.renderVal());
        }
        return CustomFDSProps.get(props);
    }

    protected void collectCustomVal(Map<String, String> props, String renderedField) {
        int eix = renderedField.indexOf(61);
        if (eix == -1 || eix == 0 || eix == renderedField.length() - 1) {
            return;
        }
        String key = renderedField.substring(0, eix);
        String val = renderedField.substring(eix + 1);
        assert (!key.isEmpty() && !val.isEmpty());
        props.put(key, val);
    }

    private static class InvsColor
    extends Color {
        private static final long serialVersionUID = -762022996250689188L;

        public InvsColor() {
            super(0, 0, 0, 0);
        }
    }
}

