/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.extloader;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Vector3d;
import pyroloader.IPyroGeom;
import pyroloader.IPyroGeomNode;
import pyroloader.IPyroPrimProps;
import pyroloader.PyroPoint2d;
import pyroloader.PyroPoint3d;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.io.extloader.DataStore;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.elem.ElementMesh;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.MatrixXform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.util.MappedIterator;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class GeomNodeWrapper
implements IPyroGeomNode {
    private final DataStore d_store;
    private final IGeomNode d_node;
    private List<IPrimitive> d_cachedPrims;

    public GeomNodeWrapper(DataStore store, IGeomNode node) {
        this.d_store = store;
        this.d_node = node;
    }

    public double[] getTransform() {
        if (this.d_node.getLocalTransform().isIdentity()) {
            return DataStore.IDENTITY_XFORM;
        }
        double[] result = new double[16];
        Matrix4d xform = this.d_node.getLocalTransform().toMatrix(false);
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 4; ++col) {
                result[row * 4 + col] = xform.getElement(row, col);
            }
        }
        return result;
    }

    public IPyroGeom getGeom() {
        return this.d_store.getGeom(this.d_node.getLocalGeom());
    }

    public <T> T[][] getElements(double[] parentXform, IPyroGeomNode.Elem<T> elem, List<IPyroPrimProps> props) {
        IGeomNode fnode = this.d_node;
        List<IPrimitive> prims = this.getCachedPrims(new MatrixXform(new Matrix4d(parentXform)));
        return GeomNodeWrapper.getElements(this.d_store, fnode, prims, elem, this.getPropIterator(props));
    }

    private Iterator<IPrimProps> getPropIterator(List<IPyroPrimProps> props) {
        return new MappedIterator<IPyroPrimProps, IPrimProps>(props.iterator(), p -> this.d_store.getNativeProps((IPyroPrimProps)p));
    }

    protected List<IPrimitive> getCachedPrims(ITransform parentXform) {
        if (this.d_cachedPrims == null) {
            TransformInfo ti = parentXform.concatenate(this.d_node.getLocalTransform()).getInfo();
            this.d_cachedPrims = GeomUtil.explode(this.d_node.getLocalGeom(), IPrimitive.class);
            this.d_cachedPrims = new ArrayList<IPrimitive>(theUtil.map(this.d_cachedPrims, g -> g.transform(ti, 0)));
        }
        return this.d_cachedPrims;
    }

    public Map<String, PyroPoint2d[][]> getUVElements(double[] parentXform, List<IPyroPrimProps> props) {
        Map<String, IElemSource<Point2d>> uvsets = this.d_node.getLocalElements().get(Elements.UV);
        if (uvsets.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, PyroPoint2d[][]> result = new HashMap<String, PyroPoint2d[][]>();
        List<IPrimitive> prims = this.getCachedPrims(new MatrixXform(new Matrix4d(parentXform)));
        for (Map.Entry<String, IElemSource<Point2d>> entry : uvsets.entrySet()) {
            IElemSource<Point2d> uvset = entry.getValue();
            HashMap map = new HashMap();
            Function<Point2d, PyroPoint2d> maker = p -> new PyroPoint2d(p.x, p.y);
            PyroPoint2d[][] uvsetElems = GeomNodeWrapper.getElements(this.d_store, this.d_node, prims, PyroPoint2d.class, this.getPropIterator(props), Elements.UV_DIFFUSE, (i, p) -> uvset.getPrimSource((int)i), uv -> (PyroPoint2d)map.computeIfAbsent(uv, maker), Mapping.FACE_VERT, p -> {
                Surface surf = (Surface)p.getMaterial();
                return surf != null && surf.getAppearance() != null;
            });
            result.put(entry.getKey(), uvsetElems);
        }
        return result;
    }

    public static <T, NT> T[][] getElements(DataStore store, IGeomNode fnode, List<IPrimitive> prims, IPyroGeomNode.Elem<T> elem, Iterator<IPrimProps> props) {
        if (elem.equals((Object)UV)) {
            HashMap map = new HashMap();
            Function<Point2d, PyroPoint2d> maker = p -> new PyroPoint2d(p.x, p.y);
            Map<String, IElemSource<Point2d>> uvs = fnode.getLocalElements().get(Elements.UV);
            return GeomNodeWrapper.getElements(store, fnode, prims, PyroPoint2d.class, props, Elements.UV_DIFFUSE, (i, p) -> {
                String uvSet;
                String string = uvSet = p.getMaterial() != null ? p.getMaterial().getAttributes().getUVSet() : null;
                if (uvSet != null) {
                    IElemSource puv = (IElemSource)uvs.get(uvSet);
                    if (puv == null && !uvs.isEmpty()) {
                        puv = (IElemSource)uvs.entrySet().iterator().next().getValue();
                    }
                    if (puv == null) {
                        return Elements.NO_UV;
                    }
                    return puv.getPrimSource((int)i);
                }
                return Elements.NO_UV;
            }, uv -> (PyroPoint2d)map.computeIfAbsent(uv, maker), Mapping.FACE_VERT, p -> {
                Surface surf = (Surface)p.getMaterial();
                return surf != null && surf.getAppearance() != null;
            });
        }
        if (elem.equals((Object)CCW)) {
            return GeomNodeWrapper.getElements(store, fnode, prims, elem, props, Elements.ORIENT, o -> o == Elements.Orient.CCW ? Boolean.TRUE : Boolean.FALSE, Mapping.PRIM, Predicates.alwaysTrue());
        }
        if (elem.equals((Object)NORMAL)) {
            HashMap map = new HashMap();
            Function<Vector3d, PyroPoint3d> maker = p -> new PyroPoint3d(p.x, p.y, p.z);
            return GeomNodeWrapper.getElements(store, fnode, prims, elem, props, Elements.NORMAL, n -> map.computeIfAbsent(n, maker), Mapping.FACE_VERT, Predicates.alwaysTrue());
        }
        if (elem.equals((Object)CREASE)) {
            return GeomNodeWrapper.getElements(store, fnode, prims, elem, props, Elements.CREASE, c -> c, Mapping.FACE_VERT, Predicates.alwaysTrue());
        }
        return (Object[][])Array.newInstance(elem.type, 0, 0);
    }

    public static <T, NT> T[][] getElements(DataStore store, IGeomNode fnode, List<IPrimitive> prims, IPyroGeomNode.Elem<T> elem, Iterator<IPrimProps> props, Elements.ElemProp<NT> nelem, Function<NT, T> convert, Mapping mapping, Predicate<IPrimProps> requiresElems) {
        IElemSource elems = fnode.getElements(nelem);
        return GeomNodeWrapper.getElements(store, fnode, prims, elem.type, props, nelem, (i, p) -> elems.getPrimSource((int)i), convert, mapping, requiresElems);
    }

    private static <T, NT> T[][] getElements(DataStore store, IGeomNode fnode, List<IPrimitive> prims, Class<T> ttype, Iterator<IPrimProps> props, Elements.ElemProp<NT> nelem, BiFunction<Integer, IPrimProps, IElemSource<NT>> elems, Function<NT, T> convert, Mapping mapping, Predicate<IPrimProps> requiresElems) {
        Iterator orientit = ((IElemSource)((Object)fnode.getLocalElements().get(Elements.ORIENT))).getPrimIterator();
        Iterator<IPrimProps> propIt = props;
        Object[][] resultElems = (Object[][])Array.newInstance(ttype, prims.size(), 0);
        block4: for (int m = 0; m < prims.size(); ++m) {
            IPrimitive prim = prims.get(m);
            IPrimProps nprops = propIt.next();
            IElemSource<NT> elemPrim = elems.apply(m, nprops);
            IElemSource<Elements.Orient> oprim = orientit.next();
            if (!(prim instanceof IPolygon) || !requiresElems.test(nprops)) {
                resultElems[m] = null;
                continue;
            }
            IPolygon poly = (IPolygon)prim;
            int numVerts = PolyUtil.getNumVerts(poly);
            if (elemPrim == nelem.defVal) {
                resultElems[m] = null;
                continue;
            }
            ElementMesh<NT> elemMesh = elemPrim.generate(nelem.type, Collections.singletonList(poly), oprim, new UniformProps(nprops), numVerts, false);
            switch (mapping) {
                case PRIM: {
                    Object[] faceElem = (Object[])Array.newInstance(ttype, numVerts);
                    T item = convert.apply(elemMesh.getPrimElement(0));
                    Arrays.fill(faceElem, item);
                    resultElems[m] = faceElem;
                    continue block4;
                }
                case FACE_VERT: {
                    Object[] faceElem = (Object[])Array.newInstance(ttype, numVerts);
                    for (int n = 0; n < numVerts; ++n) {
                        NT elem = elemMesh.getPrimVertElement(0, n);
                        faceElem[n] = convert.apply(elem);
                    }
                    resultElems[m] = faceElem;
                    continue block4;
                }
            }
        }
        return resultElems;
    }

    public IPyroGeomNode[] getChildren() {
        Collection<? extends IGeomNode> children = this.d_node.getChildren();
        IPyroGeomNode[] result = new IPyroGeomNode[children.size()];
        int ix = 0;
        for (IGeomNode iGeomNode : children) {
            result[ix++] = new GeomNodeWrapper(this.d_store, iGeomNode);
        }
        return result;
    }

    public static enum Mapping {
        FACE_VERT,
        PRIM;

    }
}

