/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import pyrosim.Intl;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.io.IOUtil;
import thunderheadeng.util.LinkedIdentityHashSet;

public class STLReader {
    private static final int MAX_TRI_ALLOC = 2000000;
    private final Options d_options;
    private final ITriReader d_reader;
    private List<Triangle> d_tris = Collections.EMPTY_LIST;

    public STLReader(File file, Options options) throws IOException {
        this.d_options = options;
        this.d_reader = this.getReader(file);
    }

    private ITriReader getReader(File file) throws IOException {
        ATriReader reader = null;
        try {
            reader = new AsciiTriReader(file, this.d_options);
            return reader;
        }
        catch (InvalidSTLReaderException invalidSTLReaderException) {
            try {
                reader = new BinaryTriReader(file, this.d_options);
                return reader;
            }
            catch (InvalidSTLReaderException invalidSTLReaderException2) {
                String errMsg = String.format(Intl.intl("Could not determine if STL file was binary or ASCII format."), new Object[0]);
                throw new IOException(errMsg);
            }
        }
    }

    public Type getType() {
        return this.d_reader instanceof AsciiTriReader ? Type.ASCII : Type.BINARY;
    }

    public void read() throws IOException {
        int sizeHint = this.d_reader.getSizeHint();
        if (sizeHint > 2000000) {
            sizeHint = 2000000;
        }
        List<Triangle> list = this.d_tris = sizeHint > 0 ? new ArrayList<Triangle>(sizeHint) : new ArrayList();
        while (this.readNextTri()) {
        }
        this.d_reader.close();
    }

    private boolean readNextTri() throws IOException {
        Triangle tri = this.d_reader.readNext();
        if (tri == null) {
            return false;
        }
        if (STLReader.isValid(tri)) {
            this.d_tris.add(tri);
        } else {
            System.err.printf("Found invalid triangle: [%s, %s, %s]%n", tri.p1, tri.p2, tri.p3);
        }
        return true;
    }

    private static boolean isValid(Triangle tri) {
        return !tri.p1.equals(tri.p2) && !tri.p1.equals(tri.p3);
    }

    public String getName() {
        return this.d_reader.getName();
    }

    public List<? extends IGeom> getGeometry() {
        List<List<Triangle>> sepTris = STLReader.separateTris(this.d_tris);
        ArrayList<Mesh> result = new ArrayList<Mesh>(sepTris.size());
        for (List<Triangle> tris : sepTris) {
            result.add(STLReader.toMesh(tris));
        }
        return result;
    }

    private static List<List<Triangle>> separateTris(List<Triangle> tris) {
        HashMap<Point3d, List<Triangle>> pointAdjMap = new HashMap<Point3d, List<Triangle>>();
        for (Triangle tri : tris) {
            for (int n = 0; n < 3; ++n) {
                Point3d p = tri.getPoint(0, n);
                ArrayList<Triangle> pAdj = (ArrayList<Triangle>)pointAdjMap.get(p);
                if (pAdj == null) {
                    pAdj = new ArrayList<Triangle>(2);
                    pointAdjMap.put(p, pAdj);
                }
                pAdj.add(tri);
            }
        }
        ArrayList<List<Triangle>> result = new ArrayList<List<Triangle>>();
        LinkedIdentityHashSet<Triangle> openTris = new LinkedIdentityHashSet<Triangle>((Collection<Triangle>)tris);
        while (!openTris.isEmpty()) {
            Triangle seed = (Triangle)openTris.iterator().next();
            List<Triangle> triList = STLReader.getConnectedTris(seed, pointAdjMap, openTris);
            assert (!triList.isEmpty());
            result.add(triList);
        }
        return result;
    }

    private static List<Triangle> getConnectedTris(Triangle seed, Map<Point3d, List<Triangle>> pointAdjMap, Set<Triangle> availTris) {
        ArrayList<Triangle> result = new ArrayList<Triangle>();
        ArrayDeque<Triangle> open = new ArrayDeque<Triangle>();
        open.push(seed);
        availTris.remove(seed);
        while (!open.isEmpty()) {
            Triangle tri = (Triangle)open.pop();
            result.add(tri);
            for (int m = 0; m < 3; ++m) {
                Point3d p = tri.getPoint(0, m);
                List<Triangle> adjTris = pointAdjMap.get(p);
                for (Triangle adjTri : adjTris) {
                    if (adjTri == tri || !availTris.remove(adjTri)) continue;
                    open.push(adjTri);
                }
            }
        }
        return result;
    }

    private static Mesh toMesh(List<Triangle> tris) {
        LinkedHashMap<Point3d, Integer> pmap = new LinkedHashMap<Point3d, Integer>();
        int[] triIxes = new int[tris.size() * 3];
        int offset = 0;
        for (int m = 0; m < tris.size(); ++m) {
            Triangle tri = tris.get(m);
            triIxes[offset++] = STLReader.indexOf(tri.p1, pmap);
            triIxes[offset++] = STLReader.indexOf(tri.p2, pmap);
            triIxes[offset++] = STLReader.indexOf(tri.p3, pmap);
        }
        Point3d[] points = pmap.keySet().toArray(new Point3d[pmap.size()]);
        return new Mesh(points, triIxes, 2, 0);
    }

    private static int indexOf(Point3d p, Map<Point3d, Integer> pmap) {
        Integer ix = pmap.get(p);
        if (ix == null) {
            ix = pmap.size();
            pmap.put(p, ix);
        }
        return ix;
    }

    public static class Options {
        public final Matrix4d lwXform;
        public final double weldTol;

        public Options(Matrix4d lwXform, double weldTol) {
            this.lwXform = lwXform;
            this.weldTol = weldTol;
        }
    }

    private static class BinaryTriReader
    extends ATriReader {
        private static final int HEADER_LEN = 80;
        private final byte[] d_header;
        private final DataInput d_is;
        private final int d_numTris;
        private int d_currTri;
        private float[] d_buffer;

        public BinaryTriReader(File file, Options options) throws IOException, InvalidSTLReaderException {
            super(options);
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            try {
                this.d_header = new byte[80];
                int numRead = ((InputStream)is).read(this.d_header);
                if (numRead < 80) {
                    ((InputStream)is).close();
                    throw new InvalidSTLReaderException();
                }
                this.d_is = IOUtil.constructNativeDataInput(is);
                this.d_numTris = this.d_is.readInt();
                this.d_currTri = 0;
                this.d_buffer = new float[3];
            }
            catch (IOException e) {
                ((InputStream)is).close();
                throw e;
            }
        }

        @Override
        public void close() throws IOException {
            if (this.d_is instanceof Closeable) {
                ((Closeable)((Object)this.d_is)).close();
            }
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public int getSizeHint() {
            return this.d_numTris;
        }

        @Override
        public Triangle readNext() throws IOException {
            if (this.d_currTri >= this.d_numTris) {
                return null;
            }
            ++this.d_currTri;
            this.readREAL32(this.d_buffer);
            Point3d p1 = this.readPoint();
            Point3d p2 = this.readPoint();
            Point3d p3 = this.readPoint();
            this.d_is.readShort();
            return new Triangle(p1, p2, p3);
        }

        private void readREAL32(float[] data) throws IOException {
            data[0] = this.d_is.readFloat();
            data[1] = this.d_is.readFloat();
            data[2] = this.d_is.readFloat();
        }

        private Point3d readPoint() throws IOException {
            this.readREAL32(this.d_buffer);
            return this.finalize(new Point3d(this.d_buffer[0], this.d_buffer[1], this.d_buffer[2]));
        }
    }

    private static class AsciiTriReader
    extends ATriReader {
        private static final String SOLID = "solid";
        private static final String FACET = "facet";
        private static final String NORMAL = "normal";
        private static final String OUTER = "outer";
        private static final String LOOP = "loop";
        private static final String VERTEX = "vertex";
        private static final String ENDLOOP = "endloop";
        private static final String ENDFACET = "endfacet";
        private static final String ENDSOLID = "endsolid";
        private final String d_name;
        private String d_nextKeyword;
        private final StringBuilder d_tempStringBuilder = new StringBuilder();
        private final BufferedReader d_reader;
        private int d_lineCount;

        public AsciiTriReader(File file, Options options) throws IOException, InvalidSTLReaderException {
            super(options);
            this.d_reader = new BufferedReader(new FileReader(file));
            this.d_lineCount = 0;
            try {
                String header = this.readNextToken();
                if (!header.equals(SOLID)) {
                    throw new InvalidSTLReaderException();
                }
                this.d_name = this.readTitle();
                if (!this.d_nextKeyword.equals(FACET) && !this.d_nextKeyword.equals(ENDSOLID)) {
                    throw new InvalidSTLReaderException();
                }
            }
            catch (IOException e) {
                this.d_reader.close();
                throw e;
            }
            catch (InvalidSTLReaderException e) {
                this.d_reader.close();
                throw e;
            }
        }

        @Override
        public void close() throws IOException {
            if (this.d_reader != null) {
                this.d_reader.close();
            }
        }

        @Override
        public String getName() {
            return this.d_name;
        }

        @Override
        public int getSizeHint() {
            return -1;
        }

        @Override
        public Triangle readNext() throws IOException {
            if (this.d_nextKeyword.equals(ENDSOLID)) {
                return null;
            }
            this.checkKeyword(this.d_nextKeyword, FACET);
            this.readNextKeyword(NORMAL);
            this.readNormal();
            this.readNextKeywords(OUTER, LOOP);
            Point3d p1 = this.readPoint();
            Point3d p2 = this.readPoint();
            Point3d p3 = this.readPoint();
            this.readNextKeyword(ENDLOOP);
            this.readNextKeyword(ENDFACET);
            this.d_nextKeyword = this.readNextToken();
            return new Triangle(p1, p2, p3);
        }

        private void readNormal() throws IOException {
            this.readDouble();
            this.readDouble();
            this.readDouble();
        }

        private Point3d readPoint() throws IOException {
            this.readNextKeyword(VERTEX);
            return this.finalize(new Point3d(this.readDouble(), this.readDouble(), this.readDouble()));
        }

        private double readDouble() throws IOException {
            String token = this.readNextToken();
            try {
                return Double.parseDouble(token);
            }
            catch (NumberFormatException e) {
                throw this.exc(e.getLocalizedMessage());
            }
        }

        private void readNextKeywords(String ... keywords) throws IOException {
            for (String keyword : keywords) {
                this.readNextKeyword(keyword);
            }
        }

        private void readNextKeyword(String keyword) throws IOException {
            String token = this.readNextToken();
            this.checkKeyword(token, keyword);
        }

        private void checkKeyword(String token, String expected) throws IOException {
            if (!token.equals(expected)) {
                String err = String.format(Intl.intl("Unexpected keyword, \"%1$s\".  Expected \"%2$s\"."), token, expected);
                throw this.exc(err);
            }
        }

        private IOException exc(String error) {
            return new IOException(String.format(Intl.intl("Error on line %d: %s"), this.d_lineCount + 1, error));
        }

        private String readNextToken() throws IOException {
            int nextChar;
            this.d_tempStringBuilder.setLength(0);
            while ((nextChar = this.d_reader.read()) != -1) {
                char c = (char)nextChar;
                if (c == ' ' || c == '\n' || c == '\t' || c == '\r') {
                    if (c == '\n') {
                        ++this.d_lineCount;
                    }
                    if (this.d_tempStringBuilder.length() <= 0) continue;
                    break;
                }
                this.d_tempStringBuilder.append(c);
            }
            return this.d_tempStringBuilder.toString();
        }

        private String readTitle() throws IOException {
            Object accumulatedName = "";
            this.d_nextKeyword = this.readNextToken();
            while (!(this.d_nextKeyword.equals(FACET) || this.d_nextKeyword.equals(ENDSOLID) || this.d_nextKeyword.isEmpty())) {
                accumulatedName = (String)accumulatedName + " " + this.d_nextKeyword;
                this.d_nextKeyword = this.readNextToken();
            }
            return accumulatedName;
        }
    }

    private static class InvalidSTLReaderException
    extends Exception {
        private static final long serialVersionUID = 4242355089218497348L;

        private InvalidSTLReaderException() {
        }
    }

    private static abstract class ATriReader
    implements ITriReader {
        private final Options d_options;
        private final Map<Point3d, Point3d> d_pointMap;

        public ATriReader(Options options) {
            this.d_options = options;
            this.d_pointMap = this.d_options.weldTol > 0.0 ? new HashMap() : null;
        }

        protected Point3d finalize(Point3d p) {
            if (this.d_options.lwXform != null) {
                this.d_options.lwXform.transform(p);
            }
            if (this.d_pointMap != null) {
                Point3d rp = Util3D.round(p, this.d_options.weldTol);
                Point3d existing = this.d_pointMap.get(rp);
                if (existing == null) {
                    existing = p;
                    this.d_pointMap.put(rp, p);
                } else {
                    p = existing;
                }
            }
            return p;
        }
    }

    private static interface ITriReader {
        public String getName();

        public int getSizeHint();

        public Triangle readNext() throws IOException;

        public void close() throws IOException;
    }

    public static enum Type {
        ASCII,
        BINARY;

    }
}

